/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.IFontChangeable;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.NewsTabFolder;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.dnd.FavoritesTreeDND;
import net.sourceforge.rssowl.controller.popup.FavoritesTreePopup;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class FavoritesTree
implements ITranslatable,
IFontChangeable {
    private ToolItem aggregateAll;
    private ToolItem closeControllsToolItem;
    private MenuItem closeMenuItem;
    private boolean deletionInProgress;
    private Display display;
    private Composite favoritesTreeHolder;
    private boolean isClassicSort;
    private ToolItem markAllRead;
    private ToolItem reloadAll;
    private FavoritesTreeDND rssOwlFavoritesTreeDND;
    private FavoritesTreePopup rssOwlPopUpMenu;
    private ToolItem searchAll;
    private Menu topToolBarMenu;
    private ViewForm treeViewForm;
    private Composite treeViewFormCenterHeader;
    private Label treeViewFormHeaderLabel;
    private Composite treeViewFormLeftHeader;
    SashForm contentPane;
    EventManager eventManager;
    Tree favoritesTree;
    ToolItem linkTab;
    Composite renameEditorContainer;
    GUI rssOwlGui;
    Shell shell;
    MenuItem toggleToolBarMenuItem;
    TreeEditor treeEditor;

    public FavoritesTree(Display display, Shell shell, SashForm sashForm, GUI gUI, EventManager eventManager) {
        this.contentPane = sashForm;
        this.display = display;
        this.shell = shell;
        this.rssOwlGui = gUI;
        this.eventManager = eventManager;
        this.isClassicSort = System.getProperties().containsKey("net.sourceforge.rssowl.oldSort");
        this.initComponents();
        this.rssOwlFavoritesTreeDND = new FavoritesTreeDND(this);
    }

    public void addCategory(String string, Category category) {
        Category category2 = new Category(string, category, false);
        category.addCategory(category2);
        GlobalSettings.selectedTreeItem = category2.toCatPath();
        SettingsManager.getInstance().requestSave();
    }

    public void addFavorite(Category category, String string, String string2, Favorite favorite) {
        if (string.length() == 0) {
            return;
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        string = Category.createUniqueLink(string);
        string2 = Category.createUniqueTitle(string2);
        Category category2 = category;
        while (!category2.isRoot()) {
            category2.setExpanded(true);
            category2 = category2.getParent();
        }
        Favorite favorite2 = new Favorite(string, string2, category);
        if (favorite == null) {
            favorite2.setCreationDate(System.currentTimeMillis());
            favorite2.setLastVisitDate(0L);
        } else {
            favorite.clone(favorite2);
        }
        category.addFavorite(favorite2);
        GlobalSettings.selectedTreeItem = category.toCatPath() + "=;=" + favorite2.getTitle();
        SettingsManager.getInstance().requestSave();
    }

    public void addFavorite(String string, String string2, String string3, Favorite favorite) {
        this.addFavorite(this.getSelectedCat(string), string2, string3, favorite);
    }

    public void appendUnreadCount(TreeItem treeItem, String string, int n) {
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n > 0) {
            stringBuffer.append(" (").append(n).append(")");
        }
        if (!(string3 = stringBuffer.toString()).equals(string2 = treeItem.getText())) {
            treeItem.setText(string3);
        }
    }

    public void buildFavoritesTree() {
        this.buildFavoritesTree(false);
    }

    public void buildFavoritesTree(boolean bl) {
        Object object;
        String string = GlobalSettings.selectedTreeItem;
        String string2 = null;
        if (bl && WidgetShop.isset((Widget)(object = this.favoritesTree.getTopItem()))) {
            string2 = this.getTreePath((TreeItem)object, false);
        }
        if (bl) {
            this.favoritesTree.setVisible(false);
        }
        this.deletionInProgress = true;
        this.favoritesTree.removeAll();
        this.deletionInProgress = false;
        object = Category.getRootCategory().getSubCategories();
        TreeSet treeSet = Category.getRootCategory().getSortedSubCatTitles();
        this.addCategoryOrFavorite((Hashtable)object, treeSet, this.favoritesTree, Category.getRootCategory());
        this.restoreExpanded(this.favoritesTree.getItems(), Category.getRootCategory());
        if (string != null) {
            this.restoreSelection(string);
        }
        if (bl && StringShop.isset(string2)) {
            TreeItem treeItem = this.getItem(string2);
            if (WidgetShop.isset(treeItem)) {
                this.favoritesTree.setTopItem(treeItem);
            } else if (this.favoritesTree.getSelectionCount() > 0) {
                this.favoritesTree.showSelection();
            }
        }
        if (bl) {
            this.favoritesTree.setVisible(true);
            this.favoritesTree.setFocus();
        }
        this.selectionChanged();
    }

    public void createAmphetaRateFeed() {
        if (Category.getRootCategory().getSortedSubCatTitles().contains("AmphetaRate")) {
            Category.getRootCategory().removeCategory("AmphetaRate", Category.getRootCategory());
        }
        this.addCategory("AmphetaRate", Category.getRootCategory());
        if (!Category.linkExists("http://amphetarate.sourceforge.net/dinka-get-rss.php?global=1&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3")) {
            this.addFavorite("AmphetaRate", "http://amphetarate.sourceforge.net/dinka-get-rss.php?global=1&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3", "Latest best news", null);
        }
        if (AmphetaRateThread.isOldUser()) {
            if (!Category.linkExists("http://amphetarate.sourceforge.net/dinka-get-rss.php?uid=" + GlobalSettings.amphetaRateUserID + "&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3")) {
                this.addFavorite("AmphetaRate", "http://amphetarate.sourceforge.net/dinka-get-rss.php?uid=" + GlobalSettings.amphetaRateUserID + "&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3", GUI.i18n.getTranslation("RECOMMENDED_ARTICLES"), null);
            }
        } else if (!Category.linkExists("http://amphetarate.sourceforge.net/dinka-get-rss.php?alias=" + GlobalSettings.amphetaRateUsername + "&password=" + GlobalSettings.amphetaRatePassword + "&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3")) {
            this.addFavorite("AmphetaRate", "http://amphetarate.sourceforge.net/dinka-get-rss.php?alias=" + GlobalSettings.amphetaRateUsername + "&password=" + GlobalSettings.amphetaRatePassword + "&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3", GUI.i18n.getTranslation("RECOMMENDED_ARTICLES"), null);
        }
        this.buildFavoritesTree();
    }

    public Tree getFavoritesTree() {
        return this.favoritesTree;
    }

    public FavoritesTreeDND getRSSOwlFavoritesTreeDND() {
        return this.rssOwlFavoritesTreeDND;
    }

    public Category getSelectedCat() {
        return this.getSelectedCat(null);
    }

    public Category getSelectedCat(String string) {
        Category category = Category.getRootCategory();
        String[] stringArray = string != null ? string.split("=;=") : this.getTreePath(true).split("=;=");
        for (int i = 0; i < stringArray.length && category != null; ++i) {
            category = (Category)category.getSubCategories().get(stringArray[i]);
        }
        return category;
    }

    public Favorite getSelectedFav() {
        if (this.getFavoritesTree().getSelectionCount() <= 0) {
            return null;
        }
        TreeItemData treeItemData = (TreeItemData)this.getFavoritesTree().getSelection()[0].getData();
        return treeItemData.getFavorite();
    }

    public boolean getTreeHasUnreadFavs() {
        TreeItem[] treeItemArray = this.favoritesTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItemData treeItemData = (TreeItemData)treeItemArray[i].getData();
            if (!treeItemData.isStatusUnread()) continue;
            return true;
        }
        return false;
    }

    public String getTreePath(boolean bl) {
        TreeItem[] treeItemArray = this.favoritesTree.getSelection();
        if (treeItemArray.length > 0) {
            TreeItem treeItem = treeItemArray[0];
            return this.getTreePath(treeItem, bl);
        }
        if (this.favoritesTree.getItemCount() > 0) {
            TreeItemData treeItemData = (TreeItemData)this.favoritesTree.getItems()[0].getData();
            return treeItemData.getName();
        }
        return "";
    }

    public String getTreePath(TreeItem treeItem, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeItemData treeItemData = (TreeItemData)treeItem.getData();
        if (treeItemData.isCategory() || treeItemData.isBlogroll()) {
            arrayList.add(treeItemData.getName());
        } else if (!bl) {
            arrayList.add(treeItemData.getName());
        }
        while (treeItem.getParentItem() != null) {
            TreeItemData treeItemData2 = (TreeItemData)treeItem.getParentItem().getData();
            arrayList.add(treeItemData2.getName());
            treeItem = treeItem.getParentItem();
        }
        if (arrayList.size() > 0) {
            stringBuffer = new StringBuffer((String)arrayList.get(arrayList.size() - 1));
            for (int i = arrayList.size() - 2; i >= 0; --i) {
                stringBuffer.append("=;=").append(arrayList.get(i));
            }
        }
        return stringBuffer.toString();
    }

    public void handleTreeItemSelect(boolean bl) {
        TreeItem[] treeItemArray = this.favoritesTree.getSelection();
        if (treeItemArray.length > 0) {
            TreeItemData treeItemData = (TreeItemData)treeItemArray[0].getData();
            if (!treeItemData.isCategory() && !treeItemData.isBlogroll()) {
                this.rssOwlGui.loadNewsFeed(Category.getLinkForTitle(treeItemData.getName()), SearchDefinition.NO_SEARCH, true, true, 0);
                treeItemData.getFavorite().setLastVisitDate(System.currentTimeMillis());
            } else if (!bl) {
                treeItemArray[0].setExpanded(!treeItemArray[0].getExpanded());
                Event event = new Event();
                event.item = treeItemArray[0];
                event.widget = this.favoritesTree;
                this.onTreeEvent(new TreeEvent(event), treeItemArray[0].getExpanded());
            }
        }
    }

    public void setShowToolBar(boolean bl) {
        this.toggleToolBarMenuItem.setSelection(bl);
        if (bl && this.treeViewForm.getTopCenter() == null) {
            this.treeViewForm.setTopCenter(this.treeViewFormCenterHeader, true);
        } else if (!bl && this.treeViewForm.getTopCenter() != null) {
            this.treeViewForm.setTopCenter(null, true);
        }
    }

    public void stopRenaming() {
        if (WidgetShop.isset(this.renameEditorContainer)) {
            this.renameEditorContainer.dispose();
            this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
        }
    }

    @Override
    public void updateFonts() {
        this.treeViewFormHeaderLabel.setFont(FontShop.headerFont);
        this.favoritesTree.setFont(FontShop.treeFont);
        this.buildFavoritesTree(true);
    }

    @Override
    public void updateI18N() {
        this.treeViewFormHeaderLabel.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        this.closeControllsToolItem.setToolTipText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.markAllRead.setToolTipText(GUI.i18n.getTranslation("BUTTON_MARK_ALL_READ"));
        this.linkTab.setToolTipText(GUI.i18n.getTranslation("BUTTON_LINK_TAB"));
        this.aggregateAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_AGGREGATE_ALL"));
        this.reloadAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_RELOAD_ALL"));
        this.searchAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_SEARCH_ALL"));
        this.toggleToolBarMenuItem.setText(GUI.i18n.getTranslation("MENU_TOOLBAR"));
        this.closeMenuItem.setText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.rssOwlPopUpMenu.setRequiresUpdate();
        this.onSelection();
    }

    public void updateTreeItemIcon(TreeItem treeItem) {
        if (GUI.isAlive() && !treeItem.isDisposed()) {
            Favorite favorite = ((TreeItemData)treeItem.getData()).getFavorite();
            if (favorite == null) {
                return;
            }
            Image image = PaintShop.iconLense;
            if (favorite.isErrorLoading()) {
                image = PaintShop.iconErrorLense;
            } else if (favorite.getUnreadNewsCount() > 0) {
                image = PaintShop.iconLenseUnread;
            }
            treeItem.setImage(image);
        }
    }

    public void updateTreeReadStatus(TreeItem treeItem) {
        boolean bl;
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == null) {
            return;
        }
        TreeItem[] treeItemArray = treeItem2.getItems();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItemData treeItemData = (TreeItemData)treeItemArray[i].getData();
            if (treeItemData.isStatusUnread() && (treeItemData.isFavorite() || treeItemData.isBlogrollFavorite())) {
                bl2 = true;
                bl3 = true;
                bl4 = true;
                break;
            }
            if (!treeItemData.isStatusUnread()) continue;
            bl3 = true;
            bl4 = true;
        }
        TreeItemData treeItemData = (TreeItemData)treeItem2.getData();
        boolean bl5 = false;
        if (treeItemData.isCategory()) {
            bl5 = treeItem2.getImage().equals(bl2 ? PaintShop.iconFolder : PaintShop.iconFolderUnread);
        } else if (treeItemData.isBlogroll()) {
            bl5 = treeItem2.getImage().equals(bl2 ? PaintShop.iconFolderSubscribe : PaintShop.iconFolderSubscribeUnread);
        }
        if (bl5 && treeItemData.isCategory()) {
            treeItem2.setImage(bl2 ? PaintShop.iconFolderUnread : PaintShop.iconFolder);
        } else if (bl5 && treeItemData.isBlogroll()) {
            treeItem2.setImage(bl2 ? PaintShop.iconFolderSubscribeUnread : PaintShop.iconFolderSubscribe);
        }
        boolean bl6 = bl = bl4 != treeItemData.isStatusUnread();
        if (bl) {
            treeItem2.setFont(bl3 ? FontShop.treeBoldFont : FontShop.treeFont);
        }
        treeItemData.setStatusUnread(bl4);
        this.updateTreeReadStatus(treeItem2);
    }

    private void addCategoryOrFavorite(Hashtable hashtable, TreeSet treeSet, Widget widget, Category category) {
        for (String string : treeSet) {
            TreeItem treeItem;
            Object object;
            if (hashtable.get(string) instanceof Category) {
                TreeSet treeSet2;
                Hashtable hashtable2;
                TreeSet treeSet3;
                Hashtable hashtable3;
                object = (Category)hashtable.get(string);
                treeItem = ((Category)object).isBlogroll() ? this.addTreeItem(((Category)object).getName(), PaintShop.iconFolderSubscribe, "", widget, ((Category)object).isBlogroll(), 0) : this.addTreeItem(((Category)object).getName(), PaintShop.iconFolder, "", widget, ((Category)object).isBlogroll(), 0);
                if (this.isClassicSort) {
                    hashtable3 = ((Category)object).getFavorites();
                    treeSet3 = ((Category)object).getSortedLinkTitles();
                    this.addCategoryOrFavorite(hashtable3, treeSet3, treeItem, (Category)object);
                    hashtable2 = ((Category)object).getSubCategories();
                    treeSet2 = ((Category)object).getSortedSubCatTitles();
                    this.addCategoryOrFavorite(hashtable2, treeSet2, treeItem, (Category)object);
                } else {
                    hashtable3 = ((Category)object).getSubCategories();
                    treeSet3 = ((Category)object).getSortedSubCatTitles();
                    this.addCategoryOrFavorite(hashtable3, treeSet3, treeItem, (Category)object);
                    hashtable2 = ((Category)object).getFavorites();
                    treeSet2 = ((Category)object).getSortedLinkTitles();
                    this.addCategoryOrFavorite(hashtable2, treeSet2, treeItem, (Category)object);
                }
                ((Category)object).setTreeItem(treeItem);
                continue;
            }
            if (!(hashtable.get(Category.getLinkForTitle(string)) instanceof Favorite)) continue;
            object = (Favorite)hashtable.get(Category.getLinkForTitle(string));
            treeItem = ((Favorite)object).isErrorLoading() ? this.addTreeItem(((Favorite)object).getTitle(), PaintShop.iconErrorLense, category.getName(), widget, category.isBlogroll(), 0) : (((Favorite)object).unreadNewsAvailable() ? this.addTreeItem(((Favorite)object).getTitle(), PaintShop.iconLenseUnread, category.getName(), widget, category.isBlogroll(), ((Favorite)object).getUnreadNewsCount()) : (((Favorite)object).isSynchronizer() ? this.addTreeItem(((Favorite)object).getTitle(), PaintShop.iconReload, category.getName(), widget, category.isBlogroll(), 0) : this.addTreeItem(((Favorite)object).getTitle(), PaintShop.iconLense, category.getName(), widget, category.isBlogroll(), 0)));
            ((Favorite)object).setTreeItem(treeItem);
            ((TreeItemData)treeItem.getData()).setFavorite((Favorite)object);
        }
    }

    private TreeItem addTreeItem(String string, Image image, String string2, Widget widget, boolean bl, int n) {
        boolean bl2 = widget instanceof Tree;
        boolean bl3 = n > 0;
        TreeItem treeItem = bl2 ? new TreeItem((Tree)widget, 0) : new TreeItem((TreeItem)widget, 0);
        if (string2.length() == 0) {
            if (!bl) {
                treeItem.setData(TreeItemData.createCategory(string, bl3));
            } else {
                treeItem.setData(TreeItemData.createBlogroll(string, bl3));
            }
        } else if (!bl) {
            treeItem.setData(TreeItemData.createFavorite(string, bl3));
        } else {
            treeItem.setData(TreeItemData.createBlogrollFavorite(string, bl3));
        }
        treeItem.setText(string);
        treeItem.setImage(image);
        if (bl3) {
            treeItem.setFont(FontShop.treeBoldFont);
            this.appendUnreadCount(treeItem, string, n);
            this.updateTreeReadStatus(treeItem);
        }
        return treeItem;
    }

    private TreeItem getItem(String string) {
        String[] stringArray = string.split("=;=");
        TreeItem[] treeItemArray = this.favoritesTree.getItems();
        TreeItem treeItem = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < treeItemArray.length; ++j) {
                TreeItem treeItem2 = treeItemArray[j];
                TreeItemData treeItemData = (TreeItemData)treeItem2.getData();
                if (treeItemData == null || !treeItemData.getName().equals(string2)) continue;
                treeItem = treeItem2;
                treeItemArray = treeItem.getItems();
                bl = true;
                break;
            }
            if (bl) continue;
            return null;
        }
        return treeItem;
    }

    private void initComponents() {
        this.favoritesTreeHolder = new Composite(this.contentPane, 0);
        this.favoritesTreeHolder.setLayout(new FillLayout());
        int n = GlobalSettings.isMac() ? 0x800800 : 2048;
        this.treeViewForm = new ViewForm(this.favoritesTreeHolder, n);
        this.treeViewForm.setTopCenterSeparate(true, false);
        this.treeViewFormLeftHeader = new Composite(this.treeViewForm, 0);
        this.treeViewFormLeftHeader.setBackground(PaintShop.grayViewFormColor);
        this.treeViewFormLeftHeader.setLayout(LayoutShop.createGridLayout(1, 5, 5));
        this.initTopContextMenu(this.treeViewFormLeftHeader);
        this.treeViewFormLeftHeader.setMenu(this.topToolBarMenu);
        this.treeViewFormHeaderLabel = new Label(this.treeViewFormLeftHeader, 0);
        this.treeViewFormHeaderLabel.setBackground(PaintShop.grayViewFormColor);
        this.treeViewFormHeaderLabel.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        this.treeViewFormHeaderLabel.setFont(FontShop.headerFont);
        this.treeViewFormHeaderLabel.setLayoutData(new GridData(1, 0x1000000, false, true));
        this.treeViewFormHeaderLabel.setMenu(this.topToolBarMenu);
        this.treeViewForm.setTopLeft(this.treeViewFormLeftHeader, false);
        Composite composite = new Composite(this.treeViewForm, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        composite.setBackground(PaintShop.grayViewFormColor);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setBackground(PaintShop.grayViewFormColor);
        toolBar.setLayoutData(new GridData(131072, 0x1000000, true, true));
        this.closeControllsToolItem = new ToolItem(toolBar, 8);
        this.closeControllsToolItem.setImage(PaintShop.loadImage("/img/icons/cross.gif"));
        this.closeControllsToolItem.setToolTipText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.closeControllsToolItem.addDisposeListener(DisposeListenerImpl.getInstance());
        this.closeControllsToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.rssOwlGui.setFavoritesMinimized(true, true);
            }
        });
        this.treeViewForm.setTopRight(composite, false);
        this.treeViewFormCenterHeader = new Composite(this.treeViewForm, 0);
        this.treeViewFormCenterHeader.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        this.treeViewFormCenterHeader.setBackground(PaintShop.grayToolBarColor);
        this.treeViewFormCenterHeader.setMenu(this.topToolBarMenu);
        ToolBar toolBar2 = new ToolBar(this.treeViewFormCenterHeader, 0x800040);
        toolBar2.setLayoutData(new GridData(131072, 128, true, false));
        toolBar2.setBackground(PaintShop.grayToolBarColor);
        toolBar2.setMenu(this.topToolBarMenu);
        this.aggregateAll = new ToolItem(toolBar2, 8);
        this.aggregateAll.setImage(PaintShop.loadImage("/img/icons/aggregate_all_big.gif"));
        this.aggregateAll.addDisposeListener(DisposeListenerImpl.getInstance());
        this.aggregateAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_AGGREGATE_ALL"));
        this.aggregateAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.eventManager.actionAggregateAllCategories();
            }
        });
        this.reloadAll = new ToolItem(toolBar2, 8);
        this.reloadAll.setImage(PaintShop.loadImage("/img/icons/reload_all_big.gif"));
        this.reloadAll.addDisposeListener(DisposeListenerImpl.getInstance());
        this.reloadAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_RELOAD_ALL"));
        this.reloadAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.eventManager.actionReloadAllCategories();
            }
        });
        this.searchAll = new ToolItem(toolBar2, 8);
        this.searchAll.setImage(PaintShop.loadImage("/img/icons/search_all_big.gif"));
        this.searchAll.addDisposeListener(DisposeListenerImpl.getInstance());
        this.searchAll.setToolTipText(GUI.i18n.getTranslation("BUTTON_SEARCH_ALL"));
        this.searchAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.eventManager.actionSearchInAllCategories();
            }
        });
        new ToolItem(toolBar2, 2);
        this.markAllRead = new ToolItem(toolBar2, 8);
        this.markAllRead.setImage(PaintShop.loadImage("/img/icons/mark_read_big.gif"));
        this.markAllRead.addDisposeListener(DisposeListenerImpl.getInstance());
        this.markAllRead.setToolTipText(GUI.i18n.getTranslation("BUTTON_MARK_ALL_READ"));
        this.markAllRead.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.eventManager.actionMarkAllCategoriesRead();
            }
        });
        new ToolItem(toolBar2, 2);
        this.linkTab = new ToolItem(toolBar2, 32);
        this.linkTab.setImage(PaintShop.loadImage("/img/icons/link_tab.gif"));
        this.linkTab.addDisposeListener(DisposeListenerImpl.getInstance());
        this.linkTab.setToolTipText(GUI.i18n.getTranslation("BUTTON_LINK_TAB"));
        this.linkTab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                GlobalSettings.linkTreeWithTab = FavoritesTree.this.linkTab.getSelection();
                if (GlobalSettings.linkTreeWithTab) {
                    FavoritesTree.this.rssOwlGui.getRSSOwlNewsTabFolder().linkSelectionToTree();
                    FavoritesTree.this.favoritesTree.setFocus();
                }
            }
        });
        this.treeViewForm.setTopCenter(this.treeViewFormCenterHeader, false);
        this.favoritesTree = new Tree(this.treeViewForm, 0);
        this.favoritesTree.setFont(FontShop.treeFont);
        this.favoritesTree.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.onSelection();
            }
        });
        this.favoritesTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                FavoritesTree.this.onMouseUp(mouseEvent);
            }
        });
        this.favoritesTree.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                FavoritesTree.this.onMouseDoubleClick(event);
            }
        });
        this.favoritesTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                FavoritesTree.this.onKeyPressed(keyEvent);
            }
        });
        this.favoritesTree.addTreeListener(new TreeListener(){

            @Override
            public void treeCollapsed(TreeEvent treeEvent) {
                FavoritesTree.this.onTreeEvent(treeEvent, false);
            }

            @Override
            public void treeExpanded(TreeEvent treeEvent) {
                FavoritesTree.this.onTreeEvent(treeEvent, true);
            }
        });
        this.treeViewForm.setContent(this.favoritesTree, true);
        this.rssOwlPopUpMenu = new FavoritesTreePopup(this.shell, this, this.rssOwlGui, this.eventManager);
        this.favoritesTree.setMenu(this.rssOwlPopUpMenu.getTreePopUpMenu());
        this.rssOwlPopUpMenu.getTreePopUpMenu().addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                FavoritesTree.this.onPopupMenuShown();
            }
        });
        this.treeEditor = new TreeEditor(this.favoritesTree);
    }

    private void initTopContextMenu(Control control) {
        this.topToolBarMenu = new Menu(control);
        this.toggleToolBarMenuItem = new MenuItem(this.topToolBarMenu, 32);
        this.toggleToolBarMenuItem.setText(GUI.i18n.getTranslation("MENU_TOOLBAR"));
        this.toggleToolBarMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                GlobalSettings.isTreeToolBarShown = FavoritesTree.this.toggleToolBarMenuItem.getSelection();
                FavoritesTree.this.setShowToolBar(GlobalSettings.isTreeToolBarShown);
            }
        });
        new MenuItem(this.topToolBarMenu, 2);
        this.closeMenuItem = new MenuItem(this.topToolBarMenu, 0);
        this.closeMenuItem.setText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.closeMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FavoritesTree.this.rssOwlGui.setFavoritesMinimized(true, true);
            }
        });
    }

    private void rename(final TreeItem treeItem) {
        if (!WidgetShop.isset(treeItem)) {
            return;
        }
        final TreeItemData treeItemData = (TreeItemData)treeItem.getData();
        this.renameEditorContainer = new Composite(this.favoritesTree, 0);
        this.renameEditorContainer.setBackground(this.display.getSystemColor(2));
        final Text text = new Text(this.renameEditorContainer, 0);
        text.setFont(FontShop.treeFont);
        this.renameEditorContainer.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Rectangle rectangle = FavoritesTree.this.renameEditorContainer.getClientArea();
                text.setBounds(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
        });
        final Category category = treeItemData.isCategory() ? this.getSelectedCat() : null;
        final Favorite favorite = treeItemData.isFavorite() ? this.getSelectedFav() : null;
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 16: {
                        if (treeItemData.isFavorite()) {
                            FavoritesTree.this.renameFavorite(favorite, text.getText());
                        } else if (treeItemData.isCategory()) {
                            FavoritesTree.this.renameCategory(category, text.getText());
                        }
                        FavoritesTree.this.renameEditorContainer.dispose();
                        FavoritesTree.this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                        break;
                    }
                    case 15: {
                        FavoritesTree.this.rssOwlGui.getRSSOwlMenu().updateAccelerators(true);
                        break;
                    }
                    case 25: {
                        String string = text.getText();
                        String string2 = string.substring(0, event.start);
                        String string3 = string.substring(event.end, string.length());
                        GC gC = new GC(text);
                        Point point = gC.textExtent(string2 + event.text + string3);
                        gC.dispose();
                        point = text.computeSize(point.x, -1);
                        FavoritesTree.this.treeEditor.horizontalAlignment = 16384;
                        Rectangle rectangle = treeItem.getBounds();
                        Rectangle rectangle2 = FavoritesTree.this.favoritesTree.getClientArea();
                        FavoritesTree.this.treeEditor.minimumWidth = Math.max(point.x, rectangle.width) + 2;
                        int n = rectangle.x;
                        int n2 = rectangle2.x + rectangle2.width;
                        FavoritesTree.this.treeEditor.minimumWidth = Math.min(FavoritesTree.this.treeEditor.minimumWidth, n2 - n);
                        FavoritesTree.this.treeEditor.minimumHeight = point.y + 2;
                        FavoritesTree.this.treeEditor.layout();
                        break;
                    }
                    case 31: {
                        switch (event.detail) {
                            case 4: {
                                if (treeItemData.isFavorite()) {
                                    FavoritesTree.this.renameFavorite(favorite, text.getText());
                                } else if (treeItemData.isCategory()) {
                                    FavoritesTree.this.renameCategory(category, text.getText());
                                }
                                FavoritesTree.this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                            }
                            case 2: {
                                FavoritesTree.this.renameEditorContainer.dispose();
                                event.doit = false;
                                FavoritesTree.this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                            }
                        }
                    }
                }
            }
        };
        text.addListener(16, listener);
        text.addListener(15, listener);
        text.addListener(31, listener);
        text.addListener(25, listener);
        this.treeEditor.setEditor(this.renameEditorContainer, treeItem);
        text.setText(treeItemData.getName());
        text.selectAll();
        text.setFocus();
    }

    private void restoreExpanded(TreeItem[] treeItemArray, Category category) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItemData treeItemData = (TreeItemData)treeItemArray[i].getData();
            if (!treeItemData.isCategory() && !treeItemData.isBlogroll()) continue;
            Category category2 = (Category)category.getSubCategories().get(treeItemData.getName());
            treeItemArray[i].setExpanded(category2.isExpanded());
            this.restoreExpanded(treeItemArray[i].getItems(), category2);
        }
    }

    private void restoreSelection(String string) {
        int n;
        String[] stringArray = string.split("=;=");
        if (this.favoritesTree.getItemCount() <= 0) {
            return;
        }
        TreeItem treeItem = this.favoritesTree.getItem(0);
        TreeItem[] treeItemArray = this.favoritesTree.getItems();
        for (n = 0; n < treeItemArray.length; ++n) {
            TreeItemData treeItemData = (TreeItemData)treeItemArray[n].getData();
            if (!treeItemData.getName().equals(stringArray[0])) continue;
            treeItem = treeItemArray[n];
            break;
        }
        block1: for (n = 0; n < stringArray.length; ++n) {
            treeItemArray = treeItem.getItems();
            for (int i = 0; i < treeItemArray.length; ++i) {
                TreeItemData treeItemData = (TreeItemData)treeItemArray[i].getData();
                if (!treeItemData.getName().equals(stringArray[n])) continue;
                treeItem = treeItemArray[i];
                continue block1;
            }
        }
        if (treeItem != null) {
            this.favoritesTree.setFocus();
            this.favoritesTree.setSelection(new TreeItem[]{treeItem});
        }
    }

    TreeItemData getSelectedTreeItemData() {
        TreeItem[] treeItemArray = this.favoritesTree.getSelection();
        if (treeItemArray.length > 0) {
            return (TreeItemData)treeItemArray[0].getData();
        }
        return null;
    }

    void onKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 127 || GlobalSettings.isMac() && keyEvent.keyCode == 8) {
            this.performDeletion();
        } else if (keyEvent.keyCode == 13) {
            this.handleTreeItemSelect(false);
        }
    }

    void onMouseDoubleClick(Event event) {
        TreeItem[] treeItemArray = this.favoritesTree.getSelection();
        if (treeItemArray.length > 0 && treeItemArray[0] != null) {
            Rectangle rectangle = event.getBounds();
            Rectangle rectangle2 = treeItemArray[0].getBounds();
            Rectangle rectangle3 = treeItemArray[0].getImageBounds(0);
            if (rectangle3 != null) {
                rectangle2.add(rectangle3);
            }
            if (rectangle2.contains(rectangle.x, rectangle.y)) {
                this.handleTreeItemSelect(false);
            }
        } else {
            this.handleTreeItemSelect(false);
        }
    }

    void onMouseUp(MouseEvent mouseEvent) {
        if (GlobalSettings.isLinux() && mouseEvent.button != 1 && !this.favoritesTree.getMenu().isVisible()) {
            this.favoritesTree.getMenu().setVisible(true);
        }
        if (GlobalSettings.isMac() && mouseEvent.stateMask == 786432) {
            this.favoritesTree.getMenu().setVisible(true);
        }
        if (mouseEvent.button == 1 && !GlobalSettings.isDoubleClickOpen) {
            TreeItem[] treeItemArray = this.favoritesTree.getSelection();
            if (treeItemArray.length <= 0) {
                return;
            }
            Rectangle rectangle = treeItemArray[0].getBounds();
            Rectangle rectangle2 = treeItemArray[0].getImageBounds(0);
            if (rectangle2 != null) {
                rectangle.add(rectangle2);
            }
            if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                this.handleTreeItemSelect(true);
            }
        }
    }

    void onPopupMenuShown() {
        boolean bl = false;
        this.stopRenaming();
        if (this.favoritesTree.getSelectionCount() > 0) {
            TreeItem treeItem = this.favoritesTree.getSelection()[0];
            TreeItemData treeItemData = (TreeItemData)treeItem.getData();
            if (treeItemData.isCategory() && treeItem.getItemCount() == 0) {
                this.rssOwlPopUpMenu.setRequiresUpdate();
            }
            if (treeItemData.isCategory()) {
                bl = this.rssOwlPopUpMenu.updateMenu(1, treeItem);
            } else if (treeItemData.isFavorite()) {
                bl = this.rssOwlPopUpMenu.updateMenu(2, treeItem);
            } else if (treeItemData.isBlogroll()) {
                bl = this.rssOwlPopUpMenu.updateMenu(3, treeItem);
            } else if (treeItemData.isBlogrollFavorite()) {
                bl = this.rssOwlPopUpMenu.updateMenu(4, treeItem);
            }
        } else {
            bl = this.rssOwlPopUpMenu.updateMenu(5, null);
        }
        if (bl) {
            MenuManager.initMnemonics(this.rssOwlPopUpMenu.getTreePopUpMenu());
        }
    }

    void onSelection() {
        GlobalSettings.selectedTreeItem = this.getTreePath(false);
        this.selectionChanged();
    }

    void onTreeEvent(TreeEvent treeEvent, boolean bl) {
        if (this.deletionInProgress || treeEvent.item.isDisposed()) {
            return;
        }
        String string = this.getTreePath((TreeItem)treeEvent.item, true);
        if (string == null) {
            return;
        }
        final Category category = this.getSelectedCat(string);
        if (category != null) {
            category.setExpanded(bl);
        }
        if (bl && category != null && category.isBlogroll() && category.isUnSynchronized()) {
            this.display.timerExec(50, new Runnable(){

                @Override
                public void run() {
                    FavoritesTree.this.eventManager.actionSynchronizeBlogroll(category);
                }
            });
        }
    }

    void performDeletion() {
        TreeItemData treeItemData = null;
        if (this.favoritesTree.getSelection().length > 0) {
            treeItemData = (TreeItemData)this.favoritesTree.getSelection()[0].getData();
        }
        if (treeItemData != null) {
            if (treeItemData.isFavorite()) {
                this.eventManager.actionDeleteFavorite();
            } else if (treeItemData.isCategory()) {
                this.eventManager.actionDeleteCategory();
            } else if (treeItemData.isBlogroll() || treeItemData.isBlogrollFavorite()) {
                this.eventManager.actionDeleteBlogroll();
            }
        }
        this.selectionChanged();
        SettingsManager.getInstance().requestSave();
    }

    void renameCategory(Category category, String string) {
        if (!StringShop.isset(string) || category.getParent().getSubCategories().containsKey(string) || category.getName().equals(string)) {
            return;
        }
        category.getParent().editCategory(category.getName(), string);
        GlobalSettings.selectedTreeItem = category.toCatPath();
        this.buildFavoritesTree();
        SettingsManager.getInstance().requestSave();
    }

    void renameFavorite(Favorite favorite, String string) {
        if (!StringShop.isset(string) || Category.titleExists(string) || favorite.getTitle().equals(string)) {
            return;
        }
        Favorite favorite2 = new Favorite(favorite.getUrl(), string, favorite.getRSSOwlCategory());
        favorite.clone(favorite2);
        favorite.getRSSOwlCategory().editFavorite(favorite, favorite2);
        GlobalSettings.selectedTreeItem = favorite.getRSSOwlCategory().toCatPath() + "=;=" + string;
        this.buildFavoritesTree();
        SettingsManager.getInstance().requestSave();
    }

    void renameSelectedItem() {
        if (this.favoritesTree.getSelectionCount() <= 0) {
            return;
        }
        this.rename(this.favoritesTree.getSelection()[0]);
    }

    void selectionChanged() {
        TreeItem[] treeItemArray = this.favoritesTree.getSelection();
        if (treeItemArray.length > 0) {
            NewsTabFolder newsTabFolder;
            CTabItem cTabItem;
            TreeItem treeItem = treeItemArray[0];
            TreeItemData treeItemData = (TreeItemData)treeItem.getData();
            if (treeItemData.isCategory()) {
                MenuManager.notifyState(12);
            } else if (treeItemData.isBlogroll()) {
                MenuManager.notifyState(13);
            } else if (treeItemData.isFavorite()) {
                MenuManager.notifyState(11);
            } else if (treeItemData.isBlogrollFavorite()) {
                MenuManager.notifyState(14);
            }
            if (GlobalSettings.isDoubleClickOpen && GlobalSettings.linkTreeWithTab && !GlobalSettings.displaySingleTab && WidgetShop.isset(cTabItem = (newsTabFolder = this.rssOwlGui.getRSSOwlNewsTabFolder()).getFeedTabItem(treeItemData.getName()))) {
                newsTabFolder.getNewsHeaderTabFolder().setSelection(cTabItem);
                newsTabFolder.updateTabFolderState();
            }
        } else {
            MenuManager.notifyState(15);
        }
    }

    void setLinkWithTabChecked(boolean bl) {
        if (this.linkTab.getSelection() != bl) {
            this.linkTab.setSelection(bl);
        }
    }
}

