/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.text.Collator;
import java.util.Locale;
import java.util.TreeSet;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.FavoritesTree;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.NewsTabFolder;
import net.sourceforge.rssowl.controller.NewsText;
import net.sourceforge.rssowl.controller.Quickview;
import net.sourceforge.rssowl.controller.RSSOwlLoader;
import net.sourceforge.rssowl.controller.RSSOwlMenu;
import net.sourceforge.rssowl.controller.TutorialBrowser;
import net.sourceforge.rssowl.controller.dialog.ToolBarDialog;
import net.sourceforge.rssowl.controller.statusline.LoadJob;
import net.sourceforge.rssowl.controller.statusline.StatusLine;
import net.sourceforge.rssowl.controller.thread.AggregationLoader;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.controller.thread.FeedLoader;
import net.sourceforge.rssowl.controller.thread.FeedQueueLoader;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.controller.thread.ShutdownHook;
import net.sourceforge.rssowl.controller.thread.StartupManager;
import net.sourceforge.rssowl.controller.thread.UpdateManager;
import net.sourceforge.rssowl.controller.tray.SystemTray;
import net.sourceforge.rssowl.dao.SettingsLoader;
import net.sourceforge.rssowl.dao.SettingsSaver;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.LoggerImpl;
import net.sourceforge.rssowl.util.archive.ArchiveManager;
import net.sourceforge.rssowl.util.archive.FeedCacheManager;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.i18n.LanguageDetector;
import net.sourceforge.rssowl.util.i18n.RSSOwlI18n;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GUI
implements ITranslatable {
    public static Display display;
    public static RSSOwlI18n i18n;
    public static boolean isClosing;
    public static LoggerImpl logger;
    public static GUI rssOwlGui;
    public static Shell shell;
    private Composite boxContainer;
    private SashForm holdContentSash;
    private SashForm holdNewsSash;
    private AmphetaRateThread rssOwlAmphetaRate;
    private CryptoManager rssOwlCryptoManager;
    private FeedAutoUpdater rssOwlFeedAutoUpdater;
    private FeedQueueLoader rssOwlFeedQueueLoader;
    private RSSOwlMenu rssOwlMenu;
    private NewsText rssOwlNewsText;
    private Quickview rssOwlQuickView;
    private SystemTray rssOwlSystray;
    private SettingsManager settingsManager;
    ArchiveManager archiveManager;
    EventManager eventManager;
    FavoritesTree rssOwlFavoritesTree;
    FeedCacheManager rssOwlFeedCacheManager;
    NewsTabFolder rssOwlNewsTabFolder;
    StatusLine rssOwlStatusLine;

    public GUI(Display display, Shell shell) {
        GUI.display = display;
        rssOwlGui = this;
        this.archiveManager = new ArchiveManager();
        this.rssOwlFeedQueueLoader = new FeedQueueLoader();
        this.startUp();
        shell.dispose();
    }

    public static boolean isAlive() {
        return !display.isDisposed() && !shell.isDisposed() && !isClosing;
    }

    public void abnormalShutDown() {
        this.archiveManager.flush();
        this.rssOwlCryptoManager.saveData();
        new SettingsSaver(this).saveUserSettings(true);
        this.rssOwlFeedCacheManager.shutdown();
        StartupManager.stopServer();
    }

    public void changeWindowLayout() {
        if (GlobalSettings.isThreeColumnGUI) {
            this.holdNewsSash.setOrientation(256);
        } else {
            this.holdNewsSash.setOrientation(512);
        }
    }

    public void displayNewsfeed(Channel channel, String string, SearchDefinition searchDefinition, boolean bl, int n) {
        this.rssOwlNewsTabFolder.displayNewsfeed(channel, string, searchDefinition, bl, n);
    }

    public void enableSystrayIcon(boolean bl) {
        if (bl) {
            SystemTray.trayIsTeasing = this.rssOwlFavoritesTree.getTreeHasUnreadFavs();
            this.rssOwlSystray = new SystemTray(display, shell, this);
        } else if (this.rssOwlSystray != null) {
            this.rssOwlSystray.disable();
        }
    }

    public ArchiveManager getArchiveManager() {
        return this.archiveManager;
    }

    public SashForm getContentSash() {
        return this.holdContentSash;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public FeedCacheManager getFeedCacheManager() {
        return this.rssOwlFeedCacheManager;
    }

    public SashForm getNewsSash() {
        return this.holdNewsSash;
    }

    public AmphetaRateThread getRSSOwlAmphetaRate() {
        return this.rssOwlAmphetaRate;
    }

    public FavoritesTree getRSSOwlFavoritesTree() {
        return this.rssOwlFavoritesTree;
    }

    public FeedQueueLoader getRSSOwlFeedQueueLoader() {
        return this.rssOwlFeedQueueLoader;
    }

    public RSSOwlMenu getRSSOwlMenu() {
        return this.rssOwlMenu;
    }

    public NewsTabFolder getRSSOwlNewsTabFolder() {
        return this.rssOwlNewsTabFolder;
    }

    public NewsText getRSSOwlNewsText() {
        return this.rssOwlNewsText;
    }

    public Quickview getRSSOwlQuickview() {
        return this.rssOwlQuickView;
    }

    public StatusLine getRSSOwlStatusLine() {
        return this.rssOwlStatusLine;
    }

    public SystemTray getRSSOwlSystray() {
        return this.rssOwlSystray;
    }

    public boolean isBusyLoading() {
        return this.rssOwlStatusLine.isBusyLoading();
    }

    public void loadNewsFeed(String string, SearchDefinition searchDefinition, boolean bl, boolean bl2, int n) {
        if (!StringShop.isset(string)) {
            return;
        }
        int n2 = 0;
        boolean bl3 = StringShop.isset(searchDefinition.getPattern());
        if (!bl) {
            n2 = 2;
        } else if (bl3) {
            n2 = 1;
        }
        FeedLoader feedLoader = new FeedLoader(string, searchDefinition, bl, bl2, n);
        LoadJob loadJob = new LoadJob(string, Category.getTitleForLink(string), false, n2, feedLoader);
        this.rssOwlStatusLine.insertJob(loadJob);
        this.rssOwlStatusLine.addEntireLoad(1);
        feedLoader.setRSSOwlLoadJob(loadJob);
        feedLoader.startThread();
    }

    public void reloadNewsFeed(String string) {
        boolean bl = this.rssOwlNewsTabFolder.getFeedTabItem(string) != null;
        this.rssOwlFeedCacheManager.unCacheNewsfeed(string, false);
        this.loadNewsFeed(string, SearchDefinition.NO_SEARCH, bl, true, 1);
    }

    public void restoreWindow() {
        if (GlobalSettings.useSystemTray() && this.rssOwlSystray != null && this.rssOwlSystray.isMinimizedToTray()) {
            this.rssOwlSystray.restoreWindow();
        } else {
            shell.forceActive();
            shell.setMinimized(false);
        }
    }

    public void setFavoritesMinimized(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.holdContentSash.getMaximizedControl() != null;
        if (bl3 != bl && WidgetShop.isset(this.holdContentSash)) {
            this.rssOwlFavoritesTree.stopRenaming();
            this.holdContentSash.setMaximizedControl(bl ? this.holdNewsSash : null);
            this.rssOwlMenu.setFavoritesTreeMenuEnabled(!bl);
            if (bl2) {
                GlobalSettings.isFavoritesTreeShown = !bl;
                this.settingsManager.requestSave();
            }
        }
    }

    @Override
    public void updateI18N() {
        this.rssOwlMenu.updateI18N();
        this.rssOwlQuickView.updateI18N();
        this.rssOwlFavoritesTree.updateI18N();
        this.rssOwlNewsTabFolder.updateI18N();
        this.rssOwlNewsText.updateI18N();
        this.rssOwlStatusLine.updateI18N();
        if (this.rssOwlSystray != null) {
            this.rssOwlSystray.updateI18N();
        }
        if (this.eventManager.toolBarDialog != null) {
            this.eventManager.toolBarDialog.updateI18N();
        }
        shell.setText(WidgetShop.getShellTitle());
        LayoutShop.setLayoutForAll(shell);
    }

    private void initComponents() {
        if (GlobalSettings.isMac()) {
            display.addListener(12, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    if (WidgetShop.isset(shell)) {
                        GlobalSettings.shellBounds = shell.getBounds();
                    }
                }
            });
        }
        shell = new Shell(display);
        shell.setLayout(LayoutShop.createGridLayout(1, 0, 0, 3));
        shell.setText(WidgetShop.getShellTitle());
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.addHelpListener(new HelpListener(){

            @Override
            public void helpRequested(HelpEvent helpEvent) {
                new TutorialBrowser(display, shell, rssOwlGui).show();
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!GlobalSettings.isMac() && !shell.isDisposed() && shell.isVisible()) {
                    shell.setVisible(false);
                }
                GUI.this.onDispose();
            }
        });
        shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                GUI.this.onClose(event);
            }
        });
        shell.addListener(19, new Listener(){

            @Override
            public void handleEvent(Event event) {
                GUI.this.onIconify();
            }
        });
        this.eventManager = new EventManager(display, shell, this);
        this.rssOwlMenu = new RSSOwlMenu(this, shell, this.eventManager);
        this.rssOwlQuickView = new Quickview(this, shell, this.eventManager);
        this.boxContainer = new Composite(shell, 0);
        this.boxContainer.setLayout(LayoutShop.createGridLayout(1, 4, 2, 3));
        this.boxContainer.setLayoutData(new GridData(4, 4, true, true));
        this.holdContentSash = new SashForm(this.boxContainer, 65536);
        this.holdContentSash.setLayoutData(LayoutDataShop.createGridData(1808, 4));
        this.rssOwlFavoritesTree = new FavoritesTree(display, shell, this.holdContentSash, this, this.eventManager);
        int n = GlobalSettings.isThreeColumnGUI ? 256 : 512;
        this.holdNewsSash = new SashForm(this.holdContentSash, n | 0x10000);
        this.rssOwlNewsTabFolder = new NewsTabFolder(display, shell, this.holdNewsSash, this, this.eventManager);
        this.rssOwlNewsText = new NewsText(display, shell, this.holdNewsSash, this, this.eventManager);
        this.rssOwlStatusLine = new StatusLine(display, this.boxContainer, this);
        this.eventManager.syncControls();
        this.rssOwlNewsTabFolder.updateTabFolderState();
    }

    private void runEventLoop() {
        block3: {
            try {
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
            catch (Exception exception) {
                logger.log("runEventLoop (Unforseen Exception)", exception);
                logger.logCritical("runEventLoop (Unforseen Exception)", exception);
                int n = MessageBoxFactory.showMessage(shell, 193, i18n.getTranslation("MESSAGE_BOX_TITLE_ERROR"), i18n.getTranslation("ERROR_UNEXPECTED"));
                if (n != 64) break block3;
                BrowserShop.openLink(URLShop.createErrorReport());
            }
        }
        display.dispose();
    }

    private void startUp() {
        SettingsLoader settingsLoader = new SettingsLoader(this);
        this.rssOwlCryptoManager = CryptoManager.getInstance();
        this.archiveManager.startup();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
        this.updateCoreSettings(settingsLoader, false);
        HotkeyShop.initDefaultAccelerators();
        PaintShop.initIcons();
        PaintShop.initColors();
        this.rssOwlFeedCacheManager = new FeedCacheManager();
        this.initComponents();
        this.updateUserSettings(settingsLoader, false);
        if (GlobalSettings.isWelcomeShown) {
            this.rssOwlNewsTabFolder.showWelcomeTab();
        }
        if (GlobalSettings.checkUpdate) {
            new UpdateManager(this, false).start();
        }
        this.rssOwlFeedQueueLoader.startThread();
        this.rssOwlFeedAutoUpdater = new FeedAutoUpdater(this);
        this.rssOwlFeedAutoUpdater.start();
        this.rssOwlAmphetaRate = new AmphetaRateThread();
        this.settingsManager = SettingsManager.getInstance();
        this.settingsManager.start();
        if (GlobalSettings.isLinux()) {
            this.rssOwlFavoritesTree.getFavoritesTree().setFocus();
            this.rssOwlFavoritesTree.getFavoritesTree().notifyListeners(13, new Event());
        }
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && GlobalSettings.trayOnStartup) {
            shell.notifyListeners(19, new Event());
        }
    }

    void onClose(Event event) {
        this.onClose(event, false);
    }

    void onClose(Event event, boolean bl) {
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && GlobalSettings.trayOnExit && !bl) {
            event.doit = false;
            shell.notifyListeners(19, new Event());
            return;
        }
        isClosing = true;
        if (WidgetShop.isset(shell) && (this.rssOwlSystray == null || !this.rssOwlSystray.isMinimizedToTray())) {
            GlobalSettings.shellBounds = shell.getBounds();
            GlobalSettings.isShellMaximized = shell.getMaximized();
        }
    }

    void onDispose() {
        this.shutDown();
    }

    void onIconify() {
        if (GlobalSettings.markAllReadOnMinimize) {
            this.eventManager.actionMarkAllCategoriesRead();
        }
        if (this.rssOwlSystray != null) {
            this.rssOwlSystray.resetPopupTimeLock();
        }
    }

    void showGui() {
        if (!(GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && GlobalSettings.trayOnStartup)) {
            shell.open();
        }
        if (StringShop.isset(RSSOwlLoader.feedArgument)) {
            this.eventManager.actionHandleSuppliedLink(RSSOwlLoader.feedArgument);
        }
        this.runEventLoop();
    }

    void shutDown() {
        this.settingsManager.stopThread();
        this.rssOwlFeedAutoUpdater.interrupt();
        new SettingsSaver(this).saveUserSettings(false);
        this.rssOwlCryptoManager.saveData();
        this.archiveManager.flush();
        this.rssOwlFeedQueueLoader.stopThread();
        this.rssOwlFeedCacheManager.shutdown();
        StartupManager.stopServer();
        FontShop.disposeFonts();
        PaintShop.disposeIcons();
        this.rssOwlFavoritesTree.getRSSOwlFavoritesTreeDND().dispose();
        this.rssOwlNewsTabFolder.getRSSOwlNewsTabFolderDND().dispose();
    }

    void updateCoreSettings(SettingsLoader settingsLoader, boolean bl) {
        GlobalSettings.isWelcomeShown = settingsLoader.getBoolean("isWelcomeShown", true);
        i18n = new RSSOwlI18n(new Locale(settingsLoader.getValue("language", "value", LanguageDetector.parseLanguage(Locale.getDefault()))));
        FontShop.textFont = settingsLoader.loadFont(FontShop.textFont, "textfont", bl);
        FontShop.treeFont = settingsLoader.loadFont(FontShop.treeFont, "treefont", bl);
        FontShop.tableFont = settingsLoader.loadFont(FontShop.tableFont, "tablefont", bl);
        FontShop.headerFont = settingsLoader.loadFont(FontShop.headerFont, "headerfont", bl);
        FontShop.dialogFont = settingsLoader.loadFont(FontShop.dialogFont, "dialogfont", bl);
        FontShop.updateFonts();
        GlobalSettings.linkColor = settingsLoader.loadColor("linkColor", new RGB(0, 0, 255));
        PaintShop.initLinkColor(display);
        if (!bl) {
            GlobalSettings.selectedTreeItem = settingsLoader.getValue("treeSelection", null, "", false);
        }
        GlobalSettings.showSystrayIcon = settingsLoader.getBoolean("showSystrayIcon", false);
        if (GlobalSettings.useInternalBrowser()) {
            if (!bl) {
                GlobalSettings.useBrowserForNewsText = settingsLoader.getBoolean("useBrowserForNewsText", true);
            }
        } else {
            GlobalSettings.useBrowserForNewsText = false;
        }
        GlobalSettings.openBrowserExtern = settingsLoader.getBoolean("openBrowserExtern", false);
        GlobalSettings.isThreeColumnGUI = settingsLoader.getBoolean("isThreeColumnGUI", false);
        GlobalSettings.tabPositionIsTop = settingsLoader.getBoolean("tabPositionIsTop", true);
        GlobalSettings.displaySingleTab = settingsLoader.getBoolean("displaySingleTab", false);
        GlobalSettings.showTabCloseButton = settingsLoader.getBoolean("showTabCloseButton", true);
        GlobalSettings.localCacheFeeds = settingsLoader.getBoolean("localCacheFeeds", true);
        if (!bl) {
            GlobalSettings.workOffline = settingsLoader.getBoolean("workOffline", false);
        }
    }

    void updateUserSettings(SettingsLoader settingsLoader, boolean bl) {
        this.rssOwlFavoritesTree.getFavoritesTree().removeAll();
        Category.getRootCategory().reset();
        settingsLoader.loadProxySettings();
        GlobalSettings.maxConnectionCount = Integer.parseInt(settingsLoader.getValue("maxConnectionCount", "value", "32"));
        GlobalSettings.connectionTimeout = Integer.parseInt(settingsLoader.getValue("connectionTimeout", "value", "30"));
        GlobalSettings.charEncoding = settingsLoader.getValue("encoding", "name", "UTF-8");
        Category.createRootCategory();
        settingsLoader.loadFavorites();
        this.rssOwlFavoritesTree.buildFavoritesTree();
        GlobalSettings.sortOrder = settingsLoader.loadSortOrder();
        GlobalSettings.autoSortNews = settingsLoader.getBoolean("autoSortNews", true);
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        Category.getRootCategory().getLoadOnStartupFavorites(treeSet, Category.getRootCategory());
        if (treeSet.size() > 0) {
            AggregationLoader aggregationLoader = new AggregationLoader(treeSet, Category.getRootCategory(), this, "");
            aggregationLoader.loadFavorites(false);
        }
        GlobalSettings.confirmFavoriteDeletion = settingsLoader.getBoolean("confirmFavoriteDeletion", true);
        GlobalSettings.confirmCategoryDeletion = settingsLoader.getBoolean("confirmCategoryDeletion", true);
        GlobalSettings.confirmBlogrollDeletion = settingsLoader.getBoolean("confirmBlogrollDeletion", true);
        GlobalSettings.trayOnStartup = settingsLoader.getBoolean("trayOnStartup", false);
        GlobalSettings.trayOnExit = settingsLoader.getBoolean("trayOnExit", false);
        GlobalSettings.showTrayPopup = settingsLoader.getBoolean("showTrayPopup", true);
        settingsLoader.loadShellBounds();
        boolean bl2 = GlobalSettings.isShellMaximized;
        Rectangle rectangle = GlobalSettings.shellBounds;
        int n = display.getMonitors().length;
        if (n <= 1) {
            if (rectangle != null && !bl2) {
                shell.setBounds(rectangle);
            }
            if (bl2) {
                shell.setMaximized(bl2);
            }
        } else {
            if (rectangle != null) {
                shell.setBounds(rectangle);
            }
            if (bl2) {
                shell.setMaximized(bl2);
            }
        }
        settingsLoader.loadSashWeights();
        this.holdContentSash.setWeights(GlobalSettings.contentSashWeights);
        this.holdNewsSash.setWeights(GlobalSettings.newsSashWeights);
        GlobalSettings.isQuickviewShown = settingsLoader.getBoolean("isQuickviewShown", true);
        this.rssOwlQuickView.setShowQuickview(GlobalSettings.isQuickviewShown, false);
        GlobalSettings.isToolBarShown = settingsLoader.getBoolean("isToolBarShown", true);
        GlobalSettings.useSmallIcons = settingsLoader.getBoolean("useSmallIcons", true);
        GlobalSettings.toolBarItems = settingsLoader.getValue("toolBarItems", "value", ToolBarDialog.getDefaultToolBarItems());
        GlobalSettings.toolBarMode = Integer.parseInt(settingsLoader.getValue("toolBarMode", "value", String.valueOf(0)));
        this.rssOwlQuickView.createToolBar();
        this.rssOwlQuickView.setShowToolBar(GlobalSettings.isToolBarShown, false);
        GlobalSettings.isTreeToolBarShown = settingsLoader.getBoolean("isTreeToolBarShown", true);
        this.rssOwlFavoritesTree.setShowToolBar(GlobalSettings.isTreeToolBarShown);
        GlobalSettings.isFavoritesTreeShown = settingsLoader.getBoolean("isFavoritesTreeShown", true);
        this.setFavoritesMinimized(!GlobalSettings.isFavoritesTreeShown, false);
        this.rssOwlMenu.setFavoritesTreeMenuEnabled(GlobalSettings.isFavoritesTreeShown);
        GlobalSettings.linkTreeWithTab = settingsLoader.getBoolean("linkTreeWithTab", false);
        if (GlobalSettings.linkTreeWithTab) {
            this.rssOwlFavoritesTree.setLinkWithTabChecked(true);
        }
        GlobalSettings.mailSubject = settingsLoader.getValue("mailSubject", null, "[TITLE]", false);
        GlobalSettings.mailBody = settingsLoader.getValue("mailBody", null, "[TITLE]\n[LINK]\n\n[DESCRIPTION]", false);
        GlobalSettings.bloggerPath = settingsLoader.getValue("bloggerPath", "value", "", false);
        GlobalSettings.bloggerArguments = settingsLoader.getValue("bloggerArguments", "value", "", false);
        GlobalSettings.syntaxHighlightColor = settingsLoader.loadColor("syntaxHighlightColor", new RGB(255, 255, 0));
        PaintShop.initSyntaxHighlightColor(display);
        GlobalSettings.favDefaultReloadOnStartup = settingsLoader.getBoolean("favDefaultReloadOnStartup", false);
        GlobalSettings.favDefaultOpenOnStartup = settingsLoader.getBoolean("favDefaultOpenOnStartup", false);
        GlobalSettings.favDefaultAutoReloadInterval = Integer.parseInt(settingsLoader.getValue("favDefaultAutoReloadInterval", "value", "60"));
        GlobalSettings.directOpenNews = settingsLoader.getBoolean("isDirectOpenNews", false);
        GlobalSettings.showChannelInfo = settingsLoader.getBoolean("showChannelInfo", true);
        GlobalSettings.directOpenEachNews = settingsLoader.getBoolean("directOpenEachNews", false);
        GlobalSettings.openNewBrowserWindow = settingsLoader.getBoolean("openNewBrowserWindow", true);
        GlobalSettings.checkUpdate = settingsLoader.getBoolean("checkUpdate", true);
        GlobalSettings.isDoubleClickOpen = settingsLoader.getBoolean("isDoubleClickOpen", !GlobalSettings.useSingleClickOpen());
        GlobalSettings.focusNewTabs = settingsLoader.getBoolean("focusNewTabs", true);
        GlobalSettings.htmlFormatMail = settingsLoader.getBoolean("htmlFormatMail", true);
        GlobalSettings.showErrors = settingsLoader.getBoolean("showErrors", true);
        GlobalSettings.reopenFeeds = settingsLoader.getBoolean("reopenFeeds", false);
        GlobalSettings.autoCloseNewsPopup = settingsLoader.getBoolean("autoCloseNewsPopup", true);
        GlobalSettings.animateNewsPopup = settingsLoader.getBoolean("animateNewsPopup", true);
        GlobalSettings.markAllReadOnMinimize = settingsLoader.getBoolean("markAllReadOnMinimize", false);
        GlobalSettings.markFeedReadOnTabClose = settingsLoader.getBoolean("markFeedReadOnTabClose", false);
        GlobalSettings.customBrowser = settingsLoader.getValue("customBrowser", "path");
        GlobalSettings.customBrowserArguments = settingsLoader.getValue("customBrowserArguments", "value");
        GlobalSettings.setProxyForAllFavorites = settingsLoader.getBoolean("setProxyForAllFavorites", true);
        this.rssOwlNewsText.setNewsTextToolBarVisible(false);
        this.rssOwlStatusLine.setAmphetaRateItemsVisible(false);
        if (!GlobalSettings.isLinux()) {
            GlobalSettings.blockPopups = settingsLoader.getBoolean("blockPopups", true);
        }
        if (GlobalSettings.useBrowserForNewsText && !bl) {
            this.rssOwlMenu.setUseBrowserForNewsText(GlobalSettings.useBrowserForNewsText);
        }
        settingsLoader.loadHotKeys();
        this.rssOwlMenu.updateAccelerators();
        this.rssOwlMenu.initMnemonics();
        this.rssOwlQuickView.updateI18N();
        GlobalSettings.simpleTabs = settingsLoader.getBoolean("simpleTabs", true);
        this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().setSimple(GlobalSettings.simpleTabs);
        this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().setSelectionBackground(GlobalSettings.displaySingleTab ? PaintShop.grayViewFormColor : display.getSystemColor(1));
        this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().setTabHeight(GlobalSettings.displaySingleTab ? 0 : -1);
        if (GlobalSettings.displaySingleTab) {
            rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabPosition(1024);
        } else {
            this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().setTabPosition(GlobalSettings.tabPositionIsTop ? 128 : 1024);
        }
        if (GlobalSettings.reopenFeeds) {
            settingsLoader.loadReopenFeeds();
        }
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && this.rssOwlSystray == null) {
            this.enableSystrayIcon(true);
        } else if (!GlobalSettings.showSystrayIcon && this.rssOwlSystray != null) {
            this.enableSystrayIcon(false);
        }
    }

    static {
        isClosing = false;
        logger = new LoggerImpl();
    }
}

