/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.IFontChangeable;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.dialog.SearchDialog;
import net.sourceforge.rssowl.controller.dnd.NewsTabFolderDND;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.controller.panel.ErrorPanel;
import net.sourceforge.rssowl.controller.panel.NewsfeedPanel;
import net.sourceforge.rssowl.controller.panel.UpdatePanel;
import net.sourceforge.rssowl.controller.panel.WelcomePanel;
import net.sourceforge.rssowl.controller.thread.AggregationLoader;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.model.TableItemData;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.document.DocumentGenerator;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.search.ParsedSearch;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class NewsTabFolder
implements ITranslatable,
IFontChangeable {
    public static final int DISPLAY_MODE_FOCUS = 0;
    public static final int DISPLAY_MODE_FOCUS_FIRST = 2;
    public static final int DISPLAY_MODE_NO_FOCUS = 1;
    public static final int DISPLAY_MODE_SELECT_NEWS = 3;
    public static final int DISPLAY_MODE_SELECT_UNREAD_NEWS = 4;
    private static final int MAX_HISTORY_ITEMS = 25;
    private static final int MAX_TAB_TITLE_LENGTH = 40;
    private static final int TAB_STATE_BROWSER = 1;
    private static final int TAB_STATE_EMPTY = 0;
    private static final int TAB_STATE_ERROR = 2;
    private static final int TAB_STATE_FEED = 4;
    private static final int TAB_STATE_MESSAGE = 3;
    private MenuItem close;
    private MenuItem closeAll;
    private Display display;
    private Vector lastOpenedFeeds;
    private int lastTabState;
    private Composite newsHeaderTabFolderHolder;
    private NewsTabFolderDND rssOwlNewsTabFolderDND;
    private MenuItem tabPositionMenu;
    MenuItem closeAllKeepCurrent;
    MenuItem closeAllKeepFeeds;
    SashForm contentPane;
    EventManager eventManager;
    ArrayList historyList;
    boolean mouseInTab;
    CTabFolder newsHeaderTabFolder;
    ViewForm newsHeaderViewForm;
    GUI rssOwlGui;
    Shell shell;
    Menu tabFolderMenu;
    MenuItem tabPositionBottom;
    MenuItem tabPositionTop;

    public NewsTabFolder(Display display, Shell shell, SashForm sashForm, GUI gUI, EventManager eventManager) {
        this.display = display;
        this.shell = shell;
        this.contentPane = sashForm;
        this.rssOwlGui = gUI;
        this.eventManager = eventManager;
        this.lastOpenedFeeds = new Vector();
        this.lastTabState = -1;
        this.historyList = new ArrayList();
        this.initComponents();
        this.rssOwlNewsTabFolderDND = new NewsTabFolderDND(this.newsHeaderTabFolder, gUI.getRSSOwlFavoritesTree().getRSSOwlFavoritesTreeDND());
    }

    public void addFeedToLastOpened(String string) {
        if (GlobalSettings.displaySingleTab) {
            this.lastOpenedFeeds.clear();
        }
        if (!this.lastOpenedFeeds.contains(string)) {
            this.lastOpenedFeeds.add(string);
        }
    }

    public void closeTab(CTabItem cTabItem) {
        Channel channel;
        TabItemData tabItemData;
        boolean bl;
        int n = this.newsHeaderTabFolder.getSelectionIndex();
        boolean bl2 = bl = this.newsHeaderTabFolder.getSelection() != null && this.newsHeaderTabFolder.getSelection().equals(cTabItem);
        if (!WidgetShop.isset(cTabItem)) {
            return;
        }
        if (cTabItem.getText() != null && cTabItem.getText().equals(GUI.i18n.getTranslation("TAB_WELCOME"))) {
            GlobalSettings.isWelcomeShown = false;
        }
        TabItemData tabItemData2 = tabItemData = cTabItem.getData() != null ? (TabItemData)cTabItem.getData() : null;
        if (tabItemData != null && tabItemData.isFeed() && tabItemData.getUrl() != null) {
            this.lastOpenedFeeds.remove(tabItemData.getUrl());
        }
        if (GlobalSettings.markFeedReadOnTabClose && tabItemData != null && tabItemData.isFeed() && (channel = tabItemData.getChannel()) != null) {
            this.eventManager.actionMarkAllNewsRead(channel, false);
        }
        if (tabItemData != null) {
            tabItemData.dispose();
        }
        if (cTabItem.getControl() != null) {
            cTabItem.getControl().dispose();
        }
        cTabItem.dispose();
        if (bl && n >= 0 && n < this.newsHeaderTabFolder.getItemCount()) {
            this.newsHeaderTabFolder.setSelection(n);
        }
        this.updateTabFolderState();
        if (this.newsHeaderTabFolder.getMaximized() && this.newsHeaderTabFolder.getItemCount() == 0 && GUI.isAlive()) {
            this.onRestore();
        }
    }

    public Browser createBrowserPopupTab() {
        CTabItem cTabItem;
        CTabItem cTabItem2 = cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        if (GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 && WidgetShop.isset(this.newsHeaderTabFolder.getItem(0)) && WidgetShop.isset(this.newsHeaderTabFolder.getItem(0).getControl())) {
            this.newsHeaderTabFolder.getItem(0).getControl().dispose();
        }
        BrowserPanel browserPanel = new BrowserPanel(this.rssOwlGui, this.newsHeaderTabFolder, cTabItem, true, true);
        cTabItem.setControl(browserPanel.getBrowserPanel());
        cTabItem.setImage(PaintShop.iconWorld);
        cTabItem.setData(TabItemData.createBrowserData(browserPanel));
        if (!GUI.isAlive()) {
            return browserPanel.getBrowser();
        }
        if (this.focusTab() || this.newsHeaderTabFolder.getSelectionIndex() == -1) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
            this.updateTabFolderState();
        }
        if (WidgetShop.isset(browserPanel.getBrowser())) {
            browserPanel.getBrowser().addTitleListener(new TitleListener(){

                @Override
                public void changed(TitleEvent titleEvent) {
                    if (!StringShop.isWhiteSpaceOrEmpty(titleEvent.title) && !"about:blank".equals(titleEvent.title)) {
                        cTabItem.setText(StringShop.pointTrim(titleEvent.title, 40, true));
                    } else {
                        cTabItem.setText(GUI.i18n.getTranslation("NO_TITLE"));
                    }
                }
            });
        }
        return browserPanel.getBrowser();
    }

    public void displayBrowserTab(String string) {
        CTabItem cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        cTabItem.setText(StringShop.pointTrim(string, 40, true));
        cTabItem.setImage(PaintShop.iconWorld);
        this.createBrowserTab(cTabItem, string);
    }

    public void displayNewsfeed(Channel channel, String string, SearchDefinition searchDefinition, boolean bl, int n) {
        boolean bl2;
        boolean bl3;
        int n2;
        Object object;
        TabItemData tabItemData;
        CTabItem cTabItem;
        String string2 = null;
        int[] nArray = null;
        if (!GUI.isAlive() || this.newsHeaderTabFolder.isDisposed()) {
            return;
        }
        boolean bl4 = false;
        boolean bl5 = n == 3 || n == 4;
        BrowserPanel browserPanel = GUI.rssOwlGui.getRSSOwlNewsText().getBrowserPanel();
        if (bl5 && browserPanel != null && WidgetShop.isset(browserPanel.getBrowser())) {
            bl4 = browserPanel.getBrowser().isFocusControl();
        }
        if ((cTabItem = this.getFeedTabItem(string)) == null && channel.isAggregatedCat()) {
            cTabItem = this.getTabItem(channel.getAggregatedCategory());
        }
        if (WidgetShop.isset(cTabItem) && cTabItem.getData() != null) {
            tabItemData = (TabItemData)cTabItem.getData();
            object = tabItemData.getNewsHeaderTable();
            if (bl && WidgetShop.isset((Widget)object) && ((Table)object).getSelectionCount() > 0) {
                string2 = ((Table)object).getSelection()[0].getText(1);
            }
            if (WidgetShop.isset((Widget)object) && ((Table)object).getColumnCount() > 0) {
                nArray = new int[((Table)object).getColumnCount()];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = ((Table)object).getColumn(n2).getWidth();
                }
            }
        }
        if (GlobalSettings.displaySingleTab && cTabItem == null && this.newsHeaderTabFolder.getItemCount() > 0) {
            cTabItem = this.newsHeaderTabFolder.getItem(0);
            tabItemData = (TabItemData)cTabItem.getData();
            if (GlobalSettings.markFeedReadOnTabClose && tabItemData != null && tabItemData.isFeed()) {
                this.eventManager.actionMarkAllNewsRead(tabItemData.getChannel(), false);
            }
        }
        boolean bl6 = bl3 = cTabItem != null;
        if (bl3 && cTabItem != null) {
            cTabItem.getControl().dispose();
        } else {
            cTabItem = new CTabItem(this.getNewsHeaderTabFolder(), 0);
        }
        Object object2 = object = StringShop.isset(string) ? string : GUI.i18n.getTranslation("NO_TITLE");
        if (Category.getTitleForLink((String)object) != null) {
            object = Category.getTitleForLink((String)object);
        } else if (channel != null && StringShop.isset(channel.getTitle())) {
            object = channel.getTitle();
        }
        if (!cTabItem.getText().equals(object)) {
            cTabItem.setText((String)object);
        }
        if ((n2 = (int)(StringShop.isset(searchDefinition.getPattern()) ? 1 : 0)) != 0 && channel != null) {
            channel.peformSearch(ParsedSearch.parseFrom(searchDefinition));
        }
        NewsfeedPanel newsfeedPanel = new NewsfeedPanel(this.rssOwlGui, cTabItem, channel, string, (String)object, searchDefinition.getPattern(), string2, nArray);
        cTabItem.setControl(newsfeedPanel.getNewsfeedPanel());
        boolean bl7 = this.newsHeaderTabFolder.getItemCount() == 1;
        boolean bl8 = this.focusTab();
        if (n == 0 && bl8) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        } else if (n == 2 && bl7 && bl8) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        } else if (this.newsHeaderTabFolder.getSelectionIndex() == -1) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        } else if (n == 0 && bl3) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        } else if (n == 3 && bl8) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        } else if (n == 4 && bl8) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        }
        this.updateTabItemStatus(cTabItem);
        this.updateTabFolderState();
        if (bl5 && !GlobalSettings.linkTreeWithTab) {
            this.linkSelectionToTree();
        }
        if (Category.getFavPool().containsKey(string) && channel != null) {
            Favorite favorite = (Favorite)Category.getFavPool().get(string);
            favorite.updateReadStatus(channel.getUnreadNewsCount());
        }
        boolean bl9 = bl2 = channel != null && channel.getItemCount() > 0;
        if (bl2 && n == 3) {
            this.eventManager.actionGotoNextNews();
        } else if (bl2 && n == 4) {
            this.eventManager.actionGotoNextUnreadNews();
        }
        if (bl4 && browserPanel != null && WidgetShop.isset(browserPanel.getBrowser()) && !browserPanel.getBrowser().isFocusControl()) {
            browserPanel.getBrowser().setFocus();
        }
        this.addHistoryItem(string, (String)object);
    }

    public boolean focusTab() {
        if (GlobalSettings.displaySingleTab) {
            return true;
        }
        return GlobalSettings.focusNewTabs || this.newsHeaderTabFolder.getItemCount() == 1;
    }

    public CTabItem getFeedTabItem(String string) {
        if (!StringShop.isset(string)) {
            return null;
        }
        CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            TabItemData tabItemData;
            if (!WidgetShop.isset(cTabItemArray[i]) || (tabItemData = (TabItemData)cTabItemArray[i].getData()) == null || !tabItemData.isFeed() && !tabItemData.isError()) continue;
            String string2 = cTabItemArray[i].getText();
            if (string.equals(string2) || string.equals(Category.getLinkForTitle(string2))) {
                return cTabItemArray[i];
            }
            if (tabItemData.getUrl() == null || !tabItemData.getUrl().equals(string)) continue;
            return cTabItemArray[i];
        }
        return null;
    }

    public Vector getLastOpenedFeeds() {
        return this.lastOpenedFeeds;
    }

    public CTabFolder getNewsHeaderTabFolder() {
        return this.newsHeaderTabFolder;
    }

    public NewsTabFolderDND getRSSOwlNewsTabFolderDND() {
        return this.rssOwlNewsTabFolderDND;
    }

    public Channel getSelectedChannel() {
        if (this.newsHeaderTabFolder.getSelectionIndex() != -1) {
            return this.getChannel(this.newsHeaderTabFolder.getSelection());
        }
        return null;
    }

    public CTabItem getTabItem(Category category) {
        CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            TabItemData tabItemData;
            if (!WidgetShop.isset(cTabItemArray[i]) || !(tabItemData = (TabItemData)cTabItemArray[i].getData()).showsCategory(category)) continue;
            return cTabItemArray[i];
        }
        return null;
    }

    public boolean isAggregationOpened(String string) {
        CTabItem[] cTabItemArray = this.getNewsHeaderTabFolder().getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            String string2;
            TabItemData tabItemData = (TabItemData)cTabItemArray[i].getData();
            if (!tabItemData.isAggregatedCat() || !string.equals(string2 = cTabItemArray[i].getText()) && !string.equals(Category.getLinkForTitle(string2))) continue;
            return true;
        }
        return false;
    }

    public boolean isFeedOpened(String string) {
        CTabItem[] cTabItemArray = this.getNewsHeaderTabFolder().getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            TabItemData tabItemData = (TabItemData)cTabItemArray[i].getData();
            if (!tabItemData.isFeed() || !StringShop.isset(string) || !string.equals(tabItemData.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void loadURLInTab(String string) {
        if (GlobalSettings.openNewBrowserWindow) {
            this.displayBrowserTab(string);
        } else {
            int n;
            CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
            for (n = 0; n < cTabItemArray.length; ++n) {
                TabItemData tabItemData = (TabItemData)cTabItemArray[n].getData();
                if (tabItemData == null || !tabItemData.isBrowser()) continue;
                Browser browser = tabItemData.getRSSOwlBrowserPanel().getBrowser();
                if (!browser.isDisposed()) {
                    tabItemData.getRSSOwlBrowserPanel().openUrl(string);
                    cTabItemArray[n].setText(StringShop.pointTrim(string, 40, true));
                    if (!this.focusTab()) break;
                    this.newsHeaderTabFolder.setSelection(cTabItemArray[n]);
                    this.updateTabFolderState();
                    break;
                }
                this.displayBrowserTab(string);
                break;
            }
            if (n == cTabItemArray.length) {
                this.displayBrowserTab(string);
            }
        }
    }

    public void reloadFeed() {
        CTabItem cTabItem = this.newsHeaderTabFolder.getSelection();
        this.reloadFeed(cTabItem);
    }

    public void searchInSelectedFeed() {
        SearchDialog searchDialog = new SearchDialog(this.shell, GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE"), GUI.i18n.getTranslation("SEARCH_DIALOG_MESSAGE"));
        if (searchDialog.open() == 0 && StringShop.isset(searchDialog.getValue().getPattern())) {
            this.searchInSelectedFeed(searchDialog.getValue(), true);
        }
    }

    public void searchInSelectedFeed(SearchDefinition searchDefinition, boolean bl) {
        if (this.newsHeaderTabFolder.getSelectionIndex() < 0) {
            return;
        }
        TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
        String string = tabItemData.getUrl();
        if (string == null && tabItemData.getTitle() != null) {
            string = Category.getLinkForTitle(tabItemData.getTitle());
        }
        this.rssOwlGui.loadNewsFeed(string, searchDefinition, true, bl, 0);
    }

    public void showErrorTab(CTabItem cTabItem, NewsfeedFactoryException newsfeedFactoryException) {
        ErrorPanel errorPanel = new ErrorPanel(this.rssOwlGui, this.display, this.eventManager, this.newsHeaderTabFolder, newsfeedFactoryException);
        cTabItem.setFont(FontShop.headerFont);
        cTabItem.setControl(errorPanel.getPanel());
    }

    public void showErrorTab(String string, NewsfeedFactoryException newsfeedFactoryException) {
        CTabItem cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        cTabItem.setData(TabItemData.createErrorData(string));
        cTabItem.setImage(PaintShop.iconError);
        cTabItem.setFont(FontShop.headerFont);
        if (Category.getTitleForLink(string) != null) {
            cTabItem.setText(Category.getTitleForLink(string));
        } else {
            cTabItem.setText(StringShop.escapeAmpersands(string));
        }
        this.showErrorTab(cTabItem, newsfeedFactoryException);
        if (this.focusTab() || this.newsHeaderTabFolder.getSelectionIndex() == -1) {
            this.newsHeaderTabFolder.setSelection(cTabItem);
        }
        this.updateTabFolderState();
    }

    public void showLicenseTab(InputStream inputStream, Image image) {
        String string = FileShop.getContent(inputStream);
        this.showMessageTab(string, "EPL - Eclipse Public License", image);
    }

    public void showUpdateAvailableTab(String string, String string2) {
        if (!GUI.isAlive() || this.newsHeaderTabFolder.isDisposed()) {
            return;
        }
        CTabItem cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        cTabItem.setText(string);
        cTabItem.setData(TabItemData.createMessageData(string));
        cTabItem.setImage(PaintShop.loadImage("/img/icons/update.gif"));
        UpdatePanel updatePanel = new UpdatePanel(this.display, this.newsHeaderTabFolder, string, string2);
        cTabItem.setControl(updatePanel.getPanel());
        this.newsHeaderTabFolder.setSelection(cTabItem);
        this.updateTabFolderState();
    }

    @Override
    public void updateFonts() {
        this.newsHeaderTabFolder.setFont(FontShop.headerFont);
        CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            CTabItem cTabItem = cTabItemArray[i];
            cTabItem.setFont(FontShop.headerFont);
            TabItemData tabItemData = (TabItemData)cTabItem.getData();
            if (tabItemData.getChannel() != null && tabItemData.getChannel().containsUnreadNews()) {
                cTabItem.setFont(FontShop.headerBoldFont);
            } else {
                cTabItem.setFont(FontShop.headerFont);
            }
            if (!WidgetShop.isset(tabItemData.getNewsHeaderTable())) continue;
            Table table = tabItemData.getNewsHeaderTable();
            table.setFont(FontShop.tableFont);
            TableItem[] tableItemArray = table.getItems();
            for (int j = 0; j < tableItemArray.length; ++j) {
                TableItem tableItem;
                TableItemData tableItemData = (TableItemData)(tableItem = tableItemArray[j]).getData();
                tableItem.setFont(tableItemData.isNewsRead() ? FontShop.tableFont : FontShop.tableBoldFont);
            }
            TableColumn[] tableColumnArray = table.getColumns();
            for (int j = 0; j < tableColumnArray.length; ++j) {
                tableColumnArray[j].pack();
            }
        }
    }

    @Override
    public void updateI18N() {
        this.close.setText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.closeAll.setText(GUI.i18n.getTranslation("MENU_CLOSE_ALL"));
        this.closeAllKeepCurrent.setText(GUI.i18n.getTranslation("POP_KEEP_CURRENT"));
        this.closeAllKeepFeeds.setText(GUI.i18n.getTranslation("POP_KEEP_NEWSFEEDS"));
        this.tabPositionBottom.setText(GUI.i18n.getTranslation("POP_TAB_POS_BOTTOM"));
        this.tabPositionTop.setText(GUI.i18n.getTranslation("POP_TAB_POS_TOP"));
        this.tabPositionMenu.setText(GUI.i18n.getTranslation("POP_TAB_POSITION"));
        MenuManager.initMnemonics(this.tabFolderMenu);
    }

    public void updateLastOpenedFeeds() {
        this.lastOpenedFeeds.clear();
        CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            TabItemData tabItemData = (TabItemData)cTabItemArray[i].getData();
            if (!tabItemData.isFeed() || tabItemData.isAggregatedCat()) continue;
            this.addFeedToLastOpened(tabItemData.getUrl());
        }
    }

    public void updateTabFolderState() {
        TabItemData tabItemData = null;
        if (this.newsHeaderTabFolder.getSelection() != null) {
            tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
        }
        if (this.newsHeaderTabFolder.getItemCount() > 1) {
            MenuManager.notifyState(8);
        } else {
            MenuManager.notifyState(7);
        }
        if (tabItemData == null) {
            this.announceTabFolderState(tabItemData, 0);
        } else if (tabItemData.isMessage()) {
            this.announceTabFolderState(tabItemData, 3);
        } else if (tabItemData.isBrowser()) {
            this.announceTabFolderState(tabItemData, 1);
        } else if (tabItemData.isError()) {
            this.announceTabFolderState(tabItemData, 2);
        } else if (tabItemData.isFeed()) {
            this.announceTabFolderState(tabItemData, 4);
        }
        this.updateViewFormBorder();
    }

    public void updateTabItemStatus(CTabItem cTabItem) {
        boolean bl;
        if (!WidgetShop.isset(cTabItem) || !(cTabItem.getData() instanceof TabItemData) || GlobalSettings.displaySingleTab) {
            return;
        }
        TabItemData tabItemData = (TabItemData)cTabItem.getData();
        if (!tabItemData.isFeed() && !tabItemData.isAggregatedCat()) {
            return;
        }
        Channel channel = tabItemData.getChannel();
        boolean bl2 = !PaintShop.isset(cTabItem.getImage()) || cTabItem.getImage().equals(PaintShop.iconError);
        boolean bl3 = !bl2 && (cTabItem.getImage().equals(PaintShop.iconRead) && channel.containsUnreadNews() || cTabItem.getImage().equals(PaintShop.iconUnread) && !channel.containsUnreadNews());
        boolean bl4 = bl = bl2 || bl3 || tabItemData.isShowsUnreadNews() != channel.containsUnreadNews() || tabItemData.isAggregatedCat() != channel.isAggregatedCat();
        if (!bl) {
            return;
        }
        if (channel.isAggregatedCat()) {
            cTabItem.setImage(channel.containsUnreadNews() ? PaintShop.iconFolderUnread : PaintShop.iconFolder);
        } else {
            cTabItem.setImage(channel.containsUnreadNews() ? PaintShop.iconUnread : PaintShop.iconRead);
        }
        cTabItem.setFont(channel.containsUnreadNews() ? FontShop.headerBoldFont : FontShop.headerFont);
        tabItemData.setShowsUnreadNews(channel.containsUnreadNews());
        this.newsHeaderTabFolder.layout();
    }

    private void addHistoryItem(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" =;;= ").append(string2);
        String string3 = stringBuffer.toString();
        int n = this.historyList.indexOf(string3);
        if (n >= 0 && n >= 25) {
            this.historyList.remove(string3);
            this.historyList.add(0, string3);
        } else if (n < 0) {
            this.historyList.add(0, string3);
        }
    }

    private void initComponents() {
        this.newsHeaderTabFolderHolder = new Composite(this.contentPane, 0);
        this.newsHeaderTabFolderHolder.setLayout(new FillLayout());
        int n = GlobalSettings.isMac() ? 0x800800 : 2048;
        this.newsHeaderViewForm = new ViewForm(this.newsHeaderTabFolderHolder, n);
        this.newsHeaderTabFolder = new CTabFolder(this.newsHeaderViewForm, GlobalSettings.displaySingleTab || !GlobalSettings.showTabCloseButton ? 0 : 64);
        this.newsHeaderTabFolder.setFont(FontShop.headerFont);
        this.newsHeaderTabFolder.setSimple(GlobalSettings.simpleTabs);
        this.newsHeaderTabFolder.setSelectionBackground(GlobalSettings.displaySingleTab ? PaintShop.grayViewFormColor : this.display.getSystemColor(1));
        this.newsHeaderTabFolder.setTabPosition(GlobalSettings.tabPositionIsTop ? 128 : 1024);
        this.newsHeaderTabFolder.setMRUVisible(true);
        this.newsHeaderTabFolder.setMaximizeVisible(true);
        this.newsHeaderTabFolder.setMinimumCharacters(10);
        this.newsHeaderTabFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItemData tabItemData;
                NewsTabFolder.this.updateTabFolderState();
                if (WidgetShop.isset(selectionEvent.item) && (tabItemData = (TabItemData)selectionEvent.item.getData()).isFeed() && WidgetShop.isset(tabItemData.getNewsHeaderTable())) {
                    tabItemData.getNewsHeaderTable().setFocus();
                }
            }
        });
        this.newsHeaderTabFolder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                CTabItem cTabItem;
                if (!GlobalSettings.displaySingleTab && mouseEvent.button == 2 && WidgetShop.isset(cTabItem = NewsTabFolder.this.newsHeaderTabFolder.getItem(new Point(mouseEvent.x, mouseEvent.y)))) {
                    NewsTabFolder.this.closeTab(cTabItem);
                }
            }
        });
        this.newsHeaderTabFolder.addCTabFolder2Listener(new CTabFolder2Adapter(){

            @Override
            public void close(CTabFolderEvent cTabFolderEvent) {
                cTabFolderEvent.doit = false;
                NewsTabFolder.this.closeTab((CTabItem)cTabFolderEvent.item);
            }

            @Override
            public void maximize(CTabFolderEvent cTabFolderEvent) {
                NewsTabFolder.this.onMaximize();
            }

            @Override
            public void restore(CTabFolderEvent cTabFolderEvent) {
                NewsTabFolder.this.onRestore();
            }
        });
        this.initTabFolderPopup();
        this.newsHeaderViewForm.setContent(this.newsHeaderTabFolder, true);
    }

    private void initTabFolderPopup() {
        this.mouseInTab = false;
        this.tabFolderMenu = new Menu(this.newsHeaderTabFolder);
        this.tabFolderMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                if (GlobalSettings.displaySingleTab || NewsTabFolder.this.newsHeaderTabFolder.getItemCount() <= 0 || NewsTabFolder.this.newsHeaderTabFolder.getSelectionIndex() == -1) {
                    NewsTabFolder.this.tabFolderMenu.setVisible(false);
                    return;
                }
                if (NewsTabFolder.this.newsHeaderTabFolder.getItemCount() == 1) {
                    NewsTabFolder.this.closeAllKeepCurrent.setEnabled(false);
                } else if (!NewsTabFolder.this.closeAllKeepCurrent.getEnabled()) {
                    NewsTabFolder.this.closeAllKeepCurrent.setEnabled(true);
                }
                if (NewsTabFolder.this.isOnlyFeedsOpen() || NewsTabFolder.this.isNoFeedOpen()) {
                    NewsTabFolder.this.closeAllKeepFeeds.setEnabled(false);
                } else if (!NewsTabFolder.this.closeAllKeepFeeds.getEnabled()) {
                    NewsTabFolder.this.closeAllKeepFeeds.setEnabled(true);
                }
            }
        });
        this.newsHeaderTabFolder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                NewsTabFolder.this.onMouseDoubleClick(mouseEvent);
            }
        });
        this.close = new MenuItem(this.tabFolderMenu, 8);
        this.close.setText(GUI.i18n.getTranslation("MENU_CLOSE"));
        this.close.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NewsTabFolder.this.newsHeaderTabFolder.getSelection() == null) {
                    return;
                }
                NewsTabFolder.this.closeCurrent();
            }
        });
        new MenuItem(this.tabFolderMenu, 2);
        this.closeAllKeepCurrent = new MenuItem(this.tabFolderMenu, 8);
        this.closeAllKeepCurrent.setText(GUI.i18n.getTranslation("POP_KEEP_CURRENT"));
        this.closeAllKeepCurrent.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTabFolder.this.closeAll(true, false);
            }
        });
        this.closeAllKeepFeeds = new MenuItem(this.tabFolderMenu, 8);
        this.closeAllKeepFeeds.setText(GUI.i18n.getTranslation("POP_KEEP_NEWSFEEDS"));
        this.closeAllKeepFeeds.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTabFolder.this.closeAll(false, true);
            }
        });
        this.closeAll = new MenuItem(this.tabFolderMenu, 8);
        this.closeAll.setText(GUI.i18n.getTranslation("MENU_CLOSE_ALL"));
        this.closeAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTabFolder.this.closeAll();
            }
        });
        new MenuItem(this.tabFolderMenu, 2);
        this.tabPositionMenu = new MenuItem(this.tabFolderMenu, 64);
        this.tabPositionMenu.setText(GUI.i18n.getTranslation("POP_TAB_POSITION"));
        Menu menu = new Menu(this.shell, 4);
        this.tabPositionMenu.setMenu(menu);
        this.tabPositionTop = new MenuItem(menu, 16);
        this.tabPositionTop.setText(GUI.i18n.getTranslation("POP_TAB_POS_TOP"));
        this.tabPositionTop.setSelection(GlobalSettings.tabPositionIsTop);
        this.tabPositionTop.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NewsTabFolder.this.tabPositionTop.getSelection()) {
                    NewsTabFolder.this.newsHeaderTabFolder.setTabPosition(128);
                    GlobalSettings.tabPositionIsTop = true;
                    NewsTabFolder.this.newsHeaderTabFolder.layout();
                }
            }
        });
        this.tabPositionBottom = new MenuItem(menu, 16);
        this.tabPositionBottom.setText(GUI.i18n.getTranslation("POP_TAB_POS_BOTTOM"));
        this.tabPositionBottom.setSelection(!GlobalSettings.tabPositionIsTop);
        this.tabPositionBottom.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NewsTabFolder.this.tabPositionBottom.getSelection()) {
                    NewsTabFolder.this.newsHeaderTabFolder.setTabPosition(1024);
                    GlobalSettings.tabPositionIsTop = false;
                    NewsTabFolder.this.newsHeaderTabFolder.layout();
                }
            }
        });
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent menuEvent) {
                NewsTabFolder.this.tabPositionTop.setSelection(GlobalSettings.tabPositionIsTop);
                NewsTabFolder.this.tabPositionBottom.setSelection(!GlobalSettings.tabPositionIsTop);
            }
        });
        MenuManager.initMnemonics(this.tabFolderMenu);
        this.newsHeaderTabFolder.setMenu(this.tabFolderMenu);
    }

    void announceTabFolderState(TabItemData tabItemData, int n) {
        switch (n) {
            case 0: {
                if (this.lastTabState == 5) {
                    return;
                }
                this.setMaximized(false);
                MenuManager.notifyState(5);
                this.lastTabState = 5;
                Control control = this.display.getFocusControl();
                if (!WidgetShop.isset(control) || !(control instanceof Text) && !(control instanceof Combo)) {
                    this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                }
                MenuManager.notifyState(4);
                this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                if (!this.newsHeaderTabFolder.getVisible()) break;
                this.newsHeaderTabFolder.setVisible(false);
                break;
            }
            case 3: {
                if (this.lastTabState == 1) {
                    return;
                }
                this.setMaximized(true);
                MenuManager.notifyState(1);
                this.lastTabState = 1;
                MenuManager.notifyState(4);
                this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                if (this.newsHeaderTabFolder.getVisible()) break;
                this.newsHeaderTabFolder.setVisible(true);
                break;
            }
            case 2: {
                if (GlobalSettings.linkTreeWithTab) {
                    this.linkSelectionToTree();
                }
                if (this.lastTabState == 10) {
                    return;
                }
                this.setMaximized(false);
                MenuManager.notifyState(10);
                this.lastTabState = 10;
                Control control = this.display.getFocusControl();
                if (!WidgetShop.isset(control) || !(control instanceof Text) && !(control instanceof Combo)) {
                    this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                }
                MenuManager.notifyState(4);
                this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                if (this.newsHeaderTabFolder.getVisible()) break;
                this.newsHeaderTabFolder.setVisible(true);
                break;
            }
            case 1: {
                BrowserPanel browserPanel = tabItemData.getRSSOwlBrowserPanel();
                if (browserPanel != null && WidgetShop.isset(browserPanel.getBrowser())) {
                    if (!"about:blank".equals(browserPanel.getBrowser().getUrl())) {
                        browserPanel.getBrowser().setFocus();
                    } else if (WidgetShop.isset(browserPanel.getLocation())) {
                        browserPanel.getLocation().setFocus();
                        browserPanel.getLocation().selectAll();
                    }
                }
                if (this.lastTabState == 1) {
                    return;
                }
                this.setMaximized(true);
                MenuManager.notifyState(1);
                this.lastTabState = 1;
                MenuManager.notifyState(4);
                this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                this.rssOwlGui.getRSSOwlMenu().updateAccelerators(true);
                if (this.newsHeaderTabFolder.getVisible()) break;
                this.newsHeaderTabFolder.setVisible(true);
                break;
            }
            case 4: {
                this.setMaximized(false);
                if (!this.newsHeaderTabFolder.getVisible()) {
                    this.newsHeaderTabFolder.setVisible(true);
                }
                MenuManager.notifyState(2);
                this.lastTabState = 2;
                Control control = this.display.getFocusControl();
                if (!WidgetShop.isset(control) || !(control instanceof Text) && !(control instanceof Combo)) {
                    this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
                }
                if (GlobalSettings.linkTreeWithTab) {
                    this.linkSelectionToTree();
                }
                Table table = null;
                if (WidgetShop.isset(tabItemData.getNewsHeaderTable())) {
                    table = tabItemData.getNewsHeaderTable();
                }
                if (WidgetShop.isset(table) && table.getSelectionIndex() >= 0) {
                    MenuManager.notifyState(6);
                    String string = tabItemData.getUrl();
                    String string2 = table.getSelection()[0].getText(1);
                    NewsItem newsItem = this.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedNewsItem(string2);
                    if (newsItem == null) {
                        return;
                    }
                    if (!GlobalSettings.useBrowserForNewsText && (GlobalSettings.directOpenEachNews || GlobalSettings.directOpenNews) && (GlobalSettings.directOpenEachNews || newsItem.getDescription() == null)) break;
                    this.rssOwlGui.getRSSOwlNewsText().displayNews(string, string2);
                    MenuManager.notifyState(3);
                    break;
                }
                if (table == null || table.isDisposed()) {
                    MenuManager.notifyState(9);
                    this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                    MenuManager.notifyState(4);
                    break;
                }
                this.rssOwlGui.getRSSOwlNewsText().clearNewstext();
                MenuManager.notifyState(4);
            }
        }
    }

    void closeAll() {
        boolean bl = GlobalSettings.linkTreeWithTab;
        GlobalSettings.linkTreeWithTab = false;
        this.closeAll(false, false);
        GlobalSettings.linkTreeWithTab = bl;
    }

    void closeAll(boolean bl, boolean bl2) {
        CTabItem[] cTabItemArray = this.newsHeaderTabFolder.getItems();
        int n = this.newsHeaderTabFolder.getSelectionIndex();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            if (bl && i != n) {
                this.closeTab(cTabItemArray[i]);
                continue;
            }
            if (bl2 && cTabItemArray[i].getData() != null && !((TabItemData)cTabItemArray[i].getData()).isFeed()) {
                this.closeTab(cTabItemArray[i]);
                continue;
            }
            if (bl || bl2) continue;
            this.closeTab(cTabItemArray[i]);
        }
    }

    void closeCurrent() {
        if (this.newsHeaderTabFolder.getSelection() != null) {
            this.closeTab(this.newsHeaderTabFolder.getSelection());
        }
    }

    void createBrowserTab(final CTabItem cTabItem, String string) {
        try {
            BrowserPanel browserPanel = new BrowserPanel(this.rssOwlGui, this.newsHeaderTabFolder, cTabItem, true, true);
            cTabItem.setControl(browserPanel.getBrowserPanel());
            cTabItem.setData(TabItemData.createBrowserData(browserPanel));
            browserPanel.openUrl(string);
            if (this.focusTab() || this.newsHeaderTabFolder.getSelectionIndex() == -1) {
                this.newsHeaderTabFolder.setSelection(cTabItem);
                this.updateTabFolderState();
            }
            browserPanel.getBrowser().addTitleListener(new TitleListener(){

                @Override
                public void changed(TitleEvent titleEvent) {
                    if (!StringShop.isWhiteSpaceOrEmpty(titleEvent.title) && !"about:blank".equals(titleEvent.title)) {
                        cTabItem.setText(StringShop.pointTrim(titleEvent.title, 40, true));
                    } else {
                        cTabItem.setText(GUI.i18n.getTranslation("NO_TITLE"));
                    }
                }
            });
        }
        catch (SWTError sWTError) {
            GUI.logger.log("createBrowserTab()", sWTError);
            cTabItem.dispose();
            GlobalSettings.openBrowserExtern = true;
            MessageBoxFactory.showError(this.shell, BrowserShop.createBrowserError(sWTError));
            this.eventManager.actionOpenFAQOnBrowser();
            BrowserShop.openLink(string);
        }
    }

    void exportToDocument(File file, int n, String string) {
        Channel channel = this.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedChannel();
        if (channel != null) {
            TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string == null && WidgetShop.isset(tabItemData.getNewsHeaderTable())) {
                Table table = tabItemData.getNewsHeaderTable();
                int n2 = table.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(table.getItem(i).getText(1));
                }
            } else if (string != null) {
                arrayList.add(string);
            }
            if (file != null) {
                try {
                    new DocumentGenerator(channel, new FileOutputStream(file), n).createDocument(arrayList);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    GUI.logger.log("exportToDocument()", fileNotFoundException);
                    MessageBoxFactory.showError(this.shell, fileNotFoundException);
                }
                catch (DocumentException documentException) {
                    GUI.logger.log("exportToDocument()", documentException);
                    MessageBoxFactory.showError(this.shell, documentException);
                }
                catch (IOException iOException) {
                    GUI.logger.log("exportToDocument()", iOException);
                    MessageBoxFactory.showError(this.shell, iOException);
                }
            }
        }
    }

    void exportToDocument(int n, String string) {
        TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
        String string2 = DateParser.dateToFileName(DateParser.formatDate());
        String string3 = string == null ? StringShop.createFileName(tabItemData.getTitle()) : StringShop.createFileName(string);
        if (string3.matches("[_]+")) {
            string3 = "rssowl";
        }
        String string4 = n == 2 ? GUI.i18n.getTranslation("MENU_GENERATE_RTF") : (n == 1 ? GUI.i18n.getTranslation("MENU_GENERATE_HTML") : GUI.i18n.getTranslation("MENU_GENERATE_PDF"));
        String string5 = string3 + "_rss_" + string2 + "." + DocumentGenerator.formatToString(n);
        String string6 = FileShop.getSavePath(string5, DocumentGenerator.formatToString(n), string4);
        if (!StringShop.isset(string6)) {
            return;
        }
        this.exportToDocument(new File(string6), n, string);
    }

    void fillHistory(Menu menu) {
        boolean bl = this.historyList.size() == 0;
        for (int i = 0; i < this.historyList.size() && i < 25; ++i) {
            String[] stringArray = ((String)this.historyList.get(i)).split(" =;;= ");
            String string = stringArray[0];
            String string2 = stringArray[1];
            StringBuffer stringBuffer = new StringBuffer(string2);
            Image image = null;
            Channel channel = this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string);
            if (channel != null) {
                boolean bl2;
                int n = channel.getUnreadNewsCount();
                boolean bl3 = bl2 = n > 0;
                if (bl2) {
                    stringBuffer.append(" (").append(n).append(")");
                }
                image = channel.isAggregatedCat() && bl2 ? PaintShop.iconFolderUnread : (channel.isAggregatedCat() ? PaintShop.iconFolder : (bl2 ? PaintShop.iconLenseUnread : PaintShop.iconLense));
            }
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(stringBuffer.toString());
            menuItem.setData(string);
            if (!GlobalSettings.isMac() && PaintShop.isset(image)) {
                menuItem.setImage(image);
            }
            menuItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (WidgetShop.isset(selectionEvent.widget)) {
                        NewsTabFolder.this.eventManager.actionOpenFeed((String)selectionEvent.widget.getData());
                    }
                }
            });
        }
        if (!bl) {
            new MenuItem(menu, 2);
        }
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(GUI.i18n.getTranslation("POP_CLEAR_HISTORY"));
        menuItem.setEnabled(!bl);
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsTabFolder.this.historyList.clear();
            }
        });
    }

    Channel getChannel(CTabItem cTabItem) {
        TabItemData tabItemData = (TabItemData)cTabItem.getData();
        if (tabItemData.getChannel() != null) {
            return tabItemData.getChannel();
        }
        if (this.rssOwlGui.getFeedCacheManager().isNewsfeedCached(tabItemData.getUrl(), false)) {
            return this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(tabItemData.getUrl());
        }
        if (tabItemData.getTitle() != null && Category.getLinkForTitle(tabItemData.getTitle()) != null) {
            return this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(Category.getLinkForTitle(tabItemData.getTitle()));
        }
        return null;
    }

    NewsItem getSelectedNewsItem() {
        TableItem[] tableItemArray;
        TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
        if (tabItemData != null && tabItemData.getNewsHeaderTable() != null && (tableItemArray = tabItemData.getNewsHeaderTable().getSelection()).length == 1) {
            return this.getSelectedNewsItem(tableItemArray[0].getText(1));
        }
        return null;
    }

    NewsItem getSelectedNewsItem(String string) {
        Channel channel = this.getSelectedChannel();
        if (channel != null) {
            return (NewsItem)channel.getItems().get(string);
        }
        return null;
    }

    void gotoNextTab() {
        int n = this.newsHeaderTabFolder.getSelectionIndex();
        int n2 = -1;
        if (this.newsHeaderTabFolder.getItemCount() > n + 1) {
            n2 = n + 1;
        } else if (this.newsHeaderTabFolder.getItemCount() > 1) {
            n2 = 0;
        }
        if (n2 >= 0) {
            TabItemData tabItemData;
            this.newsHeaderTabFolder.showItem(this.newsHeaderTabFolder.getItem(n2));
            this.newsHeaderTabFolder.setSelection(this.newsHeaderTabFolder.getItem(n2));
            this.updateTabFolderState();
            CTabItem cTabItem = this.newsHeaderTabFolder.getSelection();
            if (WidgetShop.isset(cTabItem) && (tabItemData = (TabItemData)cTabItem.getData()).isFeed() && WidgetShop.isset(tabItemData.getNewsHeaderTable())) {
                tabItemData.getNewsHeaderTable().setFocus();
            }
        }
    }

    void gotoPreviousTab() {
        int n = this.newsHeaderTabFolder.getSelectionIndex();
        int n2 = -1;
        if (n > 0) {
            n2 = n - 1;
        } else if (n == 0 && this.newsHeaderTabFolder.getItemCount() > 1) {
            n2 = this.newsHeaderTabFolder.getItemCount() - 1;
        }
        if (n2 >= 0) {
            TabItemData tabItemData;
            this.newsHeaderTabFolder.showItem(this.newsHeaderTabFolder.getItem(n2));
            this.newsHeaderTabFolder.setSelection(this.newsHeaderTabFolder.getItem(n2));
            this.updateTabFolderState();
            CTabItem cTabItem = this.newsHeaderTabFolder.getSelection();
            if (WidgetShop.isset(cTabItem) && (tabItemData = (TabItemData)cTabItem.getData()).isFeed() && WidgetShop.isset(tabItemData.getNewsHeaderTable())) {
                tabItemData.getNewsHeaderTable().setFocus();
            }
        }
    }

    boolean isNoFeedOpen() {
        int n = this.newsHeaderTabFolder.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!((TabItemData)this.newsHeaderTabFolder.getItem(i).getData()).isFeed()) continue;
            return false;
        }
        return true;
    }

    boolean isOnlyFeedsOpen() {
        int n = this.newsHeaderTabFolder.getItemCount();
        for (int i = 0; i < n; ++i) {
            TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getItem(i).getData();
            if (tabItemData == null || tabItemData.isFeed()) continue;
            return false;
        }
        return true;
    }

    void linkSelectionToTree() {
        TreeItem treeItem;
        if (!WidgetShop.isset(this.newsHeaderTabFolder) || this.newsHeaderTabFolder.getSelectionIndex() == -1) {
            return;
        }
        TabItemData tabItemData = (TabItemData)this.newsHeaderTabFolder.getSelection().getData();
        if (!tabItemData.isFeed() && !tabItemData.isError()) {
            return;
        }
        if (tabItemData.isAggregatedCat()) {
            treeItem = tabItemData.getAggregatedCategory().getTreeItem();
        } else {
            if (!Category.getFavPool().containsKey(tabItemData.getUrl())) {
                return;
            }
            Favorite favorite = (Favorite)Category.getFavPool().get(tabItemData.getUrl());
            treeItem = favorite.getTreeItem();
        }
        if (!WidgetShop.isset(treeItem)) {
            return;
        }
        this.rssOwlGui.getRSSOwlFavoritesTree().getFavoritesTree().showItem(treeItem);
        this.rssOwlGui.getRSSOwlFavoritesTree().getFavoritesTree().setSelection(new TreeItem[]{treeItem});
    }

    void onMaximize() {
        this.newsHeaderTabFolder.setMaximized(true);
        this.rssOwlGui.setFavoritesMinimized(true, false);
        this.rssOwlGui.getRSSOwlQuickview().setShowQuickview(false, false);
        this.rssOwlGui.getRSSOwlQuickview().setShowToolBar(false, false);
    }

    void onMouseDoubleClick(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.stateMask;
        boolean bl2 = (n & 0x40000) != 0 || (n & 0x400000) != 0;
        boolean bl3 = n == 131072;
        boolean bl4 = bl = bl2 || bl3;
        if (this.newsHeaderTabFolder.getItemCount() == 0 || this.newsHeaderTabFolder.getSelectionIndex() == -1) {
            this.mouseInTab = false;
            return;
        }
        Rectangle rectangle = this.newsHeaderTabFolder.getSelection().getBounds();
        boolean bl5 = this.mouseInTab = mouseEvent.x > rectangle.x && mouseEvent.x < rectangle.width + rectangle.x;
        if (this.mouseInTab && !bl) {
            this.closeCurrent();
        } else if (this.mouseInTab && bl2) {
            this.closeAll(true, false);
        } else if (this.mouseInTab && bl3) {
            this.closeAll(false, true);
        }
    }

    void onRestore() {
        this.newsHeaderTabFolder.setMaximized(false);
        this.rssOwlGui.setFavoritesMinimized(!GlobalSettings.isFavoritesTreeShown, false);
        this.rssOwlGui.getRSSOwlQuickview().setShowQuickview(GlobalSettings.isQuickviewShown, false);
        this.rssOwlGui.getRSSOwlQuickview().setShowToolBar(GlobalSettings.isToolBarShown, false);
    }

    void reloadFeed(CTabItem cTabItem) {
        TabItemData tabItemData = (TabItemData)cTabItem.getData();
        if (tabItemData.isAggregatedCat()) {
            this.rssOwlGui.getFeedCacheManager().unCacheNewsfeed(cTabItem.getText(), false);
            AggregationLoader aggregationLoader = new AggregationLoader(tabItemData.getChannel().getAggregatedFavorites(), tabItemData.getAggregatedCategory(), this.rssOwlGui, tabItemData.getAggregatedCategory().toCatPath(true));
            aggregationLoader.setReload(true);
            aggregationLoader.loadFavorites(true);
        } else {
            String string = tabItemData.getUrl();
            if (string == null && Category.getLinkForTitle(tabItemData.getTitle()) != null) {
                string = Category.getLinkForTitle(tabItemData.getTitle());
            }
            this.rssOwlGui.reloadNewsFeed(string);
        }
    }

    void setMaximized(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.contentPane.getMaximizedControl() != null;
        if (bl2 != bl) {
            this.contentPane.setMaximizedControl(bl ? this.newsHeaderTabFolderHolder : null);
        }
    }

    void showMessageTab(String string, String string2, Image image) {
        if (!GUI.isAlive() || this.newsHeaderTabFolder.isDisposed()) {
            return;
        }
        CTabItem cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        cTabItem.setText(string2);
        cTabItem.setData(TabItemData.createMessageData(string2));
        cTabItem.setImage(image);
        Composite composite = new Composite(this.newsHeaderTabFolder, 0);
        composite.setLayout(LayoutShop.createFillLayout(10, 10));
        composite.setBackground(this.display.getSystemColor(1));
        StyledText styledText = new StyledText(composite, 586);
        styledText.setText(string);
        styledText.setCaret(null);
        styledText.setFont(FontShop.textFont);
        styledText.setBackground(this.display.getSystemColor(1));
        cTabItem.setControl(composite);
        this.newsHeaderTabFolder.setSelection(cTabItem);
        this.updateTabFolderState();
    }

    void showWelcomeTab() {
        if (!GUI.isAlive() || this.newsHeaderTabFolder.isDisposed()) {
            return;
        }
        CTabItem cTabItem = GlobalSettings.displaySingleTab && this.newsHeaderTabFolder.getItemCount() > 0 ? this.newsHeaderTabFolder.getItem(0) : new CTabItem(this.newsHeaderTabFolder, 0);
        cTabItem.setText(GUI.i18n.getTranslation("TAB_WELCOME"));
        cTabItem.setData(TabItemData.createMessageData(GUI.i18n.getTranslation("TAB_WELCOME")));
        cTabItem.setImage(PaintShop.iconInfo);
        WelcomePanel welcomePanel = new WelcomePanel(this.display, this.eventManager, this.newsHeaderTabFolder);
        cTabItem.setControl(welcomePanel.getPanel());
        this.newsHeaderTabFolder.setSelection(cTabItem);
        this.updateTabFolderState();
        this.onMaximize();
    }

    void updateViewFormBorder() {
        if (!this.newsHeaderViewForm.isDisposed() && !this.newsHeaderTabFolder.isDisposed()) {
            this.newsHeaderViewForm.set3DBorderState(this.newsHeaderTabFolder.getItemCount() != 0);
        }
    }

    void viewNewsInDocument(int n) {
        boolean bl = true;
        try {
            File file = File.createTempFile(DocumentGenerator.formatToString(n), "." + DocumentGenerator.formatToString(n), new File(GlobalSettings.TEMP_DIR));
            this.exportToDocument(file, n, null);
            switch (n) {
                case 0: {
                    bl = Program.launch(file.toString());
                    break;
                }
                case 2: {
                    bl = Program.launch(file.toString());
                    break;
                }
                case 1: {
                    BrowserShop.openLinkInTab("file://" + file.toString());
                }
            }
            if (!bl) {
                MessageBoxFactory.showMessage(this.shell, 8, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_ATTENTION"), StringShop.printf(GUI.i18n.getTranslation("MESSAGEBOX_LAUNCH_FAILED"), new String[]{"%FORMAT%"}, new String[]{DocumentGenerator.formatToString(n).toUpperCase()}));
            }
        }
        catch (IOException iOException) {
            GUI.logger.log("viewNewsInDocument()", iOException);
            MessageBoxFactory.showError(this.shell, iOException);
        }
    }
}

