/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeNode {
    private boolean filterRead;
    private boolean isUnread;
    private TreeItem item;

    public TreeNode(TreeItem treeItem, boolean bl) {
        this.item = treeItem;
        this.filterRead = bl;
        if (WidgetShop.isset(treeItem)) {
            this.isUnread = ((TreeItemData)treeItem.getData()).isStatusUnread();
        }
    }

    public TreeNode getFirstChild() {
        if (WidgetShop.isset(this.item) && !this.exclude() && this.item.getItemCount() > 0) {
            return new TreeNode(this.item.getItems()[0], this.filterRead);
        }
        return null;
    }

    public TreeItem getItem() {
        return this.item;
    }

    public TreeNode getNextSibling() {
        if (!WidgetShop.isset(this.item)) {
            return null;
        }
        TreeItem treeItem = this.item.getParentItem();
        if (WidgetShop.isset(treeItem)) {
            int n = treeItem.indexOf(this.item);
            if (treeItem.getItemCount() > n + 1) {
                return new TreeNode(treeItem.getItem(n + 1), this.filterRead);
            }
            return null;
        }
        Tree tree = this.item.getParent();
        int n = tree.indexOf(this.item);
        if (tree.getItemCount() > n + 1) {
            return new TreeNode(tree.getItem(n + 1), this.filterRead);
        }
        return null;
    }

    public TreeNode getParent() {
        if (!WidgetShop.isset(this.item)) {
            return null;
        }
        return new TreeNode(this.item.getParentItem(), this.filterRead);
    }

    public boolean hasChildNodes() {
        return WidgetShop.isset(this.item) && !this.exclude() && this.item.getItemCount() > 0;
    }

    private boolean exclude() {
        return this.filterRead && !this.isUnread;
    }
}

