/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import net.sourceforge.rssowl.util.shop.PaintShop;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ViewForm
extends Composite {
    private static final int OFFSCREEN = -200;
    public int marginHeight = 0;
    public int marginWidth = 0;
    private int BORDER_BOTTOM = 0;
    private int BORDER_LEFT = 0;
    private int BORDER_RIGHT = 0;
    private int BORDER_TOP = 0;
    private Control content;
    private boolean draw3DBorder;
    private int drawLine1 = -1;
    private int drawLine2 = -1;
    private boolean isToolBarMode = false;
    private Rectangle oldArea;
    private boolean onlyBorderBottom;
    private boolean onlyBorderTop;
    private boolean onlyBorderTopBottom;
    private boolean separateTopCenter = false;
    private boolean showBorder = false;
    private Control topCenter;
    private Control topLeft;
    private Control topRight;

    public ViewForm(Composite composite, int n) {
        super(composite, ViewForm.checkStyle(n));
        this.draw3DBorder = (n & 0x800000) == 0;
        this.setBorderVisible((n & 0x800) != 0);
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                ViewForm.this.onPaint(paintEvent.gc);
            }
        });
        this.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent controlEvent) {
                ViewForm.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                ViewForm.this.onDispose();
            }
        });
    }

    static int checkStyle(int n) {
        int n2 = 0x6800000;
        return n & n2 | 0x100000;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        SerializableCompatibility serializableCompatibility;
        this.checkWidget();
        Point point = new Point(0, 0);
        if (this.topLeft != null) {
            point = this.topLeft.computeSize(-1, -1);
            point.x = point.x + (this.isToolBarMode ? 0 : 1);
        }
        Point point2 = new Point(0, 0);
        if (this.topCenter != null) {
            point2 = this.topCenter.computeSize(-1, -1);
        }
        Point point3 = new Point(0, 0);
        if (this.topRight != null) {
            point3 = this.topRight.computeSize(-1, -1);
        }
        Point point4 = new Point(0, 0);
        if (this.separateTopCenter || n != -1 && point.x + point2.x + point3.x > n) {
            point4.x = point.x + point3.x;
            point4.x = Math.max(point2.x, point4.x);
            point4.y = Math.max(point.y, point3.y) + (this.isToolBarMode ? 0 : 1);
            if (this.topCenter != null) {
                point4.y += point2.y;
            }
        } else {
            point4.x = point.x + point2.x + point3.x;
            point4.y = Math.max(point.y, Math.max(point2.y, point3.y)) + (this.isToolBarMode ? 0 : 1);
        }
        if (this.content != null) {
            serializableCompatibility = new Point(0, 0);
            serializableCompatibility = this.content.computeSize(-1, -1);
            point4.x = Math.max(point4.x, serializableCompatibility.x);
            point4.y += serializableCompatibility.y + 1;
        }
        point4.x += 2 * this.marginWidth;
        point4.y += 2 * this.marginHeight;
        if (n != -1) {
            point4.x = n;
        }
        if (n2 != -1) {
            point4.y = n2;
        }
        serializableCompatibility = this.computeTrim(0, 0, point4.x, point4.y);
        return new Point(((Rectangle)serializableCompatibility).width, ((Rectangle)serializableCompatibility).height);
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = n - this.BORDER_LEFT;
        int n6 = n2 - this.BORDER_TOP;
        int n7 = n3 + this.BORDER_LEFT + this.BORDER_RIGHT;
        int n8 = n4 + this.BORDER_TOP + this.BORDER_BOTTOM;
        return new Rectangle(n5, n6, n7, n8);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        rectangle.x += this.BORDER_LEFT;
        rectangle.y += this.BORDER_TOP;
        rectangle.width -= this.BORDER_LEFT + this.BORDER_RIGHT;
        rectangle.height -= this.BORDER_TOP + this.BORDER_BOTTOM;
        return rectangle;
    }

    public Control getContent() {
        return this.content;
    }

    public Control getTopCenter() {
        return this.topCenter;
    }

    public Control getTopLeft() {
        return this.topLeft;
    }

    public Control getTopRight() {
        return this.topRight;
    }

    @Override
    public void layout(boolean bl) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        this.drawLine1 = -1;
        this.drawLine2 = -1;
        Point point = new Point(0, 0);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            point = this.topLeft.computeSize(-1, -1);
        }
        Point point2 = new Point(0, 0);
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            point2 = this.topCenter.computeSize(-1, -1);
        }
        Point point3 = new Point(0, 0);
        if (this.topRight != null && !this.topRight.isDisposed()) {
            point3 = this.topRight.computeSize(-1, -1);
        }
        int n = point.x + point2.x + point3.x + 2 * this.marginWidth + (this.isToolBarMode ? 0 : 1);
        int n2 = rectangle.y + this.marginHeight;
        boolean bl2 = false;
        if (this.separateTopCenter || n > rectangle.width) {
            int n3 = Math.max(point3.y, point.y);
            if (this.topRight != null && !this.topRight.isDisposed()) {
                bl2 = true;
                this.topRight.setBounds(rectangle.x + rectangle.width - this.marginWidth - point3.x, rectangle.y + 1 + this.marginHeight, point3.x, n3);
                n2 += 1 + n3;
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                bl2 = true;
                point = this.topLeft.computeSize(rectangle.width - 2 * this.marginWidth - point3.x - 1, -1);
                this.topLeft.setBounds(rectangle.x + (this.isToolBarMode ? 0 : 1) + this.marginWidth, rectangle.y + (this.isToolBarMode ? 0 : 1) + this.marginHeight, point.x, n3);
                n2 = Math.max(n2, rectangle.y + this.marginHeight + (this.isToolBarMode ? 0 : 1) + n3);
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                bl2 = true;
                if (n2 > rectangle.y + this.marginHeight) {
                    this.drawLine1 = n2++;
                }
                point2 = this.topCenter.computeSize(rectangle.width - 2 * this.marginWidth, -1);
                if (this.isToolBarMode && this.content == null) {
                    this.drawLine1 = -1;
                    --n2;
                }
                this.topCenter.setBounds(rectangle.x + rectangle.width - this.marginWidth - point2.x, n2, point2.x, point2.y);
                n2 += point2.y;
            }
        } else {
            int n4 = Math.max(point3.y, Math.max(point2.y, point.y));
            if (this.topRight != null && !this.topRight.isDisposed()) {
                bl2 = true;
                this.topRight.setBounds(rectangle.x + rectangle.width - this.marginWidth - point3.x, rectangle.y + this.marginHeight + 1, point3.x, n4);
                n2 += 1 + n4;
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                bl2 = true;
                if (this.isToolBarMode) {
                    this.topCenter.setBounds(rectangle.x + point.x - this.marginWidth, rectangle.y + this.marginHeight, rectangle.width - 2 * this.marginWidth - point.x, n4);
                } else {
                    this.topCenter.setBounds(rectangle.x + rectangle.width - this.marginWidth - point3.x - point2.x, rectangle.y + this.marginHeight + 1, point2.x, n4);
                }
                n2 = Math.max(n2, rectangle.y + this.marginHeight + (this.isToolBarMode ? 0 : 1) + n4);
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                bl2 = true;
                point = this.isToolBarMode ? (point = this.topLeft.computeSize(-1, n4)) : this.topLeft.computeSize(rectangle.width - 2 * this.marginWidth - point3.x - point2.x - 1, n4);
                this.topLeft.setBounds(rectangle.x + this.marginWidth + (this.isToolBarMode ? 0 : 1), rectangle.y + this.marginHeight + (this.isToolBarMode ? 0 : 1), point.x, n4);
                n2 = Math.max(n2, rectangle.y + this.marginHeight + (this.isToolBarMode ? 0 : 1) + n4);
            }
        }
        if (this.content != null && !this.content.isDisposed()) {
            if (bl2) {
                this.drawLine2 = n2++;
            }
            this.content.setBounds(rectangle.x + this.marginWidth, n2, rectangle.width - 2 * this.marginWidth, rectangle.y + rectangle.height - n2 - this.marginHeight);
        }
    }

    public void set3DBorderState(boolean bl) {
        if (bl == this.draw3DBorder) {
            return;
        }
        this.draw3DBorder = bl;
        this.redraw();
    }

    public void setBorderVisible(boolean bl) {
        this.checkWidget();
        if (this.showBorder == bl) {
            return;
        }
        this.showBorder = bl;
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0 || !this.draw3DBorder) {
                this.BORDER_BOTTOM = 1;
                this.BORDER_RIGHT = 1;
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
            } else {
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
                this.BORDER_BOTTOM = 3;
                this.BORDER_RIGHT = 3;
            }
        } else {
            this.BORDER_RIGHT = 0;
            this.BORDER_LEFT = 0;
            this.BORDER_TOP = 0;
            this.BORDER_BOTTOM = 0;
        }
        this.layout();
        this.redraw();
    }

    public void setContent(Control control, boolean bl) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setBounds(-200, -200, 0, 0);
        }
        this.content = control;
        if (bl) {
            this.layout();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            this.topLeft.setFont(font);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            this.topCenter.setFont(font);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.topRight.setFont(font);
        }
        this.layout();
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setOnlyBorderBottom(boolean bl) {
        this.onlyBorderBottom = bl;
    }

    public void setOnlyBorderTop(boolean bl) {
        this.onlyBorderTop = bl;
    }

    public void setOnlyBorderTopBottom(boolean bl) {
        this.onlyBorderTopBottom = bl;
    }

    public void setToolBarMode(boolean bl) {
        this.isToolBarMode = bl;
    }

    public void setTopCenter(Control control, boolean bl) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            this.topCenter.setBounds(-200, -200, 0, 0);
        }
        this.topCenter = control;
        if (bl) {
            this.layout();
        }
    }

    public void setTopCenterSeparate(boolean bl, boolean bl2) {
        this.checkWidget();
        this.separateTopCenter = bl;
        if (bl2) {
            this.layout();
        }
    }

    public void setTopLeft(Control control, boolean bl) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            this.topLeft.setBounds(-200, -200, 0, 0);
        }
        this.topLeft = control;
        if (bl) {
            this.layout();
        }
    }

    public void setTopRight(Control control, boolean bl) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.topRight.setBounds(-200, -200, 0, 0);
        }
        this.topRight = control;
        if (bl) {
            this.layout();
        }
    }

    void onDispose() {
        this.topLeft = null;
        this.topCenter = null;
        this.topRight = null;
        this.content = null;
        this.oldArea = null;
    }

    void onPaint(GC gC) {
        int n;
        Rectangle rectangle = super.getClientArea();
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0 || !this.draw3DBorder) {
                gC.setForeground(PaintShop.viewFormBorderInsideColor);
                if (this.onlyBorderTopBottom) {
                    gC.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                    gC.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                } else if (this.onlyBorderTop) {
                    gC.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                } else if (this.onlyBorderBottom) {
                    gC.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                } else {
                    gC.drawRectangle(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                }
            } else {
                gC.setForeground(PaintShop.viewFormBorderInsideColor);
                gC.drawRectangle(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 3);
                gC.setForeground(PaintShop.viewFormBorderMiddleColor);
                gC.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
                gC.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
                gC.setForeground(PaintShop.viewFormBorderOutsideColor);
                gC.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
                gC.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
            }
        }
        if (this.drawLine1 != -1) {
            gC.setForeground(PaintShop.viewFormBorderInsideColor);
            gC.drawLine(rectangle.x + this.BORDER_LEFT - 1, this.drawLine1, rectangle.x + rectangle.width - this.BORDER_RIGHT, this.drawLine1);
        }
        if (this.drawLine2 != -1) {
            n = this.onlyBorderBottom || this.onlyBorderTop || this.onlyBorderTopBottom ? 1 : 0;
            gC.setForeground(PaintShop.viewFormBorderInsideColor);
            gC.drawLine(rectangle.x + this.BORDER_LEFT - n, this.drawLine2, rectangle.x + rectangle.width - this.BORDER_RIGHT, this.drawLine2);
        }
        if ((n = this.drawLine1) == -1) {
            n = this.drawLine2;
        }
        if (n != -1) {
            gC.setForeground(PaintShop.grayViewFormColor);
            gC.drawLine(rectangle.x + this.BORDER_LEFT + this.marginWidth, rectangle.y + this.BORDER_TOP + this.marginHeight, rectangle.x + this.BORDER_LEFT + this.marginWidth, n - 1);
            gC.drawLine(rectangle.x + this.BORDER_LEFT + this.marginWidth, rectangle.y + this.BORDER_TOP + this.marginHeight, rectangle.x + rectangle.width - this.BORDER_RIGHT - this.marginWidth - 1, rectangle.y + this.BORDER_TOP + this.marginHeight);
        }
        gC.setForeground(this.getForeground());
    }

    void onResize() {
        this.layout();
        Rectangle rectangle = super.getClientArea();
        if (this.oldArea == null || this.oldArea.width == 0 || this.oldArea.height == 0) {
            this.redraw();
        } else {
            int n = 0;
            if (this.oldArea.width < rectangle.width) {
                n = rectangle.width - this.oldArea.width + this.BORDER_RIGHT;
            } else if (this.oldArea.width > rectangle.width) {
                n = this.BORDER_RIGHT;
            }
            this.redraw(rectangle.x + rectangle.width - n, rectangle.y, n, rectangle.height, false);
            int n2 = 0;
            if (this.oldArea.height < rectangle.height) {
                n2 = rectangle.height - this.oldArea.height + this.BORDER_BOTTOM;
            }
            if (this.oldArea.height > rectangle.height) {
                n2 = this.BORDER_BOTTOM;
            }
            this.redraw(rectangle.x, rectangle.y + rectangle.height - n2, rectangle.width, n2, false);
        }
        this.oldArea = rectangle;
    }
}

