/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.dao.Importer;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom.JDOMException;

public class BlogrollDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private String dialogTitle;
    private Text inputTitle;
    private Text inputUrl;
    private boolean isEdit;
    private GUI rssOwlGui;
    Category blogrollCategory;
    String dialogMessage;
    Button okButton;

    public BlogrollDialog(GUI gUI, Shell shell, String string, String string2) {
        super(shell);
        this.rssOwlGui = gUI;
        this.dialogTitle = string;
        this.dialogMessage = string2;
        this.isEdit = false;
    }

    public BlogrollDialog(GUI gUI, Shell shell, String string, String string2, Category category) {
        super(shell);
        this.rssOwlGui = gUI;
        this.dialogTitle = string;
        this.dialogMessage = string2;
        this.blogrollCategory = category;
        this.isEdit = true;
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importBlogroll() {
        if (this.isEdit) {
            if (this.blogrollCategory.getPathToBlogroll().equals(this.inputUrl.getText()) && this.blogrollCategory.getName().equals(this.inputTitle.getText())) {
                return true;
            }
            if (!this.blogrollCategory.getName().equals(this.inputTitle.getText()) && this.blogrollCategory.getPathToBlogroll().equals(this.inputUrl.getText())) {
                String string = StringShop.isset(this.inputTitle.getText()) ? this.inputTitle.getText() : this.inputUrl.getText();
                this.blogrollCategory.getParent().editCategory(this.blogrollCategory.getName(), string);
                GlobalSettings.selectedTreeItem = this.blogrollCategory.toCatPath();
                this.rssOwlGui.getRSSOwlFavoritesTree().buildFavoritesTree();
                SettingsManager.getInstance().requestSave();
                return true;
            }
        }
        try {
            this.getShell().setCursor(GUI.display.getSystemCursor(1));
            String string = StringShop.isset(this.inputTitle.getText()) ? this.inputTitle.getText() : this.inputUrl.getText();
            Importer importer = new Importer(this.inputUrl.getText(), string, this.blogrollCategory != null ? this.blogrollCategory : Category.getRootCategory());
            importer.importNewsfeeds(true);
            GlobalSettings.selectedTreeItem = this.blogrollCategory != null ? this.blogrollCategory.toCatPath() + "=;=" + string : string;
            this.rssOwlGui.getRSSOwlFavoritesTree().buildFavoritesTree();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.setMessage(GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"), 3);
        }
        catch (JDOMException jDOMException) {
            this.setMessage(jDOMException.getLocalizedMessage(), 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setMessage(illegalArgumentException.getLocalizedMessage(), 3);
        }
        finally {
            this.getShell().setCursor(null);
        }
        return false;
    }

    @Override
    protected void buttonPressed(int n) {
        if (n != 0 || this.importBlogroll()) {
            super.buttonPressed(n);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.dialogTitle);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.inputUrl.setFocus();
        this.okButton.setEnabled(this.isEdit);
        this.okButton.setFont(FontShop.dialogFont);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 20));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/newsub_big.gif"));
        this.setMessage(this.dialogMessage, 1);
        Label label = new Label(composite2, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_URL_PATH") + ": ");
        label.setLayoutData(new GridData(32));
        label.setFont(FontShop.dialogFont);
        this.inputUrl = new Text(composite2, 2052);
        this.inputUrl.setLayoutData(new GridData(768));
        this.inputUrl.setFont(FontShop.dialogFont);
        this.inputUrl.setText(this.blogrollCategory != null ? this.blogrollCategory.getPathToBlogroll() : "");
        this.inputUrl.setFocus();
        WidgetShop.tweakTextWidget(this.inputUrl);
        this.inputUrl.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                BlogrollDialog.this.validateInput();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_TITLE") + ": ");
        label2.setLayoutData(new GridData(32));
        label2.setFont(FontShop.dialogFont);
        this.inputTitle = new Text(composite2, 2052);
        this.inputTitle.setLayoutData(new GridData(768));
        this.inputTitle.setFont(FontShop.dialogFont);
        this.inputTitle.setText(this.blogrollCategory != null ? this.blogrollCategory.getName() : "");
        WidgetShop.tweakTextWidget(this.inputTitle);
        this.inputTitle.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                BlogrollDialog.this.validateInput();
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label3 = new Label(composite3, 258);
        label3.setLayoutData(new GridData(768));
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | BlogrollDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    protected void validateInput() {
        String string = null;
        if ((this.isEdit && !this.blogrollCategory.getPathToBlogroll().equals(this.inputUrl.getText()) || !this.isEdit) && Category.blogrollExists(this.inputUrl.getText())) {
            string = GUI.i18n.getTranslation("ERROR_SUB_EXISTS");
        }
        if ((this.isEdit && !this.blogrollCategory.getName().equals(this.inputTitle.getText()) || !this.isEdit) && Category.getRootCategory().getSubCategories().containsKey(this.inputTitle.getText())) {
            string = GUI.i18n.getTranslation("ERROR_CAT_EXISTS");
        }
        if (string == null) {
            this.setMessage(this.dialogMessage, 1);
            this.okButton.setEnabled(true);
        } else {
            this.setMessage(string, 3);
            this.okButton.setEnabled(false);
        }
        if (this.inputUrl.getText().equals("")) {
            this.okButton.setEnabled(false);
        }
    }
}

