/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.Importer;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom.JDOMException;

public class ImportOPMLDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private String dialogTitle;
    private GUI rssOwlGui;
    String dialogMessage;
    Text filePath;
    boolean isError;
    Button okButton;

    public ImportOPMLDialog(GUI gUI, Shell shell, String string, String string2) {
        super(shell);
        this.rssOwlGui = gUI;
        this.dialogTitle = string;
        this.dialogMessage = string2;
        this.isError = false;
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importOpml() {
        try {
            this.getShell().setCursor(GUI.display.getSystemCursor(1));
            Importer importer = new Importer(this.filePath.getText().trim(), Category.getRootCategory());
            importer.importNewsfeeds(false);
            this.rssOwlGui.getRSSOwlFavoritesTree().buildFavoritesTree();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.setMessage(GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"), 3);
            this.isError = true;
        }
        catch (JDOMException jDOMException) {
            this.setMessage(jDOMException.getLocalizedMessage(), 3);
            this.isError = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setMessage(illegalArgumentException.getLocalizedMessage(), 3);
            this.isError = true;
        }
        finally {
            this.getShell().setCursor(null);
        }
        return false;
    }

    @Override
    protected void buttonPressed(int n) {
        if (n != 0 || this.importOpml()) {
            super.buttonPressed(n);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.dialogTitle);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.filePath.setFocus();
        this.okButton.setEnabled(false);
        this.okButton.setFont(FontShop.dialogFont);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 20));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/import_big.gif"));
        this.setMessage(this.dialogMessage, 1);
        this.filePath = new Text(composite2, 2052);
        this.filePath.setLayoutData(new GridData(768));
        this.filePath.setFont(FontShop.dialogFont);
        this.filePath.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                ImportOPMLDialog.this.okButton.setEnabled(!ImportOPMLDialog.this.filePath.getText().trim().equals(""));
                if (ImportOPMLDialog.this.isError) {
                    ImportOPMLDialog.this.setMessage(ImportOPMLDialog.this.dialogMessage, 1);
                    ImportOPMLDialog.this.isError = false;
                }
            }
        });
        WidgetShop.tweakTextWidget(this.filePath);
        Button button = new Button(composite2, 8);
        button.setText(GUI.i18n.getTranslation("BUTTON_FILE") + "...");
        button.setFont(FontShop.dialogFont);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileShop.getFilePath(ImportOPMLDialog.this.getShell(), new String[]{"*.opml", "*.xml", "*.*"}, null, 4096, null, GUI.i18n.getTranslation("MENU_IMPORT_OPML"));
                if (string != null) {
                    ImportOPMLDialog.this.filePath.setText(string);
                }
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label = new Label(composite3, 258);
        label.setLayoutData(new GridData(768));
        WidgetShop.initMnemonics(new Button[]{button});
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | ImportOPMLDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

