/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private static final String PROTOCOL_SEPARATOR = "://";
    static int openDialogsCount = 0;
    private String dialogMessage;
    private Text domain;
    private String domainValue;
    private boolean isNtlm;
    private Text password;
    private String passwordValue;
    private String pathOrUrl;
    private Button saveData;
    private String title;
    private Text username;
    private String usernameValue;

    public LoginDialog(Shell shell, String string, String string2, String string3, boolean bl) {
        super(shell);
        this.pathOrUrl = string3;
        this.title = string;
        this.dialogMessage = string2;
        this.isNtlm = bl;
    }

    @Override
    public boolean close() {
        --openDialogsCount;
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    public String getDomain() {
        return this.domainValue;
    }

    public String getPassword() {
        return this.passwordValue;
    }

    public String getUsername() {
        return this.usernameValue;
    }

    @Override
    public int open() {
        ++openDialogsCount;
        return super.open();
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            this.usernameValue = this.username.getText();
            this.passwordValue = this.password.getText();
            if (this.isNtlm) {
                this.domainValue = this.domain.getText();
            }
        }
        if (n == 0 && this.saveData.getSelection()) {
            String string = this.usernameValue + " =;;= " + this.passwordValue;
            if (this.isNtlm && StringShop.isset(this.domainValue)) {
                string = string + " =;;= " + this.domainValue;
            }
            CryptoManager.getInstance().addItem(this.pathOrUrl, string);
        } else if (n == 0 && !this.saveData.getSelection()) {
            CryptoManager.getInstance().removeItem(this.pathOrUrl);
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        ((GridLayout)composite.getLayout()).marginHeight = 10;
        ((GridLayout)composite.getLayout()).marginWidth = 10;
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
        } else {
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Control control;
        Object object;
        Object object2;
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/baseauth.gif"));
        this.setMessage(this.dialogMessage, 1);
        new Label(composite2, 0);
        Label label = new Label(composite2, 64);
        label.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label.setFont(FontShop.dialogFont);
        try {
            object2 = new URL(this.pathOrUrl);
            object = new StringBuffer();
            if (StringShop.isset(((URL)object2).getProtocol())) {
                ((StringBuffer)object).append(((URL)object2).getProtocol()).append(PROTOCOL_SEPARATOR);
            }
            ((StringBuffer)object).append(((URL)object2).getHost());
            label.setText(((StringBuffer)object).toString());
        }
        catch (MalformedURLException malformedURLException) {
            label.setText(this.pathOrUrl);
        }
        object2 = new Label(composite2, 0);
        ((Label)object2).setText(GUI.i18n.getTranslation("LABEL_USERNAME") + ": ");
        ((Control)object2).setLayoutData(new GridData(32));
        ((Control)object2).setFont(FontShop.dialogFont);
        this.username = new Text(composite2, 2052);
        this.username.setLayoutData(new GridData(768));
        this.username.setFont(FontShop.dialogFont);
        this.username.setFocus();
        WidgetShop.tweakTextWidget(this.username);
        object = new Label(composite2, 0);
        ((Label)object).setText(GUI.i18n.getTranslation("LABEL_PASSWORD") + ": ");
        ((Control)object).setLayoutData(new GridData(32));
        ((Control)object).setFont(FontShop.dialogFont);
        this.password = new Text(composite2, 0x400804);
        this.password.setLayoutData(new GridData(768));
        this.password.setFont(FontShop.dialogFont);
        WidgetShop.tweakTextWidget(this.password);
        if (this.isNtlm) {
            control = new Label(composite2, 0);
            ((Label)control).setText(GUI.i18n.getTranslation("LABEL_DOMAIN") + ": ");
            control.setLayoutData(new GridData(32));
            control.setFont(FontShop.dialogFont);
        }
        if (this.isNtlm) {
            this.domain = new Text(composite2, 2052);
            this.domain.setLayoutData(new GridData(768));
            this.domain.setFont(FontShop.dialogFont);
            WidgetShop.tweakTextWidget(this.domain);
        }
        new Label(composite2, 0);
        this.saveData = new Button(composite2, 32);
        this.saveData.setFont(FontShop.dialogFont);
        this.saveData.setLayoutData(new GridData(32));
        this.saveData.setText(GUI.i18n.getTranslation("LABEL_REMEMBER_AUTH"));
        control = new Composite(composite, 0);
        control.setLayoutData(LayoutDataShop.createGridData(768, 2));
        ((Composite)control).setLayout(LayoutShop.createGridLayout(1, 0, 0));
        new Label((Composite)control, 0);
        Label label2 = new Label((Composite)control, 258);
        label2.setLayoutData(new GridData(768));
        WidgetShop.initMnemonics(new Button[]{this.saveData});
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | LoginDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        int n = this.getShell().computeSize((int)-1, (int)-1).x;
        if (n > point.x) {
            point.x = n;
        }
        this.getShell().setSize(point.x, point.y);
        LayoutShop.positionShell(this.getShell(), true, openDialogsCount);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

