/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.BloggerProperties;
import net.sourceforge.rssowl.controller.properties.BrowserProperties;
import net.sourceforge.rssowl.controller.properties.ColorProperties;
import net.sourceforge.rssowl.controller.properties.ConnectionProperties;
import net.sourceforge.rssowl.controller.properties.FavoritesProperties;
import net.sourceforge.rssowl.controller.properties.FontProperties;
import net.sourceforge.rssowl.controller.properties.HotkeysProperties;
import net.sourceforge.rssowl.controller.properties.LanguageProperties;
import net.sourceforge.rssowl.controller.properties.MailProperties;
import net.sourceforge.rssowl.controller.properties.PropertiesFilter;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.controller.properties.SortOrderPropertiers;
import net.sourceforge.rssowl.controller.properties.SystemTrayProperties;
import net.sourceforge.rssowl.controller.properties.ViewProperties;
import net.sourceforge.rssowl.controller.properties.WorkbenchProperties;
import net.sourceforge.rssowl.dao.SettingsSaver;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.SimpleFileShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PreferencesDialog
extends Dialog
implements ITranslatable {
    public static int lastOpenedPropertyPage = 0;
    private static final int dialogMinWidth = 460;
    static boolean blockFilter = false;
    private TreeItem blogger;
    private TreeItem browser;
    private Composite buttonHolder;
    private ToolItem clearFilter;
    private TreeItem colors;
    private TreeItem connection;
    private Composite contentHolder;
    private Button exportSettingsButton;
    private TreeItem favorites;
    private TreeItem font;
    private TreeItem formatNewsTipMail;
    private TreeItem hotkeys;
    private Composite importExportHolder;
    private Button importSettingsButton;
    private Label labelPrefTitle;
    private TreeItem language;
    private String lastSelectedItemText;
    private PropertiesFilter propertiesFilter;
    private TreeItem sortOrder;
    private TreeItem systemTray;
    private String title;
    private TreeItem view;
    PropertyPage activePropertyPage;
    EventManager eventManager;
    Text filterText;
    boolean isFirstFilterInputFocus;
    Label labelImgHolder;
    Composite prefTitleHolder;
    GUI rssOwlGui;
    Tree tree;
    TreeItem workbench;

    public PreferencesDialog(Shell shell, String string, GUI gUI) {
        super(shell);
        this.title = string;
        this.rssOwlGui = gUI;
        this.eventManager = gUI.getEventManager();
        this.isFirstFilterInputFocus = true;
        this.propertiesFilter = new PropertiesFilter();
        PropertyPage.initPropertyChangeManager(gUI);
    }

    @Override
    public void updateI18N() {
        if (WidgetShop.isset(this.blogger)) {
            this.blogger.setText(GUI.i18n.getTranslation("MENU_BLOGGER"));
        }
        if (WidgetShop.isset(this.colors)) {
            this.colors.setText(GUI.i18n.getTranslation("MENU_COLORS"));
        }
        if (WidgetShop.isset(this.workbench)) {
            this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
        }
        if (WidgetShop.isset(this.view)) {
            this.view.setText(GUI.i18n.getTranslation("MENU_WINDOW"));
        }
        if (WidgetShop.isset(this.browser)) {
            this.browser.setText(GUI.i18n.getTranslation("MENU_BROWSER"));
        }
        if (WidgetShop.isset(this.language)) {
            this.language.setText(GUI.i18n.getTranslation("MENU_LANGUAGE"));
        }
        if (WidgetShop.isset(this.font)) {
            this.font.setText(GUI.i18n.getTranslation("MENU_FONT"));
        }
        if (WidgetShop.isset(this.hotkeys)) {
            this.hotkeys.setText(GUI.i18n.getTranslation("MENU_HOTKEYS"));
        }
        if (WidgetShop.isset(this.favorites)) {
            this.favorites.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        }
        if (WidgetShop.isset(this.connection)) {
            this.connection.setText(GUI.i18n.getTranslation("MENU_CONNECTION"));
        }
        if (WidgetShop.isset(this.formatNewsTipMail)) {
            this.formatNewsTipMail.setText(GUI.i18n.getTranslation("MENU_NEWSTIP_MAIL"));
        }
        if (WidgetShop.isset(this.sortOrder)) {
            this.sortOrder.setText(GUI.i18n.getTranslation("LABEL_SORT_ORDER"));
        }
        if (WidgetShop.isset(this.systemTray)) {
            this.systemTray.setText(GUI.i18n.getTranslation("GROUP_TRAY"));
        }
        this.getShell().setText(GUI.i18n.getTranslation("MENU_PREFERENCES"));
        this.propertiesFilter = new PropertiesFilter();
        this.createLanguageProps();
        this.clearFilter.setToolTipText(GUI.i18n.getTranslation("BUTTON_CLEAR"));
        this.getButton(0).setText(GUI.i18n.getTranslation("BUTTON_OK"));
        this.getButton(1).setText(GUI.i18n.getTranslation("BUTTON_CANCLE"));
        this.importSettingsButton.setText(GUI.i18n.getTranslation("MENU_IMPORT") + "...");
        this.exportSettingsButton.setText(GUI.i18n.getTranslation("MENU_EXPORT") + "...");
        this.setButtonLayoutData(this.importSettingsButton);
        this.setButtonLayoutData(this.exportSettingsButton);
        this.setButtonLayoutData(this.getButton(0));
        this.setButtonLayoutData(this.getButton(1));
        this.importExportHolder.layout();
        this.buttonHolder.layout();
        this.contentHolder.layout();
    }

    private void createBloggerProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_BLOGGER"));
        this.activePropertyPage = new BloggerProperties(this.contentHolder);
    }

    private void createBrowserProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_BROWSER"));
        this.activePropertyPage = new BrowserProperties(this.contentHolder);
    }

    private void createColorProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_COLORS"));
        this.activePropertyPage = new ColorProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createConnectionProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_CONNECTION"));
        this.activePropertyPage = new ConnectionProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createFavoritesProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        this.activePropertyPage = new FavoritesProperties(this.contentHolder);
    }

    private void createFontProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_FONT"));
        this.activePropertyPage = new FontProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createHotkeysProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_HOTKEYS"));
        this.activePropertyPage = new HotkeysProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createLanguageProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_LANGUAGE"));
        this.activePropertyPage = new LanguageProperties(this.contentHolder, this.rssOwlGui, this);
    }

    private void createMailProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_NEWSTIP_MAIL"));
        this.activePropertyPage = new MailProperties(this.contentHolder);
    }

    private void createSortOrderProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("LABEL_SORT_ORDER"));
        this.activePropertyPage = new SortOrderPropertiers(this.contentHolder);
    }

    private void createSystemTrayProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("GROUP_TRAY"));
        this.activePropertyPage = new SystemTrayProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createViewProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_WINDOW"));
        this.activePropertyPage = new ViewProperties(this.contentHolder, this.rssOwlGui);
    }

    private void createWorkbenchProps() {
        this.renewPropertyPage(GUI.i18n.getTranslation("MENU_WORKBENCH"));
        this.activePropertyPage = new WorkbenchProperties(this.contentHolder, this.rssOwlGui);
    }

    private void renewPropertyPage(String string) {
        if (this.activePropertyPage != null) {
            this.activePropertyPage.updatePropertiesChangeManager();
            this.activePropertyPage.dispose();
        }
        if (this.labelPrefTitle == null) {
            this.labelPrefTitle = new Label(this.prefTitleHolder, 16384);
            this.labelPrefTitle.setBackground(GUI.display.getSystemColor(1));
            this.labelPrefTitle.setLayoutData(new GridData(4, 0x1000000, true, false));
            this.labelPrefTitle.setFont(FontShop.dialogBoldFont);
        }
        if (this.labelImgHolder == null) {
            this.labelImgHolder = new Label(this.prefTitleHolder, 0);
            this.labelImgHolder.setBackground(GUI.display.getSystemColor(1));
            this.labelImgHolder.setImage(PaintShop.iconBlueStripes);
            this.labelImgHolder.setLayoutData(new GridData(0x1000008, 0x1000008, false, false));
        }
        this.labelPrefTitle.setText(string);
        this.labelPrefTitle.update();
        this.labelImgHolder.update();
        this.prefTitleHolder.layout();
        this.contentHolder.layout();
    }

    private void restoreSelection(String string, TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (string.equals(treeItem.getText())) {
                this.tree.setSelection(new TreeItem[]{treeItem});
                break;
            }
            if (treeItem.getItemCount() == 0) continue;
            this.restoreSelection(string, treeItem.getItems());
        }
    }

    private void setTreeSelection(int n) {
        switch (n) {
            case 0: {
                this.tree.setSelection(new TreeItem[]{this.workbench});
                break;
            }
            case 1: {
                this.tree.setSelection(new TreeItem[]{this.colors});
                break;
            }
            case 2: {
                this.tree.setSelection(new TreeItem[]{this.font});
                break;
            }
            case 3: {
                this.tree.setSelection(new TreeItem[]{this.hotkeys});
                break;
            }
            case 4: {
                this.tree.setSelection(new TreeItem[]{this.language});
                break;
            }
            case 5: {
                this.tree.setSelection(new TreeItem[]{this.sortOrder});
                break;
            }
            case 6: {
                this.tree.setSelection(new TreeItem[]{this.view});
                break;
            }
            case 7: {
                this.tree.setSelection(new TreeItem[]{this.systemTray});
                break;
            }
            case 8: {
                this.tree.setSelection(new TreeItem[]{this.blogger});
                break;
            }
            case 9: {
                this.tree.setSelection(new TreeItem[]{this.browser});
                break;
            }
            case 10: {
                this.tree.setSelection(new TreeItem[]{this.favorites});
                break;
            }
            case 11: {
                this.tree.setSelection(new TreeItem[]{this.formatNewsTipMail});
                break;
            }
            case 12: {
                this.tree.setSelection(new TreeItem[]{this.connection});
            }
        }
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            this.saveSettings();
        }
        if (this.activePropertyPage != null) {
            this.activePropertyPage.dispose();
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        shell.setLayout(LayoutShop.createGridLayout(1, 0, 5));
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
        shell.setSize(0, 0);
        shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                FontProperties.setPossibleFontChange(false);
            }
        });
    }

    @Override
    protected Control createButtonBar(Composite composite) {
        this.buttonHolder = new Composite(composite, 0);
        this.buttonHolder.setLayout(LayoutShop.createGridLayout(2, 0, 0, 5, 5, false));
        this.buttonHolder.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.importExportHolder = new Composite(this.buttonHolder, 0);
        this.importExportHolder.setLayout(LayoutShop.createGridLayout(2, 5, 5, 5));
        this.importExportHolder.setLayoutData(new GridData(768));
        this.importSettingsButton = new Button(this.importExportHolder, 0);
        this.importSettingsButton.setText(GUI.i18n.getTranslation("MENU_IMPORT") + "...");
        this.importSettingsButton.setFont(FontShop.dialogFont);
        this.setButtonLayoutData(this.importSettingsButton);
        this.importSettingsButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PreferencesDialog.this.eventManager.actionImportSettings(PreferencesDialog.this.getShell());
                if (bl) {
                    PreferencesDialog.this.buttonPressed(1);
                }
            }
        });
        this.exportSettingsButton = new Button(this.importExportHolder, 0);
        this.exportSettingsButton.setFont(FontShop.dialogFont);
        this.exportSettingsButton.setText(GUI.i18n.getTranslation("MENU_EXPORT") + "...");
        this.setButtonLayoutData(this.exportSettingsButton);
        this.exportSettingsButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesDialog.this.saveSettings();
                PreferencesDialog.this.eventManager.actionExportSettings(PreferencesDialog.this.getShell());
            }
        });
        Composite composite2 = new Composite(this.buttonHolder, 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 0, 5, 5));
        composite2.setLayoutData(new GridData(0x1000008, 128, false, false));
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite2, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.createButton(composite2, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
        } else {
            this.createButton(composite2, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
            this.createButton(composite2, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        return this.buttonHolder;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout(LayoutShop.createGridLayout(2, 0, 5, 15, 0, false));
        composite2.setLayoutData(LayoutDataShop.createGridData(1808, 1));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(1040, 1, this.convertHorizontalDLUsToPixels(140)));
        composite3.setLayout(LayoutShop.createGridLayout(1, 5, 0));
        Composite composite4 = new Composite(composite3, 2048);
        composite4.setLayout(LayoutShop.createGridLayout(2, 0, 0, 0, 1, false));
        composite4.setLayoutData(new GridData(4, 1, true, false));
        composite4.setBackground(GUI.display.getSystemColor(1));
        if (!GlobalSettings.isWindows()) {
            ((GridLayout)composite4.getLayout()).marginLeft = 3;
        }
        this.filterText = new Text(composite4, 0);
        this.filterText.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.filterText.setFont(FontShop.dialogFont);
        this.filterText.setText(GUI.i18n.getTranslation("BUTTON_SEARCH"));
        this.filterText.setBackground(GUI.display.getSystemColor(1));
        this.filterText.setForeground(GUI.display.getSystemColor(16));
        this.filterText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                if (!blockFilter) {
                    PreferencesDialog.this.filterTree(PreferencesDialog.this.filterText.getText());
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            @Override
            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 && StringShop.isset(PreferencesDialog.this.filterText.getText())) {
                    PreferencesDialog.this.filterText.setText("");
                    traverseEvent.doit = false;
                } else if (traverseEvent.detail == 4) {
                    if (PreferencesDialog.this.tree.getItemCount() > 0) {
                        PreferencesDialog.this.tree.setFocus();
                    } else {
                        PreferencesDialog.this.filterText.setText("");
                    }
                    traverseEvent.doit = false;
                }
            }
        });
        this.filterText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (PreferencesDialog.this.isFirstFilterInputFocus) {
                    blockFilter = true;
                    PreferencesDialog.this.isFirstFilterInputFocus = false;
                    PreferencesDialog.this.filterText.setText("");
                    PreferencesDialog.this.filterText.setForeground(null);
                    blockFilter = false;
                }
            }
        });
        WidgetShop.tweakTextWidget(this.filterText);
        ToolBar toolBar = new ToolBar(composite4, 0x800000);
        toolBar.setBackground(GUI.display.getSystemColor(1));
        toolBar.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.clearFilter = new ToolItem(toolBar, 8);
        this.clearFilter.setImage(PaintShop.loadImage("/img/icons/closesearch.gif"));
        this.clearFilter.setToolTipText(GUI.i18n.getTranslation("BUTTON_CLEAR"));
        this.clearFilter.addDisposeListener(DisposeListenerImpl.getInstance());
        this.clearFilter.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!PreferencesDialog.this.isFirstFilterInputFocus && StringShop.isset(PreferencesDialog.this.filterText.getText())) {
                    PreferencesDialog.this.filterText.setText("");
                }
            }
        });
        this.tree = new Tree(composite3, 2048);
        this.tree.setFont(FontShop.dialogFont);
        this.tree.setFocus();
        this.tree.setLayoutData(new GridData(1808));
        this.tree.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesDialog.this.handleTreeItemSelect();
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TreeItem treeItem = PreferencesDialog.this.tree.getSelection()[0];
                if (keyEvent.keyCode == 13 && treeItem.getItemCount() > 0) {
                    treeItem.setExpanded(!treeItem.getExpanded());
                }
            }
        });
        this.tree.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (PreferencesDialog.this.tree.getSelectionCount() > 0) {
                    Rectangle rectangle = event.getBounds();
                    Rectangle rectangle2 = PreferencesDialog.this.tree.getSelection()[0].getBounds();
                    if (rectangle2.contains(rectangle.x, rectangle.y)) {
                        PreferencesDialog.this.tree.getSelection()[0].setExpanded(!PreferencesDialog.this.tree.getSelection()[0].getExpanded());
                    }
                }
            }
        });
        this.filterTree(null);
        this.contentHolder = new Composite(composite2, 0);
        this.contentHolder.setLayoutData(new GridData(1810));
        this.contentHolder.setLayout(LayoutShop.createGridLayout(1, 5, 0));
        this.prefTitleHolder = new Composite(this.contentHolder, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 2;
        gridLayout.marginLeft = 4;
        this.prefTitleHolder.setLayout(gridLayout);
        this.prefTitleHolder.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.prefTitleHolder.setBackground(GUI.display.getSystemColor(1));
        this.prefTitleHolder.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.setForeground(GUI.display.getSystemColor(16));
                Rectangle rectangle = PreferencesDialog.this.prefTitleHolder.getClientArea();
                rectangle.height -= 2;
                --rectangle.width;
                paintEvent.gc.drawRectangle(rectangle);
            }
        });
        this.setTreeSelection(lastOpenedPropertyPage);
        this.handleTreeItemSelect();
        Label label = new Label(composite2, 258);
        label.setLayoutData(LayoutDataShop.createGridData(800, 2));
        if (WidgetShop.isset(this.tree.getHorizontalBar())) {
            this.tree.getHorizontalBar().setSelection(0);
        }
        return this.contentHolder;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10830 | PreferencesDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        this.initializeBounds(true);
    }

    protected void initializeBounds(boolean bl) {
        Point point;
        Point point2 = this.getShell().getSize();
        Point point3 = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(460), -1);
        Point point4 = point = bl ? this.getInitialLocation(point3) : this.getShell().getLocation();
        if (bl && point3.y > point2.y) {
            this.getShell().setBounds(point.x, point.y, point3.x, point3.y);
        } else if (point3.y > point2.y) {
            this.getShell().setSize(point3.x, point3.y);
        }
        this.getShell().setMinimumSize(point3.x, point3.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    void filterTree(String string) {
        ArrayList arrayList;
        boolean bl = !StringShop.isset(string);
        String string2 = null;
        if (this.tree.getSelectionCount() > 0) {
            string2 = this.tree.getSelection()[0].getText();
        }
        if (this.tree.getItemCount() > 0) {
            this.tree.removeAll();
        }
        ArrayList arrayList2 = arrayList = bl ? null : this.propertiesFilter.filter(string);
        if (bl || arrayList.contains("MENU_WORKBENCH")) {
            this.workbench = new TreeItem(this.tree, 0);
            this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            if (!bl) {
                this.workbench.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_COLORS")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.colors = new TreeItem(this.workbench, 0);
            this.colors.setText(GUI.i18n.getTranslation("MENU_COLORS"));
            if (!bl) {
                this.colors.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_FONT")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.font = new TreeItem(this.workbench, 0);
            this.font.setText(GUI.i18n.getTranslation("MENU_FONT"));
            if (!bl) {
                this.font.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_HOTKEYS")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.hotkeys = new TreeItem(this.workbench, 0);
            this.hotkeys.setText(GUI.i18n.getTranslation("MENU_HOTKEYS"));
            if (!bl) {
                this.hotkeys.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_LANGUAGE")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.language = new TreeItem(this.workbench, 0);
            this.language.setText(GUI.i18n.getTranslation("MENU_LANGUAGE"));
            if (!bl) {
                this.language.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("LABEL_SORT_ORDER")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.sortOrder = new TreeItem(this.workbench, 0);
            this.sortOrder.setText(GUI.i18n.getTranslation("LABEL_SORT_ORDER"));
            if (!bl) {
                this.sortOrder.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_WINDOW")) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            this.view = new TreeItem(this.workbench, 0);
            this.view.setText(GUI.i18n.getTranslation("MENU_WINDOW"));
            if (!bl) {
                this.view.setFont(FontShop.dialogBoldFont);
            }
        }
        if (GlobalSettings.useSystemTray() && (bl || arrayList.contains("GROUP_TRAY"))) {
            if (!WidgetShop.isset(this.workbench)) {
                this.workbench = new TreeItem(this.tree, 0);
                this.workbench.setText(GUI.i18n.getTranslation("MENU_WORKBENCH"));
            }
            if (!WidgetShop.isset(this.view)) {
                this.view = new TreeItem(this.workbench, 0);
                this.view.setText(GUI.i18n.getTranslation("MENU_WINDOW"));
            }
            this.systemTray = new TreeItem(this.view, 0);
            this.systemTray.setText(GUI.i18n.getTranslation("GROUP_TRAY"));
            if (!bl) {
                this.systemTray.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_BLOGGER")) {
            this.blogger = new TreeItem(this.tree, 0);
            this.blogger.setText(GUI.i18n.getTranslation("MENU_BLOGGER"));
            if (!bl) {
                this.blogger.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_BROWSER")) {
            this.browser = new TreeItem(this.tree, 0);
            this.browser.setText(GUI.i18n.getTranslation("MENU_BROWSER"));
            if (!bl) {
                this.browser.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("HEADER_RSS_FAVORITES")) {
            this.favorites = new TreeItem(this.tree, 0);
            this.favorites.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
            if (!bl) {
                this.favorites.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_NEWSTIP_MAIL")) {
            this.formatNewsTipMail = new TreeItem(this.tree, 0);
            this.formatNewsTipMail.setText(GUI.i18n.getTranslation("MENU_NEWSTIP_MAIL"));
            if (!bl) {
                this.formatNewsTipMail.setFont(FontShop.dialogBoldFont);
            }
        }
        if (bl || arrayList.contains("MENU_CONNECTION")) {
            this.connection = new TreeItem(this.tree, 0);
            this.connection.setText(GUI.i18n.getTranslation("MENU_CONNECTION"));
            if (!bl) {
                this.connection.setFont(FontShop.dialogBoldFont);
            }
        }
        if (WidgetShop.isset(this.workbench)) {
            this.workbench.setExpanded(true);
        }
        if (GlobalSettings.useSystemTray() && WidgetShop.isset(this.view)) {
            this.view.setExpanded(true);
        }
        if (StringShop.isset(string2)) {
            this.restoreSelection(string2, this.tree.getItems());
        }
    }

    void handleTreeItemSelect() {
        if (this.tree.getSelection().length == 0) {
            return;
        }
        if (this.tree.getSelection()[0].getText().equals(this.lastSelectedItemText)) {
            return;
        }
        this.lastSelectedItemText = this.tree.getSelection()[0].getText();
        if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_WORKBENCH"))) {
            this.createWorkbenchProps();
            lastOpenedPropertyPage = 0;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_COLORS"))) {
            this.createColorProps();
            lastOpenedPropertyPage = 1;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_FONT"))) {
            this.createFontProps();
            lastOpenedPropertyPage = 2;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_HOTKEYS"))) {
            this.createHotkeysProps();
            lastOpenedPropertyPage = 3;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_LANGUAGE"))) {
            this.createLanguageProps();
            lastOpenedPropertyPage = 4;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("LABEL_SORT_ORDER"))) {
            this.createSortOrderProps();
            lastOpenedPropertyPage = 5;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_WINDOW"))) {
            this.createViewProps();
            lastOpenedPropertyPage = 6;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("GROUP_TRAY"))) {
            this.createSystemTrayProps();
            lastOpenedPropertyPage = 7;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_BLOGGER"))) {
            this.createBloggerProps();
            lastOpenedPropertyPage = 8;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_BROWSER"))) {
            this.createBrowserProps();
            lastOpenedPropertyPage = 9;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"))) {
            this.createFavoritesProps();
            lastOpenedPropertyPage = 10;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_NEWSTIP_MAIL"))) {
            this.createMailProps();
            lastOpenedPropertyPage = 11;
        } else if (this.tree.getSelection()[0].getText().equals(GUI.i18n.getTranslation("MENU_CONNECTION"))) {
            this.createConnectionProps();
            lastOpenedPropertyPage = 12;
        }
        this.contentHolder.layout();
        this.initializeBounds(false);
    }

    void saveSettings() {
        this.activePropertyPage.applyButtonPressed();
        PropertyPage.getPropertyChangeManager().saveProperties();
        if (this.rssOwlGui.getRSSOwlSystray() == null || !this.rssOwlGui.getRSSOwlSystray().isMinimizedToTray()) {
            GlobalSettings.shellBounds = GUI.shell.getBounds();
            GlobalSettings.isShellMaximized = GUI.shell.getMaximized();
        }
        File file = new File(GlobalSettings.RSSOWL_SETTINGS_FILE);
        File file2 = new File(GlobalSettings.RSSOWL_SETTINGS_BACKUP_FILE);
        new SettingsSaver(this.rssOwlGui).saveUserSettings(false);
        try {
            SimpleFileShop.copy(file, file2);
        }
        catch (IOException iOException) {
            GUI.logger.log("saveSettings()", iOException);
        }
    }
}

