/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.Quickview;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.ITranslatable;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ToolBarDialog
extends Dialog
implements ITranslatable {
    public static final String TOOLITEM_CLOSE = "MENU_CLOSE";
    public static final String TOOLITEM_CLOSE_ALL = "MENU_CLOSE_ALL";
    public static final String TOOLITEM_CLOSE_OTHERS = "POP_KEEP_CURRENT";
    public static final String TOOLITEM_EXPORT = "BUTTON_EXPORT";
    public static final String TOOLITEM_FAVORITES = "HEADER_RSS_FAVORITES";
    public static final String TOOLITEM_HISTORY = "TOOL_HISTORY";
    public static final String TOOLITEM_IMPORT = "POP_IMPORT";
    public static final String TOOLITEM_MARK = "TOOL_MARK";
    public static final String TOOLITEM_NEW = "POP_NEW";
    public static final String TOOLITEM_NEWSTIP = "TOOL_NEWSTIP";
    public static final String TOOLITEM_NEXT = "TOOL_NEXT";
    public static final String TOOLITEM_NEXT_TAB = "MENU_NEXT_TAB";
    public static final String TOOLITEM_PREVIOUS_TAB = "MENU_PREVIOUS_TAB";
    public static final String TOOLITEM_RELOAD = "MENU_RELOAD";
    public static final String TOOLITEM_SEARCH = "BUTTON_SEARCH";
    public static final String TOOLITEM_SEPARATOR = "TOOL_SEPARATOR";
    public static final String TOOLITEM_TOOLS = "MENU_TOOLS";
    private static final int APPLY_ID = 10;
    private static final int DIALOG_WIDTH = 350;
    private static final String SEPARATOR_WINGS = "----";
    private Button addSepButton;
    private Button applyButton;
    private Button cancelButton;
    private ArrayList defaultOrder;
    private Button downButton;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private HashMap itemIcons;
    private Button okButton;
    private Quickview quickview;
    private Button restoreDefaults;
    private Label separatorLabel;
    private Label showLabel;
    private String title;
    private String toolBarItems;
    private int toolBarMode;
    private Button upButton;
    private boolean useSmallIcons;
    TableItem draggedItem;
    Table itemTable;
    Button removeSepButton;
    Combo showCombo;
    Button useSmallIconsCheck;

    public ToolBarDialog(Quickview quickview, Shell shell, String string) {
        super(shell);
        this.quickview = quickview;
        this.title = string;
        this.itemIcons = new HashMap();
        this.defaultOrder = new ArrayList();
        this.toolBarItems = GlobalSettings.toolBarItems;
        this.initItemIcons();
        this.initDefaultOrder();
    }

    public static String getDefaultToolBarItems() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TOOLITEM_NEW).append(",");
        stringBuffer.append(TOOLITEM_IMPORT).append(",");
        stringBuffer.append(TOOLITEM_EXPORT).append(",");
        stringBuffer.append(TOOLITEM_SEPARATOR).append(",");
        stringBuffer.append(TOOLITEM_RELOAD).append(",");
        stringBuffer.append(TOOLITEM_SEARCH).append(",");
        stringBuffer.append(TOOLITEM_MARK).append(",");
        stringBuffer.append(TOOLITEM_SEPARATOR).append(",");
        stringBuffer.append(TOOLITEM_NEXT).append(",");
        stringBuffer.append(TOOLITEM_SEPARATOR).append(",");
        stringBuffer.append(TOOLITEM_FAVORITES).append(",");
        stringBuffer.append(TOOLITEM_SEPARATOR).append(",");
        stringBuffer.append(TOOLITEM_HISTORY).append(",");
        stringBuffer.append(TOOLITEM_TOOLS).append(",");
        return stringBuffer.toString();
    }

    public void dispose() {
        Iterator iterator = this.itemIcons.values().iterator();
        while (iterator.hasNext()) {
            ((Image)iterator.next()).dispose();
        }
        this.dragSource.dispose();
        this.dropTarget.dispose();
    }

    public String getToolBarItems() {
        return this.toolBarItems;
    }

    public int getToolBarMode() {
        return this.toolBarMode;
    }

    public boolean isUseSmallIcons() {
        return this.useSmallIcons;
    }

    @Override
    public void updateI18N() {
        this.getShell().setText(GUI.i18n.getTranslation("POP_CUSTOMIZE_TOOLBAR"));
        this.okButton.setText(GUI.i18n.getTranslation("BUTTON_OK"));
        this.cancelButton.setText(GUI.i18n.getTranslation("BUTTON_CANCLE"));
        this.applyButton.setText(GUI.i18n.getTranslation("BUTTON_APPLY"));
        this.upButton.setText(GUI.i18n.getTranslation("BUTTON_UP"));
        this.downButton.setText(GUI.i18n.getTranslation("BUTTON_DOWN"));
        this.separatorLabel.setLayoutData(new GridData(1, 0x1000000, false, true));
        this.addSepButton.setText(GUI.i18n.getTranslation("BUTTON_ADD"));
        this.removeSepButton.setText(GUI.i18n.getTranslation("BUTTON_REMOVE"));
        this.showLabel.setText(GUI.i18n.getTranslation("LABEL_SHOW") + ": ");
        this.useSmallIconsCheck.setText(GUI.i18n.getTranslation("BUTTON_SMALL_ICONS"));
        this.restoreDefaults.setText(GUI.i18n.getTranslation("BUTTON_RESTORE_DEFAULTS"));
        int n = this.showCombo.getSelectionIndex();
        this.showCombo.removeAll();
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_ICONS_TEXT"));
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_ICONS"));
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_TEXT"));
        this.showCombo.select(n);
        int n2 = this.itemTable.getItemCount();
        for (int i = 0; i < n2; ++i) {
            TableItem tableItem = this.itemTable.getItem(i);
            String string = (String)tableItem.getData();
            if (TOOLITEM_SEPARATOR.equals(string)) {
                tableItem.setText("---- " + GUI.i18n.getTranslation(TOOLITEM_SEPARATOR) + " " + SEPARATOR_WINGS);
                continue;
            }
            tableItem.setText(GUI.i18n.getTranslation(string));
        }
        WidgetShop.initMnemonics(new Button[]{this.addSepButton, this.removeSepButton, this.applyButton, this.upButton, this.downButton, this.useSmallIconsCheck, this.restoreDefaults});
        LayoutShop.setLayoutForAll(this.getShell());
        Point point = this.getShell().computeSize(-1, -1);
        if (point.x > this.getShell().getSize().x) {
            this.getShell().setSize(point.x, this.getShell().getSize().y);
        }
    }

    private TableItem createSeparator(int n) {
        TableItem tableItem = new TableItem(this.itemTable, 0, n);
        tableItem.setText("---- " + GUI.i18n.getTranslation(TOOLITEM_SEPARATOR) + " " + SEPARATOR_WINGS);
        tableItem.setImage((Image)this.itemIcons.get(TOOLITEM_SEPARATOR));
        tableItem.setChecked(true);
        tableItem.setData(TOOLITEM_SEPARATOR);
        return tableItem;
    }

    private void flip(TableItem tableItem, TableItem tableItem2) {
        String string = tableItem.getText();
        String string2 = tableItem2.getText();
        Object object = tableItem.getData();
        Object object2 = tableItem2.getData();
        Image image = tableItem.getImage();
        Image image2 = tableItem2.getImage();
        boolean bl = tableItem.getChecked();
        boolean bl2 = tableItem2.getChecked();
        tableItem.setText(string2);
        tableItem.setData(object2);
        tableItem.setImage(image2);
        tableItem.setChecked(bl2);
        tableItem2.setText(string);
        tableItem2.setData(object);
        tableItem2.setImage(image);
        tableItem2.setChecked(bl);
    }

    private String getItemStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = this.itemTable.getItemCount();
        for (int i = 0; i < n; ++i) {
            TableItem tableItem = this.itemTable.getItem(i);
            if (!tableItem.getChecked() || TOOLITEM_SEPARATOR.equals(tableItem.getData()) && bl) continue;
            stringBuffer.append(",").append(tableItem.getData());
            bl = TOOLITEM_SEPARATOR.equals(tableItem.getData());
        }
        String string = stringBuffer.toString();
        if (StringShop.isset(string)) {
            string = string.substring(1);
        }
        if (TOOLITEM_SEPARATOR.equals(string)) {
            string = "";
        }
        return string;
    }

    private void initDefaultOrder() {
        this.defaultOrder.clear();
        this.defaultOrder.add(TOOLITEM_NEW);
        this.defaultOrder.add(TOOLITEM_IMPORT);
        this.defaultOrder.add(TOOLITEM_EXPORT);
        this.defaultOrder.add(TOOLITEM_RELOAD);
        this.defaultOrder.add(TOOLITEM_SEARCH);
        this.defaultOrder.add(TOOLITEM_MARK);
        this.defaultOrder.add(TOOLITEM_NEXT);
        this.defaultOrder.add(TOOLITEM_FAVORITES);
        this.defaultOrder.add(TOOLITEM_HISTORY);
        this.defaultOrder.add(TOOLITEM_TOOLS);
        this.defaultOrder.add(TOOLITEM_CLOSE);
        this.defaultOrder.add(TOOLITEM_CLOSE_OTHERS);
        this.defaultOrder.add(TOOLITEM_CLOSE_ALL);
        this.defaultOrder.add(TOOLITEM_PREVIOUS_TAB);
        this.defaultOrder.add(TOOLITEM_NEXT_TAB);
        this.defaultOrder.add(TOOLITEM_NEWSTIP);
    }

    private void initItemIcons() {
        this.itemIcons.put(TOOLITEM_NEW, PaintShop.sizeTo(GUI.display, PaintShop.iconNew, 20, 20, false));
        this.itemIcons.put(TOOLITEM_IMPORT, PaintShop.sizeTo(GUI.display, PaintShop.iconImport, 20, 20, false));
        this.itemIcons.put(TOOLITEM_EXPORT, PaintShop.sizeTo(GUI.display, PaintShop.iconExport, 20, 20, false));
        this.itemIcons.put(TOOLITEM_RELOAD, PaintShop.sizeTo(GUI.display, PaintShop.iconReload, 20, 20, false));
        this.itemIcons.put(TOOLITEM_SEARCH, PaintShop.sizeTo(GUI.display, PaintShop.iconFind, 20, 20, false));
        this.itemIcons.put(TOOLITEM_MARK, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/mark_feed_read.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_NEXT, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/next_unread.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_FAVORITES, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/favorites.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_TOOLS, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/tools.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_CLOSE, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/close_tab.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_CLOSE_OTHERS, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/close_others.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_CLOSE_ALL, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/close_all_tabs.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_NEWSTIP, PaintShop.sizeTo(GUI.display, PaintShop.iconMail, 20, 20, false));
        this.itemIcons.put(TOOLITEM_HISTORY, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/history.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_PREVIOUS_TAB, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/backward_small.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_NEXT_TAB, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/forward_small.gif"), 20, 20, true));
        this.itemIcons.put(TOOLITEM_SEPARATOR, PaintShop.sizeTo(GUI.display, PaintShop.loadImage("/img/icons/separator.gif"), 20, 20, true));
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            this.toolBarItems = this.getItemStringValue();
            this.toolBarMode = this.showCombo.getSelectionIndex();
            this.useSmallIcons = this.useSmallIconsCheck.getSelection();
        } else if (n == 10) {
            GlobalSettings.toolBarItems = this.getItemStringValue();
            GlobalSettings.toolBarMode = this.showCombo.getSelectionIndex();
            GlobalSettings.useSmallIcons = this.useSmallIconsCheck.getSelection();
            this.quickview.createToolBar();
            SettingsManager.getInstance().requestSave();
            if (!GlobalSettings.isToolBarShown) {
                this.quickview.setShowToolBar(true, true);
            }
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                ToolBarDialog.this.dispose();
            }
        });
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.cancelButton = this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.applyButton = this.createButton(composite, 10, GUI.i18n.getTranslation("BUTTON_APPLY"), false);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.cancelButton = this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false);
            this.applyButton = this.createButton(composite, 10, GUI.i18n.getTranslation("BUTTON_APPLY"), false);
        }
        this.okButton.setFont(FontShop.dialogFont);
        this.cancelButton.setFont(FontShop.dialogFont);
        this.applyButton.setFont(FontShop.dialogFont);
        WidgetShop.initMnemonics(new Button[]{this.addSepButton, this.removeSepButton, this.applyButton, this.upButton, this.downButton, this.useSmallIconsCheck, this.restoreDefaults});
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout(new GridLayout(2, false));
        this.itemTable = new Table(composite2, 67616);
        this.itemTable.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this.itemTable.setFont(FontShop.dialogFont);
        this.itemTable.setCursor(composite2.getDisplay().getSystemCursor(21));
        this.itemTable.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ToolBarDialog.this.itemTable.getSelectionCount() > 0) {
                    TableItem tableItem = ToolBarDialog.this.itemTable.getSelection()[0];
                    ToolBarDialog.this.removeSepButton.setEnabled(ToolBarDialog.TOOLITEM_SEPARATOR.equals(tableItem.getData()));
                }
            }
        });
        this.itemTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127 || GlobalSettings.isMac() && keyEvent.keyCode == 8) {
                    if (ToolBarDialog.this.itemTable.getSelectionCount() > 0 && ToolBarDialog.TOOLITEM_SEPARATOR.equals(ToolBarDialog.this.itemTable.getSelection()[0].getData())) {
                        ToolBarDialog.this.removeSeparator();
                    } else if (ToolBarDialog.this.itemTable.getSelectionCount() > 0) {
                        ToolBarDialog.this.itemTable.getSelection()[0].setChecked(false);
                    }
                }
            }
        });
        this.itemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (ToolBarDialog.this.itemTable.getSelectionCount() > 0) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = ToolBarDialog.this.itemTable.getSelection()[0]).getChecked());
                }
            }
        });
        this.dragSource = new DragSource(this.itemTable, 2);
        this.dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.dragSource.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragFinished(DragSourceEvent dragSourceEvent) {
                ToolBarDialog.this.draggedItem = null;
            }

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (WidgetShop.isset(ToolBarDialog.this.draggedItem)) {
                    dragSourceEvent.data = " ";
                }
            }

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                boolean bl = dragSourceEvent.doit = ToolBarDialog.this.itemTable.getSelectionCount() == 1;
                if (dragSourceEvent.doit) {
                    ToolBarDialog.this.draggedItem = ToolBarDialog.this.itemTable.getSelection()[0];
                }
            }
        });
        this.dropTarget = new DropTarget(this.itemTable, 2);
        this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetEvent dropTargetEvent) {
                TableItem tableItem = (TableItem)dropTargetEvent.item;
                boolean bl = WidgetShop.isset(tableItem) && WidgetShop.isset(ToolBarDialog.this.draggedItem);
                dropTargetEvent.detail = bl ? 2 : 0;
                dropTargetEvent.feedback = bl ? 9 : 0;
            }

            @Override
            public void drop(DropTargetEvent dropTargetEvent) {
                TableItem tableItem = (TableItem)dropTargetEvent.item;
                if (WidgetShop.isset(tableItem) && WidgetShop.isset(ToolBarDialog.this.draggedItem)) {
                    int n;
                    int n2 = ToolBarDialog.this.itemTable.indexOf(ToolBarDialog.this.draggedItem);
                    int n3 = n2 > (n = ToolBarDialog.this.itemTable.indexOf(tableItem)) ? n : n + 1;
                    TableItem tableItem2 = new TableItem(ToolBarDialog.this.itemTable, 0, n3);
                    tableItem2.setText(ToolBarDialog.this.draggedItem.getText());
                    tableItem2.setData(ToolBarDialog.this.draggedItem.getData());
                    tableItem2.setImage(ToolBarDialog.this.draggedItem.getImage());
                    tableItem2.setChecked(ToolBarDialog.this.draggedItem.getChecked());
                    ToolBarDialog.this.draggedItem.dispose();
                    ToolBarDialog.this.itemTable.setSelection(new TableItem[]{tableItem2});
                }
            }
        });
        this.fillTable(GlobalSettings.toolBarItems);
        this.itemTable.setSelection(0);
        this.upButton = new Button(composite2, 8);
        this.upButton.setText(GUI.i18n.getTranslation("BUTTON_UP"));
        this.upButton.setFont(FontShop.dialogFont);
        this.upButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarDialog.this.moveTableElementUp();
            }
        });
        this.downButton = new Button(composite2, 8);
        this.downButton.setText(GUI.i18n.getTranslation("BUTTON_DOWN"));
        this.downButton.setFont(FontShop.dialogFont);
        this.downButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarDialog.this.moveTableElementDown();
            }
        });
        this.setButtonLayoutData(this.upButton, new GridData(1, 1, false, false));
        this.setButtonLayoutData(this.downButton, new GridData(1, 1, false, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout(LayoutShop.createGridLayout(3, 0, 0, 20, 5, false));
        composite3.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        this.separatorLabel = new Label(composite3, 0);
        this.separatorLabel.setLayoutData(new GridData(1, 0x1000000, false, true));
        this.separatorLabel.setText(GUI.i18n.getTranslation(TOOLITEM_SEPARATOR) + ": ");
        this.separatorLabel.setFont(FontShop.dialogFont);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        composite4.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.addSepButton = new Button(composite4, 8);
        this.addSepButton.setText(GUI.i18n.getTranslation("BUTTON_ADD"));
        this.addSepButton.setFont(FontShop.dialogFont);
        this.addSepButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarDialog.this.addSeparator();
            }
        });
        this.removeSepButton = new Button(composite4, 8);
        this.removeSepButton.setText(GUI.i18n.getTranslation("BUTTON_REMOVE"));
        this.removeSepButton.setFont(FontShop.dialogFont);
        this.removeSepButton.setEnabled(false);
        this.removeSepButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarDialog.this.removeSeparator();
            }
        });
        this.setButtonLayoutData(this.addSepButton, new GridData(1, 1, false, false));
        this.setButtonLayoutData(this.removeSepButton, new GridData(1, 1, false, false));
        Composite composite5 = new Composite(composite3, 0);
        composite5.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        composite5.setLayout(LayoutShop.createGridLayout(3, 0, 0));
        this.showLabel = new Label(composite5, 0);
        this.showLabel.setLayoutData(new GridData(1, 0x1000000, false, true));
        this.showLabel.setText(GUI.i18n.getTranslation("LABEL_SHOW") + ": ");
        this.showLabel.setFont(FontShop.dialogFont);
        this.showCombo = new Combo(composite5, 8);
        this.showCombo.setLayoutData(new GridData(1, 1, false, false));
        this.showCombo.setFont(FontShop.dialogFont);
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_ICONS_TEXT"));
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_ICONS"));
        this.showCombo.add(GUI.i18n.getTranslation("TOOL_TEXT"));
        this.showCombo.select(GlobalSettings.toolBarMode);
        Composite composite6 = new Composite(composite5, 0);
        composite6.setLayoutData(new GridData(1, 0x1000000, false, false));
        composite6.setLayout(LayoutShop.createGridLayout(1, 10, 0));
        this.useSmallIconsCheck = new Button(composite6, 32);
        this.useSmallIconsCheck.setLayoutData(new GridData(1, 0x1000000, false, false));
        this.useSmallIconsCheck.setText(GUI.i18n.getTranslation("BUTTON_SMALL_ICONS"));
        this.useSmallIconsCheck.setFont(FontShop.dialogFont);
        this.useSmallIconsCheck.setSelection(GlobalSettings.useSmallIcons);
        this.restoreDefaults = new Button(composite3, 8);
        this.restoreDefaults.setText(GUI.i18n.getTranslation("BUTTON_RESTORE_DEFAULTS"));
        this.restoreDefaults.setFont(FontShop.dialogFont);
        this.restoreDefaults.setLayoutData(new GridData(0x1000008, 0x1000000, true, true));
        this.restoreDefaults.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarDialog.this.fillTable(ToolBarDialog.getDefaultToolBarItems());
                ToolBarDialog.this.showCombo.select(0);
                ToolBarDialog.this.useSmallIconsCheck.setSelection(true);
            }
        });
        Composite composite7 = new Composite(composite, 0);
        composite7.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite7.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label = new Label(composite7, 258);
        label.setLayoutData(new GridData(768));
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x870 | ToolBarDialog.getDefaultOrientation();
        if (GlobalSettings.isMac()) {
            n = n | 0x80 | 0x400;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        Point point = this.getShell().computeSize(-1, -1);
        Point point2 = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(350), -1);
        Point point3 = this.getInitialLocation(point2);
        this.getShell().setBounds(point3.x, point3.y, point2.x > point.x ? point2.x : point.x, point2.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    protected void setButtonLayoutData(Button button, GridData gridData) {
        GC gC = new GC(button);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = Dialog.convertHorizontalDLUsToPixels(fontMetrics, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
        gC.dispose();
    }

    void addSeparator() {
        int n = this.itemTable.getSelectionIndex();
        TableItem tableItem = this.createSeparator(n + 1);
        this.itemTable.setSelection(new TableItem[]{tableItem});
        this.removeSepButton.setEnabled(true);
    }

    void fillTable(String string) {
        TableItem tableItem;
        if (WidgetShop.isset(this.itemTable)) {
            this.itemTable.removeAll();
        }
        if (StringShop.isset(string)) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                tableItem = new TableItem(this.itemTable, 0);
                tableItem.setChecked(true);
                if (((String)stringArray[i]).equals(TOOLITEM_SEPARATOR)) {
                    tableItem.setText("---- " + GUI.i18n.getTranslation((String)stringArray[i]) + " " + SEPARATOR_WINGS);
                } else {
                    tableItem.setText(GUI.i18n.getTranslation((String)stringArray[i]));
                }
                tableItem.setImage((Image)this.itemIcons.get(stringArray[i]));
                tableItem.setData(stringArray[i]);
                this.defaultOrder.remove(stringArray[i]);
            }
        }
        for (String string2 : this.defaultOrder) {
            tableItem = new TableItem(this.itemTable, 0);
            tableItem.setChecked(false);
            tableItem.setText(GUI.i18n.getTranslation(string2));
            tableItem.setImage((Image)this.itemIcons.get(string2));
            tableItem.setData(string2);
        }
        this.initDefaultOrder();
    }

    void moveTableElementDown() {
        int n = this.itemTable.getSelectionIndex();
        if (n != this.itemTable.getItemCount() - 1) {
            TableItem tableItem = this.itemTable.getItem(n);
            TableItem tableItem2 = this.itemTable.getItem(n + 1);
            this.flip(tableItem, tableItem2);
            this.itemTable.setSelection(n + 1);
        }
    }

    void moveTableElementUp() {
        int n = this.itemTable.getSelectionIndex();
        if (n != 0) {
            TableItem tableItem = this.itemTable.getItem(n);
            TableItem tableItem2 = this.itemTable.getItem(n - 1);
            this.flip(tableItem, tableItem2);
            this.itemTable.setSelection(n - 1);
        }
    }

    void removeSeparator() {
        int n = this.itemTable.getSelectionIndex();
        this.itemTable.remove(n);
        this.itemTable.setSelection(n == this.itemTable.getItemCount() ? n - 1 : n);
        this.removeSepButton.setEnabled(TOOLITEM_SEPARATOR.equals(this.itemTable.getSelection()[0].getData()));
    }
}

