/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ValidateFeedDialog
extends TitleAreaDialog {
    private static final int dialogMinWidth = 320;
    private String dialogMessage;
    private String dialogTitle;
    private String feedUrl;
    Button okButton;
    Text urlInput;

    public ValidateFeedDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.dialogTitle = string;
        this.dialogMessage = string2;
        this.feedUrl = string3;
    }

    @Override
    public boolean close() {
        this.getTitleImageLabel().getImage().dispose();
        return super.close();
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0) {
            this.feedUrl = this.urlInput.getText();
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.dialogTitle);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
        } else {
            this.okButton = this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.okButton.setEnabled(false);
        this.okButton.setFont(FontShop.dialogFont);
        if (StringShop.isset(this.feedUrl)) {
            this.urlInput.setText(this.feedUrl);
            this.urlInput.selectAll();
        }
        this.urlInput.setFocus();
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 20));
        composite2.setLayoutData(new GridData(768));
        this.setTitleImage(PaintShop.loadImage("/img/icons/validate_big.gif"));
        this.setMessage(this.dialogMessage, 1);
        Label label = new Label(composite2, 0);
        label.setText(GUI.i18n.getTranslation("TABLE_HEADER_FEEDURL") + ": ");
        label.setLayoutData(new GridData(32));
        label.setFont(FontShop.dialogFont);
        this.urlInput = new Text(composite2, 2052);
        this.urlInput.setLayoutData(new GridData(768));
        this.urlInput.setFont(FontShop.dialogFont);
        this.urlInput.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                ValidateFeedDialog.this.okButton.setEnabled(!ValidateFeedDialog.this.urlInput.getText().trim().equals(""));
            }
        });
        WidgetShop.tweakTextWidget(this.urlInput);
        WidgetShop.setupDropSupport(this.urlInput, new Runnable(){

            @Override
            public void run() {
                ValidateFeedDialog.this.urlInput.selectAll();
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        Label label2 = new Label(composite3, 258);
        label2.setLayoutData(new GridData(768));
        return composite2;
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10820 | ValidateFeedDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(point2.x, point2.y, point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }
}

