/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dnd;

import java.util.Vector;
import net.sourceforge.rssowl.controller.FavoritesTree;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FavoritesTreeDND {
    private static final Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private DragSource source;
    private DropTarget target;
    Item dragSourceItem;
    FavoritesTree rssOwlFavoritesTree;
    boolean sourceIsCategory;
    Tree tree;

    public FavoritesTreeDND(FavoritesTree favoritesTree) {
        this.rssOwlFavoritesTree = favoritesTree;
        this.tree = favoritesTree.getFavoritesTree();
        this.initDragAndDrop();
    }

    public void dispose() {
        this.source.dispose();
        this.target.dispose();
    }

    public Item getDragSourceItem() {
        return this.dragSourceItem;
    }

    public void setDragSourceItem(Item item) {
        this.dragSourceItem = item;
    }

    private void createDragSource() {
        this.source = new DragSource(this.tree, 2);
        this.source.setTransfer(types);
        this.source.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragFinished(DragSourceEvent dragSourceEvent) {
                FavoritesTreeDND.this.dragSourceItem = null;
            }

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                TreeItemData treeItemData = (TreeItemData)FavoritesTreeDND.this.dragSourceItem.getData();
                if (treeItemData.isFavorite()) {
                    dragSourceEvent.data = treeItemData.getName();
                } else if (treeItemData.isCategory() || treeItemData.isBlogroll()) {
                    dragSourceEvent.data = FavoritesTreeDND.this.rssOwlFavoritesTree.getTreePath((TreeItem)FavoritesTreeDND.this.dragSourceItem, true);
                }
                FavoritesTreeDND.this.sourceIsCategory = treeItemData.isCategory() || treeItemData.isBlogroll();
            }

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                FavoritesTreeDND.this.rssOwlFavoritesTree.stopRenaming();
                TreeItem treeItem = FavoritesTreeDND.this.getValidDragSourceTreeItem();
                if (treeItem != null) {
                    dragSourceEvent.doit = true;
                    FavoritesTreeDND.this.dragSourceItem = treeItem;
                } else {
                    dragSourceEvent.doit = false;
                }
            }
        });
    }

    private void createDropTarget() {
        this.target = new DropTarget(this.tree, 3);
        this.target.setTransfer(types);
        this.target.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetEvent dropTargetEvent) {
                Object object;
                TreeItemData treeItemData;
                TreeItem treeItem = (TreeItem)dropTargetEvent.item;
                boolean bl = false;
                if (WidgetShop.isset(treeItem) && WidgetShop.isset(FavoritesTreeDND.this.dragSourceItem) && FavoritesTreeDND.this.dragSourceItem instanceof TreeItem) {
                    treeItemData = (TreeItemData)treeItem.getData();
                    object = (TreeItemData)FavoritesTreeDND.this.dragSourceItem.getData();
                    bl = ((TreeItemData)object).isCategory() || ((TreeItemData)object).isBlogroll() ? (treeItemData.isCategory() || treeItemData.isFavorite()) && FavoritesTreeDND.this.isValidTargetForCategory((TreeItem)FavoritesTreeDND.this.dragSourceItem, treeItem, dropTargetEvent) : (treeItemData.isCategory() || treeItemData.isFavorite()) && FavoritesTreeDND.this.isValidTargetForFavorite((TreeItem)FavoritesTreeDND.this.dragSourceItem, treeItem);
                } else if (WidgetShop.isset(treeItem) && WidgetShop.isset(FavoritesTreeDND.this.dragSourceItem) && FavoritesTreeDND.this.dragSourceItem instanceof CTabItem) {
                    treeItemData = (TreeItemData)treeItem.getData();
                    object = (TabItemData)FavoritesTreeDND.this.dragSourceItem.getData();
                    boolean bl2 = bl = treeItemData.isCategory() || treeItemData.isFavorite();
                    if (bl) {
                        bl = (((TabItemData)object).isFeed() || ((TabItemData)object).isBrowser()) && !((TabItemData)object).isAggregatedCat();
                    }
                } else if (WidgetShop.isset(treeItem) && dropTargetEvent.currentDataType != null) {
                    treeItemData = (TreeItemData)treeItem.getData();
                    boolean bl3 = bl = treeItemData.isCategory() || treeItemData.isFavorite();
                }
                if (bl) {
                    dropTargetEvent.feedback = 25;
                    if (WidgetShop.isset(FavoritesTreeDND.this.dragSourceItem) && FavoritesTreeDND.this.dragSourceItem instanceof TreeItem && ((treeItemData = (TreeItemData)FavoritesTreeDND.this.dragSourceItem.getData()).isCategory() || treeItemData.isBlogroll()) && treeItem.getParentItem() == null && ((TreeItem)FavoritesTreeDND.this.dragSourceItem).getParentItem() != null) {
                        object = GUI.display.map(null, FavoritesTreeDND.this.tree, dropTargetEvent.x, dropTargetEvent.y);
                        Rectangle rectangle = treeItem.getBounds();
                        if (((Point)object).y < rectangle.y + rectangle.height / 3) {
                            dropTargetEvent.feedback = 10;
                        }
                    }
                    dropTargetEvent.detail = FavoritesTreeDND.this.dragSourceItem instanceof TreeItem ? 2 : 1;
                } else {
                    dropTargetEvent.feedback = 9;
                    dropTargetEvent.detail = 0;
                }
            }

            @Override
            public void drop(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.data == null || dropTargetEvent.item == null) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                TreeItem treeItem = (TreeItem)dropTargetEvent.item;
                if (FavoritesTreeDND.this.dragSourceItem instanceof TreeItem) {
                    String string = (String)dropTargetEvent.data;
                    boolean bl = false;
                    if (FavoritesTreeDND.this.sourceIsCategory && treeItem.getParentItem() == null && ((TreeItem)FavoritesTreeDND.this.dragSourceItem).getParentItem() != null) {
                        Point point = GUI.display.map(null, FavoritesTreeDND.this.tree, dropTargetEvent.x, dropTargetEvent.y);
                        Rectangle rectangle = treeItem.getBounds();
                        if (point.y < rectangle.y + rectangle.height / 3) {
                            bl = true;
                        }
                    }
                    if (FavoritesTreeDND.this.sourceIsCategory && !bl) {
                        FavoritesTreeDND.this.moveCategory(string, ((TreeItemData)treeItem.getData()).isCategory() ? treeItem : treeItem.getParentItem());
                    } else if (FavoritesTreeDND.this.sourceIsCategory && bl) {
                        FavoritesTreeDND.this.moveCategoryToRoot(string);
                    } else {
                        FavoritesTreeDND.this.moveFavorite(string, ((TreeItemData)treeItem.getData()).isCategory() ? treeItem : treeItem.getParentItem());
                    }
                } else if (FavoritesTreeDND.this.dragSourceItem instanceof CTabItem || FavoritesTreeDND.this.dragSourceItem instanceof TableItem) {
                    String string = System.getProperty("line.separator");
                    String string2 = (String)dropTargetEvent.data;
                    String string3 = string2.split(string)[0];
                    String string4 = string2.split(string)[1];
                    Favorite favorite = new Favorite(string3, string4, null);
                    favorite.setUseProxy(ProxyShop.isUseProxy());
                    Channel channel = FavoritesTreeDND.this.dragSourceItem instanceof CTabItem ? GUI.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedChannel() : GUI.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string3);
                    if (channel != null && channel.getLink().equals(favorite.getUrl())) {
                        favorite.syncMetaData(channel);
                        favorite.setUnreadNewsCount(channel.getUnreadNewsCount());
                    }
                    favorite.setLastVisitDate(System.currentTimeMillis());
                    favorite.setCreationDate(System.currentTimeMillis());
                    FavoritesTreeDND.this.createFavorite(favorite, ((TreeItemData)treeItem.getData()).isCategory() ? treeItem : treeItem.getParentItem());
                } else {
                    String string = dropTargetEvent.data != null ? dropTargetEvent.data.toString().trim() : "";
                    Vector vector = new Vector();
                    RegExShop.extractLinksFromText(string, vector);
                    if (vector.size() > 0) {
                        final String string5 = (String)vector.get(0);
                        String string6 = FavoritesTreeDND.this.rssOwlFavoritesTree.getTreePath(((TreeItemData)treeItem.getData()).isCategory() ? treeItem : treeItem.getParentItem(), true);
                        final Category category = FavoritesTreeDND.this.rssOwlFavoritesTree.getSelectedCat(string6);
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GUI.isAlive()) {
                                    GUI.rssOwlGui.getEventManager().actionNewFavorite(string5, "", category);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private void initDragAndDrop() {
        this.createDragSource();
        this.createDropTarget();
    }

    void createFavorite(Favorite favorite, TreeItem treeItem) {
        String string = this.rssOwlFavoritesTree.getTreePath(treeItem, true);
        if (string.equals("")) {
            return;
        }
        this.rssOwlFavoritesTree.addFavorite(string, favorite.getUrl(), favorite.getTitle(), favorite);
        this.rssOwlFavoritesTree.buildFavoritesTree(true);
    }

    TreeItem getValidDragSourceTreeItem() {
        String string;
        Category category;
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length <= 0) {
            return null;
        }
        TreeItemData treeItemData = (TreeItemData)treeItemArray[0].getData();
        if (treeItemData.isBlogroll() && !(category = this.rssOwlFavoritesTree.getSelectedCat(string = this.rssOwlFavoritesTree.getTreePath(treeItemArray[0], true))).getParent().isBlogroll()) {
            return treeItemArray[0];
        }
        if (treeItemData.isFavorite() || treeItemData.isCategory()) {
            return treeItemArray[0];
        }
        return null;
    }

    boolean isValidTargetForCategory(TreeItem treeItem, TreeItem treeItem2, DropTargetEvent dropTargetEvent) {
        TreeItemData treeItemData = (TreeItemData)treeItem2.getData();
        TreeItemData treeItemData2 = (TreeItemData)treeItem.getData();
        if ((treeItemData2.isCategory() || treeItemData2.isBlogroll()) && treeItem.getParentItem() != null && treeItem2.getParentItem() == null) {
            Point point = GUI.display.map(null, this.tree, dropTargetEvent.x, dropTargetEvent.y);
            Rectangle rectangle = treeItem2.getBounds();
            if (point.y < rectangle.y + rectangle.height / 3) {
                return true;
            }
        }
        if (treeItem2.getParentItem() == treeItem.getParentItem() && !treeItemData.isCategory()) {
            return false;
        }
        if (treeItem2 == treeItem.getParentItem()) {
            return false;
        }
        if (treeItem2 == treeItem) {
            return false;
        }
        while (treeItem2.getParentItem() != null) {
            if (treeItem2.getParentItem() == treeItem) {
                return false;
            }
            treeItem2 = treeItem2.getParentItem();
        }
        return true;
    }

    boolean isValidTargetForFavorite(TreeItem treeItem, TreeItem treeItem2) {
        TreeItemData treeItemData = (TreeItemData)treeItem2.getData();
        if (treeItem2.getParentItem() == treeItem.getParentItem() && !treeItemData.isCategory()) {
            return false;
        }
        return treeItem2 != treeItem.getParentItem();
    }

    void moveCategory(String string, TreeItem treeItem) {
        Category category = this.rssOwlFavoritesTree.getSelectedCat(string);
        Category category2 = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(treeItem, true));
        category.getParent().getSortedSubCatTitles().remove(category.getName());
        category.getParent().getSubCategories().remove(category.getName());
        category.setParent(category2);
        category2.addCategory(category, true);
        category2.setExpanded(true);
        GlobalSettings.selectedTreeItem = category.toCatPath();
        this.rssOwlFavoritesTree.buildFavoritesTree(true);
        SettingsManager.getInstance().requestSave();
    }

    void moveCategoryToRoot(String string) {
        Category category = this.rssOwlFavoritesTree.getSelectedCat(string);
        Category category2 = Category.getRootCategory();
        category.getParent().getSortedSubCatTitles().remove(category.getName());
        category.getParent().getSubCategories().remove(category.getName());
        category.setParent(category2);
        category2.addCategory(category, true);
        category2.setExpanded(true);
        GlobalSettings.selectedTreeItem = category.toCatPath();
        this.rssOwlFavoritesTree.buildFavoritesTree(true);
        SettingsManager.getInstance().requestSave();
    }

    void moveFavorite(String string, TreeItem treeItem) {
        if (!Category.titleExists(string)) {
            return;
        }
        String string2 = Category.getLinkForTitle(string);
        if (!Category.getFavPool().containsKey(string2)) {
            return;
        }
        Favorite favorite = (Favorite)Category.getFavPool().get(string2);
        String string3 = this.rssOwlFavoritesTree.getTreePath(treeItem, true);
        if (string3.equals("")) {
            return;
        }
        Category category = favorite.getRSSOwlCategory();
        category.removeFavorite(string, false, true);
        this.rssOwlFavoritesTree.addFavorite(string3, string2, string, favorite);
        this.rssOwlFavoritesTree.buildFavoritesTree(true);
    }
}

