/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.forms;

import net.sourceforge.rssowl.controller.forms.AbstractHyperlink;
import net.sourceforge.rssowl.controller.forms.FormUtil;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class Hyperlink
extends AbstractHyperlink {
    private String text;
    private boolean underlined;

    public Hyperlink(Composite composite, int n) {
        super(composite, 0x40000 | n);
        this.initAccessible();
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Hyperlink.this.getText();
                if (accessibleEvent.result == null) {
                    this.getHelp(accessibleEvent);
                }
            }

            @Override
            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Hyperlink.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = Hyperlink.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = Hyperlink.this.getBounds().contains(point) ? -1 : -2;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Hyperlink.this.getBounds();
                Point point = Hyperlink.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                if (Hyperlink.this.getSelection()) {
                    n = 6;
                }
                accessibleControlEvent.detail = n;
            }
        });
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        if (n3 != -1) {
            n3 -= this.marginWidth * 2;
        }
        Point point = this.computeTextSize(n3, n2);
        int n4 = point.x + 2 * this.marginWidth;
        int n5 = point.y + 2 * this.marginHeight;
        return new Point(n4, n5);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string != null ? string : "";
        this.redraw();
    }

    @Override
    protected void paintHyperlink(GC gC) {
        Rectangle rectangle = this.getClientArea();
        Rectangle rectangle2 = new Rectangle(this.marginWidth, this.marginHeight, rectangle.width - this.marginWidth - this.marginWidth, rectangle.height - this.marginHeight - this.marginHeight);
        this.paintText(gC, rectangle2);
    }

    protected void paintText(GC gC, Rectangle rectangle) {
        gC.setFont(this.getFont());
        gC.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            FormUtil.paintWrapText(gC, this.text, rectangle, this.underlined);
        } else {
            Point point = this.computeTextSize(rectangle.width, -1);
            int n = point.x;
            int n2 = point.y;
            gC.drawText(this.getText(), rectangle.x, rectangle.y, true);
            if (this.underlined) {
                int n3 = gC.getFontMetrics().getDescent();
                int n4 = rectangle.y + n2 - n3 + 1;
                gC.drawLine(rectangle.x, n4, rectangle.x + n, n4);
            }
        }
    }

    protected Point computeTextSize(int n, int n2) {
        GC gC = new GC(this);
        gC.setFont(this.getFont());
        Point point = (this.getStyle() & 0x40) != 0 && n != -1 ? FormUtil.computeWrapSize(gC, this.getText(), n) : gC.textExtent(this.getText());
        gC.dispose();
        return point;
    }
}

