/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.panel;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserPanel {
    private static final String JAVA_SCRIPT_PRINT = "window.print();";
    private Composite browserPanel;
    private ToolItem itemDiscovery;
    private ToolItem itemHome;
    private ToolItem itemNewTab;
    private ToolItem itemReload;
    private ToolItem itemStop;
    private Composite parent;
    private boolean showControls;
    private boolean showNewTabControl;
    boolean blockNavigation;
    Browser browser;
    ToolItem itemBack;
    ToolItem itemForward;
    Text location;
    CTabItem parentTabItem;
    GUI rssOwlGui;
    String saveHome;
    Label status;
    Label statusProgressBar;

    public BrowserPanel(GUI gUI, Composite composite, boolean bl) {
        this(gUI, composite, null, bl, false);
    }

    public BrowserPanel(GUI gUI, Composite composite, CTabItem cTabItem, boolean bl, boolean bl2) {
        this.parent = composite;
        this.rssOwlGui = gUI;
        this.showControls = bl;
        this.showNewTabControl = bl2;
        this.parentTabItem = cTabItem;
        if (bl) {
            this.initComponents();
        } else {
            this.initComponentsNoControls();
        }
    }

    public void displayNews(NewsItem newsItem) {
        this.setText(StringShop.unicodeToEntities(newsItem.toHTML()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            if (GUI.isAlive() && WidgetShop.isset(this.browser)) {
                this.browser.setVisible(false);
            }
            if (GUI.isAlive() && WidgetShop.isset(this.browserPanel)) {
                this.browserPanel.setVisible(false);
            }
            this.browser.dispose();
            this.browser = null;
            this.browserPanel.dispose();
        }
        catch (Exception exception) {
            GUI.logger.log(exception.getMessage());
        }
        finally {
            this.browser = null;
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Composite getBrowserPanel() {
        return this.browserPanel;
    }

    public Text getLocation() {
        return this.location;
    }

    public void hideNoControlsBrowser() {
        this.browserPanel.setVisible(false);
    }

    public void openUrl(String string) {
        this.saveHome = string;
        this.location.setText(string);
        if (this.showControls) {
            this.itemHome.setEnabled(true);
            this.itemHome.setToolTipText(string);
        }
        if (!WidgetShop.isset(this.browser)) {
            if (this.showControls) {
                this.initBrowser();
            } else {
                this.initBrowserNoControls();
            }
        }
        this.browser.setUrl(string);
    }

    public boolean print() {
        if (WidgetShop.isset(this.browser)) {
            return this.browser.execute(JAVA_SCRIPT_PRINT);
        }
        return false;
    }

    public void setBlockNavigation(boolean bl) {
        this.blockNavigation = bl;
    }

    public void setTabItem(CTabItem cTabItem) {
        this.parentTabItem = cTabItem;
    }

    private void initBrowser() {
        ViewForm viewForm = new ViewForm(this.browserPanel, 0x800800);
        viewForm.setLayoutData(new GridData(4, 4, true, true));
        this.browser = new Browser(viewForm, 0);
        this.setupFeedProtocolSupport(this.browser);
        this.browser.setData(this.parentTabItem);
        viewForm.setContent(this.browser, true);
        Composite composite = new Composite(this.browserPanel, 0);
        composite.setLayout(LayoutShop.createGridLayout(2, 2, 1));
        composite.setLayoutData(new GridData(4, 1, true, false));
        composite.setBackground(PaintShop.grayViewFormColor);
        this.status = new Label(composite, 0);
        this.status.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.status.setBackground(PaintShop.grayViewFormColor);
        this.statusProgressBar = new Label(composite, 0);
        this.statusProgressBar.setFont(FontShop.dialogFont);
        this.statusProgressBar.setImage(PaintShop.getProgressIcon(0));
        this.statusProgressBar.setLayoutData(new GridData(0x1000008, 0x1000000, false, false));
        this.browser.addStatusTextListener(new StatusTextListener(){

            @Override
            public void changed(StatusTextEvent statusTextEvent) {
                BrowserPanel.this.onStatusTextChange(statusTextEvent);
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            @Override
            public void changed(ProgressEvent progressEvent) {
                BrowserPanel.this.onProgressChange(progressEvent);
                if (!StringShop.isset(BrowserPanel.this.location.getText()) && !BrowserPanel.this.location.isDisposed()) {
                    String string = ((Browser)progressEvent.widget).getUrl();
                    BrowserPanel.this.location.setText("about:blank".equals(string) ? "" : string);
                }
            }

            @Override
            public void completed(ProgressEvent progressEvent) {
                BrowserPanel.this.onProgressCompletion();
                if (!BrowserPanel.this.location.isDisposed()) {
                    String string = ((Browser)progressEvent.widget).getUrl();
                    BrowserPanel.this.location.setText("about:blank".equals(string) ? "" : string);
                    if ("about:blank".equals(string)) {
                        BrowserPanel.this.location.setFocus();
                    }
                }
            }
        });
        if (!GlobalSettings.displaySingleTab) {
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                @Override
                public void open(WindowEvent windowEvent) {
                    if (GUI.isAlive() && WidgetShop.isset(BrowserPanel.this.browser)) {
                        windowEvent.browser = BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().createBrowserPopupTab();
                    }
                }
            });
        }
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            @Override
            public void close(WindowEvent windowEvent) {
                if (WidgetShop.isset(BrowserPanel.this.parentTabItem)) {
                    BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().closeTab(BrowserPanel.this.parentTabItem);
                }
            }
        });
        this.browser.addLocationListener(new LocationAdapter(){

            @Override
            public void changed(LocationEvent locationEvent) {
                BrowserPanel.this.updateNavToolItems();
            }
        });
        if (!GlobalSettings.isLinux()) {
            this.browser.addVisibilityWindowListener(new VisibilityWindowAdapter(){

                @Override
                public void show(WindowEvent windowEvent) {
                    final WindowEvent windowEvent2 = windowEvent;
                    if (!(!GlobalSettings.blockPopups || windowEvent.addressBar && windowEvent.menuBar && windowEvent.statusBar && windowEvent.toolBar || !GUI.isAlive())) {
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GUI.isAlive() && WidgetShop.isset(windowEvent2.widget) && WidgetShop.isWidget(windowEvent2.widget.getData())) {
                                    BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().closeTab((CTabItem)windowEvent2.widget.getData());
                                }
                            }
                        });
                    }
                }
            });
        }
        this.browser.addListener(26, new Listener(){

            @Override
            public void handleEvent(Event event) {
                MenuManager.handleEditMenuState();
            }
        });
    }

    private void initBrowserNoControls() {
        Composite composite = new Composite(this.browserPanel, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 0));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.browser = new Browser(composite, 0);
        this.setupFeedProtocolSupport(this.browser);
        this.browser.setLayoutData(new GridData(4, 4, true, true));
        ViewForm viewForm = new ViewForm(this.browserPanel, 0x800800);
        viewForm.setLayoutData(new GridData(4, 1, true, false));
        viewForm.setBackground(PaintShop.grayViewFormColor);
        viewForm.setOnlyBorderTop(true);
        Composite composite2 = new Composite(viewForm, 0);
        composite2.setBackground(PaintShop.grayViewFormColor);
        composite2.setLayout(LayoutShop.createGridLayout(2, 2, 2));
        viewForm.setTopLeft(composite2, true);
        this.status = new Label(composite2, 0);
        this.status.setBackground(PaintShop.grayViewFormColor);
        this.status.setLayoutData(LayoutDataShop.createGridData(768, 1));
        this.statusProgressBar = new Label(composite2, 0);
        this.statusProgressBar.setFont(FontShop.dialogFont);
        this.statusProgressBar.setImage(PaintShop.getProgressIcon(0));
        this.statusProgressBar.setLayoutData(new GridData(0x1000008, 0x1000000, false, false));
        this.browser.addStatusTextListener(new StatusTextListener(){

            @Override
            public void changed(StatusTextEvent statusTextEvent) {
                if (StringShop.isset(statusTextEvent.text) && !"about:blank".equals(statusTextEvent.text)) {
                    BrowserPanel.this.status.setText(StringShop.escapeAmpersands(statusTextEvent.text));
                } else {
                    BrowserPanel.this.status.setText(GUI.i18n.getTranslation("LABEL_READY"));
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            @Override
            public void changed(ProgressEvent progressEvent) {
                BrowserPanel.this.onProgressChange(progressEvent);
            }

            @Override
            public void completed(ProgressEvent progressEvent) {
                BrowserPanel.this.onProgressCompletion();
            }
        });
        if (!GlobalSettings.isLinux()) {
            this.browser.addVisibilityWindowListener(new VisibilityWindowAdapter(){

                @Override
                public void show(WindowEvent windowEvent) {
                    final WindowEvent windowEvent2 = windowEvent;
                    if (!(!GlobalSettings.blockPopups || windowEvent.addressBar && windowEvent.menuBar && windowEvent.statusBar && windowEvent.toolBar || !GUI.isAlive())) {
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GUI.isAlive() && WidgetShop.isset(windowEvent2.widget) && WidgetShop.isWidget(windowEvent2.widget.getData())) {
                                    BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().closeTab((CTabItem)windowEvent2.widget.getData());
                                }
                            }
                        });
                    }
                }
            });
        }
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            @Override
            public void open(WindowEvent windowEvent) {
                if (GUI.isAlive() && WidgetShop.isset(BrowserPanel.this.browser)) {
                    windowEvent.browser = BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().createBrowserPopupTab();
                }
            }
        });
        this.browser.addLocationListener(new LocationAdapter(){

            @Override
            public void changed(LocationEvent locationEvent) {
                if (locationEvent.top) {
                    BrowserPanel.this.setBlockNavigation(true);
                }
            }

            @Override
            public void changing(LocationEvent locationEvent) {
                if (GlobalSettings.isMac()) {
                    return;
                }
                if (GlobalSettings.isLinux()) {
                    return;
                }
                if (!BrowserPanel.this.blockNavigation) {
                    return;
                }
                if (!GlobalSettings.openBrowserExtern) {
                    return;
                }
                if (!StringShop.isset(locationEvent.location) || locationEvent.location.equals("about:blank") || locationEvent.location.startsWith("feed:")) {
                    return;
                }
                locationEvent.doit = false;
                BrowserPanel.this.rssOwlGui.getEventManager().actionOpenURLExternal(locationEvent.location);
            }
        });
        this.browser.addListener(26, new Listener(){

            @Override
            public void handleEvent(Event event) {
                MenuManager.handleEditMenuState();
            }
        });
    }

    private void initComponents() {
        this.browserPanel = new Composite(this.parent, 0);
        this.browserPanel.setLayout(LayoutShop.createGridLayout(1, 0, 0, 2));
        this.browserPanel.setLayoutData(new GridData(4, 4, true, true));
        this.browserPanel.setBackground(PaintShop.grayViewFormColor);
        ViewForm viewForm = new ViewForm(this.browserPanel, 0x800800);
        viewForm.setLayoutData(new GridData(4, 1, true, false));
        viewForm.setBackground(PaintShop.grayViewFormColor);
        Composite composite = new Composite(viewForm, 0);
        composite.setLayout(LayoutShop.createGridLayout(2, 3, 1));
        composite.setBackground(PaintShop.grayViewFormColor);
        viewForm.setTopLeft(composite, false);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setLayoutData(new GridData(1, 0x1000000, false, false));
        toolBar.setBackground(PaintShop.grayViewFormColor);
        if (this.showNewTabControl) {
            this.itemNewTab = new ToolItem(toolBar, 8);
            this.itemNewTab.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_OPEN_TAB"));
            this.itemNewTab.setImage(PaintShop.loadImage("/img/icons/new_browser_tab.gif"));
            this.itemNewTab.setDisabledImage(PaintShop.loadImage("/img/icons/new_browser_tab_disabled.gif"));
            this.itemNewTab.addDisposeListener(DisposeListenerImpl.getInstance());
            this.itemNewTab.setEnabled(!GlobalSettings.displaySingleTab);
            this.itemNewTab.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    BrowserPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().displayBrowserTab("about:blank");
                }
            });
            new ToolItem(toolBar, 2);
        }
        this.itemBack = new ToolItem(toolBar, 8);
        this.itemBack.setToolTipText(GUI.i18n.getTranslation("BROWSER_BACK"));
        this.itemBack.setImage(PaintShop.iconBackward);
        this.itemBack.setDisabledImage(PaintShop.loadImage("/img/icons/backward_disabled.gif"));
        this.itemBack.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                BrowserPanel.this.itemBack.getDisabledImage().dispose();
            }
        });
        this.itemBack.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(BrowserPanel.this.browser)) {
                    BrowserPanel.this.browser.back();
                }
            }
        });
        this.itemForward = new ToolItem(toolBar, 8);
        this.itemForward.setToolTipText(GUI.i18n.getTranslation("BROWSER_FORWARD"));
        this.itemForward.setImage(PaintShop.iconForward);
        this.itemForward.setDisabledImage(PaintShop.loadImage("/img/icons/forward_disabled.gif"));
        this.itemForward.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                BrowserPanel.this.itemForward.getDisabledImage().dispose();
            }
        });
        this.itemForward.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(BrowserPanel.this.browser)) {
                    BrowserPanel.this.browser.forward();
                }
            }
        });
        this.itemStop = new ToolItem(toolBar, 8);
        this.itemStop.setToolTipText(GUI.i18n.getTranslation("BROWSER_STOP"));
        this.itemStop.setImage(PaintShop.iconStop);
        this.itemStop.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(BrowserPanel.this.browser)) {
                    BrowserPanel.this.browser.stop();
                }
            }
        });
        this.itemReload = new ToolItem(toolBar, 8);
        this.itemReload.setToolTipText(GUI.i18n.getTranslation("MENU_RELOAD"));
        this.itemReload.setImage(PaintShop.iconReloadBrowser);
        this.itemReload.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(BrowserPanel.this.browser)) {
                    BrowserPanel.this.browser.refresh();
                }
            }
        });
        this.itemHome = new ToolItem(toolBar, 8);
        this.itemHome.setImage(PaintShop.loadImage("/img/icons/home.gif"));
        this.itemHome.setDisabledImage(PaintShop.loadImage("/img/icons/home_disabled.gif"));
        this.itemHome.addDisposeListener(DisposeListenerImpl.getInstance());
        this.itemHome.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(BrowserPanel.this.browser)) {
                    BrowserPanel.this.browser.setUrl(BrowserPanel.this.saveHome);
                }
            }
        });
        new ToolItem(toolBar, 2);
        this.itemDiscovery = new ToolItem(toolBar, 8);
        this.itemDiscovery.setToolTipText(GUI.i18n.getTranslation("MENU_FEED_DISCOVERY"));
        this.itemDiscovery.setImage(PaintShop.loadImage("/img/icons/feed_discovery_browse.gif"));
        this.itemDiscovery.addDisposeListener(DisposeListenerImpl.getInstance());
        this.itemDiscovery.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                BrowserPanel.this.rssOwlGui.getEventManager().actionDiscoverFeeds(BrowserPanel.this.location.getText());
            }
        });
        this.itemBack.setEnabled(false);
        this.itemForward.setEnabled(false);
        this.itemHome.setEnabled(false);
        this.location = new Text(composite, 2048);
        this.location.setFont(FontShop.dialogFont);
        this.location.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.location.addListener(14, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (StringShop.isset(BrowserPanel.this.location.getText())) {
                    BrowserPanel.this.browser.setUrl(BrowserPanel.this.location.getText());
                    BrowserPanel.this.browser.setFocus();
                }
            }
        });
        WidgetShop.setupDropSupport(this.location, new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.browser.setUrl(BrowserPanel.this.location.getText());
                BrowserPanel.this.browser.setFocus();
            }
        });
        WidgetShop.tweakTextWidget(this.location);
        this.initBrowser();
    }

    private void initComponentsNoControls() {
        this.browserPanel = new Composite(this.parent, 0);
        this.browserPanel.setLayout(LayoutShop.createGridLayout(1, 0, 0, 0, 0, false));
        this.browserPanel.setLayoutData(LayoutDataShop.createFormData(0, 0, 0, 0));
        this.initBrowserNoControls();
    }

    private void setText(String string) {
        this.setBlockNavigation(false);
        if (!WidgetShop.isset(this.browser)) {
            if (this.showControls) {
                this.initBrowser();
            } else {
                this.initBrowserNoControls();
            }
        }
        this.browser.setText(string);
        if (!this.browserPanel.isVisible()) {
            this.browserPanel.setVisible(true);
        }
    }

    private void setupFeedProtocolSupport(Browser browser) {
        browser.addLocationListener(new LocationAdapter(){

            @Override
            public void changing(LocationEvent locationEvent) {
                String string;
                if (locationEvent.location != null && locationEvent.location.startsWith("feed:") && StringShop.isset(string = (string = locationEvent.location).startsWith("feed://") ? string.substring("feed://".length()) : string.substring("feed:".length()))) {
                    BrowserPanel.this.rssOwlGui.getEventManager().actionHandleSuppliedLink(string);
                    locationEvent.doit = false;
                }
            }
        });
    }

    void onProgressChange(ProgressEvent progressEvent) {
        if (progressEvent.total == 0) {
            return;
        }
        int n = progressEvent.current * 100 / progressEvent.total;
        if (n == 100) {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(100));
        } else if (n >= 80) {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(80));
        } else if (n >= 60) {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(60));
        } else if (n >= 40) {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(40));
        } else {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(20));
        }
        this.statusProgressBar.update();
    }

    void onProgressCompletion() {
        this.statusProgressBar.setImage(PaintShop.getProgressIcon(0));
        this.statusProgressBar.update();
    }

    void onStatusTextChange(StatusTextEvent statusTextEvent) {
        this.status.setText(StringShop.isset(statusTextEvent.text) ? StringShop.escapeAmpersands(statusTextEvent.text) : GUI.i18n.getTranslation("LABEL_READY"));
        this.updateNavToolItems();
    }

    void updateNavToolItems() {
        if (WidgetShop.isset(this.itemBack)) {
            this.itemBack.setEnabled(this.browser.isBackEnabled());
        }
        if (WidgetShop.isset(this.itemForward)) {
            this.itemForward.setEnabled(this.browser.isForwardEnabled());
        }
    }
}

