/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.panel;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ErrorPanel {
    private Display display;
    private Composite errorHolderAll;
    private Composite errorViewFormContent;
    private Composite parent;
    EventManager eventManager;
    NewsfeedFactoryException exception;
    GUI rssOwlGui;

    public ErrorPanel(GUI gUI, Display display, EventManager eventManager, Composite composite, NewsfeedFactoryException newsfeedFactoryException) {
        this.rssOwlGui = gUI;
        this.display = display;
        this.eventManager = eventManager;
        this.parent = composite;
        this.exception = newsfeedFactoryException;
        this.initComponents();
        this.initPopupMenu();
    }

    public Composite getPanel() {
        return this.errorHolderAll;
    }

    private void initComponents() {
        Scrollable scrollable;
        Control control;
        this.errorHolderAll = new Composite(this.parent, 0);
        this.errorHolderAll.setLayout(LayoutShop.createGridLayout(1, 2, 2, true));
        this.errorHolderAll.setBackground(this.display.getSystemColor(1));
        ViewForm viewForm = new ViewForm(this.errorHolderAll, 0x800800);
        viewForm.setBackground(this.display.getSystemColor(1));
        viewForm.setLayoutData(new GridData(4, 4, true, true));
        Composite composite = new Composite(viewForm, 0);
        composite.setBackground(PaintShop.grayViewFormColor);
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 3));
        composite.setLayoutData(new GridData(768));
        viewForm.setTopLeft(composite, false);
        Label label = new Label(composite, 0x1000000);
        label.setLayoutData(new GridData(0x1000000, 0x1000000, true, false));
        label.setBackground(PaintShop.grayViewFormColor);
        label.setForeground(this.display.getSystemColor(3));
        label.setFont(FontShop.textBoldFont);
        String string = "";
        string = this.exception.getTitle() != null ? StringShop.printf(GUI.i18n.getTranslation("ERROR_LOADING_FEED"), new String[]{"%TITLE%"}, new String[]{this.exception.getTitle()}) : StringShop.printf(GUI.i18n.getTranslation("ERROR_LOADING_FEED"), new String[]{"%TITLE%"}, new String[]{this.exception.getUrl()});
        label.setText(StringShop.escapeAmpersands(string));
        this.errorViewFormContent = new Composite(viewForm, 0);
        this.errorViewFormContent.setLayout(LayoutShop.createGridLayout(1, 0, 0, false));
        this.errorViewFormContent.setBackground(this.display.getSystemColor(1));
        Composite composite2 = new Composite(this.errorViewFormContent, 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 10, 10, false));
        composite2.setLayoutData(new GridData(1, 1, true, true));
        composite2.setBackground(this.display.getSystemColor(1));
        Label label2 = new Label(composite2, 72);
        label2.setFont(FontShop.textBoldFont);
        label2.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        label2.setBackground(this.display.getSystemColor(1));
        label2.setText(this.exception.getMsg() + "\n\n");
        if (this.exception.getReason() != null) {
            control = new Label(composite2, 0);
            control.setFont(FontShop.textBoldFont);
            control.setLayoutData(new GridData(1, 1, false, false));
            control.setBackground(this.display.getSystemColor(1));
            ((Label)control).setText(GUI.i18n.getTranslation("ERROR_REASON") + ": ");
            scrollable = new Text(composite2, 72);
            scrollable.setFont(FontShop.textFont);
            scrollable.setLayoutData(new GridData(4, 1, true, false));
            scrollable.setBackground(this.display.getSystemColor(1));
            ((Text)scrollable).setText(this.exception.getReason());
        }
        if (this.exception.getHttpStatus() != null) {
            control = new Label(composite2, 0);
            control.setFont(FontShop.textBoldFont);
            control.setLayoutData(new GridData(1, 1, false, false));
            control.setBackground(this.display.getSystemColor(1));
            ((Label)control).setText(GUI.i18n.getTranslation("ERROR_HTTP_STATUS") + ": ");
            scrollable = new Text(composite2, 72);
            scrollable.setFont(FontShop.textFont);
            scrollable.setLayoutData(new GridData(4, 1, true, false));
            scrollable.setBackground(this.display.getSystemColor(1));
            ((Text)scrollable).setText(this.exception.getHttpStatus());
        }
        if (GlobalSettings.workOffline) {
            new Label(composite2, 0).setLayoutData(new GridData(1, 1, false, false));
            control = new Button(composite2, 8);
            ((Button)control).setText(GUI.i18n.getTranslation("MENU_WORK_ONLINE"));
            control.setBackground(this.display.getSystemColor(1));
            control.setLayoutData(new GridData(1, 1, false, false));
            ((Button)control).addSelectionListener(new SelectionAdapter((Button)control){
                final /* synthetic */ Button val$goOnlineButton;
                {
                    this.val$goOnlineButton = button;
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$goOnlineButton.setEnabled(false);
                    GlobalSettings.workOffline = false;
                    ErrorPanel.this.rssOwlGui.getRSSOwlMenu().updateOfflineModeItem();
                    ErrorPanel.this.eventManager.actionReload();
                }
            });
        }
        control = new ViewForm(this.errorViewFormContent, 0x800800);
        ((ViewForm)control).setOnlyBorderTop(true);
        control.setLayoutData(new GridData(4, 0x1000008, true, true));
        control.setBackground(this.display.getSystemColor(1));
        control.setBackground(PaintShop.grayViewFormColor);
        scrollable = new Composite((Composite)control, 0);
        ((Composite)scrollable).setLayout(LayoutShop.createFillLayout(0, 0));
        scrollable.setBackground(PaintShop.grayViewFormColor);
        ((ViewForm)control).setTopLeft(scrollable, false);
        ToolBar toolBar = new ToolBar((Composite)scrollable, 0x800000);
        toolBar.setFont(FontShop.dialogFont);
        toolBar.setBackground(PaintShop.grayViewFormColor);
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setText(GUI.i18n.getTranslation("MENU_RELOAD"));
        toolItem.setImage(PaintShop.iconReload);
        toolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorPanel.this.eventManager.actionReload();
            }
        });
        new ToolItem(toolBar, 2);
        ToolItem toolItem2 = new ToolItem(toolBar, 8);
        toolItem2.setText(GUI.i18n.getTranslation("MENU_VALIDATE") + "...");
        toolItem2.setImage(PaintShop.iconValidate);
        toolItem2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorPanel.this.eventManager.actionValidateFeeds(true);
            }
        });
        new ToolItem(toolBar, 2);
        ToolItem toolItem3 = new ToolItem(toolBar, 8);
        toolItem3.setText(GUI.i18n.getTranslation("BUTTON_OPEN_IN_BROWSER"));
        toolItem3.setImage(PaintShop.iconWorld);
        toolItem3.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorPanel.this.openFeedInBrowser();
            }
        });
        WidgetShop.initMnemonics(new ToolItem[]{toolItem, toolItem2, toolItem3});
        viewForm.setContent(this.errorViewFormContent, true);
    }

    private void initPopupMenu() {
        Menu menu = new Menu(this.errorViewFormContent);
        MenuItem menuItem = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem, "BUTTON_ADDTO_FAVORITS", true, false);
        if (!GlobalSettings.isMac()) {
            menuItem.setImage(PaintShop.iconAddToFavorites);
        }
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorPanel.this.eventManager.actionAddToFavorites();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem2 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem2, "POP_MARK_UNREAD", false, false);
        menuItem2.setEnabled(false);
        MenuItem menuItem3 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem3, "POP_MARK_ALL_READ", false, false);
        menuItem3.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem4 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem4, "MENU_RELOAD", false, false);
        if (!GlobalSettings.isMac()) {
            menuItem4.setImage(PaintShop.iconReload);
        }
        menuItem4.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorPanel.this.eventManager.actionReload();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem5 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem5, "BUTTON_SEARCH", true, false);
        if (!GlobalSettings.isMac()) {
            menuItem5.setImage(PaintShop.iconFind);
        }
        menuItem5.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem6 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem6, "POP_MAIL_LINK", false, false);
        if (!GlobalSettings.isMac()) {
            menuItem6.setImage(PaintShop.iconMail);
        }
        menuItem6.setEnabled(false);
        MenuItem menuItem7 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem7, "POP_COPY_NEWS_URL", false, false);
        menuItem7.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem8 = new MenuItem(menu, 64);
        menuItem8.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem8.setImage(PaintShop.iconExport);
        }
        menuItem8.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem9 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem9, "POP_BLOG_NEWS", false, false);
        menuItem9.setEnabled(false);
        MenuManager.initMnemonics(menu);
        this.errorViewFormContent.setMenu(menu);
    }

    void openFeedInBrowser() {
        TabItemData tabItemData;
        CTabItem cTabItem = this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().getSelection();
        String string = null;
        if (cTabItem != null && !(tabItemData = (TabItemData)cTabItem.getData()).isMessage()) {
            string = ((TabItemData)cTabItem.getData()).getUrl();
        }
        if (StringShop.isset(string)) {
            this.eventManager.actionOpenURL(string);
        }
    }
}

