/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.panel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.rssowl.controller.ChannelInfo;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.NewsTable;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.model.TableData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NewsfeedPanel {
    private int[] columnWidths;
    private Composite newsHeaderHolderAll;
    private boolean performSearch;
    private Channel rssChannel;
    private String searchPattern;
    private String selectedNews;
    private String title;
    private String url;
    EventManager eventManager;
    GUI rssOwlGui;

    public NewsfeedPanel(GUI gUI, CTabItem cTabItem, Channel channel, String string, String string2, String string3, String string4, int[] nArray) {
        this.rssChannel = channel;
        this.searchPattern = string3;
        this.rssOwlGui = gUI;
        this.selectedNews = string4;
        this.url = string;
        this.title = string2;
        this.columnWidths = nArray;
        this.eventManager = gUI.getEventManager();
        this.performSearch = StringShop.isset(string3);
        this.initComponents(cTabItem);
    }

    public Composite getNewsfeedPanel() {
        return this.newsHeaderHolderAll;
    }

    private void createEmptyNewsPopup(Control control) {
        Menu menu = new Menu(control);
        MenuItem menuItem = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem, "BUTTON_ADDTO_FAVORITS", true, false);
        if (!GlobalSettings.isMac()) {
            menuItem.setImage(PaintShop.iconAddToFavorites);
        }
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsfeedPanel.this.eventManager.actionAddToFavorites();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem2 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem2, "POP_MARK_UNREAD", false, false);
        menuItem2.setEnabled(false);
        MenuItem menuItem3 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem3, "POP_MARK_ALL_READ", false, false);
        menuItem3.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem4 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem4, "MENU_RELOAD", false, false);
        if (!GlobalSettings.isMac()) {
            menuItem4.setImage(PaintShop.iconReload);
        }
        menuItem4.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsfeedPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().reloadFeed();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem5 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem5, "BUTTON_SEARCH", true, false);
        if (!GlobalSettings.isMac()) {
            menuItem5.setImage(PaintShop.iconFind);
        }
        menuItem5.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                NewsfeedPanel.this.rssOwlGui.getRSSOwlNewsTabFolder().searchInSelectedFeed();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem6 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem6, "POP_MAIL_LINK", false, false);
        if (!GlobalSettings.isMac()) {
            menuItem6.setImage(PaintShop.iconMail);
        }
        menuItem6.setEnabled(false);
        MenuItem menuItem7 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem7, "POP_COPY_NEWS_URL", false, false);
        menuItem7.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem8 = new MenuItem(menu, 64);
        menuItem8.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem8.setImage(PaintShop.iconExport);
        }
        menuItem8.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem menuItem9 = new MenuItem(menu, 0);
        this.rssOwlGui.getRSSOwlMenu().updateAccelerator(menuItem9, "POP_BLOG_NEWS", false, false);
        menuItem9.setEnabled(false);
        MenuManager.initMnemonics(menu);
        control.setMenu(menu);
    }

    private void createInfoArea(Composite composite, String string, final String string2) {
        ViewForm viewForm = new ViewForm(composite, 2048);
        viewForm.set3DBorderState(false);
        viewForm.setLayoutData(new GridData(4, 1, true, false));
        viewForm.setBackground(GUI.display.getSystemColor(1));
        Composite composite2 = new Composite(viewForm, 0);
        composite2.setLayout(LayoutShop.createGridLayout(2, 5, 0, 5, 6, false));
        composite2.setBackground(GUI.display.getSystemColor(1));
        Label label = new Label(composite2, 0);
        label.setImage(PaintShop.iconInfo);
        label.setBackground(GUI.display.getSystemColor(1));
        label.setLayoutData(new GridData(1, 0x1000000, false, true));
        Label label2 = new Label(composite2, 64);
        label2.setFont(FontShop.textFont);
        label2.setBackground(GUI.display.getSystemColor(1));
        label2.setLayoutData(new GridData(1, 0x1000000, true, true));
        label2.setText(string);
        viewForm.setTopLeft(composite2, string2 == null);
        if (string2 != null) {
            Composite composite3 = new Composite(viewForm, 0);
            composite3.setLayout(LayoutShop.createGridLayout(1, 0, 0));
            composite3.setBackground(GUI.display.getSystemColor(1));
            ToolBar toolBar = new ToolBar(composite3, 0x800000);
            toolBar.setLayoutData(new GridData(131072, 0x1000000, false, true));
            toolBar.setBackground(GUI.display.getSystemColor(1));
            ToolItem toolItem = new ToolItem(toolBar, 8);
            toolItem.setImage(PaintShop.loadImage("/img/icons/closesearch.gif"));
            toolItem.setToolTipText(GUI.i18n.getTranslation("MENU_CLOSE"));
            toolItem.addDisposeListener(DisposeListenerImpl.getInstance());
            toolItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewsfeedPanel.this.eventManager.actionOpenFeed(string2);
                    NewsfeedPanel.this.rssOwlGui.getRSSOwlQuickview().clearLiveSearch();
                }
            });
            viewForm.setTopRight(composite3, true);
        }
    }

    private void initComponents(CTabItem cTabItem) {
        this.newsHeaderHolderAll = new Composite(this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder(), 0);
        this.newsHeaderHolderAll.setLayout(LayoutShop.createGridLayout(1, 2, 2, 4, 0, true));
        this.newsHeaderHolderAll.setBackground(GUI.display.getSystemColor(1));
        if (GlobalSettings.isMac()) {
            this.newsHeaderHolderAll.setLayout(LayoutShop.createGridLayout(1, 0, 0, 2, 0, true));
            int n = ((GridLayout)this.newsHeaderHolderAll.getLayout()).marginTop = GlobalSettings.showChannelInfo ? 2 : 0;
        }
        if (GlobalSettings.showChannelInfo && StringShop.isset(this.rssChannel.getTitle())) {
            new ChannelInfo(GUI.display, this.newsHeaderHolderAll, this.rssChannel, this.eventManager);
        }
        Hashtable hashtable = this.rssChannel.getItems();
        Vector vector = this.rssChannel.getNewsItemOrder();
        if (this.performSearch) {
            hashtable = this.rssChannel.getSearchResultsItems();
            vector = this.rssChannel.getSearchResultsItemOrder();
        }
        if (vector.size() > 0) {
            int n;
            Object object;
            Composite composite = new Composite(this.newsHeaderHolderAll, 0);
            composite.setLayout(LayoutShop.createGridLayout(1, 0, 0));
            composite.setBackground(GUI.display.getSystemColor(1));
            composite.setLayoutData(new GridData(4, 4, true, true));
            if (this.performSearch) {
                this.createInfoArea(composite, StringShop.printf(GUI.i18n.getTranslation("LABEL_SEARCH_RESULTS"), new String[]{"%TERM%", "%NUM%"}, new String[]{StringShop.escapeAmpersands(this.searchPattern), String.valueOf(this.rssChannel.getItemCount())}) + ": ", this.url);
            }
            NewsTable newsTable = new NewsTable(this.rssOwlGui, cTabItem, this.eventManager);
            Table table = newsTable.createNewsTable(composite);
            cTabItem.setData(TabItemData.createFeedData(this.url, this.title, this.rssChannel, newsTable, table));
            Vector vector2 = this.rssChannel.getAvailableNewsItemInfos();
            NewsTable.fillTableColumns(table, hashtable, vector, vector2, this.performSearch);
            if (GlobalSettings.autoSortNews) {
                object = GlobalSettings.sortOrder;
                TableData tableData = (TableData)table.getData();
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    String string = (String)((ArrayList)object).get(n);
                    if (!tableData.hasColumnSorter(string)) continue;
                    boolean bl = tableData.getColumnSorter(string).sort(string);
                    if (!"TABLE_HEADER_STATUS".equals(string)) {
                        table.setSortColumn(tableData.getColumn(string));
                        table.setSortDirection(bl ? 128 : 1024);
                        break;
                    }
                    if (table.getSortColumn() == null) break;
                    table.setSortDirection(0);
                    table.setSortColumn(null);
                    break;
                }
            }
            if (this.columnWidths != null && this.columnWidths.length == vector2.size()) {
                NewsTable.fillTable(table, hashtable, vector, vector2, this.performSearch, this.columnWidths);
            } else {
                NewsTable.fillTable(table, hashtable, vector, vector2, this.performSearch);
            }
            object = "TABLE_HEADER_PUBDATE";
            if (this.selectedNews != null) {
                int n2 = table.getItemCount();
                for (n = 0; n < n2; ++n) {
                    if (!table.getItem(n).getText(1).equals(this.selectedNews)) continue;
                    if (vector2.contains(object) && GlobalSettings.sortOrder.indexOf(object) == 0) {
                        table.select(n);
                    } else {
                        table.setSelection(n);
                    }
                    break;
                }
            }
        } else {
            cTabItem.setData(TabItemData.createFeedData(this.url, this.rssChannel.getTitle(), this.rssChannel, null, null));
            if (this.performSearch) {
                this.createInfoArea(this.newsHeaderHolderAll, StringShop.printf(GUI.i18n.getTranslation("LABEL_SEARCH_EMPTY"), new String[]{"%TERM%"}, new String[]{StringShop.escapeAmpersands(this.searchPattern)}), this.url);
            } else {
                this.createInfoArea(this.newsHeaderHolderAll, GUI.i18n.getTranslation("ERROR_NO_NEWS_FOUND"), null);
            }
            this.createEmptyNewsPopup(this.newsHeaderHolderAll);
        }
    }
}

