/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.panel;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.forms.Hyperlink;
import net.sourceforge.rssowl.controller.forms.HyperlinkAdapter;
import net.sourceforge.rssowl.controller.forms.HyperlinkEvent;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class UpdatePanel {
    private Color bannerColor;
    private Image bannerImage;
    private Display display;
    private String message;
    private ViewForm messageViewForm;
    private Composite parent;
    private String title;

    public UpdatePanel(Display display, Composite composite, String string, String string2) {
        this.parent = composite;
        this.display = display;
        this.title = string;
        this.message = string2;
        this.bannerColor = new Color(display, 216, 216, 216);
        this.bannerImage = PaintShop.loadImage("/img/aboutbanner.png");
        this.initComponents();
    }

    public void dispose() {
        this.bannerColor.dispose();
        this.bannerImage.dispose();
    }

    public Composite getPanel() {
        return this.messageViewForm;
    }

    private void initComponents() {
        this.messageViewForm = new ViewForm(this.parent, 0x800800);
        this.messageViewForm.setBackground(this.bannerColor);
        this.messageViewForm.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                UpdatePanel.this.dispose();
            }
        });
        Composite composite = new Composite(this.messageViewForm, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 0));
        composite.setBackground(this.bannerColor);
        this.messageViewForm.setTopLeft(composite, false);
        Label label = new Label(composite, 0);
        label.setImage(this.bannerImage);
        label.setLayoutData(new GridData(0x1000000, 1, true, false));
        label.setCursor(this.display.getSystemCursor(21));
        label.setToolTipText(URLShop.RSSOWL_WEBPAGE);
        label.setBackground(this.bannerColor);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_WEBPAGE);
            }
        });
        Label label2 = new Label(composite, 0x1000000);
        label2.setText(this.title);
        label2.setLayoutData(new GridData(0x1000000, 1, true, false));
        label2.setBackground(this.bannerColor);
        label2.setFont(FontShop.textBoldFont);
        Composite composite2 = new Composite(this.messageViewForm, 0);
        composite2.setLayout(LayoutShop.createGridLayout(1, 10, 5));
        composite2.setLayoutData(new GridData(1, 1, true, true));
        composite2.setBackground(this.display.getSystemColor(1));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout(LayoutShop.createGridLayout(2, 0, 10));
        composite3.setLayoutData(new GridData(1, 1, true, false));
        composite3.setBackground(this.display.getSystemColor(1));
        CLabel cLabel = new CLabel(composite3, 0);
        cLabel.setImage(PaintShop.iconMail);
        cLabel.setText(GUI.i18n.getTranslation("LABEL_DOWNLOAD") + ": ");
        cLabel.setFont(FontShop.textBoldFont);
        cLabel.setLayoutData(new GridData(1, 1, false, false));
        cLabel.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink = new Hyperlink(composite3, 0);
        hyperlink.setUnderlined(true);
        hyperlink.setText(URLShop.RSSOWL_DOWNLOAD);
        hyperlink.setFont(FontShop.textFont);
        hyperlink.setLayoutData(new GridData(1, 1, false, false));
        hyperlink.setForeground(this.display.getSystemColor(9));
        hyperlink.setBackground(this.display.getSystemColor(1));
        hyperlink.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_DOWNLOAD);
            }
        });
        StyledText styledText = new StyledText(composite2, 586);
        styledText.setText(this.message);
        styledText.setCaret(null);
        styledText.setLayoutData(new GridData(4, 4, true, true));
        styledText.setFont(FontShop.textFont);
        styledText.setBackground(this.display.getSystemColor(1));
        this.messageViewForm.setContent(composite2, true);
    }
}

