/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AmphetaRateProperties
extends PropertyPage {
    private Group existingAccountGroup;
    private Composite existingAccountHolder;
    private Text password;
    private Label userIDLabel;
    private Text username;
    Text userId;

    public AmphetaRateProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
        this.setRestoreButtonState(false);
    }

    @Override
    public void applyButtonPressed() {
        if (AmphetaRateThread.isOldUser()) {
            return;
        }
        if (!GlobalSettings.amphetaRateUsername.equals(this.username.getText()) || !GlobalSettings.amphetaRatePassword.equals(this.password.getText())) {
            GlobalSettings.amphetaRateUsername = this.username.getText();
            GlobalSettings.amphetaRatePassword = this.password.getText();
            this.rssOwlGui.getRSSOwlNewsText().setNewsTextToolBarVisible(StringShop.isset(GlobalSettings.amphetaRateUsername));
            this.rssOwlGui.getRSSOwlStatusLine().setAmphetaRateItemsVisible(StringShop.isset(GlobalSettings.amphetaRateUsername));
            this.rssOwlGui.getRSSOwlFavoritesTree().createAmphetaRateFeed();
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        if (AmphetaRateThread.isOldUser()) {
            return;
        }
        propertyChangeManager.setAmphetaRateUsername(this.username.getText());
        propertyChangeManager.setAmphetaRatePassword(this.password.getText());
    }

    @Override
    protected void initComponents() {
        this.existingAccountGroup = new Group(this.composite, 0);
        this.existingAccountGroup.setLayoutData(LayoutDataShop.createGridData(770, 2));
        this.existingAccountGroup.setText(GUI.i18n.getTranslation("GROUP_EXISTING_ACCOUNT"));
        this.existingAccountGroup.setLayout(new GridLayout(2, false));
        this.existingAccountGroup.setFont(FontShop.dialogFont);
        this.createExistingAccountGroup(!GlobalSettings.amphetaRateUserID.equals(""));
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("GROUP_NEW_ACCOUNT"));
        group.setLayout(new GridLayout(2, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_USERNAME") + ": ");
        label.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label.setFont(this.dialogFont);
        final Text text = new Text(group, 2052);
        text.setLayoutData(LayoutDataShop.createGridData(768, 1));
        text.setFont(this.dialogFont);
        WidgetShop.tweakTextWidget(text);
        Label label2 = new Label(group, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_PASSWORD") + ": ");
        label2.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label2.setFont(this.dialogFont);
        final Text text2 = new Text(group, 0x400804);
        text2.setLayoutData(LayoutDataShop.createGridData(768, 1));
        text2.setFont(this.dialogFont);
        WidgetShop.tweakTextWidget(text2);
        Label label3 = new Label(group, 0);
        label3.setText(GUI.i18n.getTranslation("LABEL_OLD_ID") + ": ");
        label3.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label3.setFont(this.dialogFont);
        final Text text3 = new Text(group, 2052);
        text3.setLayoutData(LayoutDataShop.createGridData(768, 1));
        text3.setFont(this.dialogFont);
        text3.setText(propertyChangeManager.getAmphetaRateId());
        WidgetShop.tweakTextWidget(text3);
        Button button = new Button(group, 0);
        button.setText(GUI.i18n.getTranslation("BUTTON_CREATE_ACCOUNT"));
        button.setFont(this.dialogFont);
        this.setButtonLayoutData(button, LayoutDataShop.createGridData(128, 2));
        button.addSelectionListener(new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                AmphetaRateProperties.this.setErrorMessage(null);
                try {
                    String string = text.getText();
                    String string2 = text2.getText();
                    String string3 = text3.getText();
                    if (string.equals("")) {
                        return;
                    }
                    AmphetaRateProperties.this.composite.getShell().setCursor(GUI.display.getSystemCursor(1));
                    String string4 = AmphetaRateThread.register(string, string2, string3);
                    if (string4.indexOf("OK") >= 0) {
                        PropertyPage.propertyChangeManager.setAmphetaRateUsername(string);
                        PropertyPage.propertyChangeManager.setAmphetaRatePassword(string2);
                        PropertyPage.propertyChangeManager.setAmphetaRateId("");
                        GlobalSettings.amphetaRateUserID = "";
                        AmphetaRateProperties.this.createExistingAccountGroup(false);
                        text.setText("");
                        text2.setText("");
                        text3.setText("");
                        AmphetaRateProperties.this.setSuccessMessage(GUI.i18n.getTranslation("LABEL_REGISTRATION_SUCCESS"));
                    } else {
                        AmphetaRateProperties.this.setErrorMessage(string4);
                    }
                }
                catch (IOException iOException) {
                    AmphetaRateProperties.this.setErrorMessage(GUI.i18n.getTranslation("ERROR_CONNECTION_FAILED"));
                    GUI.logger.log("AmphetaRateThread.register()", iOException);
                }
                finally {
                    AmphetaRateProperties.this.composite.getShell().setCursor(null);
                }
            }
        });
        this.errorMessageLabel = new CLabel(group, 0);
        this.errorMessageLabel.setFont(this.dialogFont);
        this.errorMessageLabel.setLayoutData(LayoutDataShop.createGridData(32, 2));
        WidgetShop.initMnemonics(new Button[]{button});
    }

    @Override
    protected void restoreButtonPressed() {
    }

    void createExistingAccountGroup(boolean bl) {
        if (WidgetShop.isset(this.existingAccountHolder)) {
            this.existingAccountHolder.dispose();
        }
        this.existingAccountHolder = new Composite(this.existingAccountGroup, 0);
        this.existingAccountHolder.setLayoutData(LayoutDataShop.createGridData(770, 2));
        this.existingAccountHolder.setLayout(new GridLayout(2, false));
        if (bl) {
            this.userIDLabel = new Label(this.existingAccountHolder, 0);
            this.userIDLabel.setText(GUI.i18n.getTranslation("LABEL_AMPHETARATE_ID") + ": ");
            this.userIDLabel.setLayoutData(LayoutDataShop.createGridData(32, 1));
            this.userIDLabel.setFont(this.dialogFont);
            this.userId = new Text(this.existingAccountHolder, 2060);
            this.userId.setLayoutData(LayoutDataShop.createGridData(768, 1));
            this.userId.setFont(this.dialogFont);
            this.userId.setText(propertyChangeManager.getAmphetaRateId());
            WidgetShop.tweakTextWidget(this.userId);
        } else {
            Label label = new Label(this.existingAccountHolder, 0);
            label.setText(GUI.i18n.getTranslation("LABEL_USERNAME") + ": ");
            label.setLayoutData(LayoutDataShop.createGridData(32, 1));
            label.setFont(this.dialogFont);
            this.username = new Text(this.existingAccountHolder, 2052);
            this.username.setLayoutData(LayoutDataShop.createGridData(768, 1));
            this.username.setFont(this.dialogFont);
            this.username.setText(propertyChangeManager.getAmphetaRateUsername());
            WidgetShop.tweakTextWidget(this.username);
            Label label2 = new Label(this.existingAccountHolder, 0);
            label2.setText(GUI.i18n.getTranslation("LABEL_PASSWORD") + ": ");
            label2.setLayoutData(LayoutDataShop.createGridData(32, 1));
            label2.setFont(this.dialogFont);
            this.password = new Text(this.existingAccountHolder, 0x400804);
            this.password.setLayoutData(LayoutDataShop.createGridData(768, 1));
            this.password.setFont(this.dialogFont);
            this.password.setText(propertyChangeManager.getAmphetaRatePassword());
            WidgetShop.tweakTextWidget(this.password);
        }
        this.existingAccountGroup.layout();
        this.composite.layout();
    }
}

