/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.ArrayList;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BrowserProperties
extends PropertyPage {
    private Button blockPopupsCheck;
    private Button openNewBrowserWindowCheck;
    Text browserArguments;
    Text browserPath;
    Button openBrowserExternCheck;

    public BrowserProperties(Composite composite) {
        super(composite);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.customBrowser = this.browserPath.getText();
        GlobalSettings.customBrowserArguments = this.browserArguments.getText();
        if (GlobalSettings.useInternalBrowser()) {
            GlobalSettings.openNewBrowserWindow = this.openNewBrowserWindowCheck.getSelection();
            GlobalSettings.openBrowserExtern = this.openBrowserExternCheck.getSelection();
            if (!GlobalSettings.isLinux()) {
                GlobalSettings.blockPopups = this.blockPopupsCheck.getSelection();
            }
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setCustomBrowserPath(this.browserPath.getText());
        propertyChangeManager.setCustomBrowserArguments(this.browserArguments.getText());
        if (GlobalSettings.useInternalBrowser()) {
            propertyChangeManager.setOpenBrowserInNewTab(this.openNewBrowserWindowCheck.getSelection());
            propertyChangeManager.setOpenBrowserExtern(this.openBrowserExternCheck.getSelection());
            if (!GlobalSettings.isLinux()) {
                propertyChangeManager.setBlockPopups(this.blockPopupsCheck.getSelection());
            }
        }
    }

    @Override
    protected void initComponents() {
        ArrayList<Button> arrayList = new ArrayList<Button>();
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("MENU_SELECT_EXTERNAL_BROWSER"));
        group.setLayout(new GridLayout(2, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 64);
        label.setText(GUI.i18n.getTranslation("DIALOG_SELECT_EXTERNAL_BROWSER") + ": ");
        label.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label.setFont(this.dialogFont);
        this.browserPath = new Text(group, 2052);
        this.browserPath.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.browserPath.setFont(this.dialogFont);
        this.browserPath.setText(propertyChangeManager.getCustomBrowserPath());
        this.browserPath.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                BrowserProperties.this.browserArguments.setEnabled(!BrowserProperties.this.browserPath.getText().equals(""));
                boolean bl = FileShop.exists(BrowserProperties.this.browserPath.getText());
                if (bl && GlobalSettings.useInternalBrowser()) {
                    BrowserProperties.this.openBrowserExternCheck.setSelection(true);
                }
                if (StringShop.isset(BrowserProperties.this.browserPath.getText())) {
                    BrowserProperties.this.setErrorMessage(bl ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));
                } else {
                    BrowserProperties.this.setErrorMessage(null);
                }
            }
        });
        WidgetShop.tweakTextWidget(this.browserPath);
        Button button = new Button(group, 8);
        button.setText(GUI.i18n.getTranslation("BUTTON_SEARCH") + "...");
        button.setFont(this.dialogFont);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileShop.getFilePath(BrowserProperties.this.composite.getShell(), null, null, 4096, BrowserProperties.this.browserPath.getText(), GUI.i18n.getTranslation("MENU_BROWSER"));
                if (string != null) {
                    BrowserProperties.this.browserPath.setText(string);
                }
            }
        });
        this.setButtonLayoutData(button);
        arrayList.add(button);
        this.errorMessageLabel = new CLabel(group, 0);
        this.errorMessageLabel.setFont(this.dialogFont);
        this.errorMessageLabel.setLayoutData(new GridData(1, 0x1000000, false, false));
        if (StringShop.isset(this.browserPath.getText())) {
            this.setErrorMessage(FileShop.exists(this.browserPath.getText()) ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));
        }
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("GROUP_ARGUMENTS"));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        this.browserArguments = new Text(group2, 2052);
        this.browserArguments.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.browserArguments.setFont(this.dialogFont);
        this.browserArguments.setText(propertyChangeManager.getCustomBrowserArguments());
        WidgetShop.tweakTextWidget(this.browserArguments);
        this.browserArguments.setEnabled(!this.browserPath.getText().equals(""));
        WidgetShop.createWildCardMenu(this.browserArguments, new String[]{"[URL]"});
        Label label2 = new Label(group2, 64);
        label2.setText(GUI.i18n.getTranslation("LABEL_BROWSER_USAGE"));
        label2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label2.setFont(this.dialogFont);
        if (GlobalSettings.useInternalBrowser()) {
            Group group3 = new Group(this.composite, 0);
            group3.setLayoutData(LayoutDataShop.createGridData(770, 2));
            group3.setText(GUI.i18n.getTranslation("MENU_MISC"));
            group3.setLayout(new GridLayout(2, false));
            group3.setFont(FontShop.dialogFont);
            if (!GlobalSettings.isLinux()) {
                this.blockPopupsCheck = new Button(group3, 32);
                this.blockPopupsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
                this.blockPopupsCheck.setSelection(propertyChangeManager.isBlockPopups());
                this.blockPopupsCheck.setText(GUI.i18n.getTranslation("BUTTON_BLOCK_POPUPS"));
                this.blockPopupsCheck.setFont(this.dialogFont);
                arrayList.add(this.blockPopupsCheck);
            }
            this.openNewBrowserWindowCheck = new Button(group3, 32);
            this.openNewBrowserWindowCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
            this.openNewBrowserWindowCheck.setSelection(propertyChangeManager.isOpenBrowserInNewTab());
            this.openNewBrowserWindowCheck.setText(GUI.i18n.getTranslation("MENU_OPENNEW_BROWSER"));
            this.openNewBrowserWindowCheck.setFont(this.dialogFont);
            arrayList.add(this.openNewBrowserWindowCheck);
            this.openBrowserExternCheck = new Button(group3, 32);
            this.openBrowserExternCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
            this.openBrowserExternCheck.setSelection(propertyChangeManager.isOpenBrowserExtern());
            this.openBrowserExternCheck.setText(GUI.i18n.getTranslation("MENU_BROWSER_EXTERN"));
            this.openBrowserExternCheck.setFont(this.dialogFont);
            arrayList.add(this.openBrowserExternCheck);
        }
        WidgetShop.initMnemonics(arrayList.toArray(new Button[arrayList.size()]));
        LayoutShop.setDialogSpacer(this.composite, 2, GlobalSettings.useInternalBrowser() ? 1 : 3);
    }

    @Override
    protected void restoreButtonPressed() {
        if (GlobalSettings.useInternalBrowser()) {
            this.openBrowserExternCheck.setSelection(false);
            this.openNewBrowserWindowCheck.setSelection(true);
            if (!GlobalSettings.isLinux()) {
                this.blockPopupsCheck.setSelection(true);
            }
            this.setErrorMessage(null);
        }
        this.browserPath.setText("");
        this.browserArguments.setText("");
        this.updatePropertiesChangeManager();
    }
}

