/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class ColorProperties
extends PropertyPage {
    Button linkColorChooser;
    Button syntaxHighlightcolorChooser;

    public ColorProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    @Override
    public void applyButtonPressed() {
        if (!propertyChangeManager.getLinkColor().equals(GlobalSettings.linkColor)) {
            GlobalSettings.linkColor = propertyChangeManager.getLinkColor();
            PaintShop.initLinkColor(GUI.display);
            this.rssOwlGui.getRSSOwlNewsText().updateLinkColor();
        }
        if (!propertyChangeManager.getSyntaxHighlightColor().equals(GlobalSettings.syntaxHighlightColor)) {
            GlobalSettings.syntaxHighlightColor = propertyChangeManager.getSyntaxHighlightColor();
            PaintShop.initSyntaxHighlightColor(GUI.display);
        }
    }

    @Override
    public void updatePropertiesChangeManager() {
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("GROUP_LINK_COLOR"));
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_CURRENT_COLOR") + ": ");
        label.setFont(this.dialogFont);
        this.linkColorChooser = new Button(group, 0);
        this.linkColorChooser.setFont(this.dialogFont);
        this.linkColorChooser.addDisposeListener(DisposeListenerImpl.getInstance());
        this.linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getLinkColor(), 30, 15));
        this.linkColorChooser.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ColorProperties.this.composite.getShell());
                colorDialog.setRGB(PropertyPage.propertyChangeManager.getLinkColor());
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    PropertyPage.propertyChangeManager.setLinkColor(rGB);
                    ColorProperties.this.linkColorChooser.getImage().dispose();
                    ColorProperties.this.linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, rGB, 30, 15));
                }
            }
        });
        Group group2 = new Group(this.composite, 0);
        group2.setText(GUI.i18n.getTranslation("GROUP_SYNTAXHIGHLIGHT_COLOR"));
        group2.setLayout(new GridLayout(2, false));
        group2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group2.setFont(FontShop.dialogFont);
        Label label2 = new Label(group2, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_CURRENT_COLOR") + ": ");
        label2.setFont(this.dialogFont);
        this.syntaxHighlightcolorChooser = new Button(group2, 0);
        this.syntaxHighlightcolorChooser.setFont(this.dialogFont);
        this.syntaxHighlightcolorChooser.addDisposeListener(DisposeListenerImpl.getInstance());
        this.syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getSyntaxHighlightColor(), 30, 15));
        this.syntaxHighlightcolorChooser.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ColorProperties.this.composite.getShell());
                colorDialog.setRGB(PropertyPage.propertyChangeManager.getSyntaxHighlightColor());
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    PropertyPage.propertyChangeManager.setSyntaxHighlightColor(rGB);
                    ColorProperties.this.syntaxHighlightcolorChooser.getImage().dispose();
                    ColorProperties.this.syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, rGB, 30, 15));
                }
            }
        });
        WidgetShop.initMnemonics(new Button[]{this.linkColorChooser, this.syntaxHighlightcolorChooser});
        LayoutShop.setDialogSpacer(this.composite, 2, 6);
    }

    @Override
    protected void restoreButtonPressed() {
        propertyChangeManager.setLinkColor(new RGB(0, 0, 255));
        propertyChangeManager.setSyntaxHighlightColor(new RGB(255, 255, 0));
        this.linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getLinkColor(), 30, 15));
        this.syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getSyntaxHighlightColor(), 30, 15));
    }
}

