/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ConnectionProperties
extends PropertyPage {
    private static final int MAX_CONNECTION_COUNT = 999;
    private static final int MAX_CONNECTION_TIMEOUT = 999;
    private static final int MIN_CONNECTION_COUNT = 1;
    private static final int MIN_CONNECTION_TIMEOUT = 1;
    private Spinner conCountSpinner;
    private Spinner conTimeoutSpinner;
    private Text textHost;
    private Text textPort;
    Button checkUpdateAll;
    Button checkUseAuthentification;
    Button checkUseProxy;
    Text textDomain;
    Text textPassword;
    Text textUsername;

    public ConnectionProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.maxConnectionCount = this.conCountSpinner.getSelection();
        GlobalSettings.connectionTimeout = this.conTimeoutSpinner.getSelection();
        this.updateProxySettings();
        if (this.checkUpdateAll.getSelection()) {
            Category.getRootCategory().setUseProxy(ProxyShop.isUseProxy());
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.getProxySettingsSave().put("proxySet", String.valueOf(this.checkUseProxy.getSelection()));
        propertyChangeManager.getProxySettingsSave().put("proxyHost", this.textHost.getText());
        propertyChangeManager.getProxySettingsSave().put("proxyPort", this.textPort.getText());
        propertyChangeManager.getProxySettingsSave().put("username", this.textUsername.getText());
        propertyChangeManager.getProxySettingsSave().put("password", this.textPassword.getText());
        propertyChangeManager.getProxySettingsSave().put("domain", this.textDomain.getText());
        propertyChangeManager.setUpdateProxyForAllFavorites(this.checkUpdateAll.getSelection());
        propertyChangeManager.setUseAuthentification(this.checkUseAuthentification.getSelection());
        propertyChangeManager.setMaxConnectionCount(this.conCountSpinner.getSelection());
        propertyChangeManager.setConnectionTimeout(this.conTimeoutSpinner.getSelection());
    }

    private void disableAuthentification() {
        this.textUsername.setEnabled(false);
        this.textPassword.setEnabled(false);
        this.textDomain.setEnabled(false);
        this.checkUseAuthentification.setSelection(false);
    }

    private void updateProxySettings() {
        ProxyShop.setUseProxy(String.valueOf(this.checkUseProxy.getSelection()));
        ProxyShop.setHost(this.textHost.getText());
        ProxyShop.setPort(this.textPort.getText());
        if (this.checkUseAuthentification.getSelection()) {
            ProxyShop.setUsername(this.textUsername.getText());
            ProxyShop.setPassword(this.textPassword.getText());
            ProxyShop.setDomain(this.textDomain.getText());
        } else {
            ProxyShop.setUsername("");
            ProxyShop.setPassword("");
            ProxyShop.setDomain("");
        }
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("MENU_PROXY"));
        group.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
        group.setFont(FontShop.dialogFont);
        Composite composite = new Composite(group, 0);
        composite.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite.setLayout(new GridLayout(2, false));
        this.checkUseProxy = new Button(composite, 32);
        this.checkUseProxy.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.checkUseProxy.setText(GUI.i18n.getTranslation("LABEL_USE_PROXY"));
        this.checkUseProxy.setFont(this.dialogFont);
        Label label = new Label(group, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_PROXY_HOST") + ": ");
        label.setFont(this.dialogFont);
        label.setLayoutData(new GridData(36));
        this.textHost = new Text(group, 2048);
        this.textHost.setFont(this.dialogFont);
        this.textHost.setText((String)propertyChangeManager.getProxySettingsSave().get("proxyHost"));
        this.textHost.setLayoutData(new GridData(770));
        WidgetShop.tweakTextWidget(this.textHost);
        Label label2 = new Label(group, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_PROXY_PORT") + ": ");
        label2.setFont(this.dialogFont);
        label2.setLayoutData(new GridData(36));
        this.textPort = new Text(group, 2048);
        this.textPort.setFont(this.dialogFont);
        this.textPort.setText((String)propertyChangeManager.getProxySettingsSave().get("proxyPort"));
        this.textPort.setLayoutData(new GridData(770));
        WidgetShop.tweakTextWidget(this.textPort);
        Composite composite2 = new Composite(group, 0);
        composite2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite2.setLayout(new GridLayout(2, false));
        this.checkUseAuthentification = new Button(composite2, 32);
        this.checkUseAuthentification.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.checkUseAuthentification.setText(GUI.i18n.getTranslation("LABEL_PROXY_AUTHENTIFICATION"));
        this.checkUseAuthentification.setFont(this.dialogFont);
        Label label3 = new Label(group, 0);
        label3.setText(GUI.i18n.getTranslation("LABEL_USERNAME") + ": ");
        label3.setFont(this.dialogFont);
        label3.setLayoutData(new GridData(36));
        this.textUsername = new Text(group, 2048);
        this.textUsername.setFont(this.dialogFont);
        this.textUsername.setText((String)propertyChangeManager.getProxySettingsSave().get("username"));
        this.textUsername.setLayoutData(new GridData(770));
        WidgetShop.tweakTextWidget(this.textUsername);
        Label label4 = new Label(group, 0);
        label4.setText(GUI.i18n.getTranslation("LABEL_PASSWORD") + ": ");
        label4.setFont(this.dialogFont);
        label4.setLayoutData(new GridData(36));
        this.textPassword = new Text(group, 0x400800);
        this.textPassword.setFont(this.dialogFont);
        this.textPassword.setText((String)propertyChangeManager.getProxySettingsSave().get("password"));
        this.textPassword.setLayoutData(new GridData(770));
        WidgetShop.tweakTextWidget(this.textPassword);
        Label label5 = new Label(group, 0);
        label5.setText(GUI.i18n.getTranslation("LABEL_DOMAIN") + ": ");
        label5.setFont(this.dialogFont);
        label5.setLayoutData(new GridData(36));
        this.textDomain = new Text(group, 2048);
        this.textDomain.setFont(this.dialogFont);
        this.textDomain.setText((String)propertyChangeManager.getProxySettingsSave().get("domain"));
        this.textDomain.setLayoutData(new GridData(770));
        WidgetShop.tweakTextWidget(this.textDomain);
        this.checkUseAuthentification.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionProperties.this.textUsername.setEnabled(ConnectionProperties.this.checkUseAuthentification.getSelection());
                ConnectionProperties.this.textPassword.setEnabled(ConnectionProperties.this.checkUseAuthentification.getSelection());
                ConnectionProperties.this.textDomain.setEnabled(ConnectionProperties.this.checkUseAuthentification.getSelection());
            }
        });
        this.checkUseProxy.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ConnectionProperties.this.checkUseProxy.getSelection()) {
                    ConnectionProperties.this.setEnabledComponents(true);
                } else {
                    ConnectionProperties.this.setEnabledComponents(false);
                }
            }
        });
        Composite composite3 = new Composite(group, 0);
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite3.setLayout(new GridLayout(2, false));
        this.checkUpdateAll = new Button(composite3, 32);
        this.checkUpdateAll.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.checkUpdateAll.setFont(this.dialogFont);
        this.checkUpdateAll.setText(GUI.i18n.getTranslation("LABEL_USE_PROXY_FOR_ALL"));
        this.checkUpdateAll.setSelection(propertyChangeManager.isUpdateProxyForAllFavorites());
        if (propertyChangeManager.getProxySettingsSave().get("proxySet").equals("false")) {
            this.setEnabledComponents(false);
        } else {
            this.checkUseProxy.setSelection(true);
        }
        if (propertyChangeManager.getProxySettingsSave().get("username").equals("") && propertyChangeManager.getProxySettingsSave().get("password").equals("")) {
            this.disableAuthentification();
        } else {
            this.checkUseAuthentification.setSelection(true);
        }
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("MENU_MISC"));
        group2.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
        group2.setFont(FontShop.dialogFont);
        Label label6 = new Label(group2, 0);
        label6.setText(GUI.i18n.getTranslation("LABEL_MAX_CONNECTIONS") + ": ");
        label6.setFont(this.dialogFont);
        label6.setLayoutData(new GridData(36));
        this.conCountSpinner = new Spinner(group2, 2048);
        this.conCountSpinner.setMinimum(1);
        this.conCountSpinner.setMaximum(999);
        this.conCountSpinner.setSelection(propertyChangeManager.getMaxConnectionCount());
        this.conCountSpinner.setFont(FontShop.dialogFont);
        this.conCountSpinner.setLayoutData(LayoutDataShop.createGridData(32, 1));
        Label label7 = new Label(group2, 0);
        label7.setText(GUI.i18n.getTranslation("LABEL_CON_TIMEOUT") + ": ");
        label7.setFont(this.dialogFont);
        label7.setLayoutData(new GridData(36));
        this.conTimeoutSpinner = new Spinner(group2, 2048);
        this.conTimeoutSpinner.setMinimum(1);
        this.conTimeoutSpinner.setMaximum(999);
        this.conTimeoutSpinner.setSelection(propertyChangeManager.getConnectionTimeout());
        this.conTimeoutSpinner.setFont(FontShop.dialogFont);
        this.conTimeoutSpinner.setLayoutData(LayoutDataShop.createGridData(32, 1));
        WidgetShop.initMnemonics(new Button[]{this.checkUseProxy, this.checkUseAuthentification, this.checkUpdateAll});
    }

    @Override
    protected void restoreButtonPressed() {
        this.checkUseProxy.setSelection(false);
        this.setEnabledComponents(false);
        this.checkUpdateAll.setSelection(true);
        this.conCountSpinner.setSelection(32);
        this.conTimeoutSpinner.setSelection(30);
        this.updatePropertiesChangeManager();
    }

    void setEnabledComponents(boolean bl) {
        this.textHost.setEnabled(bl);
        this.textPort.setEnabled(bl);
        this.checkUseProxy.setSelection(bl);
        this.checkUseAuthentification.setEnabled(bl);
        this.checkUpdateAll.setEnabled(bl);
        if (!bl) {
            this.textUsername.setEnabled(bl);
            this.textPassword.setEnabled(bl);
            this.textDomain.setEnabled(bl);
        } else if (this.checkUseAuthentification.getSelection()) {
            this.textUsername.setEnabled(true);
            this.textPassword.setEnabled(true);
            this.textDomain.setEnabled(true);
        }
    }
}

