/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class FavoritesProperties
extends PropertyPage {
    private Combo autoReloadCombo;
    private Button openOnStartupCheck;
    private Button reloadOnStartupCheck;

    public FavoritesProperties(Composite composite) {
        super(composite);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.favDefaultOpenOnStartup = this.openOnStartupCheck.getSelection();
        GlobalSettings.favDefaultReloadOnStartup = this.reloadOnStartupCheck.getSelection();
        GlobalSettings.favDefaultAutoReloadInterval = FeedAutoUpdater.updateInterval[this.autoReloadCombo.getSelectionIndex()];
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setFavDefaultOpenOnStartup(this.openOnStartupCheck.getSelection());
        propertyChangeManager.setFavDefaultReloadOnStartup(this.reloadOnStartupCheck.getSelection());
        propertyChangeManager.setFavDefaultAutoReloadInterval(FeedAutoUpdater.updateInterval[this.autoReloadCombo.getSelectionIndex()]);
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION"));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setLayout(new GridLayout(1, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 64);
        label.setText(GUI.i18n.getTranslation("LABEL_TEMPLATE_EXPLANATION"));
        label.setFont(this.dialogFont);
        label.setLayoutData(new GridData(768));
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("POP_AUTO_UPDATE"));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        this.autoReloadCombo = new Combo(group2, 8);
        this.autoReloadCombo.setVisibleItemCount(FeedAutoUpdater.updateInterval.length);
        this.autoReloadCombo.setFont(FontShop.dialogFont);
        int n = 0;
        for (int i = 0; i < FeedAutoUpdater.updateInterval.length; ++i) {
            this.autoReloadCombo.add(GUI.i18n.getTranslation(FeedAutoUpdater.updateIntervalNames[i]));
            if (FeedAutoUpdater.updateInterval[i] != propertyChangeManager.getFavDefaultAutoReloadInterval()) continue;
            n = i;
        }
        this.autoReloadCombo.select(n);
        this.reloadOnStartupCheck = new Button(group2, 32);
        this.reloadOnStartupCheck.setText(GUI.i18n.getTranslation("POP_UPDATE_ONSTARTUP"));
        this.reloadOnStartupCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.reloadOnStartupCheck.setFont(this.dialogFont);
        this.reloadOnStartupCheck.setSelection(propertyChangeManager.isFavDefaultReloadOnStartup());
        Group group3 = new Group(this.composite, 0);
        group3.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group3.setText(GUI.i18n.getTranslation("MENU_MISC"));
        group3.setLayout(new GridLayout(2, false));
        group3.setFont(FontShop.dialogFont);
        this.openOnStartupCheck = new Button(group3, 32);
        this.openOnStartupCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.openOnStartupCheck.setSelection(propertyChangeManager.isFavDefaultOpenOnStartup());
        this.openOnStartupCheck.setText(GUI.i18n.getTranslation("POP_OPEN_STARTUP"));
        this.openOnStartupCheck.setFont(this.dialogFont);
        LayoutShop.setDialogSpacer(this.composite, 2, 3);
        WidgetShop.initMnemonics(new Button[]{this.reloadOnStartupCheck, this.openOnStartupCheck});
    }

    @Override
    protected void restoreButtonPressed() {
        this.openOnStartupCheck.setSelection(false);
        this.reloadOnStartupCheck.setSelection(false);
        this.autoReloadCombo.select(5);
    }
}

