/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.nio.charset.Charset;
import java.util.SortedMap;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class FontProperties
extends PropertyPage {
    private static final int DIALOG_FONT = 1;
    private static final int HEADER_FONT = 4;
    private static final int TABLE_FONT = 3;
    private static final int TEXT_FONT = 0;
    private static final int TREE_FONT = 2;
    static boolean possibleFontChange = false;
    private Label catDescription;
    private Combo encodingsCombo;
    private Label fontHeightLabel;
    private Label fontNameLabel;
    private Label fontStyleLabel;
    private Group selectedFont;
    private FontData[] selectedFontData;
    List selectCatList;

    public FontProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    public static void setPossibleFontChange(boolean bl) {
        possibleFontChange = bl;
    }

    @Override
    public void applyButtonPressed() {
        if (possibleFontChange) {
            FontShop.textFont = propertyChangeManager.getTextFont();
            FontShop.dialogFont = propertyChangeManager.getDialogFont();
            FontShop.treeFont = propertyChangeManager.getTreeFont();
            FontShop.tableFont = propertyChangeManager.getTableFont();
            FontShop.headerFont = propertyChangeManager.getHeaderFont();
            FontShop.updateFonts();
            FontShop.setFontForAll(this.rssOwlGui);
            possibleFontChange = false;
        }
        GlobalSettings.charEncoding = propertyChangeManager.getSelectedEncoding();
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        this.saveFontData();
        propertyChangeManager.setSelectedEncoding(this.encodingsCombo.getText());
    }

    private void creteSelectedFontGroup(Font font) {
        if (font == null) {
            this.creteSelectedFontGroup(FontShop.getFontData()[0]);
            this.selectedFontData = FontShop.getFontData();
        } else {
            this.creteSelectedFontGroup(font.getFontData()[0]);
            this.selectedFontData = font.getFontData();
        }
    }

    private void creteSelectedFontGroup(FontData fontData) {
        String string = fontData.getName();
        String string2 = String.valueOf(fontData.getHeight());
        String string3 = "-";
        int n = fontData.getStyle();
        if (n == 1) {
            string3 = GUI.i18n.getTranslation("FONT_STYLE_BOLD");
        } else if (n == 2) {
            string3 = GUI.i18n.getTranslation("FONT_STYLE_ITALIC");
        } else if (n == 0) {
            string3 = GUI.i18n.getTranslation("FONT_STYLE_NORMAL");
        }
        this.fontNameLabel.setText(string);
        this.fontHeightLabel.setText(string2);
        this.fontStyleLabel.setText(string3);
        this.selectedFont.layout();
    }

    private void saveFontData() {
        Font font = this.selectedFontData != null ? new Font((Device)GUI.display, this.selectedFontData) : FontShop.createFont();
        switch (this.selectCatList.getSelectionIndex()) {
            case 0: {
                propertyChangeManager.setTextFont(font);
                break;
            }
            case 1: {
                propertyChangeManager.setDialogFont(font);
                break;
            }
            case 2: {
                propertyChangeManager.setTreeFont(font);
                break;
            }
            case 3: {
                propertyChangeManager.setTableFont(font);
                break;
            }
            case 4: {
                propertyChangeManager.setHeaderFont(font);
            }
        }
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("GROUP_FONT_AREA"));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setLayout(new GridLayout(2, true));
        group.setFont(FontShop.dialogFont);
        this.selectCatList = new List(group, 2052);
        this.selectCatList.setLayoutData(new GridData(768));
        this.selectCatList.setFont(this.dialogFont);
        this.selectCatList.add(GUI.i18n.getTranslation("FONT_AREA_TEXT"));
        this.selectCatList.add(GUI.i18n.getTranslation("FONT_AREA_DIALOG"));
        this.selectCatList.add(GUI.i18n.getTranslation("FONT_AREA_TREE"));
        this.selectCatList.add(GUI.i18n.getTranslation("FONT_AREA_TABLE"));
        this.selectCatList.add(GUI.i18n.getTranslation("FONT_AREA_HEADER"));
        this.selectCatList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FontProperties.this.handleListSelect();
            }
        });
        this.selectCatList.setSelection(0);
        this.selectCatList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (FontProperties.this.selectCatList.getSelectionCount() > 0) {
                    FontProperties.this.selectFont();
                }
            }
        });
        this.catDescription = new Label(group, 64);
        this.catDescription.setFont(this.dialogFont);
        this.catDescription.setLayoutData(new GridData(1808));
        this.selectedFont = new Group(this.composite, 0);
        this.selectedFont.setText(GUI.i18n.getTranslation("GROUP_SELECTED_FONT"));
        this.selectedFont.setFont(this.dialogFont);
        this.selectedFont.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.selectedFont.setLayout(new GridLayout(2, false));
        this.selectedFont.setFont(FontShop.dialogFont);
        Label label = new Label(this.selectedFont, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_NAME") + ": ");
        label.setFont(this.dialogFont);
        this.fontNameLabel = new Label(this.selectedFont, 0);
        this.fontNameLabel.setFont(this.dialogFont);
        Label label2 = new Label(this.selectedFont, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_SIZE") + ": ");
        label2.setFont(this.dialogFont);
        this.fontHeightLabel = new Label(this.selectedFont, 0);
        this.fontHeightLabel.setFont(this.dialogFont);
        Label label3 = new Label(this.selectedFont, 0);
        label3.setText(GUI.i18n.getTranslation("LABEL_STYLE") + ": ");
        label3.setFont(this.dialogFont);
        this.fontStyleLabel = new Label(this.selectedFont, 0);
        this.fontStyleLabel.setFont(this.dialogFont);
        GridData gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        Composite composite = new Composite(this.selectedFont, 0);
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, false));
        Button button = new Button(composite, 0);
        button.setText(GUI.i18n.getTranslation("LABEL_USE_SYSTEM_FONT"));
        button.setFont(this.dialogFont);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FontProperties.this.selectDefaultFont();
                possibleFontChange = true;
            }
        });
        Button button2 = new Button(composite, 0);
        button2.setText(GUI.i18n.getTranslation("BUTTON_CHANGE_FONT") + "...");
        button2.setFont(this.dialogFont);
        button2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                FontProperties.this.selectFont();
            }
        });
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group2.setText(GUI.i18n.getTranslation("MENU_ENCODING"));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        Label label4 = new Label(group2, 0);
        label4.setText(GUI.i18n.getTranslation("LABEL_SELECT_ENCODING") + ": ");
        label4.setFont(this.dialogFont);
        this.encodingsCombo = new Combo(group2, 8);
        this.encodingsCombo.setFont(this.dialogFont);
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        for (String string : sortedMap.keySet()) {
            this.encodingsCombo.add(string);
            if (!string.equals(propertyChangeManager.getSelectedEncoding())) continue;
            this.encodingsCombo.select(this.encodingsCombo.getItemCount() - 1);
        }
        this.handleListSelect();
        WidgetShop.initMnemonics(new Button[]{button, button2});
    }

    @Override
    protected void restoreButtonPressed() {
        propertyChangeManager.setTextFont(FontShop.createFont(GUI.display.getSystemFont().getFontData()[0].getHeight() + 1));
        propertyChangeManager.setDialogFont(FontShop.createFont());
        propertyChangeManager.setTreeFont(FontShop.createFont());
        propertyChangeManager.setTableFont(FontShop.createFont());
        propertyChangeManager.setHeaderFont(FontShop.createFont(GUI.display.getSystemFont().getFontData()[0].getHeight() + 1));
        switch (this.selectCatList.getSelectionIndex()) {
            case 0: {
                this.selectedFontData = FontShop.getFontData(GUI.display.getSystemFont().getFontData()[0].getHeight() + 1);
                this.saveFontData();
                this.creteSelectedFontGroup(this.selectedFontData[0]);
                break;
            }
            case 1: {
                this.selectedFontData = FontShop.getFontData();
                this.saveFontData();
                this.creteSelectedFontGroup(GUI.display.getSystemFont().getFontData()[0]);
                break;
            }
            case 2: {
                this.selectedFontData = FontShop.getFontData();
                this.saveFontData();
                this.creteSelectedFontGroup(GUI.display.getSystemFont().getFontData()[0]);
                break;
            }
            case 3: {
                this.selectedFontData = FontShop.getFontData();
                this.saveFontData();
                this.creteSelectedFontGroup(GUI.display.getSystemFont().getFontData()[0]);
                break;
            }
            case 4: {
                this.selectedFontData = FontShop.getFontData(GUI.display.getSystemFont().getFontData()[0].getHeight() + 1);
                this.saveFontData();
                this.creteSelectedFontGroup(this.selectedFontData[0]);
            }
        }
        int n = this.encodingsCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!this.encodingsCombo.getItem(i).equals("UTF-8")) continue;
            this.encodingsCombo.select(i);
        }
        propertyChangeManager.setSelectedEncoding(this.encodingsCombo.getText());
        this.handleListSelect();
        possibleFontChange = true;
    }

    void handleListSelect() {
        switch (this.selectCatList.getSelectionIndex()) {
            case 0: {
                this.catDescription.setText(GUI.i18n.getTranslation("FONT_AREA_TEXT_DESCRIPTION"));
                this.creteSelectedFontGroup(propertyChangeManager.getTextFont());
                break;
            }
            case 1: {
                this.catDescription.setText(GUI.i18n.getTranslation("FONT_AREA_DIALOG_DESCRIPTION"));
                this.creteSelectedFontGroup(propertyChangeManager.getDialogFont());
                break;
            }
            case 2: {
                this.catDescription.setText(GUI.i18n.getTranslation("FONT_AREA_TREE_DESCRIPTION"));
                this.creteSelectedFontGroup(propertyChangeManager.getTreeFont());
                break;
            }
            case 3: {
                this.catDescription.setText(GUI.i18n.getTranslation("FONT_AREA_TABLE_DESCRIPTION"));
                this.creteSelectedFontGroup(propertyChangeManager.getTableFont());
                break;
            }
            case 4: {
                this.catDescription.setText(GUI.i18n.getTranslation("FONT_AREA_HEADER_DESCRIPTION"));
                this.creteSelectedFontGroup(propertyChangeManager.getHeaderFont());
            }
        }
    }

    void selectDefaultFont() {
        this.selectedFontData = FontShop.getFontData();
        this.saveFontData();
        this.creteSelectedFontGroup(FontShop.getFontData()[0]);
    }

    void selectFont() {
        FontData fontData;
        FontDialog fontDialog = new FontDialog(this.composite.getShell());
        if (this.selectedFontData != null) {
            fontDialog.setFontList(this.selectedFontData);
        }
        if ((fontData = fontDialog.open()) != null) {
            this.selectedFontData[0] = fontData;
            this.saveFontData();
            this.creteSelectedFontGroup(this.selectedFontData[0]);
            possibleFontChange = true;
        }
    }
}

