/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.RSSOwlMenu;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.i18n.KeyCodeParser;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class HotkeysProperties
extends PropertyPage {
    Button assignKeyButton;
    Text charSequence;
    int countFullKey = 0;
    boolean firstKeyPress = false;
    boolean fullKeyWasPressed = false;
    Vector keys = new Vector();
    int keyValue = 0;
    Combo selectCategoryCombo;
    Combo selectCommandCombo;

    public HotkeysProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    @Override
    public void applyButtonPressed() {
        HotkeyShop.hotKeys = propertyChangeManager.getHotkeys();
        this.rssOwlGui.getRSSOwlMenu().updateAccelerators();
        this.rssOwlGui.getRSSOwlMenu().initMnemonics();
        this.rssOwlGui.getRSSOwlQuickview().updateI18N();
        this.rssOwlGui.getRSSOwlNewsText().updateI18N();
    }

    @Override
    public void updatePropertiesChangeManager() {
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("GROUP_COMMAND"));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setLayout(new GridLayout(2, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + ": ");
        label.setLayoutData(new GridData(32));
        label.setFont(this.dialogFont);
        this.selectCategoryCombo = new Combo(group, 8);
        this.selectCategoryCombo.setVisibleItemCount(RSSOwlMenu.menuStructure.length);
        this.selectCategoryCombo.setLayoutData(new GridData(768));
        this.selectCategoryCombo.setFont(this.dialogFont);
        this.selectCategoryCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                HotkeysProperties.this.selectCommandCombo.removeAll();
                HotkeysProperties.this.selectCommandCombo.setVisibleItemCount(RSSOwlMenu.subMenuStructure[HotkeysProperties.this.selectCategoryCombo.getSelectionIndex()].length);
                int n = HotkeysProperties.this.selectCategoryCombo.getSelectionIndex();
                for (int i = 0; i < RSSOwlMenu.subMenuStructure[n].length; ++i) {
                    HotkeysProperties.this.selectCommandCombo.add(GUI.i18n.getTranslation(RSSOwlMenu.subMenuStructure[HotkeysProperties.this.selectCategoryCombo.getSelectionIndex()][i]));
                }
                HotkeysProperties.this.selectCommandCombo.select(0);
                String string = RSSOwlMenu.subMenuStructure[HotkeysProperties.this.selectCategoryCombo.getSelectionIndex()][HotkeysProperties.this.selectCommandCombo.getSelectionIndex()];
                HotkeysProperties.this.charSequence.setText(((String[])PropertyPage.propertyChangeManager.getHotkeys().get(string))[0]);
                HotkeysProperties.this.setWarningMessage(null);
            }
        });
        for (int i = 0; i < RSSOwlMenu.menuStructure.length; ++i) {
            this.selectCategoryCombo.add(GUI.i18n.getTranslation(RSSOwlMenu.menuStructure[i]));
        }
        this.selectCategoryCombo.select(0);
        Label label2 = new Label(group, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_NAME") + ": ");
        label2.setLayoutData(new GridData(32));
        label2.setFont(this.dialogFont);
        this.selectCommandCombo = new Combo(group, 8);
        this.selectCommandCombo.setVisibleItemCount(RSSOwlMenu.subMenuStructure[this.selectCategoryCombo.getSelectionIndex()].length);
        this.selectCommandCombo.setLayoutData(new GridData(768));
        this.selectCommandCombo.setFont(this.dialogFont);
        this.selectCommandCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = RSSOwlMenu.subMenuStructure[HotkeysProperties.this.selectCategoryCombo.getSelectionIndex()][HotkeysProperties.this.selectCommandCombo.getSelectionIndex()];
                HotkeysProperties.this.charSequence.setText(((String[])PropertyPage.propertyChangeManager.getHotkeys().get(string))[0]);
                HotkeysProperties.this.setWarningMessage(null);
            }
        });
        int n = this.selectCategoryCombo.getSelectionIndex();
        for (int i = 0; i < RSSOwlMenu.subMenuStructure[n].length; ++i) {
            this.selectCommandCombo.add(GUI.i18n.getTranslation(RSSOwlMenu.subMenuStructure[this.selectCategoryCombo.getSelectionIndex()][i]));
        }
        this.selectCommandCombo.select(0);
        Group group2 = new Group(this.composite, 0);
        group2.setText(GUI.i18n.getTranslation("LABEL_KEY_SEQUENCE"));
        group2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        Label label3 = new Label(group2, 64);
        label3.setText(GUI.i18n.getTranslation("DIALOG_MESSAGE_KEYSEQUENCE") + ": ");
        label3.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label3.setFont(this.dialogFont);
        Composite composite = new Composite(group2, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.charSequence = new Text(composite, 2052);
        this.charSequence.setLayoutData(new GridData(800));
        this.charSequence.setFont(this.dialogFont);
        this.charSequence.addTraverseListener(new TraverseListener(){

            @Override
            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 16: {
                        traverseEvent.doit = traverseEvent.stateMask == 0;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        traverseEvent.doit = false;
                    }
                }
            }
        });
        this.charSequence.setMenu(new Menu(composite));
        this.charSequence.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HotkeysProperties.this.onKeyPressed(keyEvent);
                keyEvent.doit = false;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                HotkeysProperties.this.onKeyReleased();
            }
        });
        String string = RSSOwlMenu.subMenuStructure[0][0];
        this.charSequence.setText(((String[])propertyChangeManager.getHotkeys().get(string))[0]);
        this.assignKeyButton = new Button(composite, 8);
        this.assignKeyButton.setText(GUI.i18n.getTranslation("BUTTON_ASSIGN"));
        this.assignKeyButton.setLayoutData(new GridData(128));
        this.assignKeyButton.setFont(this.dialogFont);
        this.assignKeyButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = RSSOwlMenu.subMenuStructure[HotkeysProperties.this.selectCategoryCombo.getSelectionIndex()][HotkeysProperties.this.selectCommandCombo.getSelectionIndex()];
                PropertyPage.propertyChangeManager.getHotkeys().put(string, new String[]{HotkeysProperties.this.charSequence.getText(), String.valueOf(HotkeysProperties.this.keyValue)});
                String string2 = HotkeysProperties.this.isKeyOccupied(HotkeysProperties.this.keyValue, false);
                if (string2 != null) {
                    PropertyPage.propertyChangeManager.getHotkeys().put(string2, new String[]{"", String.valueOf(0)});
                }
                HotkeysProperties.this.keyValue = 0;
                HotkeysProperties.this.countFullKey = 0;
                HotkeysProperties.this.setWarningMessage(null);
                HotkeysProperties.this.assignKeyButton.setEnabled(false);
            }
        });
        this.assignKeyButton.setEnabled(false);
        this.errorMessageLabel = new CLabel(group2, 0);
        this.errorMessageLabel.setFont(this.dialogFont);
        LayoutShop.setDialogSpacer(this.composite, 2, 3);
    }

    @Override
    protected void restoreButtonPressed() {
        HotkeyShop.initDefaultAccelerators();
        propertyChangeManager.setHotkeys(HotkeyShop.hotKeys);
        String string = RSSOwlMenu.subMenuStructure[this.selectCategoryCombo.getSelectionIndex()][this.selectCommandCombo.getSelectionIndex()];
        this.charSequence.setText(((String[])propertyChangeManager.getHotkeys().get(string))[0]);
        this.setWarningMessage(null);
    }

    boolean isFullKey(int n) {
        switch (n) {
            case 262144: {
                return false;
            }
            case 131072: {
                return false;
            }
            case 65536: {
                return false;
            }
            case 0x400000: {
                return false;
            }
        }
        return true;
    }

    String isKeyOccupied(int n, boolean bl) {
        Enumeration enumeration = propertyChangeManager.getHotkeys().keys();
        if (n < 1) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = Integer.parseInt(((String[])propertyChangeManager.getHotkeys().get(string))[1]);
            if (n2 == n && !string.equals(RSSOwlMenu.subMenuStructure[this.selectCategoryCombo.getSelectionIndex()][this.selectCommandCombo.getSelectionIndex()])) {
                return string;
            }
            if (n2 != n || !bl) continue;
            return "_SELF";
        }
        return null;
    }

    void onKeyPressed(KeyEvent keyEvent) {
        String string;
        if (!this.firstKeyPress) {
            this.keyValue = 0;
            this.countFullKey = 0;
            this.firstKeyPress = true;
        }
        if ((string = KeyCodeParser.format(keyEvent.keyCode)).equals("")) {
            this.charSequence.setSelection(this.charSequence.getText().length(), this.charSequence.getText().length());
        } else if (string.equals("DEL") && this.charSequence.getText().length() > 0) {
            this.charSequence.setText("");
        } else if (!string.equals("DEL")) {
            this.keys.add(KeyCodeParser.format(keyEvent.keyCode));
            if (this.isFullKey(keyEvent.keyCode)) {
                this.fullKeyWasPressed = true;
                ++this.countFullKey;
            } else {
                this.fullKeyWasPressed = false;
            }
            this.keyValue = this.keyValue == 0 ? keyEvent.keyCode : (this.keyValue |= keyEvent.keyCode);
            this.setKeySequenceText();
        }
        String string2 = this.isKeyOccupied(this.keyValue, true);
        if (string2 != null && string2.equals("_SELF")) {
            this.assignKeyButton.setEnabled(false);
        } else {
            this.assignKeyButton.setEnabled(true);
        }
    }

    void onKeyReleased() {
        this.keys.clear();
        this.firstKeyPress = false;
        if (!this.fullKeyWasPressed) {
            this.charSequence.setText("");
            this.keyValue = 0;
            this.countFullKey = 0;
            this.setWarningMessage(null);
        } else {
            String string = this.isKeyOccupied(this.keyValue, false);
            if (this.countFullKey > 1) {
                this.setWarningMessage(GUI.i18n.getTranslation("LABEL_INVALID_KEYSEQUENCE"));
            } else if (string != null) {
                this.setWarningMessage(GUI.i18n.getTranslation("LABEL_USED_BY") + ": " + GUI.i18n.getTranslation(string));
            } else {
                this.setWarningMessage(null);
            }
        }
    }

    void setKeySequenceText() {
        int n;
        String string = "";
        for (n = 0; n < this.keys.size() - 1; ++n) {
            string = string + this.keys.get(n) + "+";
        }
        string = string + this.keys.get(n);
        if (!this.fullKeyWasPressed) {
            string = string + "+";
        }
        this.charSequence.setText(string);
        this.charSequence.setSelection(this.charSequence.getText().length(), this.charSequence.getText().length());
    }
}

