/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.PreferencesDialog;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.i18n.LanguageDetector;
import net.sourceforge.rssowl.util.i18n.RSSOwlI18n;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LanguageProperties
extends PropertyPage {
    private Hashtable languages;
    private PreferencesDialog rssOwlPropertiesDialog;
    String selectedLanguage;

    public LanguageProperties(Composite composite, GUI gUI, PreferencesDialog preferencesDialog) {
        super(composite, gUI);
        this.rssOwlPropertiesDialog = preferencesDialog;
    }

    @Override
    public void applyButtonPressed() {
        if (this.selectedLanguage != null && !this.selectedLanguage.equals(Dictionary.selectedLanguage)) {
            GUI.i18n = new RSSOwlI18n(new Locale(this.selectedLanguage));
            this.rssOwlGui.updateI18N();
            this.rssOwlPropertiesDialog.updateI18N();
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setSelectedLanguage(this.selectedLanguage);
    }

    private void setButtonState(String string) {
        Enumeration enumeration = this.languages.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(string)) {
                ((Button)this.languages.get(string2)).setSelection(true);
                continue;
            }
            ((Button)this.languages.get(string2)).setSelection(false);
        }
    }

    @Override
    protected void initComponents() {
        this.languages = new Hashtable();
        this.selectedLanguage = propertyChangeManager.getSelectedLanguage();
        Composite composite = new Composite(this.composite, 0);
        composite.setLayout(LayoutShop.createGridLayout(4, 10, 0, 15, 5, false));
        composite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        for (int i = 0; i < Dictionary.languages.size(); ++i) {
            final Locale locale = (Locale)Dictionary.locales.get(Dictionary.languages.get(i));
            final Button button = new Button(composite, 16);
            button.setFont(this.dialogFont);
            button.addDisposeListener(DisposeListenerImpl.getInstance());
            button.setImage(PaintShop.getLanguageFlag(locale.getCountry().toLowerCase(), this.getClass()));
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        LanguageProperties.this.selectedLanguage = locale.getLanguage();
                    }
                }
            });
            Label label = new Label(composite, 0);
            label.setText(GUI.i18n.getTranslation(locale.getLanguage()));
            label.setFont(this.dialogFont);
            this.languages.put(locale.getLanguage(), button);
        }
        this.setButtonState(this.selectedLanguage);
    }

    @Override
    protected void restoreButtonPressed() {
        this.setButtonState(LanguageDetector.parseLanguage(Locale.getDefault()));
        this.selectedLanguage = LanguageDetector.parseLanguage(Locale.getDefault());
        this.updatePropertiesChangeManager();
    }
}

