/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyChangeManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class PropertyPage {
    protected static PropertyChangeManager propertyChangeManager;
    protected Button apply;
    protected Composite composite;
    protected Font dialogFont = FontShop.dialogFont;
    protected CLabel errorMessageLabel;
    protected Composite parent;
    protected Button restore;
    protected GUI rssOwlGui;

    protected PropertyPage(Composite composite) {
        this(composite, null);
    }

    protected PropertyPage(Composite composite, GUI gUI) {
        this.parent = composite;
        this.rssOwlGui = gUI;
        this.createComposite();
        this.initComponents();
        this.createButtons();
    }

    public static PropertyChangeManager getPropertyChangeManager() {
        return propertyChangeManager;
    }

    public static void initPropertyChangeManager(GUI gUI) {
        propertyChangeManager = new PropertyChangeManager(gUI);
        propertyChangeManager.setAutoOpenEmptyNews(GlobalSettings.directOpenNews);
        propertyChangeManager.setAutoOpenEachNews(GlobalSettings.directOpenEachNews);
        propertyChangeManager.setCheckForUpdate(GlobalSettings.checkUpdate);
        propertyChangeManager.setCustomBrowserPath(GlobalSettings.customBrowser);
        propertyChangeManager.setCustomBrowserArguments(GlobalSettings.customBrowserArguments);
        propertyChangeManager.setDoubleClickOpen(GlobalSettings.isDoubleClickOpen);
        propertyChangeManager.setReopenFeeds(GlobalSettings.reopenFeeds);
        propertyChangeManager.setFocusNewTabs(GlobalSettings.focusNewTabs);
        if (GlobalSettings.useInternalBrowser()) {
            propertyChangeManager.setOpenBrowserExtern(GlobalSettings.openBrowserExtern);
            propertyChangeManager.setOpenBrowserInNewTab(GlobalSettings.openNewBrowserWindow);
            propertyChangeManager.setUseBrowserForNewsText(GlobalSettings.useBrowserForNewsText);
            propertyChangeManager.setBlockPopups(GlobalSettings.blockPopups);
        }
        propertyChangeManager.setThreeColumnGUI(GlobalSettings.isThreeColumnGUI);
        propertyChangeManager.setShowChannelInfo(GlobalSettings.showChannelInfo);
        if (GlobalSettings.useSystemTray()) {
            propertyChangeManager.setShowSystrayIcon(GlobalSettings.showSystrayIcon);
        }
        propertyChangeManager.setProxySettings(ProxyShop.proxySettings);
        if (ProxyShop.isProxyProtected()) {
            propertyChangeManager.setUseAuthentification(true);
        }
        propertyChangeManager.setSelectedEncoding(GlobalSettings.charEncoding);
        propertyChangeManager.setSortOrder(GlobalSettings.sortOrder);
        propertyChangeManager.setAutoSortNews(GlobalSettings.autoSortNews);
        propertyChangeManager.setSelectedLanguage(Dictionary.selectedLanguage);
        propertyChangeManager.setMailBody(GlobalSettings.mailBody);
        propertyChangeManager.setMailSubject(GlobalSettings.mailSubject);
        propertyChangeManager.setDialogFont(FontShop.dialogFont);
        propertyChangeManager.setTreeFont(FontShop.treeFont);
        propertyChangeManager.setTableFont(FontShop.tableFont);
        propertyChangeManager.setTextFont(FontShop.textFont);
        propertyChangeManager.setHeaderFont(FontShop.headerFont);
        propertyChangeManager.setMaxConnectionCount(GlobalSettings.maxConnectionCount);
        propertyChangeManager.setConnectionTimeout(GlobalSettings.connectionTimeout);
        propertyChangeManager.setHtmlFormatMail(GlobalSettings.htmlFormatMail);
        propertyChangeManager.setHotkeys(HotkeyShop.hotKeys);
        propertyChangeManager.setLocalCacheFeeds(GlobalSettings.localCacheFeeds);
        propertyChangeManager.setLinkColor(GlobalSettings.linkColor);
        propertyChangeManager.setSimpleTabs(GlobalSettings.simpleTabs);
        propertyChangeManager.setShowTabCloseButton(GlobalSettings.showTabCloseButton);
        propertyChangeManager.setDisplaySingleTab(GlobalSettings.displaySingleTab);
        propertyChangeManager.setSyntaxHighlightColor(GlobalSettings.syntaxHighlightColor);
        propertyChangeManager.setBloggerArguments(GlobalSettings.bloggerArguments);
        propertyChangeManager.setBloggerPath(GlobalSettings.bloggerPath);
        propertyChangeManager.setTrayOnStartup(GlobalSettings.trayOnStartup);
        propertyChangeManager.setTrayOnExit(GlobalSettings.trayOnExit);
        propertyChangeManager.setConfirmFavoriteDeletion(GlobalSettings.confirmFavoriteDeletion);
        propertyChangeManager.setConfirmCategoryDeletion(GlobalSettings.confirmCategoryDeletion);
        propertyChangeManager.setConfirmBlogrollDeletion(GlobalSettings.confirmBlogrollDeletion);
        propertyChangeManager.setShowErrors(GlobalSettings.showErrors);
        propertyChangeManager.setMarkAllReadOnMinimize(GlobalSettings.markAllReadOnMinimize);
        propertyChangeManager.setShowTrayPopup(GlobalSettings.showTrayPopup);
        propertyChangeManager.setUpdateProxyForAllFavorites(GlobalSettings.setProxyForAllFavorites);
        propertyChangeManager.setMarkFeedReadOnTabClose(GlobalSettings.markFeedReadOnTabClose);
        propertyChangeManager.setAutoCloseNewsPopup(GlobalSettings.autoCloseNewsPopup);
        propertyChangeManager.setAnimateNewsPopup(GlobalSettings.animateNewsPopup);
        propertyChangeManager.setFavDefaultAutoReloadInterval(GlobalSettings.favDefaultAutoReloadInterval);
        propertyChangeManager.setFavDefaultOpenOnStartup(GlobalSettings.favDefaultOpenOnStartup);
        propertyChangeManager.setFavDefaultReloadOnStartup(GlobalSettings.favDefaultReloadOnStartup);
    }

    public abstract void applyButtonPressed();

    public void dispose() {
        this.composite.dispose();
    }

    public abstract void updatePropertiesChangeManager();

    protected void createButtons() {
        GridData gridData = new GridData(136);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        Composite composite = new Composite(this.composite, 0);
        composite.setLayoutData(gridData);
        composite.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.restore = new Button(composite, 0);
        this.restore.setText(GUI.i18n.getTranslation("BUTTON_RESTORE_DEFAULTS"));
        this.restore.setFont(this.dialogFont);
        this.restore.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                PropertyPage.this.restoreButtonPressed();
            }
        });
        this.apply = new Button(composite, 0);
        this.apply.setText(GUI.i18n.getTranslation("BUTTON_APPLY"));
        this.apply.setFont(this.dialogFont);
        this.apply.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                PropertyPage.this.applyButtonPressed();
            }
        });
        this.setButtonLayoutData(this.restore);
        this.setButtonLayoutData(this.apply);
        WidgetShop.initMnemonics(new Button[]{this.restore, this.apply});
    }

    protected void createComposite() {
        this.composite = new Composite(this.parent, 0);
        this.composite.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
        this.composite.setLayoutData(new GridData(1810));
    }

    protected abstract void initComponents();

    protected abstract void restoreButtonPressed();

    protected void setApplyButtonState(boolean bl) {
        this.apply.setEnabled(bl);
    }

    protected void setButtonLayoutData(Button button) {
        this.setButtonLayoutData(button, new GridData(32));
    }

    protected void setButtonLayoutData(Button button, GridData gridData) {
        GC gC = new GC(button);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = Dialog.convertHorizontalDLUsToPixels(fontMetrics, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
        gC.dispose();
    }

    protected void setErrorMessage(String string) {
        this.errorMessageLabel.setImage(string == null ? null : PaintShop.iconError);
        this.errorMessageLabel.setText(string == null ? "" : string);
        this.errorMessageLabel.getParent().layout();
    }

    protected void setRestoreButtonState(boolean bl) {
        this.restore.setEnabled(bl);
    }

    protected void setSuccessMessage(String string) {
        this.errorMessageLabel.setImage(string == null ? null : PaintShop.iconValidate);
        this.errorMessageLabel.setText(string == null ? "" : string);
        this.errorMessageLabel.getParent().layout();
    }

    protected void setWarningMessage(String string) {
        this.errorMessageLabel.setImage(string == null ? null : PaintShop.iconWarning);
        this.errorMessageLabel.setText(string == null ? "" : string);
        this.errorMessageLabel.getParent().layout();
    }
}

