/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class SystemTrayProperties
extends PropertyPage {
    private Button trayOnExitCheck;
    private Button trayOnStartupCheck;
    Button trayOwlCheck;
    Button trayPopupAnimate;
    Button trayPopupCheck;
    Button trayPopupFade;

    public SystemTrayProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
        this.setApplyButtonState(GlobalSettings.useSystemTray());
        this.setRestoreButtonState(GlobalSettings.useSystemTray());
    }

    @Override
    public void applyButtonPressed() {
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon != this.trayOwlCheck.getSelection()) {
            GlobalSettings.showSystrayIcon = this.trayOwlCheck.getSelection();
            this.rssOwlGui.enableSystrayIcon(GlobalSettings.showSystrayIcon);
        }
        if (GlobalSettings.useSystemTray()) {
            GlobalSettings.trayOnStartup = this.trayOnStartupCheck.getSelection();
            GlobalSettings.trayOnExit = this.trayOnExitCheck.getSelection();
            GlobalSettings.showTrayPopup = this.trayPopupCheck.getSelection();
            GlobalSettings.autoCloseNewsPopup = this.trayPopupFade.getSelection();
            GlobalSettings.animateNewsPopup = this.trayPopupAnimate.getSelection();
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        if (GlobalSettings.useSystemTray()) {
            propertyChangeManager.setShowSystrayIcon(this.trayOwlCheck.getSelection());
            propertyChangeManager.setTrayOnStartup(this.trayOnStartupCheck.getSelection());
            propertyChangeManager.setTrayOnExit(this.trayOnExitCheck.getSelection());
            propertyChangeManager.setShowTrayPopup(this.trayPopupCheck.getSelection());
            propertyChangeManager.setAutoCloseNewsPopup(this.trayPopupFade.getSelection());
            propertyChangeManager.setAnimateNewsPopup(this.trayPopupAnimate.getSelection());
        }
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("GROUP_TRAY"));
        group.setLayout(new GridLayout(2, false));
        group.setFont(FontShop.dialogFont);
        this.trayOwlCheck = new Button(group, 32);
        this.trayOwlCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayOwlCheck.setSelection(propertyChangeManager.isShowSystrayIcon());
        this.trayOwlCheck.setText(GUI.i18n.getTranslation("MENU_SYSTRAY"));
        this.trayOwlCheck.setFont(this.dialogFont);
        this.trayOwlCheck.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTrayProperties.this.setTrayControlsEnabled(SystemTrayProperties.this.trayOwlCheck.getSelection());
            }
        });
        this.trayOnStartupCheck = new Button(group, 32);
        this.trayOnStartupCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayOnStartupCheck.setSelection(propertyChangeManager.isTrayOnStartup());
        this.trayOnStartupCheck.setText(GUI.i18n.getTranslation("BUTTON_TRAY_STARTUP"));
        this.trayOnStartupCheck.setFont(this.dialogFont);
        this.trayOnExitCheck = new Button(group, 32);
        this.trayOnExitCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayOnExitCheck.setSelection(propertyChangeManager.isTrayOnExit());
        this.trayOnExitCheck.setText(GUI.i18n.getTranslation("BUTTON_TRAY_EXIT"));
        this.trayOnExitCheck.setFont(this.dialogFont);
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("GROUP_NEWS_POPUP"));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        this.trayPopupCheck = new Button(group2, 32);
        this.trayPopupCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayPopupCheck.setSelection(propertyChangeManager.isShowTrayPopup());
        this.trayPopupCheck.setText(GUI.i18n.getTranslation("BUTTON_TRAY_POPUP"));
        this.trayPopupCheck.setFont(this.dialogFont);
        this.trayPopupCheck.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTrayProperties.this.trayPopupFade.setEnabled(SystemTrayProperties.this.trayPopupCheck.getSelection());
                SystemTrayProperties.this.trayPopupAnimate.setEnabled(SystemTrayProperties.this.trayPopupCheck.getSelection());
            }
        });
        this.trayPopupAnimate = new Button(group2, 32);
        this.trayPopupAnimate.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayPopupAnimate.setSelection(propertyChangeManager.isAnimateNewsPopup());
        this.trayPopupAnimate.setText(GUI.i18n.getTranslation("BUTTON_ANIMATE_POPUP"));
        this.trayPopupAnimate.setFont(this.dialogFont);
        this.trayPopupFade = new Button(group2, 32);
        this.trayPopupFade.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.trayPopupFade.setSelection(propertyChangeManager.isAutoCloseNewsPopup());
        this.trayPopupFade.setText(GUI.i18n.getTranslation("BUTTON_AUTOCLOSE_POPUP"));
        this.trayPopupFade.setFont(this.dialogFont);
        if (!GlobalSettings.useSystemTray()) {
            this.errorMessageLabel = new CLabel(this.composite, 0);
            this.errorMessageLabel.setFont(this.dialogFont);
            this.errorMessageLabel.setLayoutData(LayoutDataShop.createGridData(32, 2));
            this.setErrorMessage(GUI.i18n.getTranslation("LABEL_NOT_UNSUPPORTED"));
        }
        LayoutShop.setDialogSpacer(this.composite, 2, 4);
        if (GlobalSettings.useSystemTray()) {
            this.setTrayControlsEnabled(this.trayOwlCheck.getSelection());
        } else {
            this.trayOwlCheck.setSelection(false);
            this.trayOnStartupCheck.setSelection(false);
            this.trayOnExitCheck.setSelection(false);
            this.trayPopupCheck.setSelection(false);
            this.trayPopupFade.setSelection(false);
            this.trayPopupAnimate.setSelection(false);
            this.trayOwlCheck.setEnabled(false);
            this.setTrayControlsEnabled(false);
        }
        WidgetShop.initMnemonics(new Button[]{this.trayOwlCheck, this.trayOnStartupCheck, this.trayOnExitCheck, this.trayPopupCheck, this.trayPopupAnimate, this.trayPopupFade});
    }

    @Override
    protected void restoreButtonPressed() {
        if (GlobalSettings.useSystemTray()) {
            this.trayOwlCheck.setSelection(false);
            this.trayOnStartupCheck.setSelection(false);
            this.trayOnExitCheck.setSelection(false);
            this.trayPopupCheck.setSelection(true);
            this.trayPopupFade.setSelection(true);
            this.trayPopupFade.setEnabled(true);
            this.trayPopupAnimate.setSelection(true);
            this.setTrayControlsEnabled(this.trayOwlCheck.getSelection());
        }
    }

    void setTrayControlsEnabled(boolean bl) {
        this.trayOnStartupCheck.setEnabled(bl);
        this.trayOnExitCheck.setEnabled(bl);
        this.trayPopupCheck.setEnabled(bl);
        this.trayPopupAnimate.setEnabled(this.trayPopupCheck.getSelection() && bl);
        this.trayPopupFade.setEnabled(this.trayPopupCheck.getSelection() && bl);
    }
}

