/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.sort;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.rssowl.controller.NewsTable;
import net.sourceforge.rssowl.controller.sort.AbstractSorter;
import net.sourceforge.rssowl.controller.sort.AuthorSorter;
import net.sourceforge.rssowl.controller.sort.CategorySorter;
import net.sourceforge.rssowl.controller.sort.NewsFeedSorter;
import net.sourceforge.rssowl.controller.sort.PubDateSorter;
import net.sourceforge.rssowl.controller.sort.PublisherSorter;
import net.sourceforge.rssowl.controller.sort.StatusSorter;
import net.sourceforge.rssowl.controller.sort.TitleSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SortingSelectionAdapter
extends SelectionAdapter {
    private boolean authorAscending = true;
    private boolean categoryAscending = true;
    private boolean newsfeedAscending = true;
    private Vector newsItemInfos;
    private Vector newsItemOrder;
    private Hashtable newsItems;
    private boolean performSearch;
    private boolean publisherAscending = true;
    private boolean pudDateAscending = false;
    private boolean statusAscending = true;
    private Table table;
    private boolean titleAscending = true;

    public SortingSelectionAdapter(Table table, Hashtable hashtable, Vector vector, Vector vector2, boolean bl) {
        this.table = table;
        this.newsItems = hashtable;
        this.newsItemOrder = vector;
        this.newsItemInfos = vector2;
        this.performSearch = bl;
    }

    public boolean sort(String string) {
        AbstractSorter abstractSorter = null;
        boolean bl = true;
        if ("TABLE_HEADER_NEWSTITLE".equals(string)) {
            bl = this.titleAscending;
            this.titleAscending = !this.titleAscending;
            abstractSorter = new TitleSorter();
        } else if ("TABLE_HEADER_PUBDATE".equals(string)) {
            bl = this.pudDateAscending;
            this.pudDateAscending = !this.pudDateAscending;
            abstractSorter = new PubDateSorter(this.newsItems);
        } else if ("TABLE_HEADER_AUTHOR".equals(string)) {
            bl = this.authorAscending;
            this.authorAscending = !this.authorAscending;
            abstractSorter = new AuthorSorter(this.newsItems);
        } else if ("TABLE_HEADER_CATEGORY".equals(string)) {
            bl = this.categoryAscending;
            this.categoryAscending = !this.categoryAscending;
            abstractSorter = new CategorySorter(this.newsItems);
        } else if ("TABLE_HEADER_PUBLISHER".equals(string)) {
            bl = this.publisherAscending;
            this.publisherAscending = !this.publisherAscending;
            abstractSorter = new PublisherSorter(this.newsItems);
        } else if ("TABLE_HEADER_FEED".equals(string)) {
            bl = this.newsfeedAscending;
            this.newsfeedAscending = !this.newsfeedAscending;
            abstractSorter = new NewsFeedSorter(this.newsItems);
        } else if ("TABLE_HEADER_STATUS".equals(string)) {
            bl = this.statusAscending;
            this.statusAscending = !this.statusAscending;
            abstractSorter = new StatusSorter(this.newsItems);
        }
        if (null == abstractSorter) {
            Collections.sort(this.newsItemOrder);
        } else {
            Collections.sort(this.newsItemOrder, abstractSorter);
        }
        if (!bl) {
            Collections.reverse(this.newsItemOrder);
        }
        return bl;
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        this.widgetSelected((TableColumn)selectionEvent.getSource());
    }

    public void widgetSelected(TableColumn tableColumn) {
        int n;
        boolean bl = this.sort((String)tableColumn.getData());
        int n2 = this.table.getColumnCount();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.table.getColumn(i).getWidth();
        }
        String string = null;
        if (this.table.getSelectionCount() > 0) {
            string = this.table.getSelection()[0].getText(1);
        }
        if (!tableColumn.getData().equals("TABLE_HEADER_STATUS")) {
            this.table.setSortColumn(tableColumn);
            if (this.table.getSortDirection() != 0) {
                this.table.setSortDirection(0);
            }
            this.table.setSortDirection(bl ? 128 : 1024);
            this.table.setRedraw(false);
            tableColumn.pack();
            this.table.setRedraw(true);
            if (!this.table.isFocusControl()) {
                this.table.setFocus();
            }
            if (nArray[n = this.table.indexOf(tableColumn)] < tableColumn.getWidth()) {
                nArray[n] = tableColumn.getWidth();
            }
        } else if (this.table.getSortColumn() != null) {
            this.table.setSortDirection(0);
            this.table.setSortColumn(null);
        }
        this.table.removeAll();
        NewsTable.fillTable(this.table, this.newsItems, this.newsItemOrder, this.newsItemInfos, this.performSearch, nArray);
        if (string != null) {
            n = this.table.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!this.table.getItem(i).getText(1).equals(string)) continue;
                this.table.setSelection(i);
                break;
            }
        }
    }
}

