/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.NewsTabFolder;
import net.sourceforge.rssowl.controller.statusline.LoadJob;
import net.sourceforge.rssowl.controller.statusline.StatusLine;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.NewsfeedFactory;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.archive.FeedCacheManager;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;

public class FeedLoader
extends ExtendedThread {
    Display display;
    int displayMode;
    boolean displayNewsfeed;
    boolean reselectNews;
    Channel rssChannel;
    FeedCacheManager rssOwlFeedCacheManager;
    GUI rssOwlGui;
    LoadJob rssOwlLoadJob;
    NewsTabFolder rssOwlNewsTabFolder;
    StatusLine rssOwlStatusLine;
    SearchDefinition searchDefinition;
    String url;

    public FeedLoader(String string, SearchDefinition searchDefinition, boolean bl, boolean bl2, int n) {
        this.url = string;
        this.searchDefinition = searchDefinition;
        this.displayNewsfeed = bl;
        this.displayMode = n;
        this.reselectNews = bl2;
        this.rssOwlGui = GUI.rssOwlGui;
        this.display = GUI.display;
        this.rssOwlFeedCacheManager = this.rssOwlGui.getFeedCacheManager();
        this.rssOwlNewsTabFolder = this.rssOwlGui.getRSSOwlNewsTabFolder();
        this.rssOwlStatusLine = this.rssOwlGui.getRSSOwlStatusLine();
        this.setName("Load Feed Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Object object;
        block15: {
            if (this.rssOwlFeedCacheManager.isNewsfeedCached(this.url, false) && !FileShop.exists(this.url)) {
                this.rssChannel = this.rssOwlFeedCacheManager.getCachedNewsfeed(this.url);
                if (!this.isStopped() && this.rssChannel != null) {
                    this.rssChannel.updateReadStatusOnNews();
                }
            } else if (GlobalSettings.workOffline && this.rssOwlFeedCacheManager.isNewsfeedCached(this.url, true) && !FileShop.exists(this.url)) {
                this.rssChannel = this.rssOwlFeedCacheManager.getCachedNewsfeed(this.url);
                if (!this.isStopped() && this.rssChannel != null) {
                    this.rssChannel.updateReadStatusOnNews();
                }
                this.rssOwlFeedCacheManager.cacheNewsfeed(this.url, this.rssChannel);
            } else if (GlobalSettings.workOffline && !FileShop.exists(this.url)) {
                this.handleErrorLoading(new NewsfeedFactoryException(this.url, null, null, 4));
                this.stopThread();
            } else if (this.rssChannel == null) {
                try {
                    if (!this.isStopped()) {
                        object = new NewsfeedFactory(this.url);
                        this.rssChannel = ((NewsfeedFactory)object).getRSSChannel();
                        this.rssOwlFeedCacheManager.cacheNewsfeed(this.url, this.rssChannel);
                        if (!this.isStopped() && Category.getFavPool().containsKey(this.url)) {
                            Favorite favorite = (Favorite)Category.getFavPool().get(this.url);
                            favorite.updateReadStatus(this.rssChannel.getUnreadNewsCount());
                            favorite.syncMetaData(this.rssChannel);
                        }
                    }
                }
                catch (NewsfeedFactoryException newsfeedFactoryException) {
                    if (this.isStopped() || !GUI.isAlive()) break block15;
                    this.handleErrorLoading(newsfeedFactoryException);
                    this.stopThread();
                }
            }
        }
        if (!this.isStopped() && this.rssChannel != null && Category.getFavPool().containsKey(this.url)) {
            object = (Favorite)Category.getFavPool().get(this.url);
            ((Favorite)object).updateErrorState(false);
        }
        if (!this.isStopped() && GUI.isAlive()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (FeedLoader.this.displayNewsfeed) {
                        if (!FeedLoader.this.isStopped()) {
                            FeedLoader.this.rssOwlGui.displayNewsfeed(FeedLoader.this.rssChannel, FeedLoader.this.url, FeedLoader.this.searchDefinition, FeedLoader.this.reselectNews, FeedLoader.this.displayMode);
                        }
                        if (GlobalSettings.reopenFeeds && !FeedLoader.this.isStopped()) {
                            FeedLoader.this.rssOwlNewsTabFolder.addFeedToLastOpened(FeedLoader.this.url);
                        }
                    }
                    if (!FeedLoader.this.isStopped()) {
                        FeedLoader.this.rssOwlStatusLine.finishJob(FeedLoader.this.rssOwlLoadJob);
                    }
                }
            });
        }
    }

    public void setRSSOwlLoadJob(LoadJob loadJob) {
        this.rssOwlLoadJob = loadJob;
    }

    private void handleErrorLoading(final NewsfeedFactoryException newsfeedFactoryException) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Favorite favorite;
                CTabItem cTabItem = FeedLoader.this.rssOwlNewsTabFolder.getFeedTabItem(FeedLoader.this.url);
                if (cTabItem != null) {
                    cTabItem.getControl().dispose();
                    cTabItem.setData(TabItemData.createErrorData(FeedLoader.this.url));
                    cTabItem.setImage(PaintShop.iconError);
                    FeedLoader.this.rssOwlNewsTabFolder.showErrorTab(cTabItem, newsfeedFactoryException);
                    if (FeedLoader.this.rssOwlNewsTabFolder.focusTab()) {
                        FeedLoader.this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().setSelection(cTabItem);
                        FeedLoader.this.rssOwlNewsTabFolder.updateTabFolderState();
                    }
                } else if (GlobalSettings.showErrors && FeedLoader.this.displayNewsfeed) {
                    FeedLoader.this.rssOwlNewsTabFolder.showErrorTab(FeedLoader.this.url, newsfeedFactoryException);
                }
                if ((favorite = (Favorite)Category.getFavPool().get(FeedLoader.this.url)) != null) {
                    favorite.updateErrorState(true);
                }
                FeedLoader.this.rssOwlStatusLine.finishJob(FeedLoader.this.rssOwlLoadJob);
            }
        });
    }
}

