/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;

public class FeedQueueLoader
extends Thread {
    private Vector feedQueue = new Vector();
    int counter;
    private boolean isRunning;
    private static final int GAP_BETWEEN_LOADING = 3000;

    public FeedQueueLoader() {
        this.setDaemon(true);
        this.setName("Queue Loader Thread");
    }

    public void addFeed(String string) {
        if (this.feedQueue.contains(string)) {
            this.feedQueue.remove(string);
        }
        this.feedQueue.add(string);
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.counter = 0;
        while (!this.feedQueue.isEmpty() && GUI.isAlive() && !this.isInterrupted()) {
            if (this.counter > GlobalSettings.maxConnectionCount) {
                this.counter = 0;
                try {
                    FeedQueueLoader.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (GUI.isAlive() && !this.isInterrupted()) {
                GUI.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String string = GlobalSettings.displaySingleTab ? FeedQueueLoader.this.getLastFeed() : FeedQueueLoader.this.getNextFeed();
                        GUI.rssOwlGui.loadNewsFeed(string, SearchDefinition.NO_SEARCH, true, true, 2);
                        ++FeedQueueLoader.this.counter;
                    }
                });
            }
            if (!GlobalSettings.displaySingleTab) continue;
        }
        this.isRunning = false;
    }

    public void startThread() {
        this.start();
    }

    public void stopThread() {
        this.isRunning = false;
        this.interrupt();
    }

    String getLastFeed() {
        return (String)this.feedQueue.remove(this.feedQueue.size() - 1);
    }

    String getNextFeed() {
        return (String)this.feedQueue.remove(0);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

