/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.FeedSearchDialog;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.FeedParser;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FeedSearchManager {
    private static final int COLLECTOR_THREAD_COUNT = 7;
    private static final Vector localeSearchList = new Vector();
    private static final String[] SEARCH_DELIMITER = new String[]{"rss", "rdf", "atom", "newsfeed", "weblog", "blog"};
    private static final String START_PARAM = "&start=";
    private ExtendedThread[] collectorThreads;
    private boolean intensiveSearch;
    private Vector links;
    private boolean nativeLangSearch;
    private int resultCounter;
    private Thread searchThread;
    private String searchUrl;
    private String topic;
    int collectorsDone;
    Vector normalUrlObjects;
    SAXBuilder[] parser = new SAXBuilder[7];
    Vector preferredUrlObjects;
    Random randomNumberGenerator;
    FeedSearchDialog rssOwlFeedSearchDialog;
    boolean running;
    boolean searchDone;

    public FeedSearchManager(String string, FeedSearchDialog feedSearchDialog, boolean bl, boolean bl2) {
        this.topic = string;
        this.rssOwlFeedSearchDialog = feedSearchDialog;
        this.intensiveSearch = bl;
        this.nativeLangSearch = bl2;
        this.searchDone = false;
        this.running = false;
        this.collectorsDone = 0;
        this.resultCounter = 0;
        this.links = new Vector();
        this.collectorThreads = new ExtendedThread[7];
        this.randomNumberGenerator = new Random();
        this.preferredUrlObjects = new Vector();
        this.normalUrlObjects = new Vector();
        this.searchUrl = this.createUrl();
        this.initXMLParsers();
        this.createSearchThread();
        this.createCollectorThreads();
    }

    public static void addIntoLocaleSearchList(String string) {
        localeSearchList.add(string);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startSearch() {
        this.running = true;
        for (int i = 0; i < 7; ++i) {
            this.collectorThreads[i].start();
        }
        this.searchThread.start();
    }

    public void stopSearch() {
        this.running = false;
        for (int i = 0; i < 7; ++i) {
            this.collectorThreads[i].stopThread();
            this.collectorThreads[i].interrupt();
        }
        this.searchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDocument(URL uRL, boolean bl, int n) {
        Object object;
        Document document = null;
        ConnectionManager connectionManager = new ConnectionManager(uRL.toExternalForm());
        try {
            connectionManager.setShowLoginDialogIfRequired(false);
            connectionManager.setUserAgent(BrowserShop.getUserAgent());
            connectionManager.connect();
            InputStream inputStream = connectionManager.getInputStream();
            if (inputStream == null || !this.running) {
                Document document2 = null;
                return document2;
            }
            object = URLConnection.guessContentTypeFromStream(inputStream);
            if (object != null && !((String)object).equals("application/xml")) {
                Document document3 = document;
                return document3;
            }
            document = !bl ? this.parser[n].build(inputStream) : this.parser[n].build(new InputStreamReader(inputStream));
        }
        catch (JDOMException jDOMException) {
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            if (!bl) {
                object = this.buildDocument(uRL, true, n);
                return object;
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            connectionManager.closeConnection();
        }
        return document;
    }

    private void createCollectorThreads() {
        for (int i = 0; i < 7; ++i) {
            final int n = i;
            this.collectorThreads[i] = new ExtendedThread("Feed Search Collector Thread #" + n){

                @Override
                public void run() {
                    block2: while (!this.isStopped() && !this.isInterrupted()) {
                        while (FeedSearchManager.this.preferredUrlObjects.size() == 0 && FeedSearchManager.this.normalUrlObjects.size() == 0 && !FeedSearchManager.this.searchDone && !this.isStopped()) {
                            try {
                                1.sleep(500 + FeedSearchManager.this.randomNumberGenerator.nextInt(500));
                            }
                            catch (InterruptedException interruptedException) {
                                break block2;
                            }
                        }
                        if (FeedSearchManager.this.preferredUrlObjects.size() == 0 && FeedSearchManager.this.normalUrlObjects.size() == 0 && FeedSearchManager.this.searchDone) {
                            this.stopThread();
                            this.interrupt();
                        }
                        if (FeedSearchManager.this.preferredUrlObjects.size() > 0 && FeedSearchManager.this.running) {
                            FeedSearchManager.this.buildChannel((URL)FeedSearchManager.this.preferredUrlObjects.remove(0), n);
                            continue;
                        }
                        if (FeedSearchManager.this.normalUrlObjects.size() <= 0 || !FeedSearchManager.this.running) continue;
                        FeedSearchManager.this.buildChannel((URL)FeedSearchManager.this.normalUrlObjects.remove(0), n);
                    }
                    ++FeedSearchManager.this.collectorsDone;
                }
            };
            this.collectorThreads[i].setDaemon(true);
        }
    }

    private void createSearchThread() {
        this.searchThread = new Thread("Feed Search Thread"){

            @Override
            public void run() {
                block6: {
                    try {
                        FeedSearchManager.this.performSearch();
                        FeedSearchManager.this.searchDone = true;
                        while (FeedSearchManager.this.collectorsDone != 7) {
                            try {
                                2.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                break;
                            }
                        }
                        FeedSearchManager.this.rssOwlFeedSearchDialog.setSearching(false);
                        if (GUI.isAlive() && !FeedSearchManager.this.rssOwlFeedSearchDialog.isSearching()) {
                            GUI.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FeedSearchManager.this.rssOwlFeedSearchDialog.setButtonState(false);
                                    FeedSearchManager.this.rssOwlFeedSearchDialog.stopStatusMessageAnimate();
                                    FeedSearchManager.this.rssOwlFeedSearchDialog.setMessage(GUI.i18n.getTranslation("LABEL_SEARCH_FINISHED"));
                                }
                            });
                        }
                        FeedSearchManager.this.running = false;
                    }
                    catch (IOException iOException) {
                        FeedSearchManager.this.searchDone = true;
                        FeedSearchManager.this.running = false;
                        if (this.isInterrupted() || !GUI.isAlive()) break block6;
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FeedSearchManager.this.rssOwlFeedSearchDialog.stopStatusMessageAnimate();
                                FeedSearchManager.this.rssOwlFeedSearchDialog.setErrorMessage(GUI.i18n.getTranslation("ERROR_CONNECTION_FAILED"));
                                FeedSearchManager.this.rssOwlFeedSearchDialog.setButtonState(false);
                                FeedSearchManager.this.rssOwlFeedSearchDialog.setSearching(false);
                            }
                        });
                    }
                }
            }
        };
        this.searchThread.setDaemon(true);
    }

    private String createUrl() {
        String string = URLShop.urlEncode(this.topic);
        string = string + "+" + SEARCH_DELIMITER[0];
        for (int i = 1; i < SEARCH_DELIMITER.length; ++i) {
            string = string + "+OR+" + SEARCH_DELIMITER[i];
        }
        String string2 = "com";
        String string3 = "en";
        if (localeSearchList.contains(Dictionary.selectedLocale.getCountry().toLowerCase())) {
            string2 = Dictionary.selectedLocale.getCountry().toLowerCase();
            string3 = Dictionary.selectedLocale.getLanguage().toLowerCase();
        }
        if (this.nativeLangSearch) {
            return "http://www.google." + string2 + "/search?q=" + string + "&ie=UTF-8&oe=UTF-8&hl=" + string3 + "&num=10&meta=lr=lang_" + Dictionary.selectedLanguage;
        }
        return "http://www.google." + string2 + "/search?q=" + string + "&ie=UTF-8&oe=UTF-8&hl=" + string3 + "&num=10";
    }

    private void filterLink(String string) {
        if (string.equals("http://www")) {
            return;
        }
        if (string.indexOf("/search?q=") >= 0 || string.indexOf("/translate?hl=") >= 0) {
            return;
        }
        if (this.intensiveSearch && URLShop.looksLikeBinary(string)) {
            return;
        }
        if (!this.intensiveSearch && !URLShop.looksLikeNewsfeed(string, true)) {
            return;
        }
        string = URLShop.canonicalize(string);
        if (!this.links.contains(string = StringShop.replaceAll(string, "&amp;", "&")) && !this.rssOwlFeedSearchDialog.getResults().containsKey(string)) {
            try {
                URL uRL = new URL(string);
                if (URLShop.looksLikeNewsfeed(uRL, true)) {
                    this.preferredUrlObjects.add(uRL);
                } else {
                    this.normalUrlObjects.add(uRL);
                }
                this.links.add(string);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
    }

    private void initXMLParsers() {
        for (int i = 0; i < 7; ++i) {
            this.parser[i] = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            this.parser[i].setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            XMLShop.setDefaultEntityResolver(this.parser[i]);
        }
    }

    void buildChannel(URL uRL, int n) {
        Document document = this.buildDocument(uRL, false, n);
        if (document == null) {
            return;
        }
        try {
            FeedParser feedParser = new FeedParser(document, uRL.toExternalForm());
            feedParser.parse();
            final Channel channel = feedParser.getChannel();
            if (channel == null) {
                return;
            }
            if (!this.nativeLangSearch || channel.getLanguage() != null && channel.getLanguage().equals(Dictionary.selectedLanguage)) {
                ++this.resultCounter;
                if (StringShop.isset(channel.getLink()) && !Category.linkExists(channel.getLink())) {
                    GUI.rssOwlGui.getFeedCacheManager().cacheNewsfeed(channel.getLink(), channel);
                }
                if (GUI.isAlive()) {
                    GUI.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (FeedSearchManager.this.running) {
                                FeedSearchManager.this.rssOwlFeedSearchDialog.addResultElement(channel.getLink(), channel.getTitle(), channel.getFormat());
                            }
                        }
                    });
                }
            }
        }
        catch (NewsfeedFactoryException newsfeedFactoryException) {
            // empty catch block
        }
    }

    void performSearch() throws IOException {
        Object object;
        Object object2;
        int n = 0;
        if (URLShop.looksLikeURL(this.topic)) {
            try {
                object2 = URLShop.crawlUrls(this.topic);
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    this.filterLink((String)object.next());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.filterLink(this.topic);
        }
        do {
            object2 = this.searchUrl + START_PARAM + n;
            object = new ConnectionManager((String)object2);
            ((ConnectionManager)object).setShowLoginDialogIfRequired(false);
            ((ConnectionManager)object).setUserAgent(BrowserShop.getUserAgent());
            ((ConnectionManager)object).connect();
            String string = FileShop.getContent(((ConnectionManager)object).getInputStream());
            ((ConnectionManager)object).closeConnection();
            string = StringShop.replaceAll(string, "<b>", "");
            string = StringShop.replaceAll(string, "</b>", "");
            Vector vector = new Vector();
            RegExShop.extractLinksFromText(string, vector);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.filterLink((String)iterator.next());
            }
            n += 10;
            while (this.normalUrlObjects.size() > 0 || this.preferredUrlObjects.size() > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        } while (n <= 1000 && !this.searchThread.isInterrupted());
    }
}

