/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.IOException;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.model.ChannelImage;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImageLoader
extends Thread {
    Image image;
    Label imgHolder;
    Composite parent;
    ChannelImage rssChannelImage;

    public ImageLoader(ChannelImage channelImage, Label label, Composite composite) {
        this.rssChannelImage = channelImage;
        this.imgHolder = label;
        this.parent = composite;
        this.setName("Image Loader Thread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (StringShop.isset(this.rssChannelImage.getImgUrl())) {
            ConnectionManager connectionManager = new ConnectionManager(this.rssChannelImage.getImgUrl());
            try {
                connectionManager.setShowLoginDialogIfRequired(false);
                connectionManager.connect();
                this.image = new Image((Device)GUI.display, connectionManager.getInputStream());
            }
            catch (IOException iOException) {
                GUI.logger.info("ChannelImage()", iOException);
            }
            catch (SWTException sWTException) {
                GUI.logger.info("ChannelImage()", sWTException);
            }
            finally {
                connectionManager.closeConnection();
            }
        }
        if (this.image != null && GUI.isAlive()) {
            this.showImage();
        }
    }

    private void showImage() {
        GUI.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ImageLoader.this.imgHolder.isDisposed()) {
                    return;
                }
                ImageLoader.this.imgHolder.setImage(ImageLoader.this.image);
                ImageLoader.this.imgHolder.addDisposeListener(DisposeListenerImpl.getInstance());
                if (ImageLoader.this.rssChannelImage.getLink() != null) {
                    ImageLoader.this.imgHolder.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_URLOPEN"));
                    ImageLoader.this.imgHolder.setCursor(GUI.display.getSystemCursor(21));
                }
                ImageLoader.this.imgHolder.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseDown(MouseEvent mouseEvent) {
                        if (ImageLoader.this.rssChannelImage.getLink() == null) {
                            return;
                        }
                        BrowserShop.openLinkInTab(ImageLoader.this.rssChannelImage.getLink());
                    }
                });
                if (!ImageLoader.this.parent.isDisposed()) {
                    ImageLoader.this.parent.layout();
                }
            }
        });
    }
}

