/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.tray;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.controller.tray.SystemTray;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SystemTrayAlert {
    private static final int ANIMATION_DELAY = 500;
    private static final int ANIMATION_SLEEP = 10;
    private static final int ANIMATION_STEPS = 35;
    private static final int AUTO_CLOSE_TIME = 6000;
    private static SystemTrayAlert instance = null;
    private ExtendedThread autoClosePopup;
    Image closeImageHot;
    Image closeImageNormal;
    Display display;
    boolean mouseInPopup;
    Font popupBoldFont;
    Color popupBorderColor;
    boolean popupClosed;
    Color popupInnerCircleColor;
    Color popupOuterCircleColor;
    Shell popupShell;
    SystemTray rssOwlSystemTray;
    Image trayOwlTease;

    private SystemTrayAlert(Display display, SystemTray systemTray) {
        this.display = display;
        this.rssOwlSystemTray = systemTray;
        this.mouseInPopup = false;
        this.popupClosed = false;
        this.initResources();
        this.initComponents();
    }

    public static SystemTrayAlert getInstance(Display display, SystemTray systemTray) {
        if (instance == null) {
            instance = new SystemTrayAlert(display, systemTray);
        }
        return instance;
    }

    public boolean isPopupClosed() {
        return this.popupClosed;
    }

    public void show() {
        this.popupClosed = false;
        if (GlobalSettings.animateNewsPopup) {
            this.moveIn();
        } else {
            Rectangle rectangle = this.getPrimaryClientArea();
            this.popupShell.setLocation(rectangle.width + rectangle.x - this.popupShell.getSize().x, rectangle.height + rectangle.y - this.popupShell.getSize().y);
            this.popupShell.setVisible(true);
        }
        if (GlobalSettings.autoCloseNewsPopup) {
            this.startAutoCloseThread();
        }
    }

    private Rectangle getPrimaryClientArea() {
        Monitor monitor = this.display.getPrimaryMonitor();
        return monitor != null ? monitor.getClientArea() : this.display.getClientArea();
    }

    private void initComponents() {
        this.popupShell = new Shell(this.display, GlobalSettings.isWindows() ? 540672 : 540680);
        this.popupShell.setBackground(this.popupBorderColor);
        this.popupShell.setLayout(LayoutShop.createGridLayout(1, 1, 1));
        this.popupShell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                SystemTrayAlert.this.onDispose();
            }
        });
        Composite composite = new Composite(this.popupShell, 524288);
        composite.setBackground(this.popupOuterCircleColor);
        composite.setLayoutData(LayoutDataShop.createGridData(1808, 1));
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 3, 0));
        Composite composite2 = new Composite(composite, 524288);
        composite2.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite2.setBackground(composite.getBackground());
        composite2.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        CLabel cLabel = new CLabel(composite2, 524288);
        cLabel.setText("RSSOwl");
        cLabel.setFont(this.popupBoldFont);
        cLabel.setBackground(composite2.getBackground());
        cLabel.setLayoutData(new GridData(768));
        cLabel.setForeground(this.display.getSystemColor(1));
        final CLabel cLabel2 = new CLabel(composite2, 524288);
        cLabel2.setLayoutData(new GridData(128));
        cLabel2.setBackground(composite2.getBackground());
        cLabel2.setImage(this.closeImageNormal);
        cLabel2.setCursor(this.display.getSystemCursor(21));
        cLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                SystemTrayAlert.this.close();
            }
        });
        cLabel2.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
                cLabel2.setImage(SystemTrayAlert.this.closeImageHot);
                SystemTrayAlert.this.mouseInPopup = true;
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
                cLabel2.setImage(SystemTrayAlert.this.closeImageNormal);
                SystemTrayAlert.this.mouseInPopup = false;
            }
        });
        Composite composite3 = new Composite(composite, 524288);
        composite3.setLayout(LayoutShop.createGridLayout(1, 3, 0));
        composite3.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite3.setBackground(composite.getBackground());
        Composite composite4 = new Composite(composite3, 524288);
        composite4.setLayout(LayoutShop.createGridLayout(1, 1, 1));
        composite4.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite4.setBackground(this.display.getSystemColor(2));
        Composite composite5 = new Composite(composite4, 524288);
        composite5.setLayoutData(LayoutDataShop.createGridData(768, 1));
        composite5.setLayout(LayoutShop.createGridLayout(1, 5, 5));
        composite5.setBackground(this.popupInnerCircleColor);
        final CLabel cLabel3 = new CLabel(composite5, 524288);
        cLabel3.setLayoutData(new GridData(768));
        cLabel3.setBackground(composite2.getBackground());
        cLabel3.setImage(this.trayOwlTease);
        cLabel3.setBackground(this.popupInnerCircleColor);
        cLabel3.setText(GUI.i18n.getTranslation("TOOLTIP_UNREAD_AVAILABLE"));
        cLabel3.setFont(this.popupBoldFont);
        cLabel3.setCursor(this.display.getSystemCursor(21));
        cLabel3.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
                cLabel3.setForeground(SystemTrayAlert.this.display.getSystemColor(9));
                SystemTrayAlert.this.mouseInPopup = true;
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
                cLabel3.setForeground(SystemTrayAlert.this.display.getSystemColor(2));
                SystemTrayAlert.this.mouseInPopup = false;
            }
        });
        cLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                SystemTrayAlert.this.close();
                SystemTrayAlert.this.rssOwlSystemTray.restoreWindow();
            }
        });
        this.popupShell.pack();
    }

    private void initResources() {
        this.popupBorderColor = new Color(this.display, 125, 177, 251);
        this.popupOuterCircleColor = new Color(this.display, 73, 135, 234);
        this.popupInnerCircleColor = new Color(this.display, 241, 240, 234);
        this.popupBoldFont = FontShop.createFont(this.display.getSystemFont().getFontData()[0].getHeight(), 1);
        this.closeImageNormal = PaintShop.loadImage("/img/popupclose.gif");
        this.closeImageHot = PaintShop.loadImage("/img/popupclose_hot.gif");
        this.trayOwlTease = PaintShop.loadImage("/img/trayowl_tease.gif");
    }

    private void moveIn() {
        final Rectangle rectangle = this.getPrimaryClientArea();
        final Point point = this.popupShell.getSize();
        final int n = rectangle.width + rectangle.x;
        final int n2 = n - point.x;
        final int n3 = rectangle.height + rectangle.y - point.y;
        final int n4 = point.x / 35;
        this.popupShell.setLocation(n, n3);
        if (!this.popupShell.isVisible()) {
            this.popupShell.setVisible(true);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    6.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                for (int i = n; i > n2; i -= n4) {
                    SystemTrayAlert.this.move(i, n3);
                    try {
                        6.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                SystemTrayAlert.this.move(rectangle.width + rectangle.x - point.x, n3);
            }
        };
        thread.setName("Popup Animator Thread");
        thread.setDaemon(true);
        thread.start();
    }

    private void startAutoCloseThread() {
        if (this.autoClosePopup != null && !this.autoClosePopup.isStopped()) {
            this.autoClosePopup.stopThread();
        }
        this.autoClosePopup = new ExtendedThread(){

            @Override
            public void run() {
                while (!this.isStopped() && !SystemTrayAlert.this.popupClosed) {
                    try {
                        7.sleep(6000L);
                        if (!GUI.isAlive() || this.isStopped()) continue;
                        SystemTrayAlert.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(SystemTrayAlert.this.mouseInPopup || SystemTrayAlert.this.popupClosed || this.isStopped())) {
                                    SystemTrayAlert.this.close();
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        this.autoClosePopup.setName("Auto Close Tray Popup Thread");
        this.autoClosePopup.setDaemon(true);
        this.autoClosePopup.start();
    }

    void close() {
        this.popupClosed = true;
        if (this.autoClosePopup != null) {
            this.autoClosePopup.stopThread();
        }
        this.hide();
    }

    void hide() {
        if (GUI.isAlive() && WidgetShop.isset(this.popupShell)) {
            Rectangle rectangle = this.getPrimaryClientArea();
            this.popupShell.setVisible(false);
            this.popupShell.setLocation(rectangle.width + rectangle.x, rectangle.height + rectangle.y);
        }
    }

    void move(final int n, final int n2) {
        if (GUI.isAlive()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (WidgetShop.isset(SystemTrayAlert.this.popupShell)) {
                        SystemTrayAlert.this.popupShell.setLocation(n, n2);
                    }
                }
            });
        }
    }

    void onDispose() {
        this.popupBorderColor.dispose();
        this.popupOuterCircleColor.dispose();
        this.popupInnerCircleColor.dispose();
        this.popupBoldFont.dispose();
        this.closeImageNormal.dispose();
        this.closeImageHot.dispose();
        this.trayOwlTease.dispose();
    }
}

