/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import java.util.List;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Importer {
    private String categoryTitle;
    private Document document;
    private String opmlFilePath;
    private Category targetCategory;

    public Importer(String string, Category category) {
        this(string, null, category);
    }

    public Importer(String string, String string2, Category category) {
        this.opmlFilePath = string;
        this.categoryTitle = string2;
        this.targetCategory = category;
    }

    public void importNewsfeeds(boolean bl) throws FileNotFoundException, JDOMException, IOException {
        Object object2;
        this.loadDocument(false);
        Element element = this.document.getRootElement();
        if (element == null || !element.getName().equalsIgnoreCase("opml")) {
            throw new JDOMException(GUI.i18n.getTranslation("ERROR_NOT_A_OPML"));
        }
        Element element2 = element.getChild("body");
        if (element2 == null) {
            throw new JDOMException(GUI.i18n.getTranslation("ERROR_NOT_A_OPML"));
        }
        boolean bl2 = false;
        List list = element2.getChildren();
        for (Object object2 : list) {
            if (((Element)object2).getChildren().size() != 0 || this.isCategory((Element)object2)) continue;
            bl2 = true;
            break;
        }
        if (StringShop.isset(this.categoryTitle) && bl) {
            if (this.targetCategory != Category.getRootCategory()) {
                Category.getBlogrolls().remove(this.targetCategory.getPathToBlogroll());
                this.targetCategory.removeAll();
                this.targetCategory.setPathToBlogroll(this.opmlFilePath);
                this.targetCategory.setUseProxy(ProxyShop.isUseProxy());
                this.targetCategory.getParent().editCategory(this.targetCategory.getName(), this.categoryTitle);
                this.importFromOPML(element.getChild("body"), this.targetCategory, bl);
            } else {
                object2 = new Category(this.categoryTitle, this.targetCategory, true);
                ((Category)object2).setPathToBlogroll(this.opmlFilePath);
                ((Category)object2).setUseProxy(ProxyShop.isUseProxy());
                this.targetCategory.addCategory((Category)object2, true);
                this.importFromOPML(element.getChild("body"), (Category)object2, bl);
            }
        } else if (bl2) {
            object2 = new Category(GUI.i18n.getTranslation("OPML_IMPORTED"), this.targetCategory, false);
            this.targetCategory.addCategory((Category)object2, true);
            this.importFromOPML(element.getChild("body"), (Category)object2, bl);
        } else {
            this.importFromOPML(element.getChild("body"), this.targetCategory, bl);
        }
        SettingsManager.getInstance().requestSave();
    }

    private void importFromOPML(Element element, Category category, boolean bl) {
        List list = element.getChildren();
        for (Element element2 : list) {
            Object object;
            String string = element2.getAttributeValue("xmlUrl");
            if (string == null) {
                string = element2.getAttributeValue("xmlurl");
            }
            if (string == null) {
                string = element2.getAttributeValue("xmlURL");
            }
            if (string == null) {
                object = new Category(GUI.i18n.getTranslation("OPML_IMPORTED"), category, bl);
                if (StringShop.isset(element2.getAttributeValue("title"))) {
                    ((Category)object).setName(element2.getAttributeValue("title"));
                } else if (StringShop.isset(element2.getAttributeValue("text"))) {
                    ((Category)object).setName(element2.getAttributeValue("text"));
                }
                if (bl) {
                    ((Category)object).setBlogroll(true);
                    ((Category)object).setPathToBlogroll(this.opmlFilePath);
                    ((Category)object).setUseProxy(category.isUseProxy());
                }
                category.addCategory((Category)object, true);
                this.importFromOPML(element2, (Category)object, bl);
                continue;
            }
            if (!StringShop.isset(string)) continue;
            string = Category.createUniqueLink(string);
            object = string;
            if (StringShop.isset(element2.getAttributeValue("text"))) {
                object = element2.getAttributeValue("text");
            } else if (StringShop.isset(element2.getAttributeValue("title"))) {
                object = element2.getAttributeValue("title");
            }
            object = Category.createUniqueTitle((String)object);
            Favorite favorite = new Favorite(string, (String)object, category);
            favorite.setCreationDate(System.currentTimeMillis());
            if (StringShop.isset(element2.getAttributeValue("openOnStartup"))) {
                favorite.setOpenOnStartup(Boolean.valueOf(element2.getAttributeValue("openOnStartup")));
            }
            if (StringShop.isset(element2.getAttributeValue("loadOnStartup"))) {
                favorite.setLoadOnStartup(Boolean.valueOf(element2.getAttributeValue("loadOnStartup")));
            }
            if (StringShop.isset(element2.getAttributeValue("useproxy"))) {
                favorite.setUseProxy(Boolean.valueOf(element2.getAttributeValue("useproxy")));
            }
            if (StringShop.isset(element2.getAttributeValue("rssOwlUpdateInterval"))) {
                favorite.setUpdateInterval(Integer.parseInt(element2.getAttributeValue("rssOwlUpdateInterval")));
            }
            if (StringShop.isset(element2.getAttributeValue("htmlUrl"))) {
                favorite.setHomepage(element2.getAttributeValue("htmlUrl"));
            }
            if (StringShop.isset(element2.getAttributeValue("language"))) {
                favorite.setLanguage(element2.getAttributeValue("language"));
            }
            if (StringShop.isset(element2.getAttributeValue("description"))) {
                favorite.setDescription(element2.getAttributeValue("description"));
            }
            if (bl) {
                favorite.setUseProxy(category.isUseProxy());
            }
            category.addFavorite(favorite);
        }
    }

    private boolean isCategory(Element element) {
        return element != null && element.getAttributeValue("xmlUrl") == null && element.getAttributeValue("xmlurl") == null && element.getAttributeValue("xmlURL") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDocument(boolean bl) throws FileNotFoundException, JDOMException, IOException {
        block8: {
            SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            sAXBuilder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            XMLShop.setDefaultEntityResolver(sAXBuilder);
            if (new File(this.opmlFilePath).exists()) {
                this.document = sAXBuilder.build(new BufferedInputStream(new FileInputStream(this.opmlFilePath)));
            } else {
                ConnectionManager connectionManager = new ConnectionManager(this.opmlFilePath);
                connectionManager.setUserAgent(BrowserShop.getOwlAgent());
                connectionManager.connect(this.targetCategory.isUseProxy());
                try {
                    this.document = !bl ? sAXBuilder.build(connectionManager.getInputStream()) : sAXBuilder.build(new InputStreamReader(connectionManager.getInputStream()));
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    if (!bl) {
                        this.loadDocument(true);
                        break block8;
                    }
                    throw uTFDataFormatException;
                }
                finally {
                    connectionManager.closeConnection();
                }
            }
        }
    }
}

