/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.FeedParser;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;

public class NewsfeedFactory {
    private Document document;
    private FeedParser parser;
    private Channel rssChannel;
    String rssUrl;

    public NewsfeedFactory(Favorite favorite) throws NewsfeedFactoryException {
        this(favorite.getUrl(), false);
    }

    public NewsfeedFactory(String string) throws NewsfeedFactoryException {
        this(string, false);
    }

    public NewsfeedFactory(String string, boolean bl) throws NewsfeedFactoryException {
        this.rssUrl = string;
        this.initXmlDocument(false);
        if (this.document == null) {
            return;
        }
        if (!bl) {
            this.initXMLParser();
            this.parser.parse();
            this.rssChannel = this.parser.getChannel();
            if (this.rssChannel != null) {
                this.rssChannel.updateReadStatusOnNews();
                GUI.rssOwlGui.getArchiveManager().getArchive().cleanUpItem(this.rssChannel.getLink(), this.rssChannel.getItems());
            }
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Channel getRSSChannel() {
        return this.rssChannel;
    }

    private void initXMLParser() throws NewsfeedFactoryException {
        if (this.document != null) {
            this.parser = new FeedParser(this.document, this.rssUrl);
        }
    }

    private Document openRSSFromLocal(SAXBuilder sAXBuilder, boolean bl) throws NewsfeedFactoryException {
        try {
            this.document = !bl ? sAXBuilder.build(new File(this.rssUrl)) : sAXBuilder.build(new InputStreamReader(new FileInputStream(this.rssUrl)));
        }
        catch (JDOMException jDOMException) {
            throw new NewsfeedFactoryException(this.rssUrl, jDOMException.getMessage(), null, 2);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            if (!bl) {
                return this.openRSSFromLocal(sAXBuilder, true);
            }
            throw new NewsfeedFactoryException(this.rssUrl, uTFDataFormatException.getMessage(), null, 2);
        }
        catch (IOException iOException) {
            throw new NewsfeedFactoryException(this.rssUrl, iOException.getMessage(), null, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NewsfeedFactoryException(this.rssUrl, illegalArgumentException.getMessage(), null, 2);
        }
        return this.document;
    }

    void initXmlDocument(boolean bl) throws NewsfeedFactoryException {
        block16: {
            SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            sAXBuilder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            this.document = null;
            XMLShop.setDefaultEntityResolver(sAXBuilder);
            if (new File(this.rssUrl).exists()) {
                this.document = this.openRSSFromLocal(sAXBuilder, false);
            } else {
                ConnectionManager connectionManager = new ConnectionManager(this.rssUrl);
                try {
                    connectionManager.connect();
                    InputStream inputStream = connectionManager.getInputStream();
                    if (inputStream == null) {
                        return;
                    }
                    this.document = !bl ? sAXBuilder.build(inputStream) : sAXBuilder.build(new InputStreamReader(inputStream));
                }
                catch (JDOMParseException jDOMParseException) {
                    throw new NewsfeedFactoryException(this.rssUrl, jDOMParseException.getMessage(), null, 2);
                }
                catch (JDOMException jDOMException) {
                    throw new NewsfeedFactoryException(this.rssUrl, jDOMException.getMessage(), null, 2);
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    if (!bl) {
                        this.initXmlDocument(true);
                        break block16;
                    }
                    throw new NewsfeedFactoryException(this.rssUrl, uTFDataFormatException.getMessage(), null, 2);
                }
                catch (IOException iOException) {
                    if (iOException.getMessage() != null && iOException.getMessage().equals("401")) {
                        throw new NewsfeedFactoryException(this.rssUrl, null, connectionManager.getStatusLine(), 1);
                    }
                    throw new NewsfeedFactoryException(this.rssUrl, iOException.getMessage(), connectionManager.getStatusLine(), 0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new NewsfeedFactoryException(this.rssUrl, illegalArgumentException.getMessage(), null, 2);
                }
                finally {
                    connectionManager.closeConnection();
                }
            }
        }
    }
}

