/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.util.shop.StringShop;

public class NewsfeedFactoryException
extends Exception {
    public static final int ERROR_AUTH_REQUIRED = 1;
    public static final int ERROR_FILE_NOT_FOUND = 0;
    public static final int ERROR_INVALID_NEWSFEED = 3;
    public static final int ERROR_INVALID_XML = 2;
    public static final int ERROR_WORKING_OFFLINE = 4;
    static final long serialVersionUID = 3256440292004541489L;
    private String httpStatus;
    private String msg;
    private String reason;
    private String title;
    private int type;
    private String url;

    public NewsfeedFactoryException(String string, String string2, String string3, int n) {
        this.url = string;
        this.reason = string2;
        this.httpStatus = string3;
        this.type = n;
        this.msg = GUI.i18n.getTranslation("ERROR_NEWSFEED_GENERAL");
        if (string != null) {
            this.title = Category.getTitleForLink(string);
        }
    }

    public String getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.msg);
        if (this.getReason() != null) {
            stringBuffer.append("\n\n");
            stringBuffer.append(GUI.i18n.getTranslation("ERROR_REASON"));
            stringBuffer.append(": ");
            stringBuffer.append(this.getReason());
        }
        if (this.getHttpStatus() != null) {
            stringBuffer.append("\n");
            stringBuffer.append(GUI.i18n.getTranslation("ERROR_HTTP_STATUS"));
            stringBuffer.append(": ");
            stringBuffer.append(this.getHttpStatus());
        }
        return stringBuffer.toString();
    }

    public String getMsg() {
        return this.msg;
    }

    public String getReason() {
        String string = null;
        switch (this.type) {
            case 0: {
                string = GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND");
                break;
            }
            case 1: {
                string = GUI.i18n.getTranslation("ERROR_AUTH_REQUIRED");
                break;
            }
            case 2: {
                string = GUI.i18n.getTranslation("ERROR_NOT_A_XML");
                break;
            }
            case 3: {
                string = GUI.i18n.getTranslation("ERROR_NOT_A_RSS");
                break;
            }
            case 4: {
                string = GUI.i18n.getTranslation("ERROR_WORKING_OFFLINE");
            }
        }
        if (StringShop.isset(this.reason) && this.reason.indexOf(" ") < 0) {
            string = string + " (" + this.reason + ")";
        } else if (StringShop.isset(this.reason) && this.reason.indexOf(" ") >= 0) {
            string = string + ". " + this.reason;
        }
        return string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }
}

