/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.ToolBarDialog;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class SettingsSaver {
    private Document document;
    private Element root;
    private GUI rssOwlGui;

    public SettingsSaver(GUI gUI) {
        this.rssOwlGui = gUI;
        this.root = new Element("rssowl");
        this.document = new Document(this.root);
    }

    public synchronized void saveUserSettings(boolean bl) {
        Content content;
        if (!bl) {
            content = new Comment(" XML generated by RSSOwl (http://www.rssowl.org) on " + DateParser.formatDate(new Date(), true) + " ");
            this.document.getContent().add(0, content);
        }
        content = new Element("favorites");
        this.root.addContent(content);
        Hashtable hashtable = Category.getRootCategory().getSubCategories();
        this.saveFavoritesOrCategorys(hashtable, (Element)content);
        if (!bl) {
            this.saveSashWeights();
        }
        this.saveShellBounds();
        this.saveProxySettings();
        this.saveSortOrder(GlobalSettings.sortOrder);
        if (!GlobalSettings.toolBarItems.equals(ToolBarDialog.getDefaultToolBarItems())) {
            this.saveValue("toolBarItems", "value", GlobalSettings.toolBarItems);
        }
        if (!GlobalSettings.useSmallIcons) {
            this.saveBoolean("useSmallIcons", GlobalSettings.useSmallIcons);
        }
        if (GlobalSettings.toolBarMode != 0) {
            this.saveValue("toolBarMode", "value", String.valueOf(GlobalSettings.toolBarMode));
        }
        if (!GlobalSettings.confirmFavoriteDeletion) {
            this.saveBoolean("confirmFavoriteDeletion", GlobalSettings.confirmFavoriteDeletion);
        }
        if (!GlobalSettings.confirmCategoryDeletion) {
            this.saveBoolean("confirmCategoryDeletion", GlobalSettings.confirmCategoryDeletion);
        }
        if (!GlobalSettings.confirmBlogrollDeletion) {
            this.saveBoolean("confirmBlogrollDeletion", GlobalSettings.confirmBlogrollDeletion);
        }
        if (GlobalSettings.maxConnectionCount != 32) {
            this.saveValue("maxConnectionCount", "value", String.valueOf(GlobalSettings.maxConnectionCount));
        }
        if (GlobalSettings.connectionTimeout != 30) {
            this.saveValue("connectionTimeout", "value", String.valueOf(GlobalSettings.connectionTimeout));
        }
        if (!GlobalSettings.isQuickviewShown) {
            this.saveBoolean("isQuickviewShown", GlobalSettings.isQuickviewShown);
        }
        if (!GlobalSettings.isToolBarShown) {
            this.saveBoolean("isToolBarShown", GlobalSettings.isToolBarShown);
        }
        if (!GlobalSettings.isTreeToolBarShown) {
            this.saveBoolean("isTreeToolBarShown", GlobalSettings.isTreeToolBarShown);
        }
        if (!GlobalSettings.isFavoritesTreeShown) {
            this.saveBoolean("isFavoritesTreeShown", GlobalSettings.isFavoritesTreeShown);
        }
        if (!GlobalSettings.isWelcomeShown) {
            this.saveBoolean("isWelcomeShown", GlobalSettings.isWelcomeShown);
        }
        if (GlobalSettings.linkTreeWithTab) {
            this.saveBoolean("linkTreeWithTab", GlobalSettings.linkTreeWithTab);
        }
        if (!GlobalSettings.showErrors) {
            this.saveBoolean("showErrors", GlobalSettings.showErrors);
        }
        if (!GlobalSettings.autoSortNews) {
            this.saveBoolean("autoSortNews", GlobalSettings.autoSortNews);
        }
        if (!GlobalSettings.autoCloseNewsPopup) {
            this.saveBoolean("autoCloseNewsPopup", GlobalSettings.autoCloseNewsPopup);
        }
        if (!GlobalSettings.animateNewsPopup) {
            this.saveBoolean("animateNewsPopup", GlobalSettings.animateNewsPopup);
        }
        if (!GlobalSettings.tabPositionIsTop) {
            this.saveBoolean("tabPositionIsTop", GlobalSettings.tabPositionIsTop);
        }
        if (!GlobalSettings.showTabCloseButton) {
            this.saveBoolean("showTabCloseButton", GlobalSettings.showTabCloseButton);
        }
        if (!GlobalSettings.blockPopups && !GlobalSettings.isLinux()) {
            this.saveBoolean("blockPopups", GlobalSettings.blockPopups);
        }
        if (GlobalSettings.workOffline) {
            this.saveBoolean("workOffline", GlobalSettings.workOffline);
        }
        if (GlobalSettings.reopenFeeds) {
            this.saveBoolean("reopenFeeds", GlobalSettings.reopenFeeds);
        }
        if (!GlobalSettings.simpleTabs) {
            this.saveBoolean("simpleTabs", GlobalSettings.simpleTabs);
        }
        if (GlobalSettings.displaySingleTab) {
            this.saveBoolean("displaySingleTab", GlobalSettings.displaySingleTab);
        }
        if (!GlobalSettings.localCacheFeeds) {
            this.saveBoolean("localCacheFeeds", GlobalSettings.localCacheFeeds);
        }
        if (GlobalSettings.isDoubleClickOpen == GlobalSettings.useSingleClickOpen()) {
            this.saveBoolean("isDoubleClickOpen", GlobalSettings.isDoubleClickOpen);
        }
        if (!GlobalSettings.showTrayPopup) {
            this.saveBoolean("showTrayPopup", GlobalSettings.showTrayPopup);
        }
        if (GlobalSettings.directOpenNews) {
            this.saveBoolean("isDirectOpenNews", GlobalSettings.directOpenNews);
        }
        if (GlobalSettings.favDefaultOpenOnStartup) {
            this.saveBoolean("favDefaultOpenOnStartup", GlobalSettings.favDefaultOpenOnStartup);
        }
        if (GlobalSettings.favDefaultReloadOnStartup) {
            this.saveBoolean("favDefaultReloadOnStartup", GlobalSettings.favDefaultReloadOnStartup);
        }
        if (GlobalSettings.favDefaultAutoReloadInterval != 60) {
            this.saveValue("favDefaultAutoReloadInterval", "value", String.valueOf(GlobalSettings.favDefaultAutoReloadInterval));
        }
        if (GlobalSettings.showSystrayIcon) {
            this.saveBoolean("showSystrayIcon", GlobalSettings.showSystrayIcon);
        }
        if (!GlobalSettings.setProxyForAllFavorites) {
            this.saveBoolean("setProxyForAllFavorites", GlobalSettings.setProxyForAllFavorites);
        }
        if (GlobalSettings.markAllReadOnMinimize) {
            this.saveBoolean("markAllReadOnMinimize", GlobalSettings.markAllReadOnMinimize);
        }
        if (GlobalSettings.markFeedReadOnTabClose) {
            this.saveBoolean("markFeedReadOnTabClose", GlobalSettings.markFeedReadOnTabClose);
        }
        if (!GlobalSettings.showChannelInfo) {
            this.saveBoolean("showChannelInfo", GlobalSettings.showChannelInfo);
        }
        if (GlobalSettings.directOpenEachNews) {
            this.saveBoolean("directOpenEachNews", GlobalSettings.directOpenEachNews);
        }
        if (!GlobalSettings.openNewBrowserWindow) {
            this.saveBoolean("openNewBrowserWindow", GlobalSettings.openNewBrowserWindow);
        }
        this.saveBoolean("openBrowserExtern", GlobalSettings.openBrowserExtern);
        if (!GlobalSettings.focusNewTabs) {
            this.saveBoolean("focusNewTabs", GlobalSettings.focusNewTabs);
        }
        if (!GlobalSettings.checkUpdate) {
            this.saveBoolean("checkUpdate", GlobalSettings.checkUpdate);
        }
        if (GlobalSettings.trayOnExit) {
            this.saveBoolean("trayOnExit", GlobalSettings.trayOnExit);
        }
        if (GlobalSettings.trayOnStartup) {
            this.saveBoolean("trayOnStartup", GlobalSettings.trayOnStartup);
        }
        if (GlobalSettings.useInternalBrowser()) {
            this.saveBoolean("useBrowserForNewsText", GlobalSettings.useBrowserForNewsText);
        }
        if (!GlobalSettings.htmlFormatMail) {
            this.saveBoolean("htmlFormatMail", GlobalSettings.htmlFormatMail);
        }
        if (GlobalSettings.isThreeColumnGUI) {
            this.saveBoolean("isThreeColumnGUI", GlobalSettings.isThreeColumnGUI);
        }
        this.saveValue("language", "value", Dictionary.selectedLanguage);
        if (!GlobalSettings.bloggerPath.equals("")) {
            this.saveValue("bloggerPath", "value", GlobalSettings.bloggerPath);
        }
        if (!GlobalSettings.bloggerArguments.equals("")) {
            this.saveValue("bloggerArguments", "value", GlobalSettings.bloggerArguments);
        }
        if (!GlobalSettings.linkColor.equals(new RGB(0, 0, 255))) {
            this.saveColor("linkColor", GlobalSettings.linkColor);
        }
        if (!GlobalSettings.syntaxHighlightColor.equals(new RGB(255, 255, 0))) {
            this.saveColor("syntaxHighlightColor", GlobalSettings.syntaxHighlightColor);
        }
        this.saveFont("textfont", FontShop.textFont);
        this.saveFont("treefont", FontShop.treeFont);
        this.saveFont("tablefont", FontShop.tableFont);
        this.saveFont("headerfont", FontShop.headerFont);
        this.saveFont("dialogfont", FontShop.dialogFont);
        if (!GlobalSettings.charEncoding.equals("UTF-8")) {
            this.saveValue("encoding", "name", GlobalSettings.charEncoding);
        }
        if (!GlobalSettings.customBrowser.equals("")) {
            this.saveValue("customBrowser", "path", GlobalSettings.customBrowser);
        }
        if (!GlobalSettings.customBrowserArguments.equals("")) {
            this.saveValue("customBrowserArguments", "value", GlobalSettings.customBrowserArguments);
        }
        this.saveHotkeys();
        if (!GlobalSettings.mailSubject.equals("RSSOwl NewsTip: [TITLE]")) {
            this.saveValue("mailSubject", GlobalSettings.mailSubject);
        }
        if (!GlobalSettings.mailBody.equals(GUI.i18n.getTranslation("LABEL_TITLE") + ": [TITLE]\nURL: [LINK]")) {
            this.saveValue("mailBody", GlobalSettings.mailBody);
        }
        this.saveValue("treeSelection", GlobalSettings.selectedTreeItem);
        if (GlobalSettings.reopenFeeds) {
            this.saveReopenFeeds(GUI.rssOwlGui.getRSSOwlNewsTabFolder().getLastOpenedFeeds());
        }
        XMLShop.writeXML(this.document, GlobalSettings.RSSOWL_SETTINGS_FILE);
    }

    private void saveBoolean(String string, boolean bl) {
        Element element = new Element(string);
        this.root.addContent(element);
        element.setAttribute("value", String.valueOf(bl));
    }

    private void saveColor(String string, RGB rGB) {
        Element element = new Element(string);
        this.root.addContent(element);
        element.setAttribute("red", String.valueOf(rGB.red));
        element.setAttribute("green", String.valueOf(rGB.green));
        element.setAttribute("blue", String.valueOf(rGB.blue));
    }

    private void saveFont(String string, Font font) {
        if (FontShop.isset(font)) {
            Element element = new Element(string);
            this.root.addContent(element);
            element.setAttribute("name", font.getFontData()[0].getName());
            element.setAttribute("height", String.valueOf(font.getFontData()[0].getHeight()));
            element.setAttribute("style", String.valueOf(font.getFontData()[0].getStyle()));
        }
    }

    private void saveHotkeys() {
        Element element = new Element("hotkeys");
        this.root.addContent(element);
        Enumeration enumeration = HotkeyShop.hotKeys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Element element2 = new Element(string);
            element2.setAttribute("keyName", HotkeyShop.getHotkeyName(string));
            element2.setAttribute("keyInt", String.valueOf(HotkeyShop.getHotkeyValue(string)));
            element.addContent(element2);
        }
    }

    private void saveProxySettings() {
        Element element = new Element("proxy");
        this.root.addContent(element);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        Enumeration enumeration = ProxyShop.proxySettings.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string.equals("username")) {
                object = (String)ProxyShop.proxySettings.get(string);
                if (StringShop.isset((String)object)) {
                    cryptoManager.addItem("PROXY_USER_KEY", (String)object);
                    continue;
                }
                cryptoManager.removeItem("PROXY_USER_KEY");
                continue;
            }
            if (string.equals("password")) {
                object = (String)ProxyShop.proxySettings.get(string);
                if (StringShop.isset((String)object)) {
                    cryptoManager.addItem("PROXY_PASSWORD_KEY", (String)object);
                    continue;
                }
                cryptoManager.removeItem("PROXY_PASSWORD_KEY");
                continue;
            }
            if (string.equals("domain")) {
                object = (String)ProxyShop.proxySettings.get(string);
                if (StringShop.isset((String)object)) {
                    cryptoManager.addItem("PROXY_DOMAIN_KEY", (String)object);
                    continue;
                }
                cryptoManager.removeItem("PROXY_DOMAIN_KEY");
                continue;
            }
            object = new Element(string);
            ((Element)object).setText((String)ProxyShop.proxySettings.get(string));
            element.addContent((Content)object);
        }
    }

    private void saveRatings() {
        Hashtable hashtable = AmphetaRateThread.getRatings();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Element element = new Element("rating");
            element.setAttribute("key", string);
            element.setText((String)hashtable.get(string));
            this.root.addContent(element);
        }
    }

    private void saveReopenFeeds(Vector vector) {
        Element element = new Element("reopenFeedsList");
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = new Element("feed");
            element2.setAttribute("url", (String)vector.get(i));
            element.addContent(element2);
        }
        this.root.addContent(element);
    }

    private void saveSashWeights() {
        int n;
        String string;
        int[] nArray;
        Element element;
        if (WidgetShop.isset(this.rssOwlGui.getContentSash())) {
            element = new Element("sashweight");
            element.setAttribute("name", "holdContentSash");
            nArray = this.rssOwlGui.getContentSash().getWeights();
            string = String.valueOf(nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                string = string + ',' + String.valueOf(nArray[n]);
            }
            element.setAttribute("weight", string);
            this.root.addContent(element);
        }
        if (WidgetShop.isset(this.rssOwlGui.getNewsSash())) {
            element = new Element("sashweight");
            element.setAttribute("name", "holdNewsSash");
            nArray = this.rssOwlGui.getNewsSash().getWeights();
            string = String.valueOf(nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                string = string + ',' + String.valueOf(nArray[n]);
            }
            element.setAttribute("weight", string);
            this.root.addContent(element);
        }
    }

    private void saveShellBounds() {
        Element element = new Element("shell");
        this.root.addContent(element);
        if (!GlobalSettings.isMac()) {
            element.setAttribute("maximized", String.valueOf(GlobalSettings.isShellMaximized).toLowerCase());
        }
        if (GlobalSettings.shellBounds != null) {
            Rectangle rectangle = GlobalSettings.shellBounds;
            element.setAttribute("height", String.valueOf(rectangle.height));
            element.setAttribute("width", String.valueOf(rectangle.width));
            element.setAttribute("x", String.valueOf(rectangle.x));
            element.setAttribute("y", String.valueOf(rectangle.y));
        }
    }

    private void saveSortOrder(ArrayList arrayList) {
        Element element = new Element("sortOrder");
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element2 = new Element((String)arrayList.get(i));
            element2.setAttribute("level", String.valueOf(i));
            element.addContent(element2);
        }
        this.root.addContent(element);
    }

    private void saveValue(String string, String string2) {
        this.saveValue(string, null, string2);
    }

    private void saveValue(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        Element element = new Element(string);
        this.root.addContent(element);
        if (string2 != null) {
            element.setAttribute(string2, string3);
        } else {
            element.setText(string3);
        }
    }

    void saveFavoritesOrCategorys(Hashtable hashtable, Element element) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Element element2;
            Category category = (Category)enumeration.nextElement();
            if (!category.isBlogroll()) {
                element2 = new Element("category");
                element2.setAttribute("name", category.getName());
                if (category.isExpanded()) {
                    element2.setAttribute("isExpanded", String.valueOf(category.isExpanded()));
                }
                element.addContent(element2);
                this.saveFavoritesOrCategorys(category.getSubCategories(), element2);
                Hashtable hashtable2 = category.getFavorites();
                Enumeration enumeration2 = hashtable2.elements();
                while (enumeration2.hasMoreElements()) {
                    Favorite favorite = (Favorite)enumeration2.nextElement();
                    Element element3 = new Element("link");
                    element3.setText(favorite.getUrl());
                    element3.setAttribute("title", favorite.getTitle());
                    if (favorite.isErrorLoading()) {
                        element3.setAttribute("errorLoading", String.valueOf(favorite.isErrorLoading()));
                    }
                    if (favorite.isLoadOnStartup()) {
                        element3.setAttribute("loadOnStartup", String.valueOf(favorite.isLoadOnStartup()));
                    }
                    if (favorite.isOpenOnStartup()) {
                        element3.setAttribute("openOnStartup", String.valueOf(favorite.isOpenOnStartup()));
                    }
                    if (favorite.isUseProxy()) {
                        element3.setAttribute("useproxy", String.valueOf(favorite.isUseProxy()));
                    }
                    if (favorite.getUpdateInterval() != 0) {
                        element3.setAttribute("updateInterval", String.valueOf(favorite.getUpdateInterval()));
                    }
                    if (favorite.getUnreadNewsCount() > 0) {
                        element3.setAttribute("new", String.valueOf(favorite.getUnreadNewsCount()));
                    }
                    if (StringShop.isset(favorite.getDescription())) {
                        element3.setAttribute("description", favorite.getDescription());
                    }
                    if (StringShop.isset(favorite.getLanguage())) {
                        element3.setAttribute("language", favorite.getLanguage());
                    }
                    if (StringShop.isset(favorite.getHomepage())) {
                        element3.setAttribute("homepage", favorite.getHomepage());
                    }
                    element3.setAttribute("creationDate", favorite.getCreationDate() != 0L ? String.valueOf(favorite.getCreationDate()) : String.valueOf(new Date().getTime()));
                    element3.setAttribute("lastVisitDate", String.valueOf(favorite.getLastVisitDate()));
                    element2.addContent(element3);
                }
                continue;
            }
            element2 = new Element("category");
            element2.setAttribute("name", category.getName());
            element2.setAttribute("useproxy", String.valueOf(category.isUseProxy()));
            element2.setAttribute("url", category.getPathToBlogroll());
            element.addContent(element2);
        }
    }
}

