/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao.feedparser;

import java.util.List;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public abstract class AbstractFeedParser {
    protected Namespace content;
    protected Namespace dc;
    protected Namespace defNs;
    protected Document document;
    protected Namespace rdf;
    protected Element root;
    protected Channel rssChannel;
    protected Namespace sy;
    protected String url;

    protected AbstractFeedParser(Document document, Channel channel, String string) throws NewsfeedFactoryException {
        this.document = document;
        this.rssChannel = channel;
        this.url = string;
        channel.setLink(string);
        channel.setDocument(document);
        if (document == null) {
            throw new NewsfeedFactoryException(string, null, null, 2);
        }
        this.parseRoot();
        if (this.root == null) {
            throw new NewsfeedFactoryException(string, null, null, 2);
        }
        this.parseAvailableNamespaces();
    }

    protected AbstractFeedParser(Document document, Channel channel, String string, Namespace[] namespaceArray) throws NewsfeedFactoryException {
        this.document = document;
        this.rssChannel = channel;
        this.url = string;
        channel.setLink(string);
        channel.setDocument(document);
        if (namespaceArray.length == 5) {
            this.content = namespaceArray[0];
            this.dc = namespaceArray[1];
            this.defNs = namespaceArray[2];
            this.rdf = namespaceArray[3];
            this.sy = namespaceArray[4];
        }
        this.parseRoot();
        if (this.root == null) {
            throw new NewsfeedFactoryException(string, null, null, 2);
        }
    }

    private void parseAvailableNamespaces() {
        this.defNs = Namespace.NO_NAMESPACE;
        Namespace namespace = this.root.getNamespace();
        if (namespace.getPrefix().equals("rdf")) {
            this.rdf = namespace;
        } else if (namespace.getPrefix().equals("sy")) {
            this.sy = namespace;
        } else if (namespace.getPrefix().equals("dc")) {
            this.dc = namespace;
        } else if (namespace.getPrefix().equals("content")) {
            this.content = namespace;
        } else if (namespace.getPrefix().equals("")) {
            this.defNs = namespace;
        }
        for (Namespace namespace2 : this.root.getAdditionalNamespaces()) {
            if (namespace2.getPrefix().equalsIgnoreCase("dc")) {
                this.dc = namespace2;
                continue;
            }
            if (namespace2.getPrefix().equalsIgnoreCase("sy")) {
                this.sy = namespace2;
                continue;
            }
            if (namespace2.getPrefix().equalsIgnoreCase("rdf")) {
                this.rdf = namespace2;
                continue;
            }
            if (namespace2.getPrefix().equalsIgnoreCase("content")) {
                this.content = namespace2;
                continue;
            }
            if (!namespace2.getPrefix().equalsIgnoreCase("")) continue;
            this.defNs = namespace2;
        }
    }

    private void parseRoot() throws NewsfeedFactoryException {
        try {
            this.root = this.document.getRootElement();
        }
        catch (IllegalStateException illegalStateException) {
            throw new NewsfeedFactoryException(this.url, null, null, 2);
        }
    }

    protected String getAttributeValue(Element element, String string) {
        if (element == null) {
            return null;
        }
        String string2 = element.getAttributeValue(string);
        if (string2 != null) {
            return string2;
        }
        return this.getAttributeValue(element, string, this.defNs);
    }

    protected String getAttributeValue(Element element, String string, Namespace namespace) {
        if (element == null) {
            return null;
        }
        return element.getAttributeValue(string, namespace);
    }

    protected Element getChildElement(Element element, String string) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild(string);
        if (element2 != null) {
            return element2;
        }
        return this.getChildElement(element, string, this.defNs);
    }

    protected Element getChildElement(Element element, String string, Namespace namespace) {
        if (element == null) {
            return null;
        }
        return element.getChild(string, namespace);
    }

    protected List getChildren(Element element, String string) {
        if (element == null) {
            return null;
        }
        List list = element.getChildren(string);
        if (!list.isEmpty()) {
            return list;
        }
        return this.getChildren(element, string, this.defNs);
    }

    protected List getChildren(Element element, String string, Namespace namespace) {
        if (element == null) {
            return null;
        }
        return element.getChildren(string, namespace);
    }

    protected String getChildValue(String string, Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild(string);
        if (element2 != null) {
            return element2.getTextTrim();
        }
        return this.getChildValue(string, element, this.defNs);
    }

    protected String getChildValue(String string, Element element, Namespace namespace) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild(string, namespace);
        if (element2 != null) {
            return element2.getTextTrim();
        }
        return null;
    }

    protected abstract void parse() throws NewsfeedFactoryException;

    protected void parseContentModule(Element element, NewsItem newsItem) {
        String string;
        if (this.content != null && StringShop.isset(string = this.getChildValue("encoded", element, this.content))) {
            newsItem.setDescription(string);
        }
    }

    protected void parseDCModule(Element element, NewsItem newsItem) {
        if (this.dc != null) {
            String string = this.getChildValue("title", element, this.dc);
            if (StringShop.isset(string)) {
                newsItem.setTitle(string);
            }
            if (StringShop.isset(string = this.getChildValue("description", element, this.dc))) {
                newsItem.setDescription(string);
            }
            if ((newsItem.getTitle() == null || newsItem.getTitle().equals("")) && newsItem.getDescription() != null) {
                newsItem.setTitle(newsItem.getDescription(), true);
            }
            if (StringShop.isset(string = this.getChildValue("date", element, this.dc))) {
                newsItem.setPubDate(string, true);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBDATE");
            }
            if (StringShop.isset(string = this.getChildValue("publisher", element, this.dc))) {
                newsItem.setPublisher(string);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBLISHER");
            }
            if (StringShop.isset(string = this.getChildValue("creator", element, this.dc))) {
                newsItem.setAuthor(string);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_AUTHOR");
            }
            if (StringShop.isset(string = this.getChildValue("source", element, this.dc))) {
                newsItem.setSource(string);
            }
            if (StringShop.isset(string = this.getChildValue("subject", element, this.dc))) {
                newsItem.setCategory(string);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_CATEGORY");
            }
        } else {
            List list = element.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                boolean bl = element2.getNamespacePrefix().equals("dc");
                if (!bl) continue;
                if (element2.getName().equals("title") && !element2.getValue().equals("")) {
                    newsItem.setTitle(element2.getValue());
                }
                if (element2.getName().equals("description") && !element2.getValue().equals("")) {
                    newsItem.setDescription(Text.normalizeString(element2.getValue()));
                }
                if ((newsItem.getTitle() == null || newsItem.getTitle().equals("")) && newsItem.getDescription() != null) {
                    newsItem.setTitle(newsItem.getDescription(), true);
                }
                if (element2.getName().equals("date") && !element2.getValue().equals("")) {
                    newsItem.setPubDate(element2.getValue(), true);
                    this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBDATE");
                }
                if (element2.getName().equals("publisher") && !element2.getValue().equals("")) {
                    newsItem.setPublisher(element2.getValue());
                    this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBLISHER");
                }
                if (element2.getName().equals("source") && !element2.getValue().equals("")) {
                    newsItem.setSource(element2.getValue());
                }
                if (element2.getName().equals("creator") && !element2.getValue().equals("")) {
                    newsItem.setAuthor(element2.getValue());
                    this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_AUTHOR");
                }
                if (!element2.getName().equals("subject") || element2.getValue().equals("")) continue;
                newsItem.setCategory(element2.getValue());
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_CATEGORY");
            }
        }
    }
}

