/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao.feedparser;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.AbstractFeedParser;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.ChannelImage;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

public class Atom_1_0_Parser
extends AbstractFeedParser {
    private static final Namespace xhtml = Namespace.getNamespace("http://www.w3.org/1999/xhtml");

    public Atom_1_0_Parser(Document document, Channel channel, String string, Namespace[] namespaceArray) throws NewsfeedFactoryException {
        super(document, channel, string, namespaceArray);
    }

    private String resolve(URI uRI, String string) {
        if (uRI == null || !StringShop.isset(string)) {
            return string;
        }
        try {
            return uRI.resolve(string).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    protected String getChildText(String string, Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = this.getChildElement(element, string);
        if (element2 == null) {
            return this.getChildValue(string, element);
        }
        String string2 = this.getAttributeValue(element2, "type");
        if (string2 == null || "text".equals(string2)) {
            return this.getChildValue(string, element);
        }
        if ("html".equals(string2)) {
            return this.getChildValue(string, element);
        }
        if ("xhtml".equals(string2)) {
            Element element3 = this.getChildElement(element2, "div", xhtml);
            if (element3 == null) {
                element3 = this.getChildElement(element2, "body", xhtml);
            }
            if (element3 != null) {
                XMLOutputter xMLOutputter = new XMLOutputter();
                StringWriter stringWriter = new StringWriter();
                try {
                    xMLOutputter.output(element3, (Writer)stringWriter);
                    stringWriter.close();
                }
                catch (IOException iOException) {
                    GUI.logger.log("parseAtomVersion_0_3()", iOException);
                }
                String string3 = stringWriter.toString();
                if (string3.indexOf("<![CDATA[") >= 0) {
                    string3 = StringShop.replaceAll(string3, "<![CDATA[", "");
                    string3 = StringShop.replaceAll(string3, "]]>", "");
                }
                return string3;
            }
        }
        return this.getChildValue(string, element);
    }

    @Override
    protected void parse() {
        Element element;
        Object object;
        Object object2;
        Object object3;
        String string = this.getAttributeValue(this.root, "lang", Namespace.XML_NAMESPACE);
        if (StringShop.isset(string)) {
            this.rssChannel.setLanguage(string);
        }
        string = this.getAttributeValue(this.root, "base", Namespace.XML_NAMESPACE);
        URI uRI = null;
        if (StringShop.isset(string)) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (StringShop.isset(string = this.getChildText("title", this.root))) {
            this.rssChannel.setTitle(Text.normalizeString(StringShop.stripTags(string)));
        }
        List list = this.getChildren(this.root, "link");
        for (int i = 0; list != null && i < list.size(); ++i) {
            object3 = (Element)list.get(i);
            object2 = this.getAttributeValue((Element)object3, "rel");
            if (object2 == null || ((String)object2).equals("alternate") || i == list.size() - 1) {
                this.rssChannel.setHomepage(this.resolve(uRI, this.getAttributeValue((Element)object3, "href")));
                continue;
            }
            if (!"self".equals(object2) || uRI != null || !StringShop.isset((String)(object = this.getAttributeValue((Element)object3, "href")))) continue;
            try {
                uRI = new URI((String)object);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        string = this.getChildText("subtitle", this.root);
        if (StringShop.isset(string)) {
            this.rssChannel.setDescription(Text.normalizeString(StringShop.stripTags(string)));
        }
        if (StringShop.isset(string = this.getChildValue("updated", this.root))) {
            this.rssChannel.setPubDate(string);
        }
        if ((element = this.getChildElement(this.root, "author")) != null && StringShop.isset(string = this.getChildValue("name", element))) {
            this.rssChannel.setCreator(string);
        }
        if (StringShop.isset(string = this.getChildValue("generator", this.root))) {
            this.rssChannel.setGenerator(string);
        }
        if (StringShop.isset(string = this.getChildValue("logo", this.root)) && RegExShop.isValidURL(string)) {
            object3 = new ChannelImage();
            ((ChannelImage)object3).setImgUrl(this.resolve(uRI, string));
            ((ChannelImage)object3).setLink(this.rssChannel.getHomepage());
            this.rssChannel.setImage((ChannelImage)object3);
        }
        if (StringShop.isset(string = this.getChildValue("rights", this.root))) {
            this.rssChannel.setCopyright(string);
        }
        object3 = this.getChildren(this.root, "entry");
        object2 = object3.iterator();
        while (object2.hasNext()) {
            Element element2;
            Object object4;
            Element element3;
            object = (Element)object2.next();
            NewsItem newsItem = new NewsItem();
            string = this.getAttributeValue((Element)object, "base", Namespace.XML_NAMESPACE);
            URI uRI2 = null;
            if (StringShop.isset(string)) {
                try {
                    uRI2 = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (uRI != null && uRI2 != null) {
                uRI2 = uRI.resolve(uRI2);
            } else if (uRI != null) {
                uRI2 = uRI;
            }
            if (uRI2 != null) {
                newsItem.setBaseUri(uRI2.toString());
            }
            if (StringShop.isset(string = this.getChildText("title", (Element)object))) {
                newsItem.setTitle(string);
            }
            List list2 = this.getChildren((Element)object, "link");
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                element3 = (Element)list2.get(i);
                object4 = this.getAttributeValue(element3, "rel");
                if (object4 == null || ((String)object4).equals("alternate")) {
                    newsItem.setLink(this.resolve(uRI2, this.getAttributeValue(element3, "href")));
                    continue;
                }
                if (!"enclosure".equals(object4)) continue;
                String string2 = this.getAttributeValue(element3, "type");
                String string3 = this.getAttributeValue(element3, "length");
                String string4 = this.resolve(uRI2, this.getAttributeValue(element3, "href"));
                Enclosure enclosure = new Enclosure();
                enclosure.setType(string2);
                enclosure.setLength(string3);
                enclosure.setUrl(string4);
                newsItem.insertEnclosure(enclosure);
            }
            if (newsItem.getLink() == null && StringShop.isset(string = this.resolve(uRI2, this.getChildValue("id", (Element)object))) && RegExShop.isValidURL(string)) {
                newsItem.setLink(string);
            }
            if (StringShop.isset(string = this.getChildText("content", (Element)object))) {
                newsItem.setDescription(Text.normalizeString(string));
            }
            if (!StringShop.isset(newsItem.getDescription()) && StringShop.isset(string = this.getChildText("summary", (Element)object))) {
                newsItem.setDescription(Text.normalizeString(string));
            }
            if (!StringShop.isset(newsItem.getTitle()) && newsItem.getDescription() != null) {
                newsItem.setTitle(newsItem.getDescription(), true);
            }
            if (StringShop.isset(string = this.getChildValue("updated", (Element)object))) {
                newsItem.setPubDate(string, true);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBDATE");
            }
            if (newsItem.getPubDate() == null && StringShop.isset(string = this.getChildValue("published", (Element)object))) {
                newsItem.setPubDate(string, true);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_PUBDATE");
            }
            if ((element2 = this.getChildElement((Element)object, "author")) != null && StringShop.isset(string = this.getChildValue("name", element2))) {
                newsItem.setAuthor(string);
                this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_AUTHOR");
            }
            if ((element3 = this.getChildElement((Element)object, "category")) != null) {
                string = this.getAttributeValue(element3, "label");
                if (!StringShop.isset(string)) {
                    string = this.getAttributeValue(element3, "term");
                }
                if (StringShop.isset(string)) {
                    newsItem.setCategory(string);
                    this.rssChannel.addAvailableNewsItemInfo("TABLE_HEADER_CATEGORY");
                }
            }
            if ((object4 = this.getChildElement((Element)object, "source")) != null && StringShop.isset(string = this.getChildValue("id", (Element)object4))) {
                newsItem.setSource(string);
            }
            this.rssChannel.insertItem(newsItem);
        }
    }
}

