/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao.feedparser;

import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.AbstractFeedParser;
import net.sourceforge.rssowl.dao.feedparser.Atom_0_3_Parser;
import net.sourceforge.rssowl.dao.feedparser.Atom_1_0_Parser;
import net.sourceforge.rssowl.dao.feedparser.OPML_1_0_Parser;
import net.sourceforge.rssowl.dao.feedparser.RDF_1_0_Parser;
import net.sourceforge.rssowl.dao.feedparser.RSS_0_91_Parser;
import net.sourceforge.rssowl.dao.feedparser.RSS_0_92_Parser;
import net.sourceforge.rssowl.dao.feedparser.RSS_2_0_Parser;
import net.sourceforge.rssowl.model.Channel;
import org.jdom.Document;
import org.jdom.Namespace;

public class FeedParser
extends AbstractFeedParser {
    public static final int FEED_FORMAT_ATOM_0_3 = 4;
    public static final int FEED_FORMAT_ATOM_1_0 = 6;
    public static final int FEED_FORMAT_OPML_1_0 = 5;
    public static final int FEED_FORMAT_RDF_1_0 = 2;
    public static final int FEED_FORMAT_RSS_0_91 = 0;
    public static final int FEED_FORMAT_RSS_0_92 = 1;
    public static final int FEED_FORMAT_RSS_2_0 = 3;
    private static final String ATOM_1_0_NAMESPACE = "http://www.w3.org/2005/Atom";

    public FeedParser(Document document, String string) throws NewsfeedFactoryException {
        super(document, new Channel(), string);
    }

    public Channel getChannel() {
        return this.rssChannel;
    }

    public int getFeedFormat() {
        if (this.root.getName().equalsIgnoreCase("rdf")) {
            this.rssChannel.setFormat("RDF");
            return 2;
        }
        if (this.root.getName().equalsIgnoreCase("feed")) {
            if (this.root.getNamespace() != null && ATOM_1_0_NAMESPACE.equals(this.root.getNamespace().getURI())) {
                this.rssChannel.setFormat("Atom 1.0");
                return 6;
            }
            this.rssChannel.setFormat("Atom 0.3");
            return 4;
        }
        if (this.root.getName().equalsIgnoreCase("opml")) {
            this.rssChannel.setFormat("OPML");
            return 5;
        }
        String string = this.getAttributeValue(this.root, "version");
        if (string != null) {
            this.rssChannel.setFormat("RSS " + string);
            if (string.indexOf("0.91") >= 0) {
                return 0;
            }
            if (string.indexOf("0.92") >= 0) {
                return 1;
            }
            if (string.indexOf("1.0") >= 0) {
                return 2;
            }
            if (string.indexOf("2.0") >= 0) {
                return 3;
            }
        }
        this.rssChannel.setFormat("RSS 0.91");
        return 0;
    }

    @Override
    public void parse() throws NewsfeedFactoryException {
        Namespace[] namespaceArray = new Namespace[]{this.content, this.dc, this.defNs, this.rdf, this.sy};
        if (!this.checkFeedFormat()) {
            throw new NewsfeedFactoryException(this.url, null, null, 3);
        }
        int n = this.getFeedFormat();
        switch (n) {
            case 0: {
                new RSS_0_91_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 1: {
                new RSS_0_92_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 2: {
                new RDF_1_0_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 3: {
                new RSS_2_0_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 4: {
                new Atom_0_3_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 6: {
                new Atom_1_0_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
                break;
            }
            case 5: {
                new OPML_1_0_Parser(this.document, this.rssChannel, this.url, namespaceArray).parse();
            }
        }
    }

    private boolean checkFeedFormat() {
        if (this.document.getRootElement().getName().equalsIgnoreCase("rdf")) {
            return true;
        }
        if (this.document.getRootElement().getName().equalsIgnoreCase("rss")) {
            return true;
        }
        if (this.document.getRootElement().getName().equalsIgnoreCase("feed")) {
            return true;
        }
        return this.document.getRootElement().getName().equalsIgnoreCase("opml");
    }
}

