/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao.feedparser;

import java.util.List;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.AbstractFeedParser;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public class OPML_1_0_Parser
extends AbstractFeedParser {
    protected OPML_1_0_Parser(Document document, Channel channel, String string, Namespace[] namespaceArray) throws NewsfeedFactoryException {
        super(document, channel, string, namespaceArray);
    }

    private void parseBody(Element element) {
        List list = this.getChildren(element, "outline");
        for (Element element2 : list) {
            this.parseOutline(element2);
        }
    }

    private void parseHead(Element element) {
        String string = this.getChildValue("title", element);
        if (StringShop.isset(string)) {
            this.rssChannel.setTitle(Text.normalizeString(string));
        }
        if (StringShop.isset(string = this.getChildValue("dateCreated", element))) {
            this.rssChannel.setPubDate(string);
        }
        if (StringShop.isset(string = this.getChildValue("dateModified", element))) {
            this.rssChannel.setLastBuildDate(string);
        }
        if (StringShop.isset(string = this.getChildValue("ownerName", element))) {
            this.rssChannel.setManagingEditor(string);
        }
    }

    private void parseOutline(Element element) {
        NewsItem newsItem = new NewsItem();
        String string = this.getAttributeValue(element, "title");
        if (StringShop.isset(string)) {
            newsItem.setTitle(string);
        }
        if (StringShop.isset(string = this.getAttributeValue(element, "url"))) {
            newsItem.setLink(string);
        }
        if (!StringShop.isset(newsItem.getLink()) && StringShop.isset(string = this.getAttributeValue(element, "htmlUrl"))) {
            newsItem.setLink(string);
        }
        if (StringShop.isset(string = this.getAttributeValue(element, "xmlUrl"))) {
            newsItem.setOrigurl(string);
            newsItem.setSource(string);
        }
        if (StringShop.isset(string = this.getAttributeValue(element, "text"))) {
            newsItem.setDescription(string);
        }
        if (StringShop.isset(string = this.getAttributeValue(element, "description"))) {
            newsItem.setDescription(string);
        }
        if (!StringShop.isset(newsItem.getTitle()) && newsItem.getDescription() != null) {
            newsItem.setTitle(newsItem.getDescription(), true);
        }
        if (!StringShop.isset(newsItem.getTitle()) && StringShop.isset(newsItem.getLink())) {
            newsItem.setTitle(newsItem.getLink(), true);
        }
        if (StringShop.isset(newsItem.getTitle())) {
            this.rssChannel.insertItem(newsItem);
        }
        List list = this.getChildren(element, "outline");
        for (Element element2 : list) {
            this.parseOutline(element2);
        }
    }

    @Override
    protected void parse() throws NewsfeedFactoryException {
        Element element;
        Element element2 = this.getChildElement(this.root, "head");
        if (element2 != null) {
            this.parseHead(element2);
        }
        if ((element = this.getChildElement(this.root, "body")) == null) {
            throw new NewsfeedFactoryException(this.url, null, null, 3);
        }
        this.parseBody(element);
    }
}

