/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.widgets.TreeItem;

public class Category {
    private static Vector blogrolls = new Vector();
    private static Vector favLinks = new Vector();
    private static Hashtable favPool = new Hashtable();
    private static Vector favTitles = new Vector();
    private static Hashtable mapLinkToTitle = new Hashtable();
    private static Hashtable mapTitleToLink = new Hashtable();
    private static Category rootCategory = new Category("root", null, false);
    private Hashtable favorites;
    private boolean isBlogroll;
    private boolean isExpanded;
    private boolean isRoot;
    private boolean isUnSynchronized;
    private String name;
    private Category parent;
    private String pathToBlogroll;
    private TreeSet sortedLinkTitles;
    private TreeSet sortedSubCatTitles;
    private Hashtable subCategories;
    private TreeItem treeItem;
    private boolean useProxy;

    public Category(String string, Category category, boolean bl) {
        this.name = string;
        this.parent = category;
        this.isBlogroll = bl;
        this.favorites = new Hashtable();
        this.subCategories = new Hashtable();
        this.sortedLinkTitles = new TreeSet<Object>(Collator.getInstance());
        this.sortedSubCatTitles = new TreeSet<Object>(Collator.getInstance());
        this.isExpanded = false;
        this.isUnSynchronized = false;
        this.isRoot = category == null;
    }

    public static boolean blogrollExists(String string) {
        return string != null && blogrolls.contains(string);
    }

    public static void createRootCategory() {
        rootCategory = new Category("root", null, false);
    }

    public static String createUniqueLink(String string) {
        int n = 1;
        String string2 = string;
        while (Category.linkExists(string)) {
            string = string2 + '#' + n++;
        }
        return string;
    }

    public static String createUniqueTitle(String string) {
        int n = 1;
        String string2 = string;
        while (Category.titleExists(string)) {
            string = string2 + " #" + n++;
        }
        return string;
    }

    public static Category fromPath(String string) {
        Category category = Category.getRootCategory();
        if (StringShop.isset(string)) {
            String[] stringArray = string.split("=;=");
            for (int i = 0; i < stringArray.length && category != null; ++i) {
                category = (Category)category.getSubCategories().get(stringArray[i]);
            }
        }
        return category != null ? category : Category.getRootCategory();
    }

    public static Vector getBlogrolls() {
        return blogrolls;
    }

    public static Hashtable getFavPool() {
        return favPool;
    }

    public static String getLinkForTitle(String string) {
        return (String)mapTitleToLink.get(string);
    }

    public static Category getRootCategory() {
        return rootCategory;
    }

    public static String getTitleForLink(String string) {
        return (String)mapLinkToTitle.get(string);
    }

    public static boolean linkExists(String string) {
        return mapLinkToTitle.containsKey(string);
    }

    public static boolean titleExists(String string) {
        return mapTitleToLink.containsKey(string);
    }

    public void addCategory(Category category) {
        this.addCategory(category, false);
    }

    public void addCategory(Category category, boolean bl) {
        if (bl && this.getSubCategories().containsKey(category.getName())) {
            String string;
            String string2 = string = category.getName();
            int n = 1;
            while (this.getSubCategories().containsKey(string)) {
                string = string2;
                string = string + " #" + n;
                ++n;
            }
            category.setName(string);
        }
        this.subCategories.put(category.getName(), category);
        this.sortedSubCatTitles.add(category.getName());
    }

    public void addFavorite(Favorite favorite) {
        this.favorites.put(favorite.getUrl(), favorite);
        this.sortedLinkTitles.add(favorite.getTitle());
        mapTitleToLink.put(favorite.getTitle(), favorite.getUrl());
        mapLinkToTitle.put(favorite.getUrl(), favorite.getTitle());
        favPool.put(favorite.getUrl(), favorite);
        favLinks.add(favorite.getUrl());
        favTitles.add(favorite.getTitle());
        if (favorite.getUpdateInterval() > 0) {
            FeedAutoUpdater.updateFeedList(favorite);
        }
    }

    public void checkUseProxy(Category category) {
        Object object;
        if (category.isRoot) {
            return;
        }
        category.useProxy = true;
        Enumeration enumeration = category.getFavorites().elements();
        while (enumeration.hasMoreElements()) {
            object = (Favorite)enumeration.nextElement();
            if (((Favorite)object).isUseProxy()) continue;
            category.useProxy = false;
            break;
        }
        if (category.useProxy) {
            object = category.getSubCategories().elements();
            while (object.hasMoreElements()) {
                Category category2 = (Category)object.nextElement();
                if (category2.isUseProxy()) continue;
                category.useProxy = false;
                break;
            }
        }
        category.checkUseProxy(category.getParent());
    }

    public boolean editCategory(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (this.subCategories.containsKey(string2)) {
            return false;
        }
        Category category = (Category)this.subCategories.get(string);
        category.setName(string2);
        this.subCategories.remove(string);
        this.sortedSubCatTitles.remove(string);
        this.sortedSubCatTitles.add(string2);
        this.subCategories.put(string2, category);
        return true;
    }

    public void editFavorite(Favorite favorite, Favorite favorite2) {
        String string = favorite2.getTitle();
        String string2 = favorite2.getUrl();
        String string3 = favorite.getTitle();
        String string4 = favorite.getUrl();
        if (string.equals("")) {
            string = string2;
        }
        int n = 1;
        String string5 = string2;
        while (!string4.equals(string2) && Category.linkExists(string2)) {
            string2 = string5 + '#' + n++;
        }
        n = 1;
        String string6 = string;
        while (!string3.equals(string) && Category.titleExists(string)) {
            string = string6 + " #" + n++;
        }
        Favorite favorite3 = (Favorite)this.favorites.get(string4);
        favorite3.setTitle(string);
        favorite3.setUrl(string2);
        favorite2.clone(favorite3);
        this.removeFavorite(string3, false, true);
        this.addFavorite(favorite3);
    }

    public void getAllFavoriteTitles(TreeSet treeSet, Category category) {
        Object object;
        TreeSet<String> treeSet2 = new TreeSet<String>(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string2.compareTo(string);
            }
        });
        Enumeration enumeration = category.getFavorites().elements();
        while (enumeration.hasMoreElements()) {
            object = (Favorite)enumeration.nextElement();
            if (((Favorite)object).isSynchronizer()) continue;
            treeSet2.add(((Favorite)object).getTitle());
        }
        treeSet.addAll(treeSet2);
        object = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                Category category = (Category)object;
                Category category2 = (Category)object2;
                return category2.getName().compareTo(category.getName());
            }
        });
        ((TreeSet)object).addAll(category.getSubCategories().values());
        Iterator iterator = ((TreeSet)object).iterator();
        while (iterator.hasNext()) {
            this.getAllFavoriteTitles(treeSet, (Category)iterator.next());
        }
    }

    public Hashtable getFavorites() {
        return this.favorites;
    }

    public void getLoadOnStartupFavorites(TreeSet treeSet, Category category) {
        Object object;
        Enumeration enumeration = category.getFavorites().elements();
        while (enumeration.hasMoreElements()) {
            object = (Favorite)enumeration.nextElement();
            if (!((Favorite)object).isLoadOnStartup()) continue;
            treeSet.add(((Favorite)object).getTitle());
        }
        object = category.getSubCategories().elements();
        while (object.hasMoreElements()) {
            this.getLoadOnStartupFavorites(treeSet, (Category)object.nextElement());
        }
    }

    public String getName() {
        return this.name;
    }

    public Category getParent() {
        return this.parent;
    }

    public String getPathToBlogroll() {
        return this.pathToBlogroll;
    }

    public TreeSet getSortedLinkTitles() {
        return this.sortedLinkTitles;
    }

    public TreeSet getSortedSubCatTitles() {
        return this.sortedSubCatTitles;
    }

    public Hashtable getSubCategories() {
        return this.subCategories;
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    public boolean isBlogroll() {
        return this.isBlogroll;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isUnSynchronized() {
        return this.isUnSynchronized;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void removeAll() {
        Object object;
        Enumeration enumeration = this.getFavorites().elements();
        while (enumeration.hasMoreElements()) {
            object = (Favorite)enumeration.nextElement();
            this.removeFavorite(((Favorite)object).getTitle(), false, !enumeration.hasMoreElements());
        }
        object = this.getSubCategories().keys();
        while (object.hasMoreElements()) {
            this.removeCategory((String)object.nextElement(), this);
        }
    }

    public void removeCategory(String string, Category category) {
        Object object;
        Category category2 = (Category)category.getSubCategories().get(string);
        Enumeration enumeration = category2.getFavorites().elements();
        while (enumeration.hasMoreElements()) {
            object = (Favorite)enumeration.nextElement();
            category2.removeFavorite(((Favorite)object).getTitle(), false, !enumeration.hasMoreElements());
        }
        if (category2.isBlogroll && StringShop.isset(category2.getPathToBlogroll())) {
            blogrolls.remove(category2.getPathToBlogroll());
        }
        object = category2.getSubCategories().keys();
        while (object.hasMoreElements()) {
            this.removeCategory((String)object.nextElement(), category2);
        }
        category.getSubCategories().remove(string);
        category.getSortedSubCatTitles().remove(string);
    }

    public void removeFavorite(String string, boolean bl, boolean bl2) {
        String string2 = Category.getLinkForTitle(string);
        Favorite favorite = string2 != null ? (Favorite)favPool.get(string2) : (Favorite)favPool.get(string);
        if (favorite != null) {
            TreeItem treeItem = favorite.getTreeItem();
            if (!treeItem.isDisposed()) {
                ((TreeItemData)treeItem.getData()).setStatusUnread(false);
                if (bl2) {
                    GUI.rssOwlGui.getRSSOwlFavoritesTree().updateTreeReadStatus(treeItem);
                }
            }
            if (!treeItem.isDisposed() && bl) {
                treeItem.dispose();
            }
            FeedAutoUpdater.removeFavorite(favorite);
        }
        if (string2 != null) {
            favLinks.remove(string2);
            this.favorites.remove(string2);
        }
        favTitles.remove(string);
        this.sortedLinkTitles.remove(string);
        if (string2 != null && !favLinks.contains(string2)) {
            favPool.remove(string2);
            mapLinkToTitle.remove(string2);
        }
        if (!favTitles.contains(string)) {
            mapTitleToLink.remove(string);
        }
    }

    public void reset() {
        this.favorites.clear();
        this.subCategories.clear();
        this.sortedLinkTitles.clear();
        this.sortedSubCatTitles.clear();
        if (this.isRoot) {
            blogrolls.clear();
            favPool.clear();
            mapLinkToTitle.clear();
            mapTitleToLink.clear();
        }
    }

    public void setBlogroll(boolean bl) {
        this.isBlogroll = bl;
    }

    public void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(Category category) {
        this.parent = category;
    }

    public void setPathToBlogroll(String string) {
        this.pathToBlogroll = string;
        if (!Category.blogrollExists(string)) {
            blogrolls.add(string);
        }
    }

    public void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public void setUnSynchronized(boolean bl) {
        this.isUnSynchronized = bl;
    }

    public void setUseProxy(boolean bl) {
        this.useProxy = bl;
        this.setUseProxy(this, bl);
    }

    public String toCatPath() {
        return this.toCatPath(false);
    }

    public String toCatPath(boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = bl ? " | " : "=;=";
        if (this.isRoot) {
            Enumeration enumeration = this.subCategories.elements();
            if (!enumeration.hasMoreElements()) {
                return stringBuffer.toString();
            }
            stringBuffer.append(((Category)enumeration.nextElement()).getName());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(", ").append(((Category)enumeration.nextElement()).getName());
            }
            return stringBuffer.toString();
        }
        Category category = this;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!category.isRoot()) {
            arrayList.add(category.getName());
            category = category.getParent();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            stringBuffer.append(arrayList.get(i)).append(string);
        }
        return stringBuffer.substring(0, stringBuffer.length() - "=;=".length());
    }

    private void setUseProxy(Category category, boolean bl) {
        category.useProxy = bl;
        Hashtable hashtable = category.getFavorites();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((Favorite)enumeration.nextElement()).setUseProxy(bl);
        }
        Hashtable hashtable2 = category.getSubCategories();
        enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            this.setUseProxy((Category)enumeration.nextElement(), bl);
        }
    }
}

