/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.ChannelImage;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.search.ParsedSearch;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class Channel {
    private Category aggregatedCategory;
    private TreeSet aggregatedFavorites;
    private String category;
    private String copyright;
    private String creator;
    private String description;
    private String docs;
    private Document document;
    private String format;
    private String generator;
    private String homepage;
    private ChannelImage image;
    private int itemCount;
    private Hashtable items;
    private String language;
    private String lastBuildDate;
    private Date lastBuildDateParsed;
    private String link;
    private String managingEditor;
    private Vector newsChannelInfos;
    private Vector newsItemInfos;
    private Vector newsItemOrder;
    private String pubDate;
    private Date pubDateParsed;
    private String publisher;
    private Vector searchResultsItemOrder;
    private Hashtable searchResultsItems;
    private String title;
    private String ttl;
    private String updateFrequency;
    private String updatePeriod;
    private String webmaster;

    public Channel() {
        this(null, null, null, null);
    }

    public Channel(String string, Category category, Vector vector, TreeSet treeSet, boolean bl) {
        this();
        this.aggregatedFavorites = treeSet;
        this.aggregatedCategory = category;
        this.setTitle(string);
        this.aggregateChannels(vector, bl);
        this.addAvailableNewsItemInfo("TABLE_HEADER_FEED");
    }

    public Channel(String string, String string2, String string3, String string4) {
        this.title = string;
        this.description = string2;
        this.link = string3;
        this.language = string4;
        this.aggregatedCategory = null;
        this.items = new Hashtable();
        this.newsItemOrder = new Vector();
        this.newsChannelInfos = new Vector();
        this.newsItemInfos = new Vector();
        this.searchResultsItems = new Hashtable();
        this.searchResultsItemOrder = new Vector();
        this.newsItemInfos.add("TABLE_HEADER_STATUS");
        this.newsItemInfos.add("TABLE_HEADER_NEWSTITLE");
    }

    public static Channel createErrorChannel(String string, NewsfeedFactoryException newsfeedFactoryException) {
        Channel channel = new Channel();
        channel.setTitle(Category.getTitleForLink(string));
        NewsItem newsItem = new NewsItem();
        newsItem.setLink(newsfeedFactoryException.getUrl());
        newsItem.setDescription(newsfeedFactoryException.getMessage() != null ? newsfeedFactoryException.getMessage() : "-");
        if (newsfeedFactoryException.getTitle() != null) {
            newsItem.setTitle(StringShop.printf(GUI.i18n.getTranslation("ERROR_LOADING_FEED"), new String[]{"%TITLE%"}, new String[]{newsfeedFactoryException.getTitle()}));
        } else {
            newsItem.setTitle(StringShop.printf(GUI.i18n.getTranslation("ERROR_LOADING_FEED"), new String[]{"%TITLE%"}, new String[]{newsfeedFactoryException.getUrl()}));
        }
        channel.insertItem(newsItem);
        return channel;
    }

    public void addAvailableNewsChannelInfo(String string) {
        if (!this.newsChannelInfos.contains(string)) {
            this.newsChannelInfos.add(string);
        }
    }

    public void addAvailableNewsItemInfo(String string) {
        if (!this.newsItemInfos.contains(string)) {
            this.newsItemInfos.add(string);
        }
    }

    public boolean containsUnreadNews() {
        return this.getUnreadNewsCount() > 0;
    }

    public Category getAggregatedCategory() {
        return this.aggregatedCategory;
    }

    public TreeSet getAggregatedFavorites() {
        return this.aggregatedFavorites;
    }

    public Vector getAvailableNewsChannelInfos() {
        return this.newsChannelInfos;
    }

    public Vector getAvailableNewsItemInfos() {
        return this.newsItemInfos;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocs() {
        return this.docs;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFormat() {
        return this.format;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public ChannelImage getImage() {
        return this.image;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public Hashtable getItems() {
        return this.items;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLastBuildDate() {
        return this.lastBuildDate;
    }

    public Date getLastBuildDateParsed() {
        return this.lastBuildDateParsed;
    }

    public String getLink() {
        return this.link;
    }

    public String getManagingEditor() {
        return this.managingEditor;
    }

    public Vector getNewsItemOrder() {
        return this.newsItemOrder;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public Date getPubDateParsed() {
        return this.pubDateParsed;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Vector getSearchResultsItemOrder() {
        return this.searchResultsItemOrder;
    }

    public Hashtable getSearchResultsItems() {
        return this.searchResultsItems;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTtl() {
        return this.ttl;
    }

    public int getUnreadNewsCount() {
        int n = 0;
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            NewsItem newsItem = (NewsItem)enumeration.nextElement();
            if (newsItem.isRead()) continue;
            ++n;
        }
        return n;
    }

    public int getUnreadNewsCount(String string) {
        int n = 0;
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            NewsItem newsItem = (NewsItem)enumeration.nextElement();
            String string2 = newsItem.getNewsfeedXmlUrl();
            if (newsItem.isRead() || string2 == null || !string2.equals(string)) continue;
            ++n;
        }
        return n;
    }

    public String getUpdateFrequency() {
        return this.updateFrequency;
    }

    public String getUpdatePeriod() {
        return this.updatePeriod;
    }

    public String getWebmaster() {
        return this.webmaster;
    }

    public void insertItem(NewsItem newsItem) {
        this.insertItem(newsItem, true);
    }

    public void insertItem(NewsItem newsItem, boolean bl) {
        String string = newsItem.getTitle();
        String string2 = newsItem.getTitle();
        if (StringShop.isWhiteSpaceOrEmpty(string)) {
            string = GUI.i18n.getTranslation("NO_TITLE");
            string2 = GUI.i18n.getTranslation("NO_TITLE");
            newsItem.setTitle(string);
        }
        if (bl) {
            int n = 1;
            while (this.items.containsKey(string)) {
                string = string2;
                string = string + " #" + n;
                ++n;
            }
            newsItem.setTitle(string, false, false);
        }
        newsItem.setNewsfeedTitle(this.getTitle());
        newsItem.setNewsfeedXmlUrl(this.getLink());
        this.items.put(string, newsItem);
        this.newsItemOrder.add(string);
        ++this.itemCount;
    }

    public boolean isAggregatedCat() {
        return this.aggregatedCategory != null;
    }

    public void peformSearch(ParsedSearch parsedSearch) {
        if (parsedSearch.isRegExSearch()) {
            this.search(parsedSearch.getSearchDefinition());
        } else {
            this.search(parsedSearch);
        }
    }

    public void setCategory(String string) {
        this.category = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_CATEGORY");
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public void setCreator(String string) {
        this.creator = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_CREATOR");
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDocs(String string) {
        this.docs = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_DOCS");
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setFormat(String string) {
        this.format = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_RSSVERSION");
    }

    public void setGenerator(String string) {
        this.generator = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_GENERATOR");
    }

    public void setHomepage(String string) {
        this.homepage = string;
    }

    public void setImage(ChannelImage channelImage) {
        this.image = channelImage;
    }

    public void setItemCount(int n) {
        this.itemCount = n;
    }

    public void setLanguage(String string) {
        this.language = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_LANGUAGE");
    }

    public void setLastBuildDate(String string) {
        this.lastBuildDate = string;
        this.lastBuildDateParsed = DateParser.getDate(string);
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_LASTBUILDDATE");
    }

    public void setLink(String string) {
        this.link = string;
    }

    public void setManagingEditor(String string) {
        this.managingEditor = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_MANAGINGEDITOR");
    }

    public void setPubDate(String string) {
        this.pubDate = string;
        this.pubDateParsed = DateParser.getDate(string);
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_PUBDATE");
    }

    public void setPublisher(String string) {
        this.publisher = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_PUBLISHER");
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTtl(String string) {
        this.ttl = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_TTL");
    }

    public void setUpdateFrequency(String string) {
        this.updateFrequency = string;
    }

    public void setUpdatePeriod(String string) {
        this.updatePeriod = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_UPDATE_PERIOD");
    }

    public void setWebmaster(String string) {
        this.webmaster = string;
        this.addAvailableNewsChannelInfo("CHANNEL_INFO_WEBMASTER");
    }

    public Document toDocument() {
        Object object;
        Cloneable cloneable;
        Document document = new Document();
        Element element = new Element("rss");
        element.setAttribute("version", "2.0");
        document.setRootElement(element);
        Element element2 = new Element("channel");
        element.addContent(element2);
        Element element3 = new Element("title");
        if (this.title != null) {
            element3.setText(this.title);
        } else {
            element3.setText(GUI.i18n.getTranslation("NO_TITLE"));
        }
        element2.addContent(element3);
        if (StringShop.isset(this.description)) {
            cloneable = new Element("description");
            ((Element)cloneable).setText(this.description);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.homepage)) {
            cloneable = new Element("link");
            ((Element)cloneable).setText(this.homepage);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.language)) {
            cloneable = new Element("language");
            ((Element)cloneable).setText(this.language);
            element2.addContent((Content)cloneable);
        }
        if (this.image != null && StringShop.isset(this.image.getImgUrl())) {
            cloneable = new Element("image");
            Element element4 = new Element("url");
            element4.setText(this.image.getImgUrl());
            ((Element)cloneable).addContent(element4);
            if (StringShop.isset(this.image.getLink())) {
                object = new Element("link");
                ((Element)object).setText(this.image.getLink());
                ((Element)cloneable).addContent((Content)object);
            }
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.copyright)) {
            cloneable = new Element("copyright");
            ((Element)cloneable).setText(this.copyright);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.pubDate)) {
            cloneable = new Element("pubDate");
            ((Element)cloneable).setText(this.pubDate);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.lastBuildDate)) {
            cloneable = new Element("lastBuildDate");
            ((Element)cloneable).setText(this.lastBuildDate);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.docs)) {
            cloneable = new Element("docs");
            ((Element)cloneable).setText(this.docs);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.managingEditor)) {
            cloneable = new Element("managingEditor");
            ((Element)cloneable).setText(this.managingEditor);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.webmaster)) {
            cloneable = new Element("webMaster");
            ((Element)cloneable).setText(this.webmaster);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.category)) {
            cloneable = new Element("category");
            ((Element)cloneable).setText(this.category);
            element2.addContent((Content)cloneable);
        }
        if (StringShop.isset(this.generator)) {
            cloneable = new Element("generator");
            ((Element)cloneable).setText(this.generator);
            element2.addContent((Content)cloneable);
        }
        cloneable = this.newsItemOrder;
        if (this.searchResultsItemOrder.size() != 0) {
            cloneable = this.searchResultsItemOrder;
        }
        for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
            Element element5;
            Object object2;
            Iterator iterator;
            Cloneable cloneable2;
            object = (NewsItem)this.items.get(((Vector)cloneable).get(i));
            Element element6 = new Element("item");
            Element element7 = new Element("title");
            if (StringShop.isset(((NewsItem)object).getTitle())) {
                element7.setText(((NewsItem)object).getTitle());
            } else {
                element7.setText(GUI.i18n.getTranslation("NO_TITLE"));
            }
            element6.addContent(element7);
            if (StringShop.isset(((NewsItem)object).getLink())) {
                cloneable2 = new Element("link");
                ((Element)cloneable2).setText(((NewsItem)object).getLink());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getDescription())) {
                cloneable2 = new Element("description");
                ((Element)cloneable2).setText(((NewsItem)object).getDescription());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getPubDate())) {
                cloneable2 = new Element("pubDate");
                ((Element)cloneable2).setText(((NewsItem)object).getPubDate());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getAuthor())) {
                cloneable2 = new Element("author");
                ((Element)cloneable2).setText(((NewsItem)object).getAuthor());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getCategory())) {
                cloneable2 = new Element("category");
                ((Element)cloneable2).setText(((NewsItem)object).getCategory());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getGuid())) {
                cloneable2 = new Element("guid");
                ((Element)cloneable2).setText(((NewsItem)object).getGuid());
                element6.addContent((Content)cloneable2);
            }
            if (StringShop.isset(((NewsItem)object).getSource())) {
                cloneable2 = new Element("source");
                ((Element)cloneable2).setAttribute("url", ((NewsItem)object).getSource());
                element6.addContent((Content)cloneable2);
            }
            if (((NewsItem)object).getEnclosures() != null && ((NewsItem)object).getEnclosures().size() > 0) {
                cloneable2 = ((NewsItem)object).getEnclosures();
                iterator = ((Vector)cloneable2).iterator();
                while (iterator.hasNext()) {
                    object2 = (Enclosure)iterator.next();
                    element5 = new Element("enclosure");
                    if (StringShop.isset(((Enclosure)object2).getUrl())) {
                        element5.setAttribute("url", ((Enclosure)object2).getUrl());
                    }
                    if (StringShop.isset(((Enclosure)object2).getLength(false))) {
                        element5.setAttribute("length", ((Enclosure)object2).getLength(false));
                    }
                    if (StringShop.isset(((Enclosure)object2).getType())) {
                        element5.setAttribute("type", ((Enclosure)object2).getType());
                    }
                    element6.addContent(element5);
                }
            }
            if (((NewsItem)object).getComments() != null && ((NewsItem)object).getComments().size() > 0) {
                cloneable2 = ((NewsItem)object).getComments();
                iterator = ((Vector)cloneable2).iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    element5 = new Element("comments");
                    element5.setText((String)object2);
                    element6.addContent(element5);
                }
            }
            element2.addContent(element6);
        }
        return document;
    }

    public void updateReadStatusOnNews() {
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            NewsItem newsItem = (NewsItem)enumeration.nextElement();
            newsItem.setRead(GUI.rssOwlGui.getArchiveManager().getArchive().isNewsRead(newsItem));
        }
    }

    private void aggregateChannels(Vector vector, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            Channel channel = (Channel)vector.get(i);
            String string = channel.getLink() != null && Category.getFavPool().containsKey(channel.getLink()) ? ((Favorite)Category.getFavPool().get(channel.getLink())).getTitle() : channel.getTitle();
            String string2 = string != null ? Category.getLinkForTitle(string) : null;
            Vector vector2 = channel.getNewsItemOrder();
            Hashtable hashtable = channel.getItems();
            for (int j = 0; j < vector2.size(); ++j) {
                NewsItem newsItem = (NewsItem)hashtable.get(vector2.get(j));
                NewsItem newsItem2 = new NewsItem(true);
                newsItem.clone(newsItem2);
                this.insertItem(newsItem2, bl);
                newsItem2.setNewsfeedTitle(string);
                newsItem2.setNewsfeedXmlUrl(string2);
                newsItem2.setNewsfeedHomepage(channel.getHomepage());
            }
            Vector vector3 = channel.getAvailableNewsItemInfos();
            for (int j = 0; j < vector3.size(); ++j) {
                if (this.getAvailableNewsItemInfos().contains(vector3.get(j))) continue;
                this.addAvailableNewsItemInfo((String)vector3.get(j));
            }
        }
    }

    private void search(ParsedSearch parsedSearch) {
        this.searchResultsItems = new Hashtable();
        this.searchResultsItemOrder = new Vector();
        ArrayList arrayList = parsedSearch.getMustNotContain();
        ArrayList arrayList2 = parsedSearch.getMustContain();
        SearchDefinition searchDefinition = parsedSearch.getSearchDefinition();
        for (int i = 0; i < this.newsItemOrder.size(); ++i) {
            String string;
            int n;
            NewsItem newsItem = (NewsItem)this.items.get(this.newsItemOrder.get(i));
            boolean bl = true;
            newsItem.setSearchCaseSensitive(searchDefinition.isCaseSensitive());
            newsItem.clearHighlightWords();
            String string2 = newsItem.toString(parsedSearch.getSearchDefinition());
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                Pattern pattern = Pattern.compile(string, searchDefinition.isCaseSensitive() ? 0 : 66);
                if (!pattern.matcher(string2).find()) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    string = (String)arrayList2.get(n);
                    int n2 = 0;
                    Pattern pattern = Pattern.compile(string, searchDefinition.isCaseSensitive() ? 0 : 66);
                    Matcher matcher = pattern.matcher(string2);
                    while (matcher.find()) {
                        newsItem.insertHighlightWord(matcher.group());
                        ++n2;
                    }
                    if (n2 != 0) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            this.searchResultsItems.put(newsItem.getTitle(), newsItem);
            this.searchResultsItemOrder.add(newsItem.getTitle());
        }
        this.setItemCount(this.searchResultsItems.size());
    }

    private void search(SearchDefinition searchDefinition) {
        this.searchResultsItems = new Hashtable();
        this.searchResultsItemOrder = new Vector();
        Pattern pattern = Pattern.compile(searchDefinition.getPattern(), searchDefinition.isCaseSensitive() ? 0 : 66);
        for (int i = 0; i < this.newsItemOrder.size(); ++i) {
            NewsItem newsItem = (NewsItem)this.items.get(this.newsItemOrder.get(i));
            String string = newsItem.toString(searchDefinition);
            newsItem.clearHighlightWords();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                newsItem.insertHighlightWord(matcher.group());
            }
            if (newsItem.getHighlightWords() == null || newsItem.getHighlightWords().size() <= 0) continue;
            this.searchResultsItems.put(newsItem.getTitle(), newsItem);
            this.searchResultsItemOrder.add(newsItem.getTitle());
        }
        this.setItemCount(this.searchResultsItems.size());
    }
}

