/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.model;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.widgets.TreeItem;

public class Favorite {
    private String catPath;
    private long creationDate;
    private String description;
    private boolean errorLoading;
    private String homepage;
    private boolean isSynchronizer;
    private String language;
    private long lastVisitDate;
    private boolean loadOnStartup;
    private boolean openOnStartup;
    private Category rssOwlCategory;
    private String title;
    private int unreadNewsCount;
    private int updateInterval;
    private String url;
    private boolean useProxy;
    TreeItem treeItem;

    public Favorite(String string, String string2, Category category) {
        this.url = string;
        this.title = string2;
        this.rssOwlCategory = category;
        this.isSynchronizer = false;
        this.errorLoading = false;
        this.description = "";
        this.language = "";
        this.homepage = "";
        this.loadOnStartup = GlobalSettings.favDefaultReloadOnStartup;
        this.openOnStartup = GlobalSettings.favDefaultOpenOnStartup;
        this.updateInterval = GlobalSettings.favDefaultAutoReloadInterval;
    }

    public void clearMetaData() {
        this.setDescription("");
        this.setLanguage("");
        this.setHomepage("");
    }

    public void clone(Favorite favorite) {
        favorite.setOpenOnStartup(this.openOnStartup);
        favorite.setLoadOnStartup(this.loadOnStartup);
        favorite.setUpdateInterval(this.updateInterval);
        favorite.setCreationDate(this.creationDate);
        favorite.setDescription(this.description);
        favorite.setErrorLoading(this.errorLoading);
        favorite.setHomepage(this.homepage);
        favorite.setLanguage(this.language);
        favorite.setLastVisitDate(this.lastVisitDate);
        favorite.setUnreadNewsCount(this.unreadNewsCount);
        favorite.setUseProxy(this.useProxy);
    }

    public void duplicate(Favorite favorite) {
        favorite.setUrl(this.url);
        favorite.setTitle(this.title);
        favorite.setCatPath(this.rssOwlCategory != null ? this.rssOwlCategory.toCatPath() : this.catPath);
        this.clone(favorite);
    }

    public String getCatPath() {
        return this.catPath;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getLanguage() {
        return this.language;
    }

    public long getLastVisitDate() {
        return this.lastVisitDate;
    }

    public Category getRSSOwlCategory() {
        return this.rssOwlCategory;
    }

    public String getTitle() {
        return this.title;
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    public int getUnreadNewsCount() {
        return this.unreadNewsCount;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isErrorLoading() {
        return this.errorLoading;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public boolean isOpenOnStartup() {
        return this.openOnStartup;
    }

    public boolean isSynchronizer() {
        return this.isSynchronizer;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setCatPath(String string) {
        this.catPath = string;
    }

    public void setCreationDate(long l) {
        this.creationDate = l;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setErrorLoading(boolean bl) {
        this.errorLoading = bl;
    }

    public void setHomepage(String string) {
        this.homepage = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setLastVisitDate(long l) {
        this.lastVisitDate = l;
    }

    public void setLoadOnStartup(boolean bl) {
        this.loadOnStartup = bl;
    }

    public void setOpenOnStartup(boolean bl) {
        this.openOnStartup = bl;
    }

    public void setSynchronizer(boolean bl) {
        this.isSynchronizer = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public void setUnreadNewsCount(int n) {
        this.unreadNewsCount = n;
    }

    public void setUpdateInterval(int n) {
        this.updateInterval = n;
        FeedAutoUpdater.updateFeedList(this);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUseProxy(boolean bl) {
        this.useProxy = bl;
    }

    public void syncMetaData(Channel channel) {
        this.setDescription(StringShop.isset(channel.getDescription()) ? channel.getDescription() : "");
        this.setLanguage(StringShop.isset(channel.getLanguage()) ? channel.getLanguage() : "");
        this.setHomepage(StringShop.isset(channel.getHomepage()) ? channel.getHomepage() : "");
    }

    public boolean unreadNewsAvailable() {
        return this.unreadNewsCount != 0;
    }

    public void updateErrorState(final boolean bl) {
        if (GUI.isAlive()) {
            GUI.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WidgetShop.isset(Favorite.this.getTreeItem()) && Favorite.this.isErrorLoading() != bl) {
                        Favorite.this.setErrorLoading(bl);
                        if (bl) {
                            Favorite.this.updateReadStatus(0);
                        }
                        GUI.rssOwlGui.getRSSOwlFavoritesTree().updateTreeItemIcon(Favorite.this.getTreeItem());
                    }
                }
            });
        }
    }

    public void updateReadStatus(int n) {
        this.updateReadStatus(n, true);
    }

    public void updateReadStatus(final int n, final boolean bl) {
        int n2 = this.getUnreadNewsCount();
        final boolean bl2 = n2 > 0 && n == 0 || n2 == 0 && n > 0;
        this.setUnreadNewsCount(n);
        if (n2 == n) {
            return;
        }
        if (GUI.isAlive()) {
            GUI.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!Favorite.this.treeItem.isDisposed()) {
                        GUI.rssOwlGui.getRSSOwlFavoritesTree().appendUnreadCount(Favorite.this.treeItem, Favorite.this.getTitle(), n);
                        if (!bl2) {
                            return;
                        }
                        Favorite.this.treeItem.setImage(n > 0 ? PaintShop.iconLenseUnread : PaintShop.iconLense);
                        Favorite.this.treeItem.setFont(n > 0 ? FontShop.treeBoldFont : FontShop.treeFont);
                        ((TreeItemData)Favorite.this.treeItem.getData()).setStatusUnread(n > 0);
                        GUI.rssOwlGui.getRSSOwlFavoritesTree().updateTreeReadStatus(Favorite.this.treeItem);
                        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && GUI.rssOwlGui.getRSSOwlSystray() != null && bl) {
                            boolean bl3 = GUI.rssOwlGui.getRSSOwlFavoritesTree().getTreeHasUnreadFavs();
                            GUI.rssOwlGui.getRSSOwlSystray().setTrayItemState(bl3);
                        }
                    }
                }
            });
        }
    }
}

