/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.archive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.archive.ArchiveEntry;
import net.sourceforge.rssowl.util.archive.ArchiveItem;
import net.sourceforge.rssowl.util.archive.ArchiveManager;

public class Archive {
    private ArchiveManager archiveManager;
    private Hashtable items;

    public Archive(ArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
        this.items = new Hashtable();
    }

    public void addEntry(NewsItem newsItem) {
        if (newsItem == null) {
            return;
        }
        String string = newsItem.getSafeXMLFeedUrl();
        if (string == null) {
            string = "NULL";
        }
        String string2 = "NULL";
        if (newsItem.getTitle() != null) {
            string2 = newsItem.getTitle();
        }
        String string3 = "NULL";
        if (newsItem.getLink() != null) {
            string3 = newsItem.getLink();
        } else if (newsItem.getGuid() != null) {
            string3 = newsItem.getGuid();
        }
        String string4 = "NULL";
        if (newsItem.getPubDate() != null) {
            string4 = newsItem.getPubDate();
        }
        this.addEntry(string, string2, string3, string4);
    }

    public void addEntry(String string, String string2, String string3, String string4) {
        ArchiveItem archiveItem;
        if (this.items.containsKey(string)) {
            archiveItem = this.getItem(string);
        } else {
            archiveItem = new ArchiveItem(string);
            this.addItem(archiveItem);
        }
        archiveItem.addEntry(new ArchiveEntry(string3, string2, string4));
    }

    public void addItem(ArchiveItem archiveItem) {
        this.items.put(archiveItem.getFeedurl(), archiveItem);
        this.archiveManager.index.syncFileName(archiveItem);
    }

    public void cleanUpItem(String string, Hashtable hashtable) {
        Object object;
        Object object2;
        if (!this.items.containsKey(string)) {
            return;
        }
        ArchiveItem archiveItem = (ArchiveItem)this.items.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (NewsItem)enumeration.nextElement();
            object = ((NewsItem)object2).getTitle();
            String string2 = ((NewsItem)object2).getLink() != null ? ((NewsItem)object2).getLink() : ((NewsItem)object2).getGuid();
            String string3 = ((NewsItem)object2).getPubDate();
            arrayList.add(ArchiveEntry.toID((String)object, string2, string3));
        }
        object2 = archiveItem.getEntries().elements();
        while (object2.hasMoreElements()) {
            object = (ArchiveEntry)object2.nextElement();
            if (arrayList.contains(((ArchiveEntry)object).toID())) continue;
            arrayList2.add(object);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            archiveItem.removeEntry((ArchiveEntry)arrayList2.get(i));
        }
    }

    public ArchiveItem getItem(String string) {
        return (ArchiveItem)this.items.get(string);
    }

    public Hashtable getItems() {
        return this.items;
    }

    public boolean isNewsRead(NewsItem newsItem) {
        String string = newsItem.getSafeXMLFeedUrl();
        if (string == null) {
            string = "NULL";
        }
        String string2 = "NULL";
        if (newsItem.getTitle() != null) {
            string2 = newsItem.getTitle();
        }
        String string3 = "NULL";
        if (newsItem.getLink() != null) {
            string3 = newsItem.getLink();
        } else if (newsItem.getGuid() != null) {
            string3 = newsItem.getGuid();
        }
        String string4 = "NULL";
        if (newsItem.getPubDate() != null) {
            string4 = newsItem.getPubDate();
        }
        return this.isNewsRead(string, string2, string3, string4);
    }

    public boolean isNewsRead(String string, String string2, String string3, String string4) {
        if (!this.items.containsKey(string)) {
            return false;
        }
        ArchiveItem archiveItem = this.getItem(string);
        return archiveItem.isNewsRead(string2, string3, string4);
    }

    public void removeEntry(NewsItem newsItem) {
        if (newsItem == null) {
            return;
        }
        String string = newsItem.getSafeXMLFeedUrl();
        if (string == null) {
            string = "NULL";
        }
        String string2 = "NULL";
        if (newsItem.getTitle() != null) {
            string2 = newsItem.getTitle();
        }
        String string3 = "NULL";
        if (newsItem.getLink() != null) {
            string3 = newsItem.getLink();
        } else if (newsItem.getGuid() != null) {
            string3 = newsItem.getGuid();
        }
        String string4 = "NULL";
        if (newsItem.getPubDate() != null) {
            string4 = newsItem.getPubDate();
        }
        this.removeEntry(string, string2, string3, string4);
    }

    public void removeEntry(String string, String string2, String string3, String string4) {
        if (this.items.containsKey(string)) {
            ArchiveItem archiveItem = (ArchiveItem)this.items.get(string);
            archiveItem.removeEntry(string2, string3, string4);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration enumeration = this.items.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(this.items.get(enumeration.nextElement()));
        }
        return new String(stringBuffer);
    }
}

