/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.archive;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.archive.ArchiveItem;
import net.sourceforge.rssowl.util.archive.ArchiveManager;

public class ArchiveIndex {
    private ArchiveManager archiveManager;
    private boolean dirty;
    private Hashtable index;

    public ArchiveIndex(ArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
        this.index = new Hashtable();
        this.dirty = true;
    }

    public void addIndex(String string, String string2) {
        this.index.put(string, string2);
        this.dirty = true;
    }

    public Hashtable getIndex() {
        return this.index;
    }

    public String getValue(String string) {
        return (String)this.index.get(string);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void removeIndex(Object object) {
        this.index.remove(object);
        this.dirty = true;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void syncFileName(ArchiveItem archiveItem) {
        if (!this.index.containsKey(archiveItem.getFeedurl())) {
            try {
                File file = this.archiveManager.createUniqueArchiveFile();
                this.addIndex(archiveItem.getFeedurl(), file.getName());
                archiveItem.setFile(file);
            }
            catch (IOException iOException) {
                GUI.logger.log("syncFileName()", iOException);
            }
        } else {
            archiveItem.setFile(new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + this.getValue(archiveItem.getFeedurl())));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration enumeration = this.index.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.index.get(string);
            stringBuffer.append("FeedURL: " + string + "   FileName: " + string2);
        }
        return new String(stringBuffer);
    }
}

