/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.archive.Archive;
import net.sourceforge.rssowl.util.archive.ArchiveEntry;
import net.sourceforge.rssowl.util.archive.ArchiveIndex;
import net.sourceforge.rssowl.util.archive.ArchiveItem;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ArchiveManager {
    private Archive archive;
    private SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
    ArchiveIndex index;

    public File createUniqueArchiveFile() throws IOException {
        return File.createTempFile("rss", ".xml", new File(GlobalSettings.ARCHIVE_DIR));
    }

    public Archive getArchive() {
        return this.archive;
    }

    public Archive loadArchive() {
        Archive archive = new Archive(this);
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = this.index.getIndex().entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            arrayList.add(string2);
            if (!this.isArchiveFileExisting(string2)) continue;
            ArchiveItem archiveItem = this.loadArchiveItem(string);
            archive.addItem(archiveItem);
        }
        arrayList.add("index.xml");
        File[] fileArray = new File(GlobalSettings.ARCHIVE_DIR).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || arrayList.contains(fileArray[i].getName())) continue;
            fileArray[i].delete();
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveArchive() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this.archive.getItems();
        Object object = hashtable;
        synchronized (object) {
            Set set = hashtable.entrySet();
            for (Map.Entry entry : set) {
                Hashtable hashtable2;
                String string = (String)entry.getKey();
                ArchiveItem archiveItem = (ArchiveItem)entry.getValue();
                Hashtable hashtable3 = hashtable2 = archiveItem.getEntries();
                synchronized (hashtable3) {
                    if (hashtable2.size() > 0) {
                        this.saveArchiveItem(archiveItem);
                    } else {
                        arrayList.add(string);
                        if (archiveItem.getFile().getName() != null && this.isArchiveFileExisting(archiveItem.getFile().getName())) {
                            this.deleteArchiveFile(archiveItem.getFile().getName());
                        }
                    }
                }
            }
        }
        object = this.index;
        synchronized (object) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.index.removeIndex(arrayList.get(i));
            }
        }
    }

    public synchronized void flush() {
        this.saveArchive();
        this.saveIndex();
    }

    public void startup() {
        this.index = this.loadIndex();
        this.archive = this.loadArchive();
    }

    private void deleteArchiveFile(String string) {
        new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + string).delete();
    }

    private boolean isArchiveFileExisting(String string) {
        return new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + string).exists();
    }

    private boolean isIndexExisting() {
        return new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + "index.xml").exists();
    }

    private ArchiveItem loadArchiveItem(String string) {
        ArchiveItem archiveItem = new ArchiveItem(string);
        String string2 = this.index.getValue(string);
        archiveItem.setFile(new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + string2));
        try {
            Document document = this.builder.build(new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + string2));
            Element element = document.getRootElement();
            List list = element.getChildren("entry");
            for (Element element2 : list) {
                Element element3 = element2.getChild("newstitle");
                Element element4 = element2.getChild("newslink");
                Element element5 = element2.getChild("newsdate");
                ArchiveEntry archiveEntry = new ArchiveEntry(element4.getText(), element3.getText(), element5 != null ? element5.getText() : "NULL");
                archiveItem.addEntry(archiveEntry);
            }
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("loadArchiveItem()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("loadArchiveItem()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("loadArchiveItem()", illegalArgumentException);
        }
        archiveItem.setDirty(false);
        return archiveItem;
    }

    private ArchiveIndex loadIndex() {
        ArchiveIndex archiveIndex = new ArchiveIndex(this);
        if (!this.isIndexExisting()) {
            return archiveIndex;
        }
        try {
            Document document = this.builder.build(new File(GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + "index.xml"));
            Element element = document.getRootElement();
            List list = element.getChildren("item");
            for (Element element2 : list) {
                Element element3 = element2.getChild("feedurl");
                Element element4 = element2.getChild("filename");
                archiveIndex.addIndex(element3.getText(), element4.getText());
            }
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("loadIndex()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("loadIndex()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("loadIndex()", illegalArgumentException);
        }
        return archiveIndex;
    }

    private void saveArchiveItem(ArchiveItem archiveItem) {
        if (!archiveItem.isDirty()) {
            return;
        }
        archiveItem.setDirty(false);
        Document document = new Document();
        Element element = new Element("item");
        document.setRootElement(element);
        Enumeration enumeration = archiveItem.getEntries().elements();
        while (enumeration.hasMoreElements()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
            Element element2 = new Element("entry");
            element.addContent(element2);
            Element element3 = new Element("newstitle");
            element3.setText(archiveEntry.getNewsTitle());
            element2.addContent(element3);
            Element element4 = new Element("newslink");
            element4.setText(archiveEntry.getNewsLink());
            element2.addContent(element4);
            Element element5 = new Element("newsdate");
            element5.setText(archiveEntry.getNewsdate());
            element2.addContent(element5);
        }
        XMLShop.writeXML(document, archiveItem.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndex() {
        Hashtable hashtable;
        if (!this.index.isDirty()) {
            return;
        }
        this.index.setDirty(false);
        Document document = new Document();
        Element element = new Element("index");
        document.setRootElement(element);
        Hashtable hashtable2 = hashtable = this.index.getIndex();
        synchronized (hashtable2) {
            Set set = hashtable.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                Element element2 = new Element("item");
                element.addContent(element2);
                Element element3 = new Element("feedurl");
                element3.setText(string);
                element2.addContent(element3);
                Element element4 = new Element("filename");
                element4.setText(string2);
                element2.addContent(element4);
            }
        }
        XMLShop.writeXML(document, GlobalSettings.ARCHIVE_DIR + GlobalSettings.PATH_SEPARATOR + "index.xml");
    }
}

