/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.document;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import java.util.Locale;
import net.sourceforge.rssowl.controller.GUI;

public class DocumentConfig {
    private static final String DEFAULT_FONT = "Helvetica";
    private static DocumentConfig documentConfig;
    private static final Color LINK_COLOR;
    private BaseFont baseFont;
    private Font boldFont;
    private Font italicFont;
    private Font linkFont;
    private Font normalFont;
    private Font smallItalicFont;
    private Font subTitleFont;

    private DocumentConfig() {
        try {
            this.initBaseFont();
        }
        catch (DocumentException documentException) {
            GUI.logger.log("initBaseFont()", documentException);
        }
        catch (IOException iOException) {
            GUI.logger.log("initBaseFont()", iOException);
        }
        if (this.baseFont != null) {
            this.initAsiaFonts();
        } else {
            this.initDefaultFonts();
        }
    }

    public static DocumentConfig getInstance() {
        if (documentConfig != null) {
            return documentConfig;
        }
        documentConfig = new DocumentConfig();
        return documentConfig;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public Font getItalicFont() {
        return this.italicFont;
    }

    public Font getLinkFont() {
        return this.linkFont;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getSmallItalicFont() {
        return this.smallItalicFont;
    }

    public Font getSubTitleFont() {
        return this.subTitleFont;
    }

    private void initAsiaFonts() {
        this.normalFont = new Font(this.baseFont, 12.0f, 0);
        this.italicFont = new Font(this.baseFont, 12.0f, 2);
        this.smallItalicFont = new Font(this.baseFont, 10.0f, 2);
        this.boldFont = new Font(this.baseFont, 12.0f, 1);
        this.subTitleFont = new Font(this.baseFont, 10.0f, 0, Color.GRAY);
        this.linkFont = new Font(this.baseFont, 12.0f, 1, LINK_COLOR);
    }

    private void initBaseFont() throws DocumentException, IOException {
        Locale locale = Locale.getDefault();
        if (locale.equals(Locale.SIMPLIFIED_CHINESE)) {
            this.baseFont = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", false);
        } else if (locale.equals(Locale.TRADITIONAL_CHINESE)) {
            this.baseFont = BaseFont.createFont("MSung-Light", "UniCNS-UCS2-H", false);
        } else if (locale.getLanguage().equalsIgnoreCase(Locale.JAPAN.getLanguage())) {
            this.baseFont = BaseFont.createFont("HeiseiKakuGo-W5", "UniJIS-UCS2-H", false);
        } else if (locale.getLanguage().equalsIgnoreCase(Locale.KOREAN.getLanguage())) {
            this.baseFont = BaseFont.createFont("HYGoThic-Medium", "UniKS-UCS2-H", false);
        }
    }

    private void initDefaultFonts() {
        this.normalFont = FontFactory.getFont(DEFAULT_FONT, 12.0f, 0);
        this.italicFont = FontFactory.getFont(DEFAULT_FONT, 12.0f, 2);
        this.smallItalicFont = FontFactory.getFont(DEFAULT_FONT, 10.0f, 2);
        this.boldFont = FontFactory.getFont(DEFAULT_FONT, 12.0f, 1);
        this.subTitleFont = FontFactory.getFont(DEFAULT_FONT, 10.0f, 0, Color.GRAY);
        this.linkFont = FontFactory.getFont(DEFAULT_FONT, 12.0f, 1, LINK_COLOR);
    }

    static {
        LINK_COLOR = new Color(0, 0, 153);
    }
}

