/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.document;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.document.DocumentConfig;
import net.sourceforge.rssowl.util.document.HTMLExporter;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import org.jdom.Text;

public class DocumentGenerator {
    public static final int HTML_FORMAT = 1;
    public static final int PDF_FORMAT = 0;
    public static final int RTF_FORMAT = 2;
    private static final int MAX_CHARS_PER_PAGE = 3000;
    private static final String TOKENIZER = " =;;= ";
    private Document document;
    private DocumentConfig documentConfig;
    private FileOutputStream fileOS;
    private int format;
    private Channel rssChannel;
    Hashtable chapters;

    public DocumentGenerator(Channel channel, FileOutputStream fileOutputStream, int n) throws DocumentException {
        this.rssChannel = channel;
        this.format = n;
        this.fileOS = fileOutputStream;
        if (n != 1) {
            this.chapters = new Hashtable();
            this.document = new Document();
            this.documentConfig = DocumentConfig.getInstance();
            this.initDocument(fileOutputStream);
        }
    }

    public static String formatToString(int n) {
        if (n == 0) {
            return "pdf";
        }
        if (n == 2) {
            return "rtf";
        }
        if (n == 1) {
            return "html";
        }
        return "pdf";
    }

    public void createDocument(ArrayList arrayList) throws DocumentException, IOException {
        if (this.format == 1) {
            new HTMLExporter(this.rssChannel, arrayList, this.fileOS).create();
        } else {
            DocumentException documentException = null;
            this.writeMetaInfos();
            try {
                this.writeFooter();
                this.document.open();
                this.writeNews(arrayList);
            }
            catch (DocumentException documentException2) {
                documentException = documentException2;
            }
            this.document.close();
            if (documentException != null) {
                throw documentException;
            }
        }
    }

    private void initDocument(FileOutputStream fileOutputStream) throws DocumentException {
        if (this.format == 0) {
            PdfWriter.getInstance(this.document, fileOutputStream).setPageEvent(new PdfPageEventHelper(){

                @Override
                public void onGenericTag(PdfWriter pdfWriter, Document document, Rectangle rectangle, String string) {
                    PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                    PdfOutline pdfOutline = pdfContentByte.getRootOutline();
                    String string2 = string.split(DocumentGenerator.TOKENIZER)[0];
                    String string3 = string.split(DocumentGenerator.TOKENIZER)[1];
                    if (!DocumentGenerator.this.chapters.containsKey(string2)) {
                        PdfOutline pdfOutline2 = new PdfOutline(pdfOutline, new PdfDestination(1, rectangle.top(-20.0f)), string2, true);
                        DocumentGenerator.this.chapters.put(string2, pdfOutline2);
                        new PdfOutline(pdfOutline2, new PdfDestination(1, rectangle.top(-20.0f)), string3);
                    } else {
                        new PdfOutline((PdfOutline)DocumentGenerator.this.chapters.get(string2), new PdfDestination(1, rectangle.top(-20.0f)), string3);
                    }
                }
            });
        } else if (this.format == 2) {
            RtfWriter.getInstance(this.document, fileOutputStream);
        }
    }

    private void writeFooter() {
        Chunk chunk = new Chunk(DateParser.formatDate() + " - " + GUI.i18n.getTranslation("DOCUMENT_GENERATED_FROM") + " (http://www.rssowl.org)", this.documentConfig.getItalicFont());
        HeaderFooter headerFooter = new HeaderFooter(new Phrase(chunk), false);
        headerFooter.setAlignment(1);
        headerFooter.setBorder(1);
        this.document.setFooter(headerFooter);
    }

    private void writeMetaInfos() {
        if (StringShop.isset(this.rssChannel.getTitle())) {
            this.document.addTitle(this.rssChannel.getTitle());
        }
        if (StringShop.isset(this.rssChannel.getManagingEditor())) {
            this.document.addAuthor(this.rssChannel.getManagingEditor());
        } else if (StringShop.isset(this.rssChannel.getPublisher())) {
            this.document.addAuthor(this.rssChannel.getPublisher());
        } else if (StringShop.isset(this.rssChannel.getCreator())) {
            this.document.addAuthor(this.rssChannel.getCreator());
        }
        this.document.addCreationDate();
        this.document.addCreator(GUI.i18n.getTranslation("DOCUMENT_GENERATED_FROM") + " (http://www.rssowl.org)");
    }

    private void writeNews(ArrayList arrayList) throws DocumentException {
        Hashtable hashtable = this.rssChannel.getItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            NewsItem newsItem = (NewsItem)hashtable.get(arrayList.get(i));
            String string = GUI.i18n.getTranslation("NO_TITLE");
            if (StringShop.isset(newsItem.getTitle())) {
                string = newsItem.getTitle();
            }
            this.document.add(new Paragraph());
            this.writeNews(newsItem, string);
        }
    }

    private void writeNews(NewsItem newsItem, String string) throws DocumentException {
        Object object;
        int n;
        String string2;
        Object object2;
        Table table = new Table(1, 2);
        table.setBorder(0);
        table.setPadding(7.0f);
        table.setWidth(this.format == 2 ? 80.0f : 100.0f);
        table.setBackgroundColor(new Color(246, 246, 246));
        table.setBorderColor(new Color(192, 192, 192));
        Cell cell = new Cell();
        cell.setBorderColor(Color.LIGHT_GRAY);
        Paragraph paragraph = new Paragraph();
        if (this.format == 0) {
            object2 = new Chunk(string);
            if (StringShop.isset(newsItem.getLink())) {
                ((Chunk)object2).setFont(this.documentConfig.getLinkFont());
                ((Chunk)object2).setAnchor(newsItem.getLink());
            } else {
                ((Chunk)object2).setFont(this.documentConfig.getBoldFont());
            }
            string2 = StringShop.isset(newsItem.getNewsfeedTitle()) ? newsItem.getNewsfeedTitle() : GUI.i18n.getTranslation("NO_TITLE");
            ((Chunk)object2).setGenericTag(string2 + TOKENIZER + string);
            paragraph.add(object2);
        } else if (StringShop.isset(newsItem.getLink())) {
            object2 = new Anchor(string, this.documentConfig.getLinkFont());
            ((Anchor)object2).setReference(newsItem.getLink());
            paragraph.add(object2);
        } else {
            object2 = new Anchor(string, this.documentConfig.getBoldFont());
            paragraph.add(object2);
        }
        object2 = new StringBuffer();
        if (newsItem.getPubDateParsed() != null) {
            ((StringBuffer)object2).append(DateParser.formatDate(newsItem.getPubDateParsed(), true, true));
        } else if (newsItem.getPubDate() != null) {
            ((StringBuffer)object2).append(newsItem.getPubDate());
        }
        if (StringShop.isset(newsItem.getAuthor())) {
            ((StringBuffer)object2).append(((StringBuffer)object2).length() > 0 ? " - " : "");
            ((StringBuffer)object2).append(newsItem.getAuthor());
        }
        string2 = ((StringBuffer)object2).toString();
        Paragraph paragraph2 = new Paragraph();
        Chunk chunk = new Chunk(string2, this.documentConfig.getSubTitleFont());
        paragraph2.add(chunk);
        cell.add(paragraph);
        cell.add(paragraph2);
        table.addCell(cell);
        Cell cell2 = new Cell();
        cell2.setBorderColor(Color.LIGHT_GRAY);
        StringBuffer stringBuffer = new StringBuffer();
        if (StringShop.isset(newsItem.getDescription())) {
            stringBuffer.append(Text.normalizeString(newsItem.getDescription()));
        }
        if (newsItem.getEnclosures() != null && newsItem.getEnclosures().size() > 0) {
            stringBuffer.append("\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE") + ": ");
            for (n = 0; n < newsItem.getEnclosures().size(); ++n) {
                object = (Enclosure)newsItem.getEnclosures().get(n);
                stringBuffer.append("\n" + ((Enclosure)object).getUrl() + " (" + ((Enclosure)object).getType() + " / " + ((Enclosure)object).getLength(true) + ")");
            }
        }
        if (StringShop.isset(newsItem.getSource())) {
            stringBuffer.append("\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE") + ": " + newsItem.getSource());
        }
        if (newsItem.getComments() != null && newsItem.getComments().size() > 0) {
            stringBuffer.append("\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS") + ":\n");
            for (n = 0; n < newsItem.getComments().size(); ++n) {
                if (newsItem.getComments().get(n) == null || newsItem.getComments().get(n).equals("")) continue;
                stringBuffer.append("\n" + newsItem.getComments().get(n));
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_NO_DESCRIPTION"));
        }
        Paragraph paragraph3 = new Paragraph();
        object = new Chunk(StringShop.stripTags(stringBuffer.toString()), this.documentConfig.getNormalFont());
        paragraph3.add(object);
        cell2.add(paragraph3);
        if (this.rssChannel.isAggregatedCat() && StringShop.isset(newsItem.getNewsfeedTitle())) {
            String string3 = newsItem.getNewsfeedTitle();
            Paragraph paragraph4 = new Paragraph();
            Chunk chunk2 = new Chunk("\n" + string3, this.documentConfig.getSmallItalicFont());
            if (URLShop.looksLikeURL(newsItem.getNewsfeedHomepage())) {
                chunk2.setAnchor(newsItem.getNewsfeedHomepage());
            }
            paragraph4.add(chunk2);
            cell2.add(paragraph4);
        }
        table.addCell(cell2);
        table.setTableFitsPage(((Chunk)object).content().length() < 3000 && this.format != 2);
        this.document.add(table);
    }
}

