/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.document;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import org.eclipse.swt.graphics.FontData;

public class HTMLExporter {
    private static final String DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final byte NEWLINE = 10;
    private static final byte TAB = 9;
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private Channel channel;
    private ArrayList newsOrder;
    private BufferedOutputStream out;

    public HTMLExporter(Channel channel, ArrayList arrayList, OutputStream outputStream) {
        this.channel = channel;
        this.newsOrder = arrayList;
        this.out = new BufferedOutputStream(outputStream);
    }

    private static byte[] getISOBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    private void addTabs(int n) throws IOException {
        this.out.write(10);
        for (int i = 0; i < n; ++i) {
            this.out.write(9);
        }
    }

    private void close() throws IOException {
        this.out.close();
    }

    private void write(String string) throws IOException {
        this.out.write(HTMLExporter.getISOBytes(string));
    }

    private void writeBase() throws IOException {
        this.write("<base href=\"");
        this.write(this.channel.getLink());
        this.write("\" />");
    }

    private void writeBody() throws IOException {
        this.addTabs(2);
        this.write("<div class=\"channelTitle\">");
        this.addTabs(3);
        this.write("<h2>");
        this.addTabs(4);
        if (StringShop.isset(this.channel.getHomepage())) {
            this.writeLink(this.channel.getHomepage(), StringShop.unicodeToEntities(this.channel.getTitle()), null);
        } else {
            this.write(StringShop.unicodeToEntities(this.channel.getTitle()));
        }
        this.addTabs(3);
        this.write("</h2>");
        this.addTabs(2);
        this.write("</div>");
        Hashtable hashtable = this.channel.getItems();
        for (int i = 0; i < this.newsOrder.size(); ++i) {
            NewsItem newsItem = (NewsItem)hashtable.get(this.newsOrder.get(i));
            this.writeNews(newsItem);
        }
    }

    private void writeFont(FontData fontData) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("font-family: ").append(fontData.getName()).append("; ");
        stringBuffer.append("font-size: ").append(fontData.getHeight());
        stringBuffer.append(GlobalSettings.isMac() ? "px" : "pt").append("; ");
        if ((fontData.getStyle() & 1) != 0) {
            stringBuffer.append("font-weight: bold; ");
        }
        if ((fontData.getStyle() & 2) != 0) {
            stringBuffer.append("font-style: italic; ");
        }
        this.write(stringBuffer.toString());
    }

    private void writeHead() throws IOException {
        this.write("<title>");
        this.write(this.channel.getTitle());
        this.write("</title>");
        this.addTabs(2);
        this.write("<style type=\"text/css\">");
        this.addTabs(3);
        this.write("a:link { text-decoration: none; color: rgb(0,0,153); }");
        this.addTabs(3);
        this.write("a:visited { text-decoration: none; color: rgb(0,0,153); }");
        this.addTabs(3);
        this.write("a:hover { text-decoration: underline; color: rgb(0,0,153); }");
        this.addTabs(3);
        this.write("a:active { text-decoration: none; color: rgb(0,0,153); }");
        this.addTabs(3);
        this.write("a.homepageLink:link { text-decoration: none; color: rgb(127,127,127); } ");
        this.addTabs(3);
        this.write("a.homepageLink:visited { text-decoration: none; color: rgb(127,127,127); } ");
        this.addTabs(3);
        this.write("a.homepageLink:hover { text-decoration: none; color: rgb(127,127,127); } ");
        this.addTabs(3);
        this.write("a.homepageLink:active { text-decoration: none; color: rgb(127,127,127); } ");
        this.out.write(10);
        this.addTabs(3);
        this.write("body { margin: 25px; background: rgb(244,244,244); ");
        this.writeFont(FontShop.textFont.getFontData()[0]);
        this.write("} ");
        this.out.write(10);
        this.addTabs(3);
        this.write("ul.enclosureList { list-style-type: square; }");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.channelTitle { text-align: center; }");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.addInfo { margin-top: 15px; }");
        this.out.write(10);
        this.addTabs(3);
        this.write("table.item { width: 100%; margin-bottom: 20px; border-width: 1px; border-color: rgb(192,192,192); border-style: solid; background: rgb(255,255,255); }");
        this.out.write(10);
        this.addTabs(3);
        this.write("td.item { padding: 10px; }");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.title { font-weight: bold; margin-bottom: 5px; ");
        this.writeFont(FontShop.textFont.getFontData()[0]);
        this.write("} ");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.body { margin-top: 15px; margin-bottom: ");
        this.write(this.channel.isAggregatedCat() ? "15px; " : "0px; ");
        this.writeFont(FontShop.textFont.getFontData()[0]);
        this.write("} ");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.date { ");
        this.writeFont(FontShop.textFont.getFontData()[0]);
        this.write(" text-decoration: none; color: rgb(127,127,127); }");
        this.out.write(10);
        this.addTabs(3);
        this.write("div.feedTitle { color: rgb(127,127,127); ");
        this.writeFont(FontShop.textFont.getFontData()[0]);
        this.write("} ");
        this.addTabs(2);
        this.write("</style>");
    }

    private void writeItemBody(NewsItem newsItem) throws IOException {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (StringShop.isset(newsItem.getDescription())) {
            stringBuffer.append(newsItem.getDescription());
        }
        if (newsItem.getEnclosures() != null && newsItem.getEnclosures().size() > 0) {
            stringBuffer.append("\n<div class=\"addInfo\">");
            stringBuffer.append("\n<strong>").append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE")).append("</strong>: ");
            stringBuffer.append("\n<ul class=\"enclosureList\">");
            for (n = 0; n < newsItem.getEnclosures().size(); ++n) {
                String string2;
                Enclosure enclosure = (Enclosure)newsItem.getEnclosures().get(n);
                string = enclosure.getUrl();
                try {
                    URL uRL = new URL(string);
                    string2 = StringShop.createAnchor(string, URLShop.getFile(uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    string2 = string;
                }
                stringBuffer.append("\n").append("<li>");
                stringBuffer.append("\n").append(string2);
                stringBuffer.append(" (").append(enclosure.getType()).append(" / ").append(enclosure.getLength(true)).append(")");
                stringBuffer.append("\n").append("</li>");
            }
            stringBuffer.append("\n</ul>");
            stringBuffer.append("\n</div>");
        }
        if (StringShop.isset(newsItem.getSource())) {
            stringBuffer.append("\n<div class=\"addInfo\">");
            stringBuffer.append("\n<strong>").append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE")).append("</strong>: ");
            if (URLShop.looksLikeURL(newsItem.getSource())) {
                stringBuffer.append("\n<a href=\"").append(newsItem.getSource()).append("\">").append(newsItem.getSource()).append("</a>");
            } else {
                stringBuffer.append(newsItem.getSource());
            }
            stringBuffer.append("\n</div>");
        }
        if (newsItem.getComments() != null && newsItem.getComments().size() > 0) {
            stringBuffer.append("\n<div class=\"addInfo\">");
            stringBuffer.append("\n<strong>").append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS")).append("</strong>: ");
            n = newsItem.getComments().size();
            for (int i = 0; i < n; ++i) {
                if (!StringShop.isset((String)newsItem.getComments().get(i))) continue;
                string = (String)newsItem.getComments().get(i);
                if (URLShop.looksLikeURL(string)) {
                    stringBuffer.append("\n<a href=\"").append(string).append("\">").append(string).append("</a>");
                } else {
                    stringBuffer.append(string);
                }
                if (n <= 1) continue;
                stringBuffer.append("\n<br />");
            }
            stringBuffer.append("\n</div>");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_NO_DESCRIPTION"));
        }
        this.write(StringShop.unicodeToEntities(stringBuffer.toString()));
    }

    private void writeLink(String string, String string2, String string3) throws IOException {
        this.write("<a ");
        if (StringShop.isset(string3)) {
            this.write("class=\"");
            this.write(string3);
            this.write("\" ");
        }
        this.write("href=\"");
        this.write(string);
        this.write("\">");
        this.write(string2);
        this.write("</a>");
    }

    private void writeNews(NewsItem newsItem) throws IOException {
        String string = StringShop.isset(newsItem.getTitle()) ? newsItem.getTitle() : GUI.i18n.getTranslation("NO_TITLE");
        string = StringShop.unicodeToEntities(string);
        boolean bl = StringShop.isset(newsItem.getLink());
        this.addTabs(2);
        this.write("<table class=\"item\"><tr><td class=\"item\">");
        this.addTabs(3);
        this.write("<div class=\"title\">");
        this.addTabs(4);
        if (bl) {
            this.writeLink(newsItem.getLink(), string, null);
        } else {
            this.write(string);
        }
        this.addTabs(3);
        this.write("</div>");
        StringBuffer stringBuffer = new StringBuffer();
        if (newsItem.getPubDateParsed() != null) {
            stringBuffer.append(DateParser.formatDate(newsItem.getPubDateParsed(), true, true));
        } else if (newsItem.getPubDate() != null) {
            stringBuffer.append(newsItem.getPubDate());
        }
        if (StringShop.isset(newsItem.getAuthor())) {
            stringBuffer.append(stringBuffer.length() > 0 ? " - " : "");
            stringBuffer.append(newsItem.getAuthor());
        }
        if (stringBuffer.length() > 0) {
            String string2 = stringBuffer.toString();
            string2 = StringShop.unicodeToEntities(string2);
            this.addTabs(3);
            this.write("<div class=\"date\">");
            this.addTabs(4);
            this.write(string2);
            this.addTabs(3);
            this.write("</div>");
        }
        this.addTabs(3);
        this.write("<div class=\"body\">");
        this.writeItemBody(newsItem);
        this.write("</div>");
        if (newsItem.isPartOfAggregation() && StringShop.isset(newsItem.getNewsfeedTitle())) {
            this.addTabs(3);
            this.write("<div class=\"feedTitle\">");
            if (URLShop.looksLikeURL(newsItem.getNewsfeedHomepage())) {
                this.writeLink(newsItem.getNewsfeedHomepage(), StringShop.unicodeToEntities(newsItem.getNewsfeedTitle()), "homepageLink");
            } else {
                this.write(StringShop.unicodeToEntities(newsItem.getNewsfeedTitle()));
            }
            this.addTabs(3);
            this.write("</div>");
        }
        this.addTabs(2);
        this.write("</td></tr></table>");
    }

    void create() throws IOException {
        this.write(XML_DECLARATION);
        this.out.write(10);
        this.write(DOCTYPE);
        this.out.write(10);
        if (GlobalSettings.isWindows()) {
            this.write("<!-- saved from url=(0014)about:internet -->");
            this.out.write(10);
        }
        this.write("<html>");
        this.addTabs(1);
        this.write("<head>");
        this.addTabs(2);
        if (!this.channel.isAggregatedCat() && StringShop.isset(this.channel.getLink())) {
            this.writeBase();
        }
        this.addTabs(2);
        this.writeHead();
        this.addTabs(1);
        this.write("</head>");
        this.addTabs(1);
        this.write("<body>");
        this.writeBody();
        this.addTabs(1);
        this.write("</body>");
        this.out.write(10);
        this.write("</html>");
        this.close();
    }
}

